function export_publication_selection_to_sql(table_name, pub_id, wp_nonce, primary_key) {
	// Get table data
	table = jQuery('#' + table_name + pub_id ).DataTable();
	rows = table.rows({selected:true});
	if (table.rows({selected:true}).count()===0) {
		rows = table.rows();
	}
	data = rows.data();

	// Add key values to array
	ids = [];
	rows.every(function ( rowIdx, tableLoop, rowLoop ) {
		for (var p in primary_key) {
			ids.push(data[rowLoop][p]);
		}
	});

	// Define target url and add arguments
	url =
		wpda_publication_vars.wpda_ajaxurl +
		"?action=wpda_export&type=row&mysql_set=off&show_create=off&show_comments=off&format_type=sql" +
		"&pub_id=" + pub_id +
		"&table_names=" + table_name +
		"&_wpnonce=" + wp_nonce;

	// Add keys to url
	for (i=0; i<ids.length; i++) {
		for (var pk in primary_key) {
			url += '&' + primary_key[pk] + '[' + i + ']=' + encodeURIComponent(ids[i]);
		}
	}

	window.location.href = url;
}

function wpdaTableSeo(settings, json, wpda_seo_links) {
	let args = location.href.split("/");
	if (args.length>5 && args[args.length-3]==="pg") {
		const pageId = args[args.length-2];
		if (!isNaN(pageId) && pageId>0) {
			jQuery("#" + settings.sTableId).on("init.dt", function() {
				jQuery("#" + settings.sTableId).DataTable().page(parseInt(pageId)-1).draw(false);
			});

			let previousButton = "";
			let previousLink = "< Previous page";
			if (pageId>1) {
				args[args.length-2] = parseInt(pageId)-1;
				if (wpda_seo_links.link_previous!==undefined) {
					previousLink = wpda_seo_links.link_previous;
				}
				previousButton = '<a href="' + args.join("/") + `">${previousLink}</a>`;
			}

			let nextButton = "";
			let nextLink = "Next page >";
			if (parseInt(pageId)<Math.ceil(json.recordsFiltered/json.data.length)) {
				args[args.length-2] = parseInt(pageId)+1;
				if (wpda_seo_links.link_next!==undefined) {
					nextLink = wpda_seo_links.link_next;
				}
				nextButton = '<a href="' + args.join("/") + `">${nextLink}</a>`;
			}

			let elmId = settings.sTableId + "_wrapper";
			let content =
				`<div class="wpda-table-seo">
					<span style="float:left">${previousButton}</span>
					<span style="float:right">${nextButton}</span>
				</div>`;
			if (wpda_seo_links.display==="inline") {
				jQuery("#" + elmId).append(content);
			} else {
				jQuery("#" + elmId).after(content);
			}
		}
	}
}

function wpda_init_master_detail(settings, json, pubId, tableName, masterColumn, detailColumn) {
	if (
		Array.isArray(masterColumn) &&
		Array.isArray(detailColumn) &&
		masterColumn.length!==detailColumn.length
	) {
		console.error("ERROR: Number of master columns does not match number of detail columns");
		return;
	}

	if (
		(
			Array.isArray(masterColumn) &&
			! Array.isArray(detailColumn)
		) ||
		(
			! Array.isArray(masterColumn) &&
			Array.isArray(detailColumn)
		)
	) {
		console.error("ERROR: Master columns format does not match detail columns format");
		return;
	}

	let tableId = tableName + pubId;

	let masterColumns = window["wpdaDbColumns" + settings.sTableId.replace(/[^a-zA-Z0-9-]/g, "")];
	if (masterColumns===undefined) {
		console.error("ERROR: Missing column object");
		return;
	}
	let masterColumnIds = [];
	if (Array.isArray(masterColumn)) {
		for (let i=0; i<masterColumn.length; i++) {
			masterColumnIds[i] = wpda_get_index_master_detail(masterColumns, masterColumn[i]);
		}
	} else {
		masterColumnIds[0] = wpda_get_index_master_detail(masterColumns, masterColumn);
	}

	let detailColumns = window["wpdaDbColumns" + tableId.replace(/[^a-zA-Z0-9-]/g, "")];
	if (detailColumns===undefined) {
		console.error("ERROR: Missing column object");
		return;
	}
	let detailColumnIds = [];
	if (Array.isArray(detailColumn)) {
		for (let i=0; i<detailColumn.length; i++) {
			detailColumnIds[i] = wpda_get_index_master_detail(detailColumns, detailColumn[i]);
		}
	} else {
		detailColumnIds[0] = wpda_get_index_master_detail(detailColumns, detailColumn);
	}

	let detailOptions = window["wpdaDbColumns" + tableId.replace(/[^a-zA-Z0-9-]/g, "") + "_advanced_options"];
	let serverSide = detailOptions.serverSide===undefined || detailOptions.serverSide===true;

	jQuery("#" + tableName + pubId + "_wrapper").hide();
	jQuery("#" + settings.sTableId).on("click", "td", function () {
		let value = null;
		if (Array.isArray(masterColumn)) {
			value = {};
			for (let i=0; i<masterColumn.length; i++) {
				let row = jQuery("#" + settings.sTableId).DataTable().row(jQuery(this).closest("tr")).data();
				value[i] = row[masterColumnIds[i]];
			}
		} else {
			let row = jQuery("#" + settings.sTableId).DataTable().row(jQuery(this).closest("tr")).data();
			value = row[masterColumnIds[0]];
		}

		if (!serverSide) {
			// Client side processing
			if (Array.isArray(detailColumn)) {
				for (let i=0; i<detailColumn.length; i++) {
					jQuery("#" + tableId).DataTable().column(detailColumnIds[i]).search(value[i]);
				}
			} else {
				jQuery("#" + tableId).DataTable().column(detailColumnIds[0]).search(value);
			}
		} else {
			// Server side processing
			wpda_add_server_side_args(detailColumn, value);
		}

		jQuery("#" + tableId).DataTable().draw();
		jQuery("#" + tableId + "_wrapper").show();
	});

	setTimeout(
		// Wait until detail table is loaded
		function() {
			jQuery("#" + tableId).on("click", function (e) {
				let element = jQuery(e.target);
				if (element.prop("tagName")==="TH" && element.hasClass("sorting")) {
					wpda_sync_master_detail(settings, masterColumnIds, masterColumn, detailColumn, serverSide);
				}
			});

			let selectElementId = tableId + "_length";
			jQuery("#" + selectElementId + " select[name=" + selectElementId + "]").off("change");
			jQuery("#" + selectElementId + " select[name=" + selectElementId + "]").on("change", function (e) {
				wpda_sync_master_detail(settings, masterColumnIds, masterColumn, detailColumn, serverSide);
				jQuery("#" + tableId).DataTable().draw();
				jQuery("#" + tableId + "_wrapper").show();
			});

			jQuery("#" + tableId + "_filter input").off();
			jQuery("#" + tableId + "_filter input").on("keyup", { sTableID: tableId }, function (e) {
				if (e.keyCode == 13) { /* Enter key */
					wpda_sync_master_detail(settings, masterColumnIds, masterColumn, detailColumn, serverSide);
					jQuery("#" + tableId).DataTable().search(this.value).draw();
				}
			});
		}, 1500
	);

}

function wpda_sync_master_detail(settings, masterColumnIds, masterColumn, detailColumn, serverSide) {
	let value = null;
	if (Array.isArray(masterColumn)) {
		value = {};
		for (let i=0; i<masterColumn.length; i++) {
			let row = jQuery("#" + settings.sTableId).DataTable().row(jQuery("#" + settings.sTableId + " tbody tr.selected")).data();
			value[i] = row[masterColumnIds[i]];
		}
	} else {
		let row = jQuery("#" + settings.sTableId).DataTable().row(jQuery("#" + settings.sTableId + " tbody tr.selected")).data();
		value = row[masterColumnIds[0]];
	}

	if (!serverSide) {
		// Client side processing does not require any actions here
	} else {
		// Server side processing
		wpda_add_server_side_args(detailColumn, value);
	}
}

function wpda_add_server_side_args(detailColumn, value) {
	window['detailQuery'] = [];
	if (Array.isArray(detailColumn)) {
		for (let i=0; i<detailColumn.length; i++) {
			window['detailQuery'][i] = {
				key: "wpda_search_column_" + detailColumn[i],
				val: value[i]
			};
		}
	} else {
		window['detailQuery'][0] = {
			key: "wpda_search_column_" + detailColumn,
			val: value
		};
	}
}

function wpda_get_index_master_detail(columns, columnName) {
	for (let i=0; i<columns.length; i++) {
		if (columns[i].name===columnName) {
			return i;
		}
	}
	return -1;
}

function wpda_nav_master_detail( settings, pubId, tableName ) {
	jQuery("#" + tableName + pubId + "_wrapper").hide();
}