<?php

namespace WPDataAccess\Premium\WPDAPRO_Templates {

	use WPDataAccess\Premium\WPDAPRO_Data_Publisher\WPDAPRO_Data_Publisher_Manage_Styles;

	class WPDAPRO_Template_Data_Publisher_Color extends WPDAPRO_Template {

		const TEMPLATE = '
			<style id="wpda-premium-styling-colors">
				/* DataTable */

				#$table_name$pub_id_wrapper * {
					color: $text_color;
				}

				#$table_name$pub_id_wrapper tr.odd:not(.selected) {
					background-color: $odd_bg_color;
				}

				#$table_name$pub_id_wrapper tr.even:not(.selected) {
					background-color: $even_bg_color;
				}

				#$table_name$pub_id_wrapper select,
				#$table_name$pub_id_wrapper select option,
				#$table_name$pub_id_wrapper input,
				#$table_name$pub_id_wrapper button,
				#$table_name$pub_id_wrapper .dataTables_paginate .paginate_button {
					color: $text_color;
					background-color: $odd_bg_color;
					border: 1px solid $border_color;
					font-weight: bold;
				}

				#$table_name$pub_id_wrapper div.dt-datetime div.dt-datetime-title button {
					background-color: transparent;
					border: none;
				}

				#$table_name$pub_id_wrapper input::placeholder {
					color: $hover_color;
					font-weight: normal;
				}

				#$table_name$pub_id_wrapper button:hover,
				#$table_name$pub_id_wrapper .dataTables_paginate .paginate_button:hover {
					color: $text_color !important;
					background: $hover_color;
					background-color: $hover_color;
					border: 1px solid $border_color;
				}

				#$table_name$pub_id_wrapper .dataTables_paginate .paginate_button.current,
				#$table_name$pub_id_wrapper .dataTables_paginate .paginate_button.disabled {
					color: $text_color;
					background: transparent;
					border: none;
					box-shadow: none;
				}

				#$table_name$pub_id {
					background: $header_bg_color;
					border: 1px solid $border_color;
				}

				#$table_name$pub_id thead th,
				#$table_name$pub_id thead td,
				#$table_name$pub_id tfoot th,
				#$table_name$pub_id tfoot td {
					background-color: transparent;
					color: $header_label_color;
					border: none;
					vertical-align: middle;
				}

				#$table_name$pub_id tbody tr th,
				#$table_name$pub_id tbody tr td {
					color: $text_color;
					border: none;
					border-bottom: 1px solid $border_color;
				}

				#$table_name$pub_id.dataTable.dtr-inline.collapsed>tbody>tr>td.dtr-control:before,
				#$table_name$pub_id.dataTable.dtr-inline.collapsed>tbody>tr>th.dtr-control:before {
					background-color: $text_color;
				}

				#$table_name$pub_id_wrapper tr.odd:hover:not(.selected),
				#$table_name$pub_id tbody tr:hover:not(.selected) {
					background-color: $hover_color;
				}

				#$table_name$pub_id td table.wpda-child-expanded td,
				#$table_name$pub_id td table.wpda-child-table {
					border: none;
				}
				#$table_name$pub_id table.wpda-child-table td {
					border: none;
				}
				#$table_name$pub_id table.wpda-child-table tbody tr td:first-child {
					border-left: 1.3em solid $text_color;
					padding-left: 1em;
				}

				#$table_name$pub_id_more_button {
					background: $odd_bg_color;
					background-color: $odd_bg_color;
					color: $text_color;
					font-weight: bold;
				}

				#$table_name$pub_id_wrapper div.dtsp-searchPanes table,
				#$table_name$pub_id_wrapper div.dtsp-searchPanes table tr td,
				#$table_name$pub_id_wrapper div.dtsp-panesContainer div.dtsp-searchPanes div.dtsp-searchPane div.dataTables_wrapper {
					border: none;
				}
				#$table_name$pub_id_wrapper div.dtsp-searchPanes table {
					border: 1px solid $border_color;
					border-bottom: none;
				}
				#$table_name$pub_id_wrapper div.dtsp-searchPanes table tr td {
					border-bottom: 1px solid $border_color;
				}

				#$table_name$pub_id_wrapper input[type=search]::placeholder {
					color: $text_color;
					opacity: 0.6;
				}

				/* Processing text and spinner */

				#$table_name$pub_id_processing {
					background-color: $even_bg_color;
					border: 1px solid $border_color;
					padding-top: 1em;
					z-index: 9999;
				}

				#$table_name$pub_id_processing > div > div {
					background-color: $text_color;
				}

				/* Selected */

				#$table_name$pub_id_wrapper tbody tr.selected > * {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue);
				}

				#$table_name$pub_id_wrapper.stripe>tbody>tr.odd.selected>*,
				#$table_name$pub_id_wrapper.display>tbody>tr.odd.selected>* {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.923);
				}

				#$table_name$pub_id_wrapper.hover > tbody > tr.selected:hover > *,
				#$table_name$pub_id_wrapper.display > tbody > tr.selected:hover > * {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.935);
				}

				#$table_name$pub_id_wrapper.order-column > tbody tr.selected > .sorting_1,
				#$table_name$pub_id_wrapper.order-column > tbody tr.selected > .sorting_2,
				#$table_name$pub_id_wrapper.order-column > tbody tr.selected > .sorting_3,
				#$table_name$pub_id_wrapper.display > tbody tr.selected > .sorting_1,
				#$table_name$pub_id_wrapper.display > tbody tr.selected > .sorting_2,
				#$table_name$pub_id_wrapper.display > tbody tr.selected > .sorting_3 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.919);
				}

				#$table_name$pub_id_wrapper.display > tbody > tr.odd.selected > .sorting_1,
				#$table_name$pub_id_wrapper.order-column.stripe > tbody > tr.odd.selected > .sorting_1 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.954);
				}
				#$table_name$pub_id_wrapper.display > tbody > tr.odd.selected > .sorting_2,
				#$table_name$pub_id_wrapper.order-column.stripe > tbody > tr.odd.selected > .sorting_2 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.947);
				}
				#$table_name$pub_id_wrapper.display > tbody > tr.odd.selected > .sorting_3,
				#$table_name$pub_id_wrapper.order-column.stripe > tbody > tr.odd.selected > .sorting_3 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.939);
				}

				#$table_name$pub_id_wrapper.display > tbody > tr.even.selected > .sorting_1,
				#$table_name$pub_id_wrapper.order-column.stripe > tbody > tr.even.selected > .sorting_1 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.919);
				}
				#$table_name$pub_id_wrapper.display > tbody > tr.even.selected > .sorting_2,
				#$table_name$pub_id_wrapper.order-column.stripe > tbody > tr.even.selected > .sorting_2 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.911);
				}
				#$table_name$pub_id_wrapper.display > tbody > tr.even.selected > .sorting_3,
				#$table_name$pub_id_wrapper.order-column.stripe > tbody > tr.even.selected > .sorting_3 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.903);
				}

				#$table_name$pub_id_wrapper.display tbody tr:hover.selected > .sorting_1,
				#$table_name$pub_id_wrapper.order-column.hover tbody tr:hover.selected > .sorting_1 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.982);
				}
				#$table_name$pub_id_wrapper.display tbody tr:hover.selected > .sorting_2,
				#$table_name$pub_id_wrapper.order-column.hover tbody tr:hover.selected > .sorting_2 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.974);
				}
				#$table_name$pub_id_wrapper.display tbody tr:hover.selected > .sorting_3,
				#$table_name$pub_id_wrapper.order-column.hover tbody tr:hover.selected > .sorting_3 {
					box-shadow: inset 0 0 0 9999px rgba($selected_red, $selected_green, $selected_blue, 0.962);
				}

				/* Horizontal scrollbar */

				.dataTables_scrollHeadInner table.dataTable.wpda-datatable,
				.dataTables_scrollFootInner table.dataTable.wpda-datatable {
					background-color: $header_bg_color !important;
					border: none !important;
				}

				.dataTables_scrollHeadInner table.dataTable.wpda-datatable>thead>tr>th,
				.dataTables_scrollHeadInner table.dataTable.wpda-datatable>thead>tr>td,
				.dataTables_scrollFootInner table.dataTable.wpda-datatable>tfoot>tr>th,
				.dataTables_scrollFootInner table.dataTable.wpda-datatable>tfoot>tr>td {
					border-bottom: none !important;
					color: $header_label_color !important;
				}

				/* Popup */

				div.dtr-modal div.dtr-modal-close {
					line-height: 20px;
				}

				div.dtr-modal-content h2 span.$class {
					color: $text_color;
				}

				div.dtr-modal-content table.wpda-child-table.$class {
					color: $text_color;
					background: $header_bg_color;
					border-bottom: $border_color;
				}

				div.dtr-modal-content table.wpda-child-table.$class tbody {
					border: 1px solid $border_color;
				}

				div.dtr-modal-content table.wpda-child-table.$class tbody tr:nth-child(odd) {
					background-color: $odd_bg_color;
				}

				div.dtr-modal-content table.wpda-child-table.$class tbody tr:nth-child(even) {
					background-color: $even_bg_color;
				}

				div.dtr-modal-content table.wpda-child-table.$class tbody tr td {
					border: none;
					border-bottom: 1px solid $border_color;
				}

				div.dtr-modal-content table.wpda-child-table.$class tbody tr:hover {
					background-color: $hover_color;
				}

				div.dtr-modal-content table.wpda-child-modal.$class input.dtr-modal-close {
					color: $text_color;
					background: $odd_bg_color;
					border: 1px solid $border_color;
				}

				div.dtr-modal-content table.wpda-child-modal.$class input.dtr-modal-close:hover {
					color: $text_color;
					background: $hover_color;
				}

				div.dtr-modal-content table.wpda-child-table.$class thead,
				div.dtr-modal-content table.wpda-child-table.$class tfoot {
					padding: 0;
					border: none;
				}

				div.dtr-modal-content table.wpda-child-table.$class thead td {
					border: none;
				}

				div.dtr-modal-content table.wpda-child-table.$class tfoot td {
					border: none;
				}
			</style>
		';

		public function get_template( $args ) {
			if ( isset( $args['table_name'], $args['pub_id'], $args['color'] ) ) {
				$table_name  = esc_attr( $args['table_name'] );
				$pub_id      = esc_attr( $args['pub_id'] );
				$css_color   = esc_attr( $args['color'] );

				$colors = WPDAPRO_Data_Publisher_Manage_Styles::get_colors();
				if ( ! isset( $colors[ $css_color ] ) ) {
					$css_color = 'default';
				}

				$text_color         = $colors[ $css_color ]['text_color'];
				$header_label_color = $colors[ $css_color ]['header_label_color'];
				$odd_bg_color       = $colors[ $css_color ]['odd_bg_color'];
				$even_bg_color      = $colors[ $css_color ]['even_bg_color'];
				$header_bg_color    = $colors[ $css_color ]['header_bg_color'];
				$border_color       = $colors[ $css_color ]['border_color'];
				$hover_color        = $colors[ $css_color ]['hover_color'];
				$selected           = isset( $colors[ $css_color ]['selected'] ) ? $colors[ $css_color ]['selected'] : '#0d6efd';
				list($selected_red, $selected_green, $selected_blue)
									= sscanf( $selected, "#%02x%02x%02x" );//phpcs:ignore - 8.1 proof

				$class = "wpda-color-{$pub_id}";

				return str_replace(
						[
							'$table_name', '$pub_id', '$class',
							'$text_color', '$header_label_color', '$odd_bg_color', '$even_bg_color', '$header_bg_color', '$border_color', '$hover_color', '$selected_red', '$selected_green', '$selected_blue'
						],
						[
							$table_name, $pub_id, $class,
							$text_color, $header_label_color, $odd_bg_color, $even_bg_color, $header_bg_color, $border_color, $hover_color, $selected_red, $selected_green, $selected_blue
						],
						self::TEMPLATE
					);

			} else {
				return '';
			}
		}

	}

}
