<?php

/**
 * Plugin Name: Robobay
 * Description: A simple WordPress plugin that saves form data to the database and modifies page content.
 * Version: 1.0.0
 * Author: Konstantin K
 * License: GPL2
 */

// Register options
function robobay_register_options()
{
  register_setting('robobay_options', 'robobay_project_name');
  register_setting('robobay_options', 'robobay_url');
  register_setting('robobay_options', 'robobay_use_www');
}
add_action('admin_init', 'robobay_register_options');


// Add a submenu page to the Tools menu
add_action('admin_menu', 'robobay_add_admin_page');

function robobay_add_admin_page()
{
  add_submenu_page(
    'tools.php', // Parent menu slug
    'Robobay', // Page title
    'Robobay', // Menu title
    'manage_options', // Capability required
    'robobay', // Menu slug
    'robobay_admin_page' // Callback function
  );
}

// Callback function for the admin page
function robobay_admin_page()
{
?>
  <div class="wrap">
    <h1>Robobay</h1>
    <form method="post" action="<?php echo esc_url(admin_url('admin-post.php')); ?>">
      <input type="hidden" name="action" value="robobay_save_data">
      <?php wp_nonce_field('robobay_save_data', 'robobay_data_nonce'); ?>
      <label for="project_name">Project Name</label>
      <input type="text" name="project_name" id="project_name" value="<?php echo esc_attr(get_option('robobay_project_name')); ?>">
      <br />
      <label for="url">URL</label>
      <input type="text" name="url" id="url" value="<?php echo (esc_attr(get_option('robobay_url'))); ?>">
      <br />
      <label for="use_www">Use www?</label>
      <input type="checkbox" name="use_www" id="use_www" <?php checked(get_option('robobay_use_www'), true); ?>>
      <br>
      <input type="submit" name="submit" value="Save">
    </form>
  </div>
<?php
}

// Save form data to the database
add_action('admin_post_robobay_save_data', 'robobay_save_data');

function robobay_save_data()
{
  if (!isset($_POST['submit'])) {
    return;
  }

  if (!wp_verify_nonce($_POST['robobay_data_nonce'], 'robobay_save_data')) {
    return;
  }
  $pname = sanitize_text_field($_POST['project_name']);
  $purl = sanitize_text_field($_POST['url']);
  $usewww = isset($_POST['use_www']);

  update_option('robobay_project_name', $pname);
  update_option('robobay_url', $purl);
  update_option('robobay_use_www', $usewww);

  robobay_modify_privacy_policy($pname, $purl, $usewww);

  wp_redirect(admin_url('tools.php?page=robobay&message=Saved.'));
  exit;
}

function robobay_modify_privacy_policy($pname, $purl, $usewww)
{
  // Modify page content
  $page_id = 3;
  $page = get_post($page_id);
  $content = $page->post_content;
  $content = str_replace('REPLACENAME', $pname, $content);
  $content = str_replace('REPLACEURL', $purl, $content);
  $www = ($usewww) ? "www." : "";
  $link = "<a href=\"https://$www$purl/\">https://$www$purl/</a>";
  $content = str_replace('REPLACEFULLURL', $link, $content);
  $page->post_content = $content;
  wp_update_post($page);
}

function robobay_modify_general_settings($pname, $purl, $usewww)
{
  $www = ($usewww) ? "www." : "";
  $fullurl = "https://$www$purl/";
  update_option('blogname', $pname);
  update_option('siteurl', $fullurl);
  update_option('home', $fullurl);
}

// Clean up database on deactivate
register_deactivation_hook(__FILE__, 'robobay_deactivate');

function robobay_deactivate()
{
  delete_option('robobay_project_name');
  delete_option('robobay_url');
  delete_option('robobay_use_www');
}


// -- Bonus: Enable showing pages with an optional notice
function admin_notice()
{
  if (is_admin() && isset($_GET['message'])) {
    $message = sanitize_text_field($_GET['message']);
    echo '<div class="notice notice-success is-dismissible"><p>' . $message . '</p></div>';
  }
}
add_action('admin_notices', 'admin_notice');
