/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-03-18 18:17:22 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=250 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=157473 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=721 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_ilj_linkindex` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `link_from` bigint(20) DEFAULT NULL,
  `link_to` bigint(20) DEFAULT NULL,
  `type_from` varchar(45) DEFAULT NULL,
  `type_to` varchar(45) DEFAULT NULL,
  `anchor` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_from` (`link_from`),
  KEY `type_from` (`type_from`),
  KEY `type_to` (`type_to`),
  KEY `link_to` (`link_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_link_juice_keeper` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `date` datetime NOT NULL,
  `url` varchar(512) NOT NULL,
  `ref` varchar(512) NOT NULL DEFAULT '',
  `ip` varchar(40) NOT NULL DEFAULT '',
  `ua` varchar(512) NOT NULL DEFAULT '',
  `status` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36777 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=175502 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=181520 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=18197 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) NOT NULL,
  `class_identifier` varchar(300) DEFAULT '0',
  `attempts` int(11) DEFAULT 0,
  `description` varchar(300) DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_locked_at` bigint(20) DEFAULT 0,
  `status` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=47 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_csv_uploads` (
  `csv_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `csv_name` varchar(100) NOT NULL,
  `csv_real_file_name` varchar(4096) NOT NULL,
  `csv_orig_file_name` varchar(4096) NOT NULL,
  `csv_timestamp` datetime DEFAULT NULL,
  `csv_mapping` text DEFAULT NULL,
  PRIMARY KEY (`csv_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_logging` (
  `log_time` datetime NOT NULL,
  `log_id` varchar(50) NOT NULL,
  `log_type` enum('FATAL','ERROR','WARN','INFO','DEBUG','TRACE') DEFAULT NULL,
  `log_msg` varchar(4096) DEFAULT NULL,
  PRIMARY KEY (`log_time`,`log_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_media` (
  `media_schema_name` varchar(64) NOT NULL DEFAULT '',
  `media_table_name` varchar(64) NOT NULL,
  `media_column_name` varchar(64) NOT NULL,
  `media_type` enum('Image','ImageURL','Attachment','Hyperlink','Audio','Video') DEFAULT NULL,
  `media_activated` enum('Yes','No') DEFAULT NULL,
  PRIMARY KEY (`media_schema_name`,`media_table_name`,`media_column_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_menus` (
  `menu_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `menu_schema_name` varchar(64) NOT NULL DEFAULT '',
  `menu_table_name` varchar(64) NOT NULL,
  `menu_name` varchar(100) NOT NULL,
  `menu_slug` varchar(100) NOT NULL,
  `menu_role` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`menu_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_project` (
  `project_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `project_name` varchar(100) NOT NULL,
  `project_description` text DEFAULT NULL,
  `add_to_menu` enum('Yes','No') DEFAULT NULL,
  `menu_name` varchar(30) DEFAULT NULL,
  `project_sequence` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`project_id`),
  UNIQUE KEY `wp_wpdp_project_project_name` (`project_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_project_page` (
  `project_id` mediumint(9) NOT NULL,
  `page_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `page_name` varchar(100) NOT NULL,
  `add_to_menu` enum('Yes','No') DEFAULT NULL,
  `page_type` enum('table','parent/child','static') NOT NULL,
  `page_schema_name` varchar(64) NOT NULL DEFAULT '',
  `page_table_name` varchar(64) DEFAULT NULL,
  `page_setname` varchar(100) DEFAULT 'default',
  `page_mode` enum('edit','view') NOT NULL,
  `page_allow_insert` enum('yes','no','only') NOT NULL,
  `page_allow_delete` enum('yes','no') NOT NULL,
  `page_allow_import` enum('yes','no') NOT NULL,
  `page_allow_bulk` enum('yes','no') NOT NULL,
  `page_allow_full_export` enum('yes','no') DEFAULT 'no',
  `page_content` bigint(20) unsigned DEFAULT NULL,
  `page_title` varchar(100) DEFAULT NULL,
  `page_subtitle` varchar(100) DEFAULT NULL,
  `page_role` varchar(100) DEFAULT NULL,
  `page_where` varchar(4096) DEFAULT NULL,
  `page_orderby` varchar(4096) DEFAULT NULL,
  `page_sequence` smallint(6) DEFAULT NULL,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `project_id` (`project_id`,`page_name`,`page_role`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_project_table` (
  `wpda_table_name` varchar(64) NOT NULL,
  `wpda_schema_name` varchar(64) NOT NULL DEFAULT '',
  `wpda_table_setname` varchar(100) NOT NULL DEFAULT 'default',
  `wpda_table_design` text NOT NULL,
  PRIMARY KEY (`wpda_schema_name`,`wpda_table_name`,`wpda_table_setname`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_publisher` (
  `pub_id` mediumint(9) NOT NULL AUTO_INCREMENT,
  `pub_name` varchar(100) NOT NULL,
  `pub_data_source` enum('Table','Query','CPT') DEFAULT 'Table',
  `pub_schema_name` varchar(64) NOT NULL DEFAULT '',
  `pub_table_name` varchar(64) NOT NULL,
  `pub_column_names` varchar(4096) DEFAULT '*',
  `pub_cpt` varchar(20) DEFAULT NULL,
  `pub_cpt_fields` text DEFAULT NULL,
  `pub_cpt_query` text DEFAULT NULL,
  `pub_cpt_format` text DEFAULT NULL,
  `pub_format` text DEFAULT NULL,
  `pub_query` text DEFAULT NULL,
  `pub_sort_icons` enum('default','none') DEFAULT NULL,
  `pub_styles` set('default','stripe','hover','order-column','row-border','compact','cell-border') DEFAULT 'default',
  `pub_style_premium` enum('Yes','No') DEFAULT 'No',
  `pub_style_user` varchar(50) DEFAULT NULL,
  `pub_style_color` varchar(50) DEFAULT 'default',
  `pub_style_space` tinyint(2) unsigned DEFAULT 10,
  `pub_style_corner` tinyint(2) unsigned DEFAULT 0,
  `pub_style_modal_width` tinyint(2) unsigned DEFAULT 80,
  `pub_responsive` enum('Yes','No') DEFAULT NULL,
  `pub_responsive_popup_title` varchar(50) DEFAULT NULL,
  `pub_responsive_cols` int(10) unsigned DEFAULT 0,
  `pub_responsive_type` enum('Modal','Collapsed','Expanded') DEFAULT NULL,
  `pub_responsive_modal_hyperlinks` enum('If not listed','Never','Always') DEFAULT NULL,
  `pub_responsive_icon` enum('Yes','No') DEFAULT NULL,
  `pub_flat_scrollx` enum('Yes','No') DEFAULT NULL,
  `pub_show_advanced_settings` tinyint(1) DEFAULT NULL,
  `pub_default_where` varchar(2000) DEFAULT '',
  `pub_default_orderby` varchar(100) DEFAULT '',
  `pub_table_options_searching` char(3) DEFAULT 'on',
  `pub_table_options_ordering` char(3) DEFAULT 'on',
  `pub_table_options_paging` char(3) DEFAULT 'on',
  `pub_table_options_serverside` char(3) DEFAULT 'on',
  `pub_table_options_nl2br` char(3) DEFAULT NULL,
  `pub_table_options_advanced` text DEFAULT NULL,
  `pub_extentions` varchar(2000) DEFAULT '',
  PRIMARY KEY (`pub_id`),
  UNIQUE KEY `pub_name` (`pub_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_table_design` (
  `wpda_table_name` varchar(64) NOT NULL,
  `wpda_schema_name` varchar(64) NOT NULL DEFAULT '',
  `wpda_table_design` text NOT NULL,
  `wpda_date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `wpda_last_updated` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`wpda_schema_name`,`wpda_table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpda_table_settings` (
  `wpda_schema_name` varchar(64) NOT NULL DEFAULT '',
  `wpda_table_name` varchar(64) NOT NULL,
  `wpda_table_settings` text NOT NULL,
  PRIMARY KEY (`wpda_schema_name`,`wpda_table_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `permalink` longtext DEFAULT NULL,
  `permalink_hash` varchar(40) DEFAULT NULL,
  `object_id` bigint(20) DEFAULT NULL,
  `object_type` varchar(32) NOT NULL,
  `object_sub_type` varchar(32) DEFAULT NULL,
  `author_id` bigint(20) DEFAULT NULL,
  `post_parent` bigint(20) DEFAULT NULL,
  `title` text DEFAULT NULL,
  `description` mediumtext DEFAULT NULL,
  `breadcrumb_title` text DEFAULT NULL,
  `post_status` varchar(20) DEFAULT NULL,
  `is_public` tinyint(1) DEFAULT NULL,
  `is_protected` tinyint(1) DEFAULT 0,
  `has_public_posts` tinyint(1) DEFAULT NULL,
  `number_of_pages` int(11) unsigned DEFAULT NULL,
  `canonical` longtext DEFAULT NULL,
  `primary_focus_keyword` varchar(191) DEFAULT NULL,
  `primary_focus_keyword_score` int(3) DEFAULT NULL,
  `readability_score` int(3) DEFAULT NULL,
  `is_cornerstone` tinyint(1) DEFAULT 0,
  `is_robots_noindex` tinyint(1) DEFAULT 0,
  `is_robots_nofollow` tinyint(1) DEFAULT 0,
  `is_robots_noarchive` tinyint(1) DEFAULT 0,
  `is_robots_noimageindex` tinyint(1) DEFAULT 0,
  `is_robots_nosnippet` tinyint(1) DEFAULT 0,
  `twitter_title` text DEFAULT NULL,
  `twitter_image` longtext DEFAULT NULL,
  `twitter_description` longtext DEFAULT NULL,
  `twitter_image_id` varchar(191) DEFAULT NULL,
  `twitter_image_source` text DEFAULT NULL,
  `open_graph_title` text DEFAULT NULL,
  `open_graph_description` longtext DEFAULT NULL,
  `open_graph_image` longtext DEFAULT NULL,
  `open_graph_image_id` varchar(191) DEFAULT NULL,
  `open_graph_image_source` text DEFAULT NULL,
  `open_graph_image_meta` mediumtext DEFAULT NULL,
  `link_count` int(11) DEFAULT NULL,
  `incoming_link_count` int(11) DEFAULT NULL,
  `prominent_words_version` int(11) unsigned DEFAULT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  `schema_page_type` varchar(64) DEFAULT NULL,
  `schema_article_type` varchar(64) DEFAULT NULL,
  `has_ancestors` tinyint(1) DEFAULT 0,
  `estimated_reading_time_minutes` int(11) DEFAULT NULL,
  `version` int(11) DEFAULT 1,
  `object_last_modified` datetime DEFAULT NULL,
  `object_published_at` datetime DEFAULT NULL,
  `inclusive_language_score` int(3) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `object_type_and_sub_type` (`object_type`,`object_sub_type`),
  KEY `object_id_and_type` (`object_id`,`object_type`),
  KEY `permalink_hash_and_object_type` (`permalink_hash`,`object_type`),
  KEY `subpages` (`post_parent`,`object_type`,`post_status`,`object_id`),
  KEY `prominent_words` (`prominent_words_version`,`object_type`,`object_sub_type`,`post_status`),
  KEY `published_sitemap_index` (`object_published_at`,`is_robots_noindex`,`object_type`,`object_sub_type`)
) ENGINE=InnoDB AUTO_INCREMENT=18149 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_indexable_hierarchy` (
  `indexable_id` int(11) unsigned NOT NULL,
  `ancestor_id` int(11) unsigned NOT NULL,
  `depth` int(11) unsigned DEFAULT NULL,
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`indexable_id`,`ancestor_id`),
  KEY `indexable_id` (`indexable_id`),
  KEY `ancestor_id` (`ancestor_id`),
  KEY `depth` (`depth`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_migrations` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `version` varchar(191) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `wp_yoast_migrations_version` (`version`)
) ENGINE=InnoDB AUTO_INCREMENT=25 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_primary_term` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) DEFAULT NULL,
  `term_id` bigint(20) DEFAULT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `created_at` datetime DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `blog_id` bigint(20) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  KEY `post_taxonomy` (`post_id`,`taxonomy`),
  KEY `post_term` (`post_id`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_yoast_seo_links` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) DEFAULT NULL,
  `post_id` bigint(20) unsigned DEFAULT NULL,
  `target_post_id` bigint(20) unsigned DEFAULT NULL,
  `type` varchar(8) DEFAULT NULL,
  `indexable_id` int(11) unsigned DEFAULT NULL,
  `target_indexable_id` int(11) unsigned DEFAULT NULL,
  `height` int(11) unsigned DEFAULT NULL,
  `width` int(11) unsigned DEFAULT NULL,
  `size` int(11) unsigned DEFAULT NULL,
  `language` varchar(32) DEFAULT NULL,
  `region` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`),
  KEY `indexable_link_direction` (`indexable_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=1532 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("30", "ilj_set_individual_index_rebuild", "complete", "2024-03-18 18:15:29", "2024-03-18 18:15:29", "[{\"id\":18168,\"type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("31", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "98e7419c9106e7e020ad17f315b43d36", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "0", "[{\"id\":18168,\"batched_data\":[18167,18166,18165,18164,18163,18162,18161,18160,18159,18158,18157,18156,18155,18154,18153,18152,18151,18150,18149,18148,18147,18146,18145,18144,18143,18142,18141,18140,18139,18138,18137,18136,18135,18134,18133,18132,18131,18130,18129,18128,18127,18126,18125,18124,18123,18122,18121,18120,18119,18118,18117,18116,18115,18114,18113,18112,18111,18110,18109,18108,18107,18106,18105,18104,18103,18102,18101,18100,18099,18098,18097,18096,18095,18094,18093,18092,18091,18090,18089,18088,18087,18086,18085,18084,18083,18082,18081,18080,18079,18078,18077,18076,18075,18074,18073,18072,18071,18070,18069,18068],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("32", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "6d2b802a1deb367dd8ed124674274875", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "0", "[{\"id\":18168,\"batched_data\":{\"100\":18067,\"101\":18066,\"102\":18065,\"103\":18064,\"104\":18063,\"105\":18062,\"106\":18061,\"107\":18060,\"108\":18059,\"109\":18058,\"110\":18057,\"111\":18056,\"112\":18055,\"113\":18054,\"114\":18053,\"115\":18052,\"116\":18051,\"117\":18050,\"118\":18049,\"119\":18048,\"120\":18047,\"121\":18046,\"122\":18045,\"123\":18044,\"124\":18043,\"125\":18042,\"126\":18041,\"127\":18040,\"128\":18039,\"129\":18038,\"130\":18037,\"131\":18036,\"132\":18035,\"133\":18034,\"134\":18033,\"135\":18032,\"136\":18031,\"137\":18030,\"138\":18029,\"139\":18028,\"140\":18027,\"141\":18026,\"142\":18025,\"143\":18024,\"144\":18023,\"145\":18022,\"146\":18021,\"147\":18020,\"148\":18019,\"149\":18018,\"150\":18017,\"151\":18016,\"152\":18015,\"153\":18014,\"154\":18013,\"155\":18012,\"156\":18011,\"157\":18010,\"158\":18009,\"159\":18008,\"160\":18007,\"161\":18006,\"162\":18005,\"163\":18004,\"164\":18003,\"165\":18002,\"166\":18001,\"167\":18000,\"168\":17999,\"169\":17998,\"170\":17997,\"171\":17996,\"172\":17995,\"173\":17994,\"174\":17993,\"175\":17992,\"176\":17991,\"177\":17990,\"178\":17989,\"179\":17988,\"180\":17987,\"181\":17986,\"182\":17985,\"183\":17984,\"184\":17983,\"185\":17982,\"186\":17981,\"187\":17980,\"188\":17979,\"189\":17978,\"190\":17977,\"191\":17976,\"192\":17975,\"193\":17974,\"194\":17973,\"195\":17972,\"196\":17971,\"197\":17970,\"198\":17969,\"199\":17968},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("33", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "25098243df92dac764cfa02a0ebe28a6", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "0", "[{\"id\":18168,\"batched_data\":{\"200\":17967,\"201\":17966,\"202\":17965,\"203\":17964,\"204\":17963,\"205\":17962,\"206\":17961,\"207\":17960,\"208\":17959,\"209\":17958,\"210\":17957,\"211\":17956,\"212\":17955,\"213\":17954,\"214\":17953,\"215\":17952,\"216\":17951,\"217\":17950,\"218\":17949,\"219\":17948,\"220\":17947,\"221\":17946,\"222\":17945,\"223\":17944,\"224\":17943,\"225\":17942,\"226\":17941,\"227\":17940,\"228\":17939,\"229\":17938,\"230\":17937,\"231\":17936,\"232\":17935,\"233\":17934,\"234\":17933,\"235\":17932,\"236\":17931,\"237\":17930,\"238\":17929,\"239\":17928,\"240\":17927,\"241\":17926,\"242\":17925,\"243\":17924,\"244\":17923,\"245\":17922,\"246\":17921,\"247\":17920,\"248\":17919,\"249\":17918,\"250\":17917,\"251\":17916,\"252\":17915,\"253\":17914,\"254\":17913,\"255\":17912,\"256\":17911,\"257\":17910,\"258\":17909,\"259\":17908,\"260\":17907,\"261\":17906,\"262\":17905,\"263\":17904,\"264\":17903,\"265\":17902,\"266\":17901,\"267\":17900,\"268\":17899,\"269\":17898,\"270\":17897,\"271\":17896,\"272\":17895,\"273\":17894,\"274\":17893,\"275\":17892,\"276\":17891,\"277\":17890,\"278\":17889,\"279\":17888,\"280\":17887,\"281\":17886,\"282\":17885,\"283\":17884,\"284\":17883,\"285\":17882,\"286\":17881,\"287\":17880,\"288\":17879,\"289\":17878,\"290\":17877,\"291\":17876,\"292\":17875,\"293\":17874,\"294\":17873,\"295\":17872,\"296\":17871,\"297\":17870,\"298\":17869,\"299\":17868},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("34", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "372a6442cf40ed277143629385a17cb0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "0", "[{\"id\":18168,\"batched_data\":{\"300\":17867,\"301\":17866,\"302\":17865,\"303\":17864,\"304\":17863,\"305\":17862,\"306\":17861,\"307\":17860,\"308\":17859,\"309\":17858,\"310\":17857,\"311\":17856,\"312\":17855,\"313\":17854,\"314\":17853,\"315\":17852,\"316\":17851,\"317\":17850,\"318\":17849,\"319\":17848,\"320\":17847,\"321\":17846,\"322\":17845,\"323\":17844,\"324\":17843,\"325\":17842,\"326\":17841,\"327\":17840,\"328\":17839,\"329\":17838,\"330\":17837,\"331\":17836,\"332\":17835,\"333\":17834,\"334\":17833,\"335\":17832,\"336\":17831,\"337\":17830,\"338\":17829,\"339\":17828,\"340\":17827,\"341\":17826,\"342\":17825,\"343\":17824,\"344\":17823,\"345\":17822,\"346\":17821,\"347\":17820,\"348\":17819,\"349\":17818,\"350\":17817,\"351\":17816,\"352\":17815,\"353\":17814,\"354\":17813,\"355\":17812,\"356\":17811,\"357\":17810,\"358\":17809,\"359\":17808,\"360\":17807,\"361\":17806,\"362\":17805,\"363\":17804,\"364\":17803,\"365\":17802,\"366\":17801,\"367\":17800,\"368\":17799,\"369\":17798,\"370\":17797,\"371\":17796,\"372\":17795,\"373\":17794,\"374\":17793,\"375\":17792,\"376\":17791,\"377\":17790,\"378\":17789,\"379\":17788,\"380\":17787,\"381\":17786,\"382\":17785,\"383\":17784,\"384\":17783,\"385\":17782,\"386\":17781,\"387\":17780,\"388\":17779,\"389\":17778,\"390\":17777,\"391\":17776,\"392\":17775,\"393\":17774,\"394\":17773,\"395\":17772,\"396\":17771,\"397\":17770,\"398\":17769,\"399\":17768},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("35", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "784c5d423ce2aac3369fe94806f51760", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "0", "[{\"id\":18168,\"batched_data\":{\"400\":17767,\"401\":17766,\"402\":17765,\"403\":17764,\"404\":17763,\"405\":17762,\"406\":17761,\"407\":17760,\"408\":17759,\"409\":17758,\"410\":17757,\"411\":17756,\"412\":17755,\"413\":17754,\"414\":17753,\"415\":17752,\"416\":17751,\"417\":17750,\"418\":17749,\"419\":17748,\"420\":17747,\"421\":17746,\"422\":17745,\"423\":17744,\"424\":17743,\"425\":17742,\"426\":17741,\"427\":17740,\"428\":17739,\"429\":17738,\"430\":17737,\"431\":17736,\"432\":17735,\"433\":17734,\"434\":17733,\"435\":17732,\"436\":17731,\"437\":17730,\"438\":17729,\"439\":17728,\"440\":17727,\"441\":17726,\"442\":17725,\"443\":17724,\"444\":17723,\"445\":17722,\"446\":17721,\"447\":17720,\"448\":17719,\"449\":17718,\"450\":17717,\"451\":17716,\"452\":17715,\"453\":17714,\"454\":17713,\"455\":17712,\"456\":17711,\"457\":17710,\"458\":17709,\"459\":17708,\"460\":17707,\"461\":17706,\"462\":17705,\"463\":17704,\"464\":17703,\"465\":17702,\"466\":17701,\"467\":17700,\"468\":17699,\"469\":17698,\"470\":17697,\"471\":17696,\"472\":17695,\"473\":17694,\"474\":17693,\"475\":17692,\"476\":17691,\"477\":17690,\"478\":17689,\"479\":17688,\"480\":17687,\"481\":17686,\"482\":17685,\"483\":17684,\"484\":17683,\"485\":17682,\"486\":17681,\"487\":17680,\"488\":17679,\"489\":17678,\"490\":17677,\"491\":17676,\"492\":17675,\"493\":17674,\"494\":17673,\"495\":17672,\"496\":17671,\"497\":17670,\"498\":17669,\"499\":17668},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":0}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("36", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:45", "2024-03-18 18:15:45", "[{\"id\":18168,\"offset\":500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("37", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "69b86ee3188f33885215a0cdce797609", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "0", "[{\"id\":18168,\"batched_data\":[17667,17666,17665,17664,17663,17662,17661,17660,17659,17658,17657,17656,17655,17654,17653,17652,17651,17650,17649,17648,17647,17646,17645,17644,17643,17642,17641,17640,17639,17638,17637,17636,17635,17634,17633,17632,17631,17630,17629,17628,17627,17626,17625,17624,17623,17622,17621,17620,17619,17618,17617,17616,17615,17614,17613,17612,17611,17610,17609,17608,17607,17606,17605,17604,17603,17600,17599,17598,17597,17596,17595,17594,17593,17592,17591,17590,17589,17588,17587,17586,17585,17584,17583,17582,17581,17580,17579,17578,17577,17576,17575,17574,17573,17572,17571,17570,17569,17568,17567,17566],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("38", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "ae529f47a6bb438d75b5e04d7f75f90b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "0", "[{\"id\":18168,\"batched_data\":{\"100\":17565,\"101\":17564,\"102\":17563,\"103\":17562,\"104\":17561,\"105\":17560,\"106\":17559,\"107\":17558,\"108\":17557,\"109\":17556,\"110\":17555,\"111\":17554,\"112\":17553,\"113\":17552,\"114\":17551,\"115\":17550,\"116\":17549,\"117\":17548,\"118\":17547,\"119\":17546,\"120\":17545,\"121\":17544,\"122\":17543,\"123\":17542,\"124\":17541,\"125\":17540,\"126\":17539,\"127\":17538,\"128\":17537,\"129\":17536,\"130\":17535,\"131\":17534,\"132\":17533,\"133\":17532,\"134\":17531,\"135\":17530,\"136\":17529,\"137\":17528,\"138\":17527,\"139\":17526,\"140\":17525,\"141\":17524,\"142\":17523,\"143\":17522,\"144\":17521,\"145\":17520,\"146\":17519,\"147\":17518,\"148\":17517,\"149\":17516,\"150\":17515,\"151\":17514,\"152\":17513,\"153\":17512,\"154\":17511,\"155\":17510,\"156\":17509,\"157\":17508,\"158\":17507,\"159\":17506,\"160\":17505,\"161\":17504,\"162\":17503,\"163\":17502,\"164\":17501,\"165\":17500,\"166\":17499,\"167\":17498,\"168\":17497,\"169\":17496,\"170\":17495,\"171\":17494,\"172\":17493,\"173\":17492,\"174\":17491,\"175\":17490,\"176\":17489,\"177\":17488,\"178\":17487,\"179\":17486,\"180\":17485,\"181\":17484,\"182\":17483,\"183\":17482,\"184\":17481,\"185\":17480,\"186\":17479,\"187\":17478,\"188\":17477,\"189\":17476,\"190\":17475,\"191\":17474,\"192\":17473,\"193\":17472,\"194\":17471,\"195\":17470,\"196\":17469,\"197\":17468,\"198\":17467,\"199\":17466},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("39", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "40390c7dec06f61f6ddc39d3fc1669b3", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "0", "[{\"id\":18168,\"batched_data\":{\"200\":17465,\"201\":17464,\"202\":17463,\"203\":17462,\"204\":17461,\"205\":17460,\"206\":17459,\"207\":17458,\"208\":17457,\"209\":17456,\"210\":17455,\"211\":17454,\"212\":17453,\"213\":17452,\"214\":17451,\"215\":17450,\"216\":17449,\"217\":17448,\"218\":17447,\"219\":17446,\"220\":17445,\"221\":17444,\"222\":17443,\"223\":17442,\"224\":17441,\"225\":17440,\"226\":17439,\"227\":17438,\"228\":17437,\"229\":17436,\"230\":17435,\"231\":17434,\"232\":17433,\"233\":17432,\"234\":17431,\"235\":17430,\"236\":17429,\"237\":17428,\"238\":17427,\"239\":17426,\"240\":17425,\"241\":17424,\"242\":17423,\"243\":17422,\"244\":17421,\"245\":17420,\"246\":17419,\"247\":17418,\"248\":17417,\"249\":17416,\"250\":17415,\"251\":17414,\"252\":17413,\"253\":17412,\"254\":17411,\"255\":17410,\"256\":17409,\"257\":17408,\"258\":17407,\"259\":17406,\"260\":17405,\"261\":17404,\"262\":17403,\"263\":17402,\"264\":17401,\"265\":17400,\"266\":17399,\"267\":17398,\"268\":17397,\"269\":17396,\"270\":17395,\"271\":17394,\"272\":17393,\"273\":17392,\"274\":17391,\"275\":17390,\"276\":17389,\"277\":17388,\"278\":17387,\"279\":17386,\"280\":17385,\"281\":17384,\"282\":17383,\"283\":17382,\"284\":17381,\"285\":17380,\"286\":17379,\"287\":17378,\"288\":17377,\"289\":17376,\"290\":17375,\"291\":17374,\"292\":17373,\"293\":17372,\"294\":17371,\"295\":17370,\"296\":17369,\"297\":17368,\"298\":17367,\"299\":17366},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("40", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "d711c63b5e2945488609b3c88a777847", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "0", "[{\"id\":18168,\"batched_data\":{\"300\":17365,\"301\":17364,\"302\":17363,\"303\":17362,\"304\":17361,\"305\":17360,\"306\":17359,\"307\":17358,\"308\":17357,\"309\":17356,\"310\":17355,\"311\":17354,\"312\":17353,\"313\":17352,\"314\":17351,\"315\":17350,\"316\":17349,\"317\":17348,\"318\":17347,\"319\":17346,\"320\":17345,\"321\":17344,\"322\":17343,\"323\":17342,\"324\":17341,\"325\":17340,\"326\":17339,\"327\":17338,\"328\":17337,\"329\":17336,\"330\":17335,\"331\":17334,\"332\":17333,\"333\":17332,\"334\":17331,\"335\":17330,\"336\":17329,\"337\":17328,\"338\":17327,\"339\":17326,\"340\":17325,\"341\":17324,\"342\":17323,\"343\":17322,\"344\":17321,\"345\":17320,\"346\":17319,\"347\":17318,\"348\":17317,\"349\":17316,\"350\":17315,\"351\":17314,\"352\":17313,\"353\":17312,\"354\":17311,\"355\":17310,\"356\":17309,\"357\":17308,\"358\":17307,\"359\":17306,\"360\":17305,\"361\":17304,\"362\":17303,\"363\":17302,\"364\":17301,\"365\":17300,\"366\":17299,\"367\":17298,\"368\":17297,\"369\":17296,\"370\":17295,\"371\":17294,\"372\":17293,\"373\":17292,\"374\":17291,\"375\":17290,\"376\":17289,\"377\":17288,\"378\":17287,\"379\":17286,\"380\":17285,\"381\":17284,\"382\":17283,\"383\":17282,\"384\":17281,\"385\":17280,\"386\":17279,\"387\":17278,\"388\":17277,\"389\":17276,\"390\":17275,\"391\":17274,\"392\":17273,\"393\":17272,\"394\":17271,\"395\":17270,\"396\":17269,\"397\":17268,\"398\":17267,\"399\":17266},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("41", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "36210f93ef7bd2ff1c527d48cd7ed822", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "0", "[{\"id\":18168,\"batched_data\":{\"400\":17265,\"401\":17264,\"402\":17263,\"403\":17262,\"404\":17261,\"405\":17260,\"406\":17259,\"407\":17258,\"408\":17257,\"409\":17256,\"410\":17255,\"411\":17254,\"412\":17253,\"413\":17252,\"414\":17251,\"415\":17250,\"416\":17249,\"417\":17248,\"418\":17247,\"419\":17246,\"420\":17245,\"421\":17244,\"422\":17243,\"423\":17242,\"424\":17241,\"425\":17240,\"426\":17239,\"427\":17238,\"428\":17237,\"429\":17236,\"430\":17235,\"431\":17234,\"432\":17233,\"433\":17232,\"434\":17231,\"435\":17230,\"436\":17229,\"437\":17228,\"438\":17227,\"439\":17226,\"440\":17225,\"441\":17224,\"442\":17223,\"443\":17222,\"444\":17221,\"445\":17220,\"446\":17219,\"447\":17218,\"448\":17217,\"449\":17216,\"450\":17215,\"451\":17214,\"452\":17213,\"453\":17212,\"454\":17211,\"455\":17210,\"456\":17209,\"457\":17208,\"458\":17207,\"459\":17206,\"460\":17205,\"461\":17204,\"462\":17203,\"463\":17202,\"464\":17201,\"465\":17200,\"466\":17199,\"467\":17198,\"468\":17197,\"469\":17196,\"470\":17195,\"471\":17194,\"472\":17193,\"473\":17192,\"474\":17191,\"475\":17190,\"476\":17189,\"477\":17188,\"478\":17187,\"479\":17186,\"480\":17185,\"481\":17184,\"482\":17183,\"483\":17182,\"484\":17181,\"485\":17180,\"486\":17179,\"487\":17178,\"488\":17177,\"489\":17176,\"490\":17175,\"491\":17174,\"492\":17173,\"493\":17172,\"494\":17171,\"495\":17170,\"496\":17169,\"497\":17168,\"498\":17167,\"499\":17166},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("42", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:46", "2024-03-18 18:15:46", "[{\"id\":18168,\"offset\":1000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("43", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "aacaea6055cd7773def0a9e2ea0a54ef", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "0", "[{\"id\":18168,\"batched_data\":[17165,17164,17163,17162,17161,17160,17159,17158,17157,17156,17155,17154,17153,17152,17151,17150,17149,17148,17147,17146,17145,17144,17143,17142,17141,17140,17139,17138,17137,17136,17135,17134,17133,17132,17131,17130,17129,17128,17127,17126,17125,17124,17123,17122,17121,17120,17119,17118,17117,17116,17115,17114,17113,17112,17111,17110,17109,17108,17107,17106,17105,17104,17103,17102,17101,17100,17099,17098,17097,17096,17095,17094,17093,17092,17091,17090,17089,17088,17087,17086,17085,17084,17083,17082,17081,17080,17079,17078,17077,17076,17075,17074,17073,17072,17071,17070,17069,17068,17067,17066],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("44", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "e8f4238c9aa7d47a08350071ce2ea6b2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "0", "[{\"id\":18168,\"batched_data\":{\"100\":17065,\"101\":17064,\"102\":17063,\"103\":17062,\"104\":17061,\"105\":17060,\"106\":17059,\"107\":17058,\"108\":17057,\"109\":17056,\"110\":17055,\"111\":17054,\"112\":17053,\"113\":17052,\"114\":17051,\"115\":17050,\"116\":17049,\"117\":17048,\"118\":17047,\"119\":17046,\"120\":17045,\"121\":17044,\"122\":17043,\"123\":17042,\"124\":17041,\"125\":17040,\"126\":17039,\"127\":17038,\"128\":17037,\"129\":17036,\"130\":17035,\"131\":17034,\"132\":17033,\"133\":17032,\"134\":17031,\"135\":17030,\"136\":17029,\"137\":17028,\"138\":17027,\"139\":17026,\"140\":17025,\"141\":17024,\"142\":17023,\"143\":17022,\"144\":17021,\"145\":17020,\"146\":17019,\"147\":17018,\"148\":17017,\"149\":17016,\"150\":17015,\"151\":17014,\"152\":17013,\"153\":17012,\"154\":17011,\"155\":17010,\"156\":17009,\"157\":17008,\"158\":17007,\"159\":17006,\"160\":17005,\"161\":17004,\"162\":17003,\"163\":17002,\"164\":17001,\"165\":17000,\"166\":16999,\"167\":16998,\"168\":16997,\"169\":16996,\"170\":16995,\"171\":16994,\"172\":16993,\"173\":16992,\"174\":16991,\"175\":16990,\"176\":16989,\"177\":16988,\"178\":16987,\"179\":16986,\"180\":16985,\"181\":16984,\"182\":16983,\"183\":16982,\"184\":16981,\"185\":16980,\"186\":16979,\"187\":16978,\"188\":16977,\"189\":16976,\"190\":16975,\"191\":16974,\"192\":16973,\"193\":16972,\"194\":16971,\"195\":16970,\"196\":16969,\"197\":16968,\"198\":16967,\"199\":16966},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("45", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "cdf132abcacec25a1ee745bbc81c6434", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "0", "[{\"id\":18168,\"batched_data\":{\"200\":16965,\"201\":16964,\"202\":16963,\"203\":16962,\"204\":16961,\"205\":16960,\"206\":16959,\"207\":16958,\"208\":16957,\"209\":16956,\"210\":16955,\"211\":16954,\"212\":16953,\"213\":16952,\"214\":16951,\"215\":16950,\"216\":16949,\"217\":16948,\"218\":16947,\"219\":16946,\"220\":16945,\"221\":16944,\"222\":16943,\"223\":16942,\"224\":16941,\"225\":16940,\"226\":16939,\"227\":16938,\"228\":16937,\"229\":16936,\"230\":16935,\"231\":16934,\"232\":16933,\"233\":16932,\"234\":16931,\"235\":16930,\"236\":16929,\"237\":16928,\"238\":16927,\"239\":16926,\"240\":16925,\"241\":16924,\"242\":16923,\"243\":16922,\"244\":16921,\"245\":16920,\"246\":16919,\"247\":16918,\"248\":16917,\"249\":16916,\"250\":16915,\"251\":16914,\"252\":16913,\"253\":16912,\"254\":16911,\"255\":16910,\"256\":16909,\"257\":16908,\"258\":16907,\"259\":16906,\"260\":16905,\"261\":16904,\"262\":16903,\"263\":16902,\"264\":16901,\"265\":16900,\"266\":16899,\"267\":16898,\"268\":16897,\"269\":16896,\"270\":16895,\"271\":16894,\"272\":16893,\"273\":16892,\"274\":16891,\"275\":16890,\"276\":16889,\"277\":16888,\"278\":16887,\"279\":16886,\"280\":16885,\"281\":16884,\"282\":16883,\"283\":16882,\"284\":16881,\"285\":16880,\"286\":16879,\"287\":16878,\"288\":16877,\"289\":16876,\"290\":16875,\"291\":16874,\"292\":16873,\"293\":16872,\"294\":16871,\"295\":16870,\"296\":16869,\"297\":16868,\"298\":16867,\"299\":16866},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("46", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "8025f12148d48bb49fdd68125ebc297d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "0", "[{\"id\":18168,\"batched_data\":{\"300\":16865,\"301\":16864,\"302\":16863,\"303\":16862,\"304\":16861,\"305\":16860,\"306\":16859,\"307\":16858,\"308\":16857,\"309\":16856,\"310\":16855,\"311\":16854,\"312\":16853,\"313\":16852,\"314\":16851,\"315\":16850,\"316\":16849,\"317\":16848,\"318\":16847,\"319\":16846,\"320\":16845,\"321\":16844,\"322\":16843,\"323\":16842,\"324\":16841,\"325\":16840,\"326\":16839,\"327\":16838,\"328\":16837,\"329\":16836,\"330\":16835,\"331\":16834,\"332\":16833,\"333\":16832,\"334\":16831,\"335\":16830,\"336\":16829,\"337\":16828,\"338\":16827,\"339\":16826,\"340\":16825,\"341\":16824,\"342\":16823,\"343\":16822,\"344\":16821,\"345\":16820,\"346\":16819,\"347\":16818,\"348\":16817,\"349\":16816,\"350\":16815,\"351\":16814,\"352\":16813,\"353\":16812,\"354\":16811,\"355\":16810,\"356\":16809,\"357\":16808,\"358\":16807,\"359\":16806,\"360\":16805,\"361\":16804,\"362\":16803,\"363\":16802,\"364\":16801,\"365\":16800,\"366\":16799,\"367\":16798,\"368\":16797,\"369\":16796,\"370\":16795,\"371\":16794,\"372\":16793,\"373\":16792,\"374\":16791,\"375\":16790,\"376\":16789,\"377\":16788,\"378\":16787,\"379\":16786,\"380\":16785,\"381\":16784,\"382\":16783,\"383\":16782,\"384\":16781,\"385\":16780,\"386\":16779,\"387\":16778,\"388\":16777,\"389\":16776,\"390\":16775,\"391\":16774,\"392\":16773,\"393\":16772,\"394\":16771,\"395\":16770,\"396\":16769,\"397\":16768,\"398\":16767,\"399\":16766},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("47", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "e6ee3f7f40ff7d9e9abcab5d47d6b9b9", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "0", "[{\"id\":18168,\"batched_data\":{\"400\":16765,\"401\":16764,\"402\":16763,\"403\":16762,\"404\":16761,\"405\":16760,\"406\":16759,\"407\":16758,\"408\":16757,\"409\":16756,\"410\":16755,\"411\":16754,\"412\":16753,\"413\":16752,\"414\":16751,\"415\":16750,\"416\":16749,\"417\":16748,\"418\":16747,\"419\":16746,\"420\":16745,\"421\":16744,\"422\":16743,\"423\":16742,\"424\":16741,\"425\":16740,\"426\":16739,\"427\":16738,\"428\":16737,\"429\":16736,\"430\":16735,\"431\":16734,\"432\":16733,\"433\":16732,\"434\":16731,\"435\":16730,\"436\":16729,\"437\":16728,\"438\":16727,\"439\":16726,\"440\":16725,\"441\":16724,\"442\":16723,\"443\":16722,\"444\":16721,\"445\":16720,\"446\":16719,\"447\":16718,\"448\":16717,\"449\":16716,\"450\":16715,\"451\":16714,\"452\":16713,\"453\":16712,\"454\":16711,\"455\":16710,\"456\":16709,\"457\":16708,\"458\":16707,\"459\":16706,\"460\":16705,\"461\":16704,\"462\":16703,\"463\":16702,\"464\":16701,\"465\":16700,\"466\":16699,\"467\":16698,\"468\":16697,\"469\":16696,\"470\":16695,\"471\":16694,\"472\":16693,\"473\":16692,\"474\":16691,\"475\":16690,\"476\":16689,\"477\":16688,\"478\":16687,\"479\":16686,\"480\":16685,\"481\":16684,\"482\":16683,\"483\":16682,\"484\":16681,\"485\":16680,\"486\":16679,\"487\":16678,\"488\":16677,\"489\":16676,\"490\":16675,\"491\":16674,\"492\":16673,\"493\":16672,\"494\":16671,\"495\":16670,\"496\":16669,\"497\":16668,\"498\":16667,\"499\":16666},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("48", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:47", "2024-03-18 18:15:47", "[{\"id\":18168,\"offset\":1500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("49", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "1214d6016b82c651752b3a32f312b9ba", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "0", "[{\"id\":18168,\"batched_data\":[16665,16664,16663,16662,16661,16660,16659,16658,16657,16656,16655,16654,16653,16652,16651,16650,16649,16648,16647,16646,16645,16644,16643,16642,16641,16640,16639,16638,16637,16636,16635,16634,16633,16632,16631,16630,16629,16628,16627,16626,16625,16624,16623,16622,16621,16620,16619,16618,16617,16616,16615,16614,16613,16612,16611,16610,16609,16608,16607,16606,16605,16604,16603,16602,16601,16600,16599,16598,16597,16596,16595,16594,16593,16592,16591,16590,16589,16588,16587,16586,16585,16584,16583,16582,16581,16580,16579,16578,16577,16576,16575,16574,16573,16572,16571,16570,16569,16568,16567,16566],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("50", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "d4e76a4ba34cab00520a5d45ed5e6201", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "0", "[{\"id\":18168,\"batched_data\":{\"100\":16565,\"101\":16564,\"102\":16563,\"103\":16562,\"104\":16561,\"105\":16560,\"106\":16559,\"107\":16558,\"108\":16557,\"109\":16556,\"110\":16555,\"111\":16554,\"112\":16553,\"113\":16552,\"114\":16551,\"115\":16550,\"116\":16549,\"117\":16548,\"118\":16547,\"119\":16546,\"120\":16545,\"121\":16544,\"122\":16543,\"123\":16542,\"124\":16541,\"125\":16540,\"126\":16539,\"127\":16538,\"128\":16537,\"129\":16536,\"130\":16535,\"131\":16534,\"132\":16533,\"133\":16532,\"134\":16531,\"135\":16530,\"136\":16529,\"137\":16528,\"138\":16527,\"139\":16526,\"140\":16525,\"141\":16524,\"142\":16523,\"143\":16522,\"144\":16521,\"145\":16520,\"146\":16519,\"147\":16518,\"148\":16517,\"149\":16516,\"150\":16515,\"151\":16514,\"152\":16513,\"153\":16512,\"154\":16511,\"155\":16510,\"156\":16509,\"157\":16508,\"158\":16507,\"159\":16506,\"160\":16505,\"161\":16504,\"162\":16503,\"163\":16502,\"164\":16501,\"165\":16500,\"166\":16499,\"167\":16498,\"168\":16497,\"169\":16496,\"170\":16495,\"171\":16494,\"172\":16493,\"173\":16492,\"174\":16491,\"175\":16490,\"176\":16489,\"177\":16488,\"178\":16487,\"179\":16486,\"180\":16485,\"181\":16484,\"182\":16483,\"183\":16482,\"184\":16481,\"185\":16480,\"186\":16479,\"187\":16478,\"188\":16477,\"189\":16476,\"190\":16475,\"191\":16474,\"192\":16473,\"193\":16472,\"194\":16471,\"195\":16470,\"196\":16469,\"197\":16468,\"198\":16467,\"199\":16466},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("51", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "1ceaa656e9a699bc1261d29234e82dab", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "0", "[{\"id\":18168,\"batched_data\":{\"200\":16465,\"201\":16464,\"202\":16463,\"203\":16462,\"204\":16461,\"205\":16460,\"206\":16459,\"207\":16458,\"208\":16457,\"209\":16456,\"210\":16455,\"211\":16454,\"212\":16453,\"213\":16452,\"214\":16451,\"215\":16450,\"216\":16449,\"217\":16448,\"218\":16447,\"219\":16446,\"220\":16445,\"221\":16444,\"222\":16443,\"223\":16442,\"224\":16441,\"225\":16440,\"226\":16439,\"227\":16438,\"228\":16437,\"229\":16436,\"230\":16435,\"231\":16434,\"232\":16433,\"233\":16432,\"234\":16431,\"235\":16430,\"236\":16429,\"237\":16428,\"238\":16427,\"239\":16426,\"240\":16425,\"241\":16424,\"242\":16423,\"243\":16422,\"244\":16421,\"245\":16420,\"246\":16419,\"247\":16418,\"248\":16417,\"249\":16416,\"250\":16415,\"251\":16414,\"252\":16413,\"253\":16412,\"254\":16411,\"255\":16410,\"256\":16409,\"257\":16408,\"258\":16407,\"259\":16406,\"260\":16405,\"261\":16404,\"262\":16403,\"263\":16402,\"264\":16401,\"265\":16400,\"266\":16399,\"267\":16398,\"268\":16397,\"269\":16396,\"270\":16395,\"271\":16394,\"272\":16393,\"273\":16392,\"274\":16391,\"275\":16390,\"276\":16389,\"277\":16388,\"278\":16387,\"279\":16386,\"280\":16385,\"281\":16384,\"282\":16383,\"283\":16382,\"284\":16381,\"285\":16380,\"286\":16379,\"287\":16378,\"288\":16377,\"289\":16376,\"290\":16375,\"291\":16374,\"292\":16373,\"293\":16372,\"294\":16371,\"295\":16370,\"296\":16369,\"297\":16368,\"298\":16367,\"299\":16366},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("52", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "e6d01fe3676bfed469001e3aaa90fc3a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "0", "[{\"id\":18168,\"batched_data\":{\"300\":16365,\"301\":16364,\"302\":16363,\"303\":16362,\"304\":16361,\"305\":16360,\"306\":16359,\"307\":16358,\"308\":16357,\"309\":16356,\"310\":16355,\"311\":16354,\"312\":16353,\"313\":16352,\"314\":16351,\"315\":16350,\"316\":16349,\"317\":16348,\"318\":16347,\"319\":16346,\"320\":16345,\"321\":16344,\"322\":16343,\"323\":16342,\"324\":16341,\"325\":16340,\"326\":16339,\"327\":16338,\"328\":16337,\"329\":16336,\"330\":16335,\"331\":16334,\"332\":16333,\"333\":16332,\"334\":16331,\"335\":16330,\"336\":16329,\"337\":16328,\"338\":16327,\"339\":16326,\"340\":16325,\"341\":16324,\"342\":16323,\"343\":16322,\"344\":16321,\"345\":16320,\"346\":16319,\"347\":16318,\"348\":16317,\"349\":16316,\"350\":16315,\"351\":16314,\"352\":16313,\"353\":16312,\"354\":16311,\"355\":16310,\"356\":16309,\"357\":16308,\"358\":16307,\"359\":16306,\"360\":16305,\"361\":16304,\"362\":16303,\"363\":16302,\"364\":16301,\"365\":16300,\"366\":16299,\"367\":16298,\"368\":16297,\"369\":16296,\"370\":16295,\"371\":16294,\"372\":16293,\"373\":16292,\"374\":16291,\"375\":16290,\"376\":16289,\"377\":16288,\"378\":16287,\"379\":16286,\"380\":16285,\"381\":16284,\"382\":16283,\"383\":16282,\"384\":16281,\"385\":16280,\"386\":16279,\"387\":16278,\"388\":16277,\"389\":16276,\"390\":16275,\"391\":16274,\"392\":16273,\"393\":16272,\"394\":16271,\"395\":16270,\"396\":16269,\"397\":16268,\"398\":16267,\"399\":16266},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("53", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "65f44783c459abfa5418aabef16e2dda", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "0", "[{\"id\":18168,\"batched_data\":{\"400\":16265,\"401\":16264,\"402\":16263,\"403\":16262,\"404\":16261,\"405\":16260,\"406\":16259,\"407\":16258,\"408\":16257,\"409\":16256,\"410\":16255,\"411\":16254,\"412\":16253,\"413\":16252,\"414\":16251,\"415\":16250,\"416\":16249,\"417\":16248,\"418\":16247,\"419\":16246,\"420\":16245,\"421\":16244,\"422\":16243,\"423\":16242,\"424\":16241,\"425\":16240,\"426\":16239,\"427\":16238,\"428\":16237,\"429\":16236,\"430\":16235,\"431\":16234,\"432\":16233,\"433\":16232,\"434\":16231,\"435\":16230,\"436\":16229,\"437\":16228,\"438\":16227,\"439\":16226,\"440\":16225,\"441\":16224,\"442\":16223,\"443\":16222,\"444\":16221,\"445\":16220,\"446\":16219,\"447\":16218,\"448\":16217,\"449\":16216,\"450\":16215,\"451\":16214,\"452\":16213,\"453\":16212,\"454\":16211,\"455\":16210,\"456\":16209,\"457\":16208,\"458\":16207,\"459\":16206,\"460\":16205,\"461\":16204,\"462\":16203,\"463\":16202,\"464\":16201,\"465\":16200,\"466\":16199,\"467\":16198,\"468\":16197,\"469\":16196,\"470\":16195,\"471\":16194,\"472\":16193,\"473\":16192,\"474\":16191,\"475\":16190,\"476\":16189,\"477\":16188,\"478\":16187,\"479\":16186,\"480\":16185,\"481\":16184,\"482\":16183,\"483\":16182,\"484\":16181,\"485\":16180,\"486\":16179,\"487\":16178,\"488\":16177,\"489\":16176,\"490\":16175,\"491\":16174,\"492\":16173,\"493\":16172,\"494\":16171,\"495\":16170,\"496\":16169,\"497\":16168,\"498\":16167,\"499\":16166},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":1500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("54", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:48", "2024-03-18 18:15:48", "[{\"id\":18168,\"offset\":2000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("55", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "f073b2f51fbbce3b984ce49d411f9ff1", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "0", "[{\"id\":18168,\"batched_data\":[16165,16164,16163,16162,16161,16160,16159,16158,16157,16156,16155,16154,16153,16152,16151,16150,16149,16148,16147,16146,16145,16144,16143,16142,16141,16140,16139,16138,16137,16136,16135,16134,16133,16132,16131,16130,16129,16128,16127,16126,16125,16124,16123,16122,16121,16120,16119,16118,16117,16116,16115,16114,16113,16112,16111,16110,16109,16108,16107,16106,16105,16104,16103,16102,16101,16100,16099,16098,16097,16096,16095,16094,16093,16092,16091,16090,16089,16088,16087,16086,16085,16084,16083,16082,16081,16080,16079,16078,16077,16076,16075,16074,16073,16072,16071,16070,16069,16068,16067,16066],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("56", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "acd473b9cc6f0b4b2a9cedd4b7adabd3", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "0", "[{\"id\":18168,\"batched_data\":{\"100\":16065,\"101\":16064,\"102\":16063,\"103\":16062,\"104\":16061,\"105\":16060,\"106\":16059,\"107\":16058,\"108\":16057,\"109\":16056,\"110\":16055,\"111\":16054,\"112\":16053,\"113\":16052,\"114\":16051,\"115\":16050,\"116\":16049,\"117\":16048,\"118\":16047,\"119\":16046,\"120\":16045,\"121\":16044,\"122\":16043,\"123\":16042,\"124\":16041,\"125\":16040,\"126\":16039,\"127\":16038,\"128\":16037,\"129\":16036,\"130\":16035,\"131\":16034,\"132\":16033,\"133\":16032,\"134\":16031,\"135\":16030,\"136\":16029,\"137\":16028,\"138\":16027,\"139\":16026,\"140\":16025,\"141\":16024,\"142\":16023,\"143\":16022,\"144\":16021,\"145\":16020,\"146\":16019,\"147\":16018,\"148\":16017,\"149\":16016,\"150\":16015,\"151\":16014,\"152\":16013,\"153\":16012,\"154\":16011,\"155\":16010,\"156\":16009,\"157\":16008,\"158\":16007,\"159\":16006,\"160\":16005,\"161\":16004,\"162\":16003,\"163\":16002,\"164\":16001,\"165\":16000,\"166\":15999,\"167\":15998,\"168\":15997,\"169\":15996,\"170\":15995,\"171\":15994,\"172\":15993,\"173\":15992,\"174\":15991,\"175\":15990,\"176\":15989,\"177\":15988,\"178\":15987,\"179\":15986,\"180\":15985,\"181\":15984,\"182\":15983,\"183\":15982,\"184\":15981,\"185\":15980,\"186\":15979,\"187\":15978,\"188\":15977,\"189\":15976,\"190\":15975,\"191\":15974,\"192\":15973,\"193\":15972,\"194\":15971,\"195\":15970,\"196\":15969,\"197\":15968,\"198\":15967,\"199\":15966},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("57", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "5b1cf3b063b8bad24325539fba0ced8c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "0", "[{\"id\":18168,\"batched_data\":{\"200\":15965,\"201\":15964,\"202\":15963,\"203\":15962,\"204\":15961,\"205\":15960,\"206\":15959,\"207\":15958,\"208\":15957,\"209\":15956,\"210\":15955,\"211\":15954,\"212\":15953,\"213\":15952,\"214\":15951,\"215\":15950,\"216\":15949,\"217\":15948,\"218\":15947,\"219\":15946,\"220\":15945,\"221\":15944,\"222\":15943,\"223\":15942,\"224\":15941,\"225\":15940,\"226\":15939,\"227\":15938,\"228\":15937,\"229\":15936,\"230\":15935,\"231\":15934,\"232\":15933,\"233\":15932,\"234\":15931,\"235\":15930,\"236\":15929,\"237\":15928,\"238\":15927,\"239\":15926,\"240\":15925,\"241\":15924,\"242\":15923,\"243\":15922,\"244\":15921,\"245\":15920,\"246\":15919,\"247\":15918,\"248\":15917,\"249\":15916,\"250\":15915,\"251\":15914,\"252\":15913,\"253\":15912,\"254\":15911,\"255\":15910,\"256\":15909,\"257\":15908,\"258\":15907,\"259\":15906,\"260\":15905,\"261\":15904,\"262\":15903,\"263\":15902,\"264\":15901,\"265\":15900,\"266\":15899,\"267\":15898,\"268\":15897,\"269\":15896,\"270\":15895,\"271\":15894,\"272\":15893,\"273\":15892,\"274\":15891,\"275\":15890,\"276\":15889,\"277\":15888,\"278\":15887,\"279\":15886,\"280\":15885,\"281\":15884,\"282\":15883,\"283\":15882,\"284\":15881,\"285\":15880,\"286\":15879,\"287\":15878,\"288\":15877,\"289\":15876,\"290\":15875,\"291\":15874,\"292\":15873,\"293\":15872,\"294\":15871,\"295\":15870,\"296\":15869,\"297\":15868,\"298\":15867,\"299\":15866},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("58", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "821f98d31eb1fe866077be925c79cc57", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "0", "[{\"id\":18168,\"batched_data\":{\"300\":15865,\"301\":15864,\"302\":15863,\"303\":15862,\"304\":15861,\"305\":15860,\"306\":15859,\"307\":15858,\"308\":15857,\"309\":15856,\"310\":15855,\"311\":15854,\"312\":15853,\"313\":15852,\"314\":15851,\"315\":15850,\"316\":15849,\"317\":15848,\"318\":15847,\"319\":15846,\"320\":15845,\"321\":15844,\"322\":15843,\"323\":15842,\"324\":15841,\"325\":15840,\"326\":15839,\"327\":15838,\"328\":15837,\"329\":15836,\"330\":15835,\"331\":15834,\"332\":15833,\"333\":15832,\"334\":15831,\"335\":15830,\"336\":15829,\"337\":15828,\"338\":15827,\"339\":15826,\"340\":15825,\"341\":15824,\"342\":15823,\"343\":15822,\"344\":15821,\"345\":15820,\"346\":15819,\"347\":15818,\"348\":15817,\"349\":15816,\"350\":15815,\"351\":15814,\"352\":15813,\"353\":15812,\"354\":15811,\"355\":15810,\"356\":15809,\"357\":15808,\"358\":15807,\"359\":15806,\"360\":15805,\"361\":15804,\"362\":15803,\"363\":15802,\"364\":15801,\"365\":15800,\"366\":15799,\"367\":15798,\"368\":15797,\"369\":15796,\"370\":15795,\"371\":15794,\"372\":15793,\"373\":15792,\"374\":15791,\"375\":15790,\"376\":15789,\"377\":15788,\"378\":15787,\"379\":15786,\"380\":15785,\"381\":15784,\"382\":15783,\"383\":15782,\"384\":15781,\"385\":15780,\"386\":15779,\"387\":15778,\"388\":15777,\"389\":15776,\"390\":15775,\"391\":15774,\"392\":15773,\"393\":15772,\"394\":15771,\"395\":15770,\"396\":15769,\"397\":15768,\"398\":15767,\"399\":15766},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("59", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "1f4ad961fdaefb572b8b87a4ec794312", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "0", "[{\"id\":18168,\"batched_data\":{\"400\":15765,\"401\":15764,\"402\":15763,\"403\":15762,\"404\":15761,\"405\":15760,\"406\":15759,\"407\":15758,\"408\":15757,\"409\":15756,\"410\":15755,\"411\":15754,\"412\":15753,\"413\":15752,\"414\":15751,\"415\":15750,\"416\":15749,\"417\":15748,\"418\":15747,\"419\":15746,\"420\":15745,\"421\":15744,\"422\":15743,\"423\":15742,\"424\":15741,\"425\":15740,\"426\":15739,\"427\":15738,\"428\":15737,\"429\":15736,\"430\":15735,\"431\":15734,\"432\":15733,\"433\":15732,\"434\":15731,\"435\":15730,\"436\":15729,\"437\":15728,\"438\":15727,\"439\":15726,\"440\":15725,\"441\":15724,\"442\":15723,\"443\":15722,\"444\":15721,\"445\":15720,\"446\":15719,\"447\":15718,\"448\":15717,\"449\":15716,\"450\":15715,\"451\":15714,\"452\":15713,\"453\":15712,\"454\":15711,\"455\":15710,\"456\":15709,\"457\":15708,\"458\":15707,\"459\":15706,\"460\":15705,\"461\":15704,\"462\":15703,\"463\":15702,\"464\":15701,\"465\":15700,\"466\":15699,\"467\":15698,\"468\":15697,\"469\":15696,\"470\":15695,\"471\":15694,\"472\":15693,\"473\":15692,\"474\":15691,\"475\":15690,\"476\":15689,\"477\":15688,\"478\":15687,\"479\":15686,\"480\":15685,\"481\":15684,\"482\":15683,\"483\":15682,\"484\":15681,\"485\":15680,\"486\":15679,\"487\":15678,\"488\":15677,\"489\":15676,\"490\":15675,\"491\":15674,\"492\":15673,\"493\":15672,\"494\":15671,\"495\":15670,\"496\":15669,\"497\":15668,\"498\":15667,\"499\":15666},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("60", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:49", "2024-03-18 18:15:49", "[{\"id\":18168,\"offset\":2500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("61", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "9a5672681b7515c18221507c536518ec", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "0", "[{\"id\":18168,\"batched_data\":[15665,15664,15663,15662,15661,15660,15659,15658,15657,15656,15655,15654,15653,15652,15651,15650,15649,15648,15647,15646,15645,15644,15643,15642,15641,15640,15639,15638,15637,15636,15635,15634,15633,15632,15631,15630,15629,15628,15627,15626,15625,15624,15623,15622,15621,15620,15619,15618,15617,15616,15615,15614,15613,15612,15611,15610,15609,15608,15607,15606,15605,15604,15603,15602,15601,15600,15599,15598,15597,15596,15595,15594,15593,15592,15591,15590,15589,15588,15587,15586,15585,15584,15583,15582,15581,15580,15579,15578,15577,15576,15575,15574,15573,15572,15571,15570,15569,15568,15567,15566],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("62", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "727865e4013426527542de189eac1714", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "0", "[{\"id\":18168,\"batched_data\":{\"100\":15565,\"101\":15564,\"102\":15563,\"103\":15562,\"104\":15561,\"105\":15560,\"106\":15559,\"107\":15558,\"108\":15557,\"109\":15556,\"110\":15555,\"111\":15554,\"112\":15553,\"113\":15552,\"114\":15551,\"115\":15550,\"116\":15549,\"117\":15548,\"118\":15547,\"119\":15546,\"120\":15545,\"121\":15544,\"122\":15543,\"123\":15542,\"124\":15541,\"125\":15540,\"126\":15539,\"127\":15538,\"128\":15537,\"129\":15536,\"130\":15535,\"131\":15534,\"132\":15533,\"133\":15532,\"134\":15531,\"135\":15530,\"136\":15529,\"137\":15528,\"138\":15527,\"139\":15526,\"140\":15525,\"141\":15524,\"142\":15523,\"143\":15522,\"144\":15521,\"145\":15520,\"146\":15519,\"147\":15518,\"148\":15517,\"149\":15516,\"150\":15515,\"151\":15514,\"152\":15513,\"153\":15512,\"154\":15511,\"155\":15510,\"156\":15509,\"157\":15508,\"158\":15507,\"159\":15506,\"160\":15505,\"161\":15504,\"162\":15503,\"163\":15502,\"164\":15501,\"165\":15500,\"166\":15499,\"167\":15498,\"168\":15497,\"169\":15496,\"170\":15495,\"171\":15494,\"172\":15493,\"173\":15492,\"174\":15491,\"175\":15490,\"176\":15489,\"177\":15488,\"178\":15487,\"179\":15486,\"180\":15485,\"181\":15484,\"182\":15483,\"183\":15482,\"184\":15481,\"185\":15480,\"186\":15479,\"187\":15478,\"188\":15477,\"189\":15476,\"190\":15475,\"191\":15474,\"192\":15473,\"193\":15472,\"194\":15471,\"195\":15470,\"196\":15469,\"197\":15468,\"198\":15467,\"199\":15466},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("63", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "ee36f2c2005fd9c3313a11f7ef12996e", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "0", "[{\"id\":18168,\"batched_data\":{\"200\":15465,\"201\":15464,\"202\":15463,\"203\":15462,\"204\":15461,\"205\":15460,\"206\":15459,\"207\":15458,\"208\":15457,\"209\":15456,\"210\":15455,\"211\":15454,\"212\":15453,\"213\":15452,\"214\":15451,\"215\":15450,\"216\":15449,\"217\":15448,\"218\":15447,\"219\":15446,\"220\":15445,\"221\":15444,\"222\":15443,\"223\":15442,\"224\":15441,\"225\":15440,\"226\":15439,\"227\":15438,\"228\":15437,\"229\":15436,\"230\":15435,\"231\":15434,\"232\":15433,\"233\":15432,\"234\":15431,\"235\":15430,\"236\":15429,\"237\":15428,\"238\":15427,\"239\":15426,\"240\":15425,\"241\":15424,\"242\":15423,\"243\":15422,\"244\":15421,\"245\":15420,\"246\":15419,\"247\":15418,\"248\":15417,\"249\":15416,\"250\":15415,\"251\":15414,\"252\":15413,\"253\":15412,\"254\":15411,\"255\":15410,\"256\":15409,\"257\":15408,\"258\":15407,\"259\":15406,\"260\":15405,\"261\":15404,\"262\":15403,\"263\":15402,\"264\":15401,\"265\":15400,\"266\":15399,\"267\":15398,\"268\":15397,\"269\":15396,\"270\":15395,\"271\":15394,\"272\":15393,\"273\":15392,\"274\":15391,\"275\":15390,\"276\":15389,\"277\":15388,\"278\":15387,\"279\":15386,\"280\":15385,\"281\":15384,\"282\":15383,\"283\":15382,\"284\":15381,\"285\":15380,\"286\":15379,\"287\":15378,\"288\":15377,\"289\":15376,\"290\":15375,\"291\":15374,\"292\":15373,\"293\":15372,\"294\":15371,\"295\":15370,\"296\":15369,\"297\":15368,\"298\":15367,\"299\":15366},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("64", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "ec77152cd55525740bca49b1e6ef43e3", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "0", "[{\"id\":18168,\"batched_data\":{\"300\":15365,\"301\":15364,\"302\":15363,\"303\":15362,\"304\":15361,\"305\":15360,\"306\":15359,\"307\":15358,\"308\":15357,\"309\":15356,\"310\":15355,\"311\":15354,\"312\":15353,\"313\":15352,\"314\":15351,\"315\":15350,\"316\":15349,\"317\":15348,\"318\":15347,\"319\":15346,\"320\":15345,\"321\":15344,\"322\":15343,\"323\":15342,\"324\":15341,\"325\":15340,\"326\":15339,\"327\":15338,\"328\":15337,\"329\":15336,\"330\":15335,\"331\":15334,\"332\":15333,\"333\":15332,\"334\":15331,\"335\":15330,\"336\":15329,\"337\":15328,\"338\":15327,\"339\":15326,\"340\":15325,\"341\":15324,\"342\":15323,\"343\":15322,\"344\":15321,\"345\":15320,\"346\":15319,\"347\":15318,\"348\":15317,\"349\":15316,\"350\":15315,\"351\":15314,\"352\":15313,\"353\":15312,\"354\":15311,\"355\":15310,\"356\":15309,\"357\":15308,\"358\":15307,\"359\":15306,\"360\":15305,\"361\":15304,\"362\":15303,\"363\":15302,\"364\":15301,\"365\":15300,\"366\":15299,\"367\":15298,\"368\":15297,\"369\":15296,\"370\":15295,\"371\":15294,\"372\":15293,\"373\":15292,\"374\":15291,\"375\":15290,\"376\":15289,\"377\":15288,\"378\":15287,\"379\":15286,\"380\":15285,\"381\":15284,\"382\":15283,\"383\":15282,\"384\":15281,\"385\":15280,\"386\":15279,\"387\":15278,\"388\":15277,\"389\":15276,\"390\":15275,\"391\":15274,\"392\":15273,\"393\":15272,\"394\":15271,\"395\":15270,\"396\":15269,\"397\":15268,\"398\":15267,\"399\":15266},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("65", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "f7e8b3a923141fbccd314942484f277a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "0", "[{\"id\":18168,\"batched_data\":{\"400\":15265,\"401\":15264,\"402\":15263,\"403\":15262,\"404\":15261,\"405\":15260,\"406\":15259,\"407\":15258,\"408\":15257,\"409\":15256,\"410\":15255,\"411\":15254,\"412\":15253,\"413\":15252,\"414\":15251,\"415\":15250,\"416\":15249,\"417\":15248,\"418\":15247,\"419\":15246,\"420\":15245,\"421\":15244,\"422\":15243,\"423\":15242,\"424\":15241,\"425\":15240,\"426\":15239,\"427\":15238,\"428\":15237,\"429\":15236,\"430\":15235,\"431\":15234,\"432\":15233,\"433\":15232,\"434\":15231,\"435\":15230,\"436\":15229,\"437\":15228,\"438\":15227,\"439\":15226,\"440\":15225,\"441\":15224,\"442\":15223,\"443\":15222,\"444\":15221,\"445\":15220,\"446\":15219,\"447\":15218,\"448\":15217,\"449\":15216,\"450\":15215,\"451\":15214,\"452\":15213,\"453\":15212,\"454\":15211,\"455\":15210,\"456\":15209,\"457\":15208,\"458\":15207,\"459\":15206,\"460\":15205,\"461\":15204,\"462\":15203,\"463\":15202,\"464\":15201,\"465\":15200,\"466\":15199,\"467\":15198,\"468\":15197,\"469\":15196,\"470\":15195,\"471\":15194,\"472\":15193,\"473\":15192,\"474\":15191,\"475\":15190,\"476\":15189,\"477\":15188,\"478\":15187,\"479\":15186,\"480\":15185,\"481\":15184,\"482\":15183,\"483\":15182,\"484\":15181,\"485\":15180,\"486\":15179,\"487\":15178,\"488\":15177,\"489\":15176,\"490\":15175,\"491\":15174,\"492\":15173,\"493\":15172,\"494\":15171,\"495\":15170,\"496\":15169,\"497\":15168,\"498\":15167,\"499\":15166},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":2500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("66", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:50", "2024-03-18 18:15:50", "[{\"id\":18168,\"offset\":3000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("67", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "1398ea1daeef0d2525d274d4e24dacab", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "0", "[{\"id\":18168,\"batched_data\":[15165,15164,15163,15162,15161,15160,15159,15158,15157,15156,15155,15154,15153,15152,15151,15150,15149,15148,15147,15146,15145,15144,15143,15142,15141,15140,15139,15138,15137,15136,15135,15134,15133,15132,15131,15130,15129,15128,15127,15126,15125,15124,15123,15122,15121,15120,15119,15118,15117,15116,15115,15114,15113,15112,15111,15110,15109,15108,15107,15106,15105,15104,15103,15102,15101,15100,15099,15098,15097,15096,15095,15094,15093,15092,15091,15090,15089,15088,15087,15086,15085,15084,15083,15082,15081,15080,15079,15078,15077,15076,15075,15074,15073,15072,15071,15070,15069,15068,15067,15066],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("68", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "f4156aa2a705bc5a4e34d252fbcaef37", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:53", "2024-03-18 18:15:53", "0", "[{\"id\":18168,\"batched_data\":{\"100\":15065,\"101\":15064,\"102\":15063,\"103\":15062,\"104\":15061,\"105\":15060,\"106\":15059,\"107\":15058,\"108\":15057,\"109\":15056,\"110\":15055,\"111\":15054,\"112\":15053,\"113\":15052,\"114\":15051,\"115\":15050,\"116\":15049,\"117\":15048,\"118\":15047,\"119\":15046,\"120\":15045,\"121\":15044,\"122\":15043,\"123\":15042,\"124\":15041,\"125\":15040,\"126\":15039,\"127\":15038,\"128\":15037,\"129\":15036,\"130\":15035,\"131\":15034,\"132\":15033,\"133\":15032,\"134\":15031,\"135\":15030,\"136\":15029,\"137\":15028,\"138\":15027,\"139\":15026,\"140\":15025,\"141\":15024,\"142\":15023,\"143\":15022,\"144\":15021,\"145\":15020,\"146\":15019,\"147\":15018,\"148\":15017,\"149\":15016,\"150\":15015,\"151\":15014,\"152\":15013,\"153\":15012,\"154\":15011,\"155\":15010,\"156\":15009,\"157\":15008,\"158\":15007,\"159\":15006,\"160\":15005,\"161\":15004,\"162\":15003,\"163\":15002,\"164\":15001,\"165\":15000,\"166\":14999,\"167\":14998,\"168\":14997,\"169\":14996,\"170\":14995,\"171\":14994,\"172\":14993,\"173\":14992,\"174\":14991,\"175\":14990,\"176\":14989,\"177\":14988,\"178\":14987,\"179\":14986,\"180\":14985,\"181\":14984,\"182\":14983,\"183\":14982,\"184\":14981,\"185\":14980,\"186\":14979,\"187\":14978,\"188\":14977,\"189\":14976,\"190\":14975,\"191\":14974,\"192\":14973,\"193\":14972,\"194\":14971,\"195\":14970,\"196\":14969,\"197\":14968,\"198\":14967,\"199\":14966},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("69", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "1ab2328e618f5dd08eefe2fc2acc576b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:53", "2024-03-18 18:15:53", "0", "[{\"id\":18168,\"batched_data\":{\"200\":14965,\"201\":14964,\"202\":14963,\"203\":14962,\"204\":14961,\"205\":14960,\"206\":14959,\"207\":14958,\"208\":14957,\"209\":14956,\"210\":14955,\"211\":14954,\"212\":14953,\"213\":14952,\"214\":14951,\"215\":14950,\"216\":14949,\"217\":14948,\"218\":14947,\"219\":14946,\"220\":14945,\"221\":14944,\"222\":14943,\"223\":14942,\"224\":14941,\"225\":14940,\"226\":14939,\"227\":14938,\"228\":14937,\"229\":14936,\"230\":14935,\"231\":14934,\"232\":14933,\"233\":14932,\"234\":14931,\"235\":14930,\"236\":14929,\"237\":14928,\"238\":14927,\"239\":14926,\"240\":14925,\"241\":14924,\"242\":14923,\"243\":14922,\"244\":14921,\"245\":14920,\"246\":14919,\"247\":14918,\"248\":14917,\"249\":14916,\"250\":14915,\"251\":14914,\"252\":14913,\"253\":14912,\"254\":14911,\"255\":14910,\"256\":14909,\"257\":14908,\"258\":14907,\"259\":14906,\"260\":14905,\"261\":14904,\"262\":14903,\"263\":14902,\"264\":14901,\"265\":14900,\"266\":14899,\"267\":14898,\"268\":14897,\"269\":14896,\"270\":14895,\"271\":14894,\"272\":14893,\"273\":14892,\"274\":14891,\"275\":14890,\"276\":14889,\"277\":14888,\"278\":14887,\"279\":14886,\"280\":14885,\"281\":14884,\"282\":14883,\"283\":14882,\"284\":14881,\"285\":14880,\"286\":14879,\"287\":14878,\"288\":14877,\"289\":14876,\"290\":14875,\"291\":14874,\"292\":14873,\"293\":14872,\"294\":14871,\"295\":14870,\"296\":14869,\"297\":14868,\"298\":14867,\"299\":14866},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("70", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "1f9e50912fb085052ed0002ff60e8856", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:53", "2024-03-18 18:15:53", "0", "[{\"id\":18168,\"batched_data\":{\"300\":14865,\"301\":14864,\"302\":14863,\"303\":14862,\"304\":14861,\"305\":14860,\"306\":14859,\"307\":14858,\"308\":14857,\"309\":14856,\"310\":14855,\"311\":14854,\"312\":14853,\"313\":14852,\"314\":14851,\"315\":14850,\"316\":14849,\"317\":14848,\"318\":14847,\"319\":14846,\"320\":14845,\"321\":14844,\"322\":14843,\"323\":14842,\"324\":14841,\"325\":14840,\"326\":14839,\"327\":14838,\"328\":14837,\"329\":14836,\"330\":14835,\"331\":14834,\"332\":14833,\"333\":14832,\"334\":14831,\"335\":14830,\"336\":14829,\"337\":14828,\"338\":14827,\"339\":14826,\"340\":14825,\"341\":14824,\"342\":14823,\"343\":14822,\"344\":14821,\"345\":14820,\"346\":14819,\"347\":14818,\"348\":14817,\"349\":14816,\"350\":14815,\"351\":14814,\"352\":14813,\"353\":14812,\"354\":14811,\"355\":14810,\"356\":14809,\"357\":14808,\"358\":14807,\"359\":14806,\"360\":14805,\"361\":14804,\"362\":14803,\"363\":14802,\"364\":14801,\"365\":14800,\"366\":14799,\"367\":14798,\"368\":14797,\"369\":14796,\"370\":14795,\"371\":14794,\"372\":14793,\"373\":14792,\"374\":14791,\"375\":14790,\"376\":14789,\"377\":14788,\"378\":14787,\"379\":14786,\"380\":14785,\"381\":14784,\"382\":14783,\"383\":14782,\"384\":14781,\"385\":14780,\"386\":14779,\"387\":14778,\"388\":14777,\"389\":14776,\"390\":14775,\"391\":14774,\"392\":14773,\"393\":14772,\"394\":14771,\"395\":14770,\"396\":14769,\"397\":14768,\"398\":14767,\"399\":14766},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("71", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "1cc7c9d6cc196001d3191b51a15cf7df", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "0", "[{\"id\":18168,\"batched_data\":{\"400\":14765,\"401\":14764,\"402\":14763,\"403\":14762,\"404\":14761,\"405\":14760,\"406\":14759,\"407\":14758,\"408\":14757,\"409\":14756,\"410\":14755,\"411\":14754,\"412\":14753,\"413\":14752,\"414\":14751,\"415\":14750,\"416\":14749,\"417\":14748,\"418\":14747,\"419\":14746,\"420\":14745,\"421\":14744,\"422\":14743,\"423\":14742,\"424\":14741,\"425\":14740,\"426\":14739,\"427\":14738,\"428\":14737,\"429\":14736,\"430\":14735,\"431\":14734,\"432\":14733,\"433\":14732,\"434\":14731,\"435\":14730,\"436\":14729,\"437\":14728,\"438\":14727,\"439\":14726,\"440\":14725,\"441\":14724,\"442\":14723,\"443\":14722,\"444\":14721,\"445\":14720,\"446\":14719,\"447\":14718,\"448\":14717,\"449\":14716,\"450\":14715,\"451\":14714,\"452\":14713,\"453\":14712,\"454\":14711,\"455\":14710,\"456\":14709,\"457\":14708,\"458\":14707,\"459\":14706,\"460\":14705,\"461\":14704,\"462\":14703,\"463\":14702,\"464\":14701,\"465\":14700,\"466\":14699,\"467\":14698,\"468\":14697,\"469\":14696,\"470\":14695,\"471\":14694,\"472\":14693,\"473\":14692,\"474\":14691,\"475\":14690,\"476\":14689,\"477\":14688,\"478\":14687,\"479\":14686,\"480\":14685,\"481\":14684,\"482\":14683,\"483\":14682,\"484\":14681,\"485\":14680,\"486\":14679,\"487\":14678,\"488\":14677,\"489\":14676,\"490\":14675,\"491\":14674,\"492\":14673,\"493\":14672,\"494\":14671,\"495\":14670,\"496\":14669,\"497\":14668,\"498\":14667,\"499\":14666},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("72", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:51", "2024-03-18 18:15:51", "[{\"id\":18168,\"offset\":3500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("73", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "bbb3b8fd18eb94b9cb276a5df499f718", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "0", "[{\"id\":18168,\"batched_data\":[14665,14664,14663,14662,14661,14660,14659,14658,14657,14656,14655,14654,14653,14652,14651,14650,14649,14648,14647,14646,14645,14644,14643,14642,14641,14640,14639,14638,14637,14636,14635,14634,14633,14632,14631,14630,14629,14628,14627,14626,14625,14624,14623,14622,14621,14620,14619,14618,14617,14616,14615,14614,14613,14612,14611,14610,14609,14608,14607,14606,14605,14604,14603,14602,14601,14600,14599,14598,14597,14596,14595,14594,14593,14592,14591,14590,14589,14588,14587,14586,14581,14580,14579,14578,14577,14576,14575,14574,14573,14572,14571,14570,14569,14568,14567,14566,14565,14564,14563,14562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("74", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "ccd58d94d97cf819a32f22d4debe7cd5", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "0", "[{\"id\":18168,\"batched_data\":{\"100\":14561,\"101\":14560,\"102\":14559,\"103\":14558,\"104\":14557,\"105\":14556,\"106\":14555,\"107\":14554,\"108\":14553,\"109\":14552,\"110\":14551,\"111\":14550,\"112\":14549,\"113\":14548,\"114\":14547,\"115\":14546,\"116\":14545,\"117\":14544,\"118\":14543,\"119\":14542,\"120\":14541,\"121\":14540,\"122\":14539,\"123\":14538,\"124\":14537,\"125\":14536,\"126\":14535,\"127\":14534,\"128\":14533,\"129\":14532,\"130\":14531,\"131\":14530,\"132\":14529,\"133\":14528,\"134\":14527,\"135\":14526,\"136\":14525,\"137\":14524,\"138\":14523,\"139\":14522,\"140\":14521,\"141\":14520,\"142\":14519,\"143\":14518,\"144\":14517,\"145\":14516,\"146\":14515,\"147\":14514,\"148\":14513,\"149\":14512,\"150\":14511,\"151\":14510,\"152\":14509,\"153\":14508,\"154\":14507,\"155\":14506,\"156\":14505,\"157\":14504,\"158\":14503,\"159\":14502,\"160\":14501,\"161\":14500,\"162\":14499,\"163\":14498,\"164\":14497,\"165\":14496,\"166\":14495,\"167\":14494,\"168\":14493,\"169\":14492,\"170\":14491,\"171\":14490,\"172\":14489,\"173\":14488,\"174\":14487,\"175\":14486,\"176\":14485,\"177\":14484,\"178\":14483,\"179\":14482,\"180\":14481,\"181\":14480,\"182\":14479,\"183\":14478,\"184\":14477,\"185\":14476,\"186\":14475,\"187\":14474,\"188\":14473,\"189\":14472,\"190\":14471,\"191\":14470,\"192\":14469,\"193\":14468,\"194\":14467,\"195\":14466,\"196\":14465,\"197\":14464,\"198\":14463,\"199\":14462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("75", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "1c7de84553189104625665dc5292e83c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "0", "[{\"id\":18168,\"batched_data\":{\"200\":14461,\"201\":14460,\"202\":14459,\"203\":14458,\"204\":14457,\"205\":14456,\"206\":14455,\"207\":14454,\"208\":14453,\"209\":14452,\"210\":14451,\"211\":14450,\"212\":14449,\"213\":14448,\"214\":14447,\"215\":14446,\"216\":14445,\"217\":14444,\"218\":14443,\"219\":14442,\"220\":14441,\"221\":14440,\"222\":14439,\"223\":14438,\"224\":14437,\"225\":14436,\"226\":14435,\"227\":14434,\"228\":14433,\"229\":14432,\"230\":14431,\"231\":14430,\"232\":14429,\"233\":14428,\"234\":14427,\"235\":14426,\"236\":14425,\"237\":14424,\"238\":14423,\"239\":14422,\"240\":14421,\"241\":14420,\"242\":14419,\"243\":14418,\"244\":14417,\"245\":14416,\"246\":14415,\"247\":14414,\"248\":14413,\"249\":14412,\"250\":14411,\"251\":14410,\"252\":14409,\"253\":14408,\"254\":14407,\"255\":14406,\"256\":14405,\"257\":14404,\"258\":14403,\"259\":14402,\"260\":14401,\"261\":14400,\"262\":14399,\"263\":14398,\"264\":14397,\"265\":14396,\"266\":14395,\"267\":14394,\"268\":14393,\"269\":14392,\"270\":14391,\"271\":14390,\"272\":14389,\"273\":14388,\"274\":14387,\"275\":14386,\"276\":14385,\"277\":14384,\"278\":14383,\"279\":14382,\"280\":14381,\"281\":14380,\"282\":14379,\"283\":14378,\"284\":14377,\"285\":14376,\"286\":14375,\"287\":14374,\"288\":14373,\"289\":14372,\"290\":14371,\"291\":14370,\"292\":14369,\"293\":14368,\"294\":14367,\"295\":14366,\"296\":14365,\"297\":14364,\"298\":14363,\"299\":14362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("76", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "550818921f9509a4118e84b1178fba5f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "0", "[{\"id\":18168,\"batched_data\":{\"300\":14361,\"301\":14360,\"302\":14359,\"303\":14358,\"304\":14357,\"305\":14356,\"306\":14355,\"307\":14354,\"308\":14353,\"309\":14352,\"310\":14351,\"311\":14350,\"312\":14349,\"313\":14348,\"314\":14347,\"315\":14346,\"316\":14345,\"317\":14344,\"318\":14343,\"319\":14342,\"320\":14341,\"321\":14340,\"322\":14339,\"323\":14338,\"324\":14337,\"325\":14336,\"326\":14335,\"327\":14334,\"328\":14333,\"329\":14332,\"330\":14331,\"331\":14330,\"332\":14329,\"333\":14328,\"334\":14327,\"335\":14326,\"336\":14325,\"337\":14324,\"338\":14323,\"339\":14322,\"340\":14321,\"341\":14320,\"342\":14319,\"343\":14318,\"344\":14317,\"345\":14316,\"346\":14315,\"347\":14314,\"348\":14313,\"349\":14312,\"350\":14311,\"351\":14310,\"352\":14309,\"353\":14308,\"354\":14307,\"355\":14306,\"356\":14305,\"357\":14304,\"358\":14303,\"359\":14302,\"360\":14301,\"361\":14300,\"362\":14299,\"363\":14298,\"364\":14297,\"365\":14296,\"366\":14295,\"367\":14294,\"368\":14293,\"369\":14292,\"370\":14291,\"371\":14290,\"372\":14289,\"373\":14288,\"374\":14287,\"375\":14286,\"376\":14285,\"377\":14284,\"378\":14283,\"379\":14282,\"380\":14281,\"381\":14280,\"382\":14279,\"383\":14278,\"384\":14277,\"385\":14276,\"386\":14275,\"387\":14274,\"388\":14273,\"389\":14272,\"390\":14271,\"391\":14270,\"392\":14269,\"393\":14268,\"394\":14267,\"395\":14266,\"396\":14265,\"397\":14264,\"398\":14263,\"399\":14262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("77", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "5fb8aa412dd96734d2ce66063bb3b38d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "0", "[{\"id\":18168,\"batched_data\":{\"400\":14261,\"401\":14260,\"402\":14259,\"403\":14258,\"404\":14257,\"405\":14256,\"406\":14255,\"407\":14254,\"408\":14253,\"409\":14252,\"410\":14251,\"411\":14250,\"412\":14249,\"413\":14248,\"414\":14247,\"415\":14246,\"416\":14245,\"417\":14244,\"418\":14243,\"419\":14242,\"420\":14241,\"421\":14240,\"422\":14239,\"423\":14238,\"424\":14237,\"425\":14236,\"426\":14235,\"427\":14234,\"428\":14233,\"429\":14232,\"430\":14231,\"431\":14230,\"432\":14229,\"433\":14228,\"434\":14227,\"435\":14226,\"436\":14225,\"437\":14224,\"438\":14223,\"439\":14222,\"440\":14221,\"441\":14220,\"442\":14219,\"443\":14218,\"444\":14217,\"445\":14216,\"446\":14215,\"447\":14214,\"448\":14213,\"449\":14212,\"450\":14211,\"451\":14210,\"452\":14209,\"453\":14208,\"454\":14207,\"455\":14206,\"456\":14205,\"457\":14204,\"458\":14203,\"459\":14202,\"460\":14201,\"461\":14200,\"462\":14199,\"463\":14198,\"464\":14197,\"465\":14196,\"466\":14195,\"467\":14194,\"468\":14193,\"469\":14192,\"470\":14191,\"471\":14190,\"472\":14189,\"473\":14188,\"474\":14187,\"475\":14186,\"476\":14185,\"477\":14184,\"478\":14183,\"479\":14182,\"480\":14181,\"481\":14180,\"482\":14179,\"483\":14178,\"484\":14177,\"485\":14176,\"486\":14175,\"487\":14174,\"488\":14173,\"489\":14172,\"490\":14171,\"491\":14170,\"492\":14169,\"493\":14168,\"494\":14167,\"495\":14166,\"496\":14165,\"497\":14164,\"498\":14163,\"499\":14162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":3500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("78", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:54", "2024-03-18 18:15:54", "[{\"id\":18168,\"offset\":4000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("79", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "86c08372c0bdbb56d580d5221c23d81d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "0", "[{\"id\":18168,\"batched_data\":[14161,14160,14159,14158,14157,14156,14155,14154,14153,14152,14151,14150,14149,14148,14147,14146,14145,14144,14143,14142,14141,14140,14139,14138,14137,14136,14135,14134,14133,14132,14131,14130,14129,14128,14127,14126,14125,14124,14123,14122,14121,14120,14119,14118,14117,14116,14115,14114,14113,14112,14111,14110,14109,14108,14107,14106,14105,14104,14103,14102,14101,14100,14099,14098,14097,14096,14095,14094,14093,14092,14091,14090,14089,14088,14087,14086,14085,14084,14083,14082,14081,14080,14079,14078,14077,14076,14075,14074,14073,14072,14071,14070,14069,14068,14067,14066,14065,14064,14063,14062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("80", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "c02ee659cf081ab4e98db5374a6e2948", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "0", "[{\"id\":18168,\"batched_data\":{\"100\":14061,\"101\":14060,\"102\":14059,\"103\":14058,\"104\":14057,\"105\":14056,\"106\":14055,\"107\":14054,\"108\":14053,\"109\":14052,\"110\":14051,\"111\":14050,\"112\":14049,\"113\":14048,\"114\":14047,\"115\":14046,\"116\":14045,\"117\":14044,\"118\":14043,\"119\":14042,\"120\":14041,\"121\":14040,\"122\":14039,\"123\":14038,\"124\":14037,\"125\":14036,\"126\":14035,\"127\":14034,\"128\":14033,\"129\":14032,\"130\":14031,\"131\":14030,\"132\":14029,\"133\":14028,\"134\":14027,\"135\":14026,\"136\":14025,\"137\":14024,\"138\":14023,\"139\":14022,\"140\":14021,\"141\":14020,\"142\":14019,\"143\":14018,\"144\":14017,\"145\":14016,\"146\":14015,\"147\":14014,\"148\":14013,\"149\":14012,\"150\":14011,\"151\":14010,\"152\":14009,\"153\":14008,\"154\":14007,\"155\":14006,\"156\":14005,\"157\":14004,\"158\":14003,\"159\":14002,\"160\":14001,\"161\":14000,\"162\":13999,\"163\":13998,\"164\":13997,\"165\":13996,\"166\":13995,\"167\":13994,\"168\":13993,\"169\":13992,\"170\":13991,\"171\":13990,\"172\":13989,\"173\":13988,\"174\":13987,\"175\":13986,\"176\":13985,\"177\":13984,\"178\":13983,\"179\":13982,\"180\":13981,\"181\":13980,\"182\":13979,\"183\":13978,\"184\":13977,\"185\":13976,\"186\":13975,\"187\":13974,\"188\":13973,\"189\":13972,\"190\":13971,\"191\":13970,\"192\":13969,\"193\":13968,\"194\":13967,\"195\":13966,\"196\":13965,\"197\":13964,\"198\":13963,\"199\":13962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("81", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "57999acbb821bae16569f00ac63ec87c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "0", "[{\"id\":18168,\"batched_data\":{\"200\":13961,\"201\":13960,\"202\":13959,\"203\":13958,\"204\":13957,\"205\":13956,\"206\":13955,\"207\":13954,\"208\":13953,\"209\":13952,\"210\":13951,\"211\":13950,\"212\":13949,\"213\":13948,\"214\":13947,\"215\":13946,\"216\":13945,\"217\":13944,\"218\":13943,\"219\":13942,\"220\":13941,\"221\":13940,\"222\":13939,\"223\":13938,\"224\":13937,\"225\":13936,\"226\":13935,\"227\":13934,\"228\":13933,\"229\":13932,\"230\":13931,\"231\":13930,\"232\":13929,\"233\":13928,\"234\":13927,\"235\":13926,\"236\":13925,\"237\":13924,\"238\":13923,\"239\":13922,\"240\":13921,\"241\":13920,\"242\":13919,\"243\":13918,\"244\":13917,\"245\":13916,\"246\":13915,\"247\":13914,\"248\":13913,\"249\":13912,\"250\":13911,\"251\":13910,\"252\":13909,\"253\":13908,\"254\":13907,\"255\":13906,\"256\":13905,\"257\":13904,\"258\":13903,\"259\":13902,\"260\":13901,\"261\":13900,\"262\":13899,\"263\":13898,\"264\":13897,\"265\":13896,\"266\":13895,\"267\":13894,\"268\":13893,\"269\":13892,\"270\":13891,\"271\":13890,\"272\":13889,\"273\":13888,\"274\":13887,\"275\":13886,\"276\":13885,\"277\":13884,\"278\":13883,\"279\":13882,\"280\":13881,\"281\":13880,\"282\":13879,\"283\":13878,\"284\":13877,\"285\":13876,\"286\":13875,\"287\":13874,\"288\":13873,\"289\":13872,\"290\":13871,\"291\":13870,\"292\":13869,\"293\":13868,\"294\":13867,\"295\":13866,\"296\":13865,\"297\":13864,\"298\":13863,\"299\":13862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("82", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "2f531efa019169ac813d2139faa409b0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "0", "[{\"id\":18168,\"batched_data\":{\"300\":13861,\"301\":13860,\"302\":13859,\"303\":13858,\"304\":13857,\"305\":13856,\"306\":13855,\"307\":13854,\"308\":13853,\"309\":13852,\"310\":13851,\"311\":13850,\"312\":13849,\"313\":13848,\"314\":13847,\"315\":13846,\"316\":13845,\"317\":13844,\"318\":13843,\"319\":13842,\"320\":13841,\"321\":13840,\"322\":13839,\"323\":13838,\"324\":13837,\"325\":13836,\"326\":13835,\"327\":13834,\"328\":13833,\"329\":13832,\"330\":13831,\"331\":13830,\"332\":13829,\"333\":13828,\"334\":13827,\"335\":13826,\"336\":13825,\"337\":13824,\"338\":13823,\"339\":13822,\"340\":13821,\"341\":13820,\"342\":13819,\"343\":13818,\"344\":13817,\"345\":13816,\"346\":13815,\"347\":13814,\"348\":13813,\"349\":13812,\"350\":13811,\"351\":13810,\"352\":13809,\"353\":13808,\"354\":13807,\"355\":13806,\"356\":13805,\"357\":13804,\"358\":13803,\"359\":13802,\"360\":13801,\"361\":13800,\"362\":13799,\"363\":13798,\"364\":13797,\"365\":13796,\"366\":13795,\"367\":13794,\"368\":13793,\"369\":13792,\"370\":13791,\"371\":13790,\"372\":13789,\"373\":13788,\"374\":13787,\"375\":13786,\"376\":13785,\"377\":13784,\"378\":13783,\"379\":13782,\"380\":13781,\"381\":13780,\"382\":13779,\"383\":13778,\"384\":13777,\"385\":13776,\"386\":13775,\"387\":13774,\"388\":13773,\"389\":13772,\"390\":13771,\"391\":13770,\"392\":13769,\"393\":13768,\"394\":13767,\"395\":13766,\"396\":13765,\"397\":13764,\"398\":13763,\"399\":13762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("83", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "2d5562ffbf9fc8cd7cec0f927bf84638", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "0", "[{\"id\":18168,\"batched_data\":{\"400\":13761,\"401\":13760,\"402\":13759,\"403\":13758,\"404\":13757,\"405\":13756,\"406\":13755,\"407\":13754,\"408\":13753,\"409\":13752,\"410\":13751,\"411\":13750,\"412\":13749,\"413\":13748,\"414\":13747,\"415\":13746,\"416\":13745,\"417\":13744,\"418\":13743,\"419\":13742,\"420\":13741,\"421\":13740,\"422\":13739,\"423\":13738,\"424\":13737,\"425\":13736,\"426\":13735,\"427\":13734,\"428\":13733,\"429\":13732,\"430\":13731,\"431\":13730,\"432\":13729,\"433\":13728,\"434\":13727,\"435\":13726,\"436\":13725,\"437\":13724,\"438\":13723,\"439\":13722,\"440\":13721,\"441\":13720,\"442\":13719,\"443\":13718,\"444\":13717,\"445\":13716,\"446\":13715,\"447\":13714,\"448\":13713,\"449\":13712,\"450\":13711,\"451\":13710,\"452\":13709,\"453\":13708,\"454\":13707,\"455\":13706,\"456\":13705,\"457\":13704,\"458\":13703,\"459\":13702,\"460\":13701,\"461\":13700,\"462\":13699,\"463\":13698,\"464\":13697,\"465\":13696,\"466\":13695,\"467\":13694,\"468\":13693,\"469\":13692,\"470\":13691,\"471\":13690,\"472\":13689,\"473\":13688,\"474\":13687,\"475\":13686,\"476\":13685,\"477\":13684,\"478\":13683,\"479\":13682,\"480\":13681,\"481\":13680,\"482\":13679,\"483\":13678,\"484\":13677,\"485\":13676,\"486\":13675,\"487\":13674,\"488\":13673,\"489\":13672,\"490\":13671,\"491\":13670,\"492\":13669,\"493\":13668,\"494\":13667,\"495\":13666,\"496\":13665,\"497\":13664,\"498\":13663,\"499\":13662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("84", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:55", "2024-03-18 18:15:55", "[{\"id\":18168,\"offset\":4500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("85", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "20faad13933886645613c9eca380479e", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "0", "[{\"id\":18168,\"batched_data\":[13661,13660,13659,13658,13657,13656,13655,13654,13653,13652,13651,13650,13649,13648,13647,13646,13645,13644,13643,13642,13641,13640,13639,13638,13637,13636,13635,13634,13633,13632,13631,13630,13629,13628,13627,13626,13625,13624,13623,13622,13621,13620,13619,13618,13617,13616,13615,13614,13613,13612,13611,13610,13609,13608,13607,13606,13605,13604,13603,13602,13601,13600,13599,13598,13597,13596,13595,13594,13593,13592,13591,13590,13589,13588,13587,13586,13585,13584,13583,13582,13581,13580,13579,13578,13577,13576,13575,13574,13573,13572,13571,13570,13569,13568,13567,13566,13565,13564,13563,13562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("86", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "5b28d58f9acca5cee3f2bdbfa9cdc495", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "0", "[{\"id\":18168,\"batched_data\":{\"100\":13561,\"101\":13560,\"102\":13559,\"103\":13558,\"104\":13557,\"105\":13556,\"106\":13555,\"107\":13554,\"108\":13553,\"109\":13552,\"110\":13551,\"111\":13550,\"112\":13549,\"113\":13548,\"114\":13547,\"115\":13546,\"116\":13545,\"117\":13544,\"118\":13543,\"119\":13542,\"120\":13541,\"121\":13540,\"122\":13539,\"123\":13538,\"124\":13537,\"125\":13536,\"126\":13535,\"127\":13534,\"128\":13533,\"129\":13532,\"130\":13531,\"131\":13530,\"132\":13529,\"133\":13528,\"134\":13527,\"135\":13526,\"136\":13525,\"137\":13524,\"138\":13523,\"139\":13522,\"140\":13521,\"141\":13520,\"142\":13519,\"143\":13518,\"144\":13517,\"145\":13516,\"146\":13515,\"147\":13514,\"148\":13513,\"149\":13512,\"150\":13511,\"151\":13510,\"152\":13509,\"153\":13508,\"154\":13507,\"155\":13506,\"156\":13505,\"157\":13504,\"158\":13503,\"159\":13502,\"160\":13501,\"161\":13500,\"162\":13499,\"163\":13498,\"164\":13497,\"165\":13496,\"166\":13495,\"167\":13494,\"168\":13493,\"169\":13492,\"170\":13491,\"171\":13490,\"172\":13489,\"173\":13488,\"174\":13487,\"175\":13486,\"176\":13485,\"177\":13484,\"178\":13483,\"179\":13482,\"180\":13481,\"181\":13480,\"182\":13479,\"183\":13478,\"184\":13477,\"185\":13476,\"186\":13475,\"187\":13474,\"188\":13473,\"189\":13472,\"190\":13471,\"191\":13470,\"192\":13469,\"193\":13468,\"194\":13467,\"195\":13466,\"196\":13465,\"197\":13464,\"198\":13463,\"199\":13462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("87", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "f78df9a12cf8b3440d0296ab25fe19f8", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "0", "[{\"id\":18168,\"batched_data\":{\"200\":13461,\"201\":13460,\"202\":13459,\"203\":13458,\"204\":13457,\"205\":13456,\"206\":13455,\"207\":13454,\"208\":13453,\"209\":13452,\"210\":13451,\"211\":13450,\"212\":13449,\"213\":13448,\"214\":13447,\"215\":13446,\"216\":13445,\"217\":13444,\"218\":13443,\"219\":13442,\"220\":13441,\"221\":13440,\"222\":13439,\"223\":13438,\"224\":13437,\"225\":13436,\"226\":13435,\"227\":13434,\"228\":13433,\"229\":13432,\"230\":13431,\"231\":13430,\"232\":13429,\"233\":13428,\"234\":13427,\"235\":13426,\"236\":13425,\"237\":13424,\"238\":13423,\"239\":13422,\"240\":13421,\"241\":13420,\"242\":13419,\"243\":13418,\"244\":13417,\"245\":13416,\"246\":13415,\"247\":13414,\"248\":13413,\"249\":13412,\"250\":13411,\"251\":13410,\"252\":13409,\"253\":13408,\"254\":13407,\"255\":13406,\"256\":13405,\"257\":13404,\"258\":13403,\"259\":13402,\"260\":13401,\"261\":13400,\"262\":13399,\"263\":13398,\"264\":13397,\"265\":13396,\"266\":13395,\"267\":13394,\"268\":13393,\"269\":13392,\"270\":13391,\"271\":13390,\"272\":13389,\"273\":13388,\"274\":13387,\"275\":13386,\"276\":13385,\"277\":13384,\"278\":13383,\"279\":13382,\"280\":13381,\"281\":13380,\"282\":13379,\"283\":13378,\"284\":13377,\"285\":13376,\"286\":13375,\"287\":13374,\"288\":13373,\"289\":13372,\"290\":13371,\"291\":13370,\"292\":13369,\"293\":13368,\"294\":13367,\"295\":13366,\"296\":13365,\"297\":13364,\"298\":13363,\"299\":13362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("88", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "e394c36dfed90808b1ac29c586108bc2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "0", "[{\"id\":18168,\"batched_data\":{\"300\":13361,\"301\":13360,\"302\":13359,\"303\":13358,\"304\":13357,\"305\":13356,\"306\":13355,\"307\":13354,\"308\":13353,\"309\":13352,\"310\":13351,\"311\":13350,\"312\":13349,\"313\":13348,\"314\":13347,\"315\":13346,\"316\":13345,\"317\":13344,\"318\":13343,\"319\":13342,\"320\":13341,\"321\":13340,\"322\":13339,\"323\":13338,\"324\":13337,\"325\":13336,\"326\":13335,\"327\":13334,\"328\":13333,\"329\":13332,\"330\":13331,\"331\":13330,\"332\":13329,\"333\":13328,\"334\":13327,\"335\":13326,\"336\":13325,\"337\":13324,\"338\":13323,\"339\":13322,\"340\":13321,\"341\":13320,\"342\":13319,\"343\":13318,\"344\":13317,\"345\":13316,\"346\":13315,\"347\":13314,\"348\":13313,\"349\":13312,\"350\":13311,\"351\":13310,\"352\":13309,\"353\":13308,\"354\":13307,\"355\":13306,\"356\":13305,\"357\":13304,\"358\":13303,\"359\":13302,\"360\":13301,\"361\":13300,\"362\":13299,\"363\":13298,\"364\":13297,\"365\":13296,\"366\":13295,\"367\":13294,\"368\":13293,\"369\":13292,\"370\":13291,\"371\":13290,\"372\":13289,\"373\":13288,\"374\":13287,\"375\":13286,\"376\":13285,\"377\":13284,\"378\":13283,\"379\":13282,\"380\":13281,\"381\":13280,\"382\":13279,\"383\":13278,\"384\":13277,\"385\":13276,\"386\":13275,\"387\":13274,\"388\":13273,\"389\":13272,\"390\":13271,\"391\":13270,\"392\":13269,\"393\":13268,\"394\":13267,\"395\":13266,\"396\":13265,\"397\":13264,\"398\":13263,\"399\":13262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("89", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "5167b8516e5951e661448223228ef574", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "0", "[{\"id\":18168,\"batched_data\":{\"400\":13261,\"401\":13260,\"402\":13259,\"403\":13258,\"404\":13257,\"405\":13256,\"406\":13255,\"407\":13254,\"408\":13253,\"409\":13252,\"410\":13251,\"411\":13250,\"412\":13249,\"413\":13248,\"414\":13247,\"415\":13246,\"416\":13245,\"417\":13244,\"418\":13243,\"419\":13242,\"420\":13241,\"421\":13240,\"422\":13239,\"423\":13238,\"424\":13237,\"425\":13236,\"426\":13235,\"427\":13234,\"428\":13233,\"429\":13232,\"430\":13231,\"431\":13230,\"432\":13229,\"433\":13228,\"434\":13227,\"435\":13226,\"436\":13225,\"437\":13224,\"438\":13223,\"439\":13222,\"440\":13221,\"441\":13220,\"442\":13219,\"443\":13218,\"444\":13217,\"445\":13216,\"446\":13215,\"447\":13214,\"448\":13213,\"449\":13212,\"450\":13211,\"451\":13210,\"452\":13209,\"453\":13208,\"454\":13207,\"455\":13206,\"456\":13205,\"457\":13204,\"458\":13203,\"459\":13202,\"460\":13201,\"461\":13200,\"462\":13199,\"463\":13198,\"464\":13197,\"465\":13196,\"466\":13195,\"467\":13194,\"468\":13193,\"469\":13192,\"470\":13191,\"471\":13190,\"472\":13189,\"473\":13188,\"474\":13187,\"475\":13186,\"476\":13185,\"477\":13184,\"478\":13183,\"479\":13182,\"480\":13181,\"481\":13180,\"482\":13179,\"483\":13178,\"484\":13177,\"485\":13176,\"486\":13175,\"487\":13174,\"488\":13173,\"489\":13172,\"490\":13171,\"491\":13170,\"492\":13169,\"493\":13168,\"494\":13167,\"495\":13166,\"496\":13165,\"497\":13164,\"498\":13163,\"499\":13162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":4500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("90", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "[{\"id\":18168,\"offset\":5000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("91", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "8aa644ddf102978edf76c793c9d71eed", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "0", "[{\"id\":18168,\"batched_data\":[13161,13160,13159,13158,13157,13156,13155,13154,13153,13152,13151,13150,13149,13148,13147,13146,13145,13144,13143,13142,13141,13140,13139,13138,13137,13136,13135,13134,13133,13132,13131,13130,13129,13128,13127,13126,13125,13124,13123,13122,13121,13120,13119,13118,13117,13116,13115,13114,13113,13112,13111,13110,13109,13108,13107,13106,13105,13104,13103,13102,13101,13100,13099,13098,13097,13096,13095,13094,13093,13092,13091,13090,13089,13088,13087,13086,13085,13084,13083,13082,13081,13080,13079,13078,13077,13076,13075,13074,13073,13072,13071,13070,13069,13068,13067,13066,13065,13064,13063,13062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("92", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "56e4e95cc52a9fb2cd9a29258be6acfd", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "0", "[{\"id\":18168,\"batched_data\":{\"100\":13061,\"101\":13060,\"102\":13059,\"103\":13058,\"104\":13057,\"105\":13056,\"106\":13055,\"107\":13054,\"108\":13053,\"109\":13052,\"110\":13051,\"111\":13050,\"112\":13049,\"113\":13048,\"114\":13047,\"115\":13046,\"116\":13045,\"117\":13044,\"118\":13043,\"119\":13042,\"120\":13041,\"121\":13040,\"122\":13039,\"123\":13038,\"124\":13037,\"125\":13036,\"126\":13035,\"127\":13034,\"128\":13033,\"129\":13032,\"130\":13031,\"131\":13030,\"132\":13029,\"133\":13028,\"134\":13027,\"135\":13026,\"136\":13025,\"137\":13024,\"138\":13023,\"139\":13022,\"140\":13021,\"141\":13020,\"142\":13019,\"143\":13018,\"144\":13017,\"145\":13016,\"146\":13015,\"147\":13014,\"148\":13013,\"149\":13012,\"150\":13011,\"151\":13010,\"152\":13009,\"153\":13008,\"154\":13007,\"155\":13006,\"156\":13005,\"157\":13004,\"158\":13003,\"159\":13002,\"160\":13001,\"161\":13000,\"162\":12999,\"163\":12998,\"164\":12997,\"165\":12996,\"166\":12995,\"167\":12994,\"168\":12993,\"169\":12992,\"170\":12991,\"171\":12990,\"172\":12989,\"173\":12988,\"174\":12987,\"175\":12986,\"176\":12985,\"177\":12984,\"178\":12983,\"179\":12982,\"180\":12981,\"181\":12980,\"182\":12979,\"183\":12978,\"184\":12977,\"185\":12976,\"186\":12975,\"187\":12974,\"188\":12973,\"189\":12972,\"190\":12971,\"191\":12970,\"192\":12969,\"193\":12968,\"194\":12967,\"195\":12966,\"196\":12965,\"197\":12964,\"198\":12963,\"199\":12962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("93", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "c9f4800078d3573e8ecaf847d3e6bafe", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "0", "[{\"id\":18168,\"batched_data\":{\"200\":12961,\"201\":12960,\"202\":12959,\"203\":12958,\"204\":12957,\"205\":12956,\"206\":12955,\"207\":12954,\"208\":12953,\"209\":12952,\"210\":12951,\"211\":12950,\"212\":12949,\"213\":12948,\"214\":12947,\"215\":12946,\"216\":12945,\"217\":12944,\"218\":12943,\"219\":12942,\"220\":12941,\"221\":12940,\"222\":12939,\"223\":12938,\"224\":12937,\"225\":12936,\"226\":12935,\"227\":12934,\"228\":12933,\"229\":12932,\"230\":12931,\"231\":12930,\"232\":12929,\"233\":12928,\"234\":12927,\"235\":12926,\"236\":12925,\"237\":12924,\"238\":12923,\"239\":12922,\"240\":12921,\"241\":12920,\"242\":12919,\"243\":12918,\"244\":12917,\"245\":12916,\"246\":12915,\"247\":12914,\"248\":12913,\"249\":12912,\"250\":12911,\"251\":12910,\"252\":12909,\"253\":12908,\"254\":12907,\"255\":12906,\"256\":12905,\"257\":12904,\"258\":12903,\"259\":12902,\"260\":12901,\"261\":12900,\"262\":12899,\"263\":12898,\"264\":12897,\"265\":12896,\"266\":12895,\"267\":12894,\"268\":12893,\"269\":12892,\"270\":12891,\"271\":12890,\"272\":12889,\"273\":12888,\"274\":12887,\"275\":12886,\"276\":12885,\"277\":12884,\"278\":12883,\"279\":12882,\"280\":12881,\"281\":12880,\"282\":12879,\"283\":12878,\"284\":12877,\"285\":12876,\"286\":12875,\"287\":12874,\"288\":12873,\"289\":12872,\"290\":12871,\"291\":12870,\"292\":12869,\"293\":12868,\"294\":12867,\"295\":12866,\"296\":12865,\"297\":12864,\"298\":12863,\"299\":12862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("94", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "923bbb28d2b0baadb2c898580a6546e1", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "0", "[{\"id\":18168,\"batched_data\":{\"300\":12861,\"301\":12860,\"302\":12859,\"303\":12858,\"304\":12857,\"305\":12856,\"306\":12855,\"307\":12854,\"308\":12853,\"309\":12852,\"310\":12851,\"311\":12850,\"312\":12849,\"313\":12848,\"314\":12847,\"315\":12846,\"316\":12845,\"317\":12844,\"318\":12843,\"319\":12842,\"320\":12841,\"321\":12840,\"322\":12839,\"323\":12838,\"324\":12837,\"325\":12836,\"326\":12835,\"327\":12834,\"328\":12833,\"329\":12832,\"330\":12831,\"331\":12830,\"332\":12829,\"333\":12828,\"334\":12827,\"335\":12826,\"336\":12825,\"337\":12824,\"338\":12823,\"339\":12822,\"340\":12821,\"341\":12820,\"342\":12819,\"343\":12818,\"344\":12817,\"345\":12816,\"346\":12815,\"347\":12814,\"348\":12813,\"349\":12812,\"350\":12811,\"351\":12810,\"352\":12809,\"353\":12808,\"354\":12807,\"355\":12806,\"356\":12805,\"357\":12804,\"358\":12803,\"359\":12802,\"360\":12801,\"361\":12800,\"362\":12799,\"363\":12798,\"364\":12797,\"365\":12796,\"366\":12795,\"367\":12794,\"368\":12793,\"369\":12792,\"370\":12791,\"371\":12790,\"372\":12789,\"373\":12788,\"374\":12787,\"375\":12786,\"376\":12785,\"377\":12784,\"378\":12783,\"379\":12782,\"380\":12781,\"381\":12780,\"382\":12779,\"383\":12778,\"384\":12777,\"385\":12776,\"386\":12775,\"387\":12774,\"388\":12773,\"389\":12772,\"390\":12771,\"391\":12770,\"392\":12769,\"393\":12768,\"394\":12767,\"395\":12766,\"396\":12765,\"397\":12764,\"398\":12763,\"399\":12762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("95", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "3d0c85b9db6c355bedd824a59027e2bc", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "0", "[{\"id\":18168,\"batched_data\":{\"400\":12761,\"401\":12760,\"402\":12759,\"403\":12758,\"404\":12757,\"405\":12756,\"406\":12755,\"407\":12754,\"408\":12753,\"409\":12752,\"410\":12751,\"411\":12750,\"412\":12749,\"413\":12748,\"414\":12747,\"415\":12746,\"416\":12745,\"417\":12744,\"418\":12743,\"419\":12742,\"420\":12741,\"421\":12740,\"422\":12739,\"423\":12738,\"424\":12737,\"425\":12736,\"426\":12735,\"427\":12734,\"428\":12733,\"429\":12732,\"430\":12731,\"431\":12730,\"432\":12729,\"433\":12728,\"434\":12727,\"435\":12726,\"436\":12725,\"437\":12724,\"438\":12723,\"439\":12722,\"440\":12721,\"441\":12720,\"442\":12719,\"443\":12718,\"444\":12717,\"445\":12716,\"446\":12715,\"447\":12714,\"448\":12713,\"449\":12712,\"450\":12711,\"451\":12710,\"452\":12709,\"453\":12708,\"454\":12707,\"455\":12706,\"456\":12705,\"457\":12704,\"458\":12703,\"459\":12702,\"460\":12701,\"461\":12700,\"462\":12699,\"463\":12698,\"464\":12697,\"465\":12696,\"466\":12695,\"467\":12694,\"468\":12693,\"469\":12692,\"470\":12691,\"471\":12690,\"472\":12689,\"473\":12688,\"474\":12687,\"475\":12686,\"476\":12685,\"477\":12684,\"478\":12683,\"479\":12682,\"480\":12681,\"481\":12680,\"482\":12679,\"483\":12678,\"484\":12677,\"485\":12676,\"486\":12675,\"487\":12674,\"488\":12673,\"489\":12672,\"490\":12671,\"491\":12670,\"492\":12669,\"493\":12668,\"494\":12667,\"495\":12666,\"496\":12665,\"497\":12664,\"498\":12663,\"499\":12662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("96", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:56", "2024-03-18 18:15:56", "[{\"id\":18168,\"offset\":5500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("97", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "61c485f7fcade61893334a38eafadbdb", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:58", "2024-03-18 18:15:58", "0", "[{\"id\":18168,\"batched_data\":[12661,12660,12659,12658,12657,12656,12655,12654,12653,12652,12651,12650,12649,12648,12647,12646,12645,12644,12643,12642,12641,12640,12639,12638,12637,12636,12635,12634,12633,12632,12631,12630,12629,12628,12627,12626,12625,12624,12623,12622,12621,12620,12619,12618,12617,12616,12615,12614,12613,12612,12611,12610,12609,12608,12607,12606,12605,12604,12603,12602,12601,12600,12599,12598,12597,12596,12595,12594,12593,12592,12591,12590,12589,12588,12587,12586,12585,12584,12583,12582,12581,12580,12579,12578,12577,12576,12575,12574,12573,12572,12571,12570,12569,12568,12567,12566,12565,12564,12563,12562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("98", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "2f1c3a34ee608b7c59dda14134192863", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:58", "2024-03-18 18:15:58", "0", "[{\"id\":18168,\"batched_data\":{\"100\":12561,\"101\":12560,\"102\":12559,\"103\":12558,\"104\":12557,\"105\":12556,\"106\":12555,\"107\":12554,\"108\":12553,\"109\":12552,\"110\":12551,\"111\":12550,\"112\":12549,\"113\":12548,\"114\":12547,\"115\":12546,\"116\":12545,\"117\":12544,\"118\":12543,\"119\":12542,\"120\":12541,\"121\":12540,\"122\":12539,\"123\":12538,\"124\":12537,\"125\":12536,\"126\":12535,\"127\":12534,\"128\":12533,\"129\":12532,\"130\":12531,\"131\":12530,\"132\":12529,\"133\":12528,\"134\":12527,\"135\":12526,\"136\":12525,\"137\":12524,\"138\":12523,\"139\":12522,\"140\":12521,\"141\":12520,\"142\":12519,\"143\":12518,\"144\":12517,\"145\":12516,\"146\":12515,\"147\":12514,\"148\":12513,\"149\":12512,\"150\":12511,\"151\":12510,\"152\":12509,\"153\":12508,\"154\":12507,\"155\":12506,\"156\":12505,\"157\":12504,\"158\":12503,\"159\":12502,\"160\":12501,\"161\":12500,\"162\":12499,\"163\":12498,\"164\":12497,\"165\":12496,\"166\":12495,\"167\":12494,\"168\":12493,\"169\":12492,\"170\":12491,\"171\":12490,\"172\":12489,\"173\":12488,\"174\":12487,\"175\":12486,\"176\":12485,\"177\":12484,\"178\":12483,\"179\":12482,\"180\":12481,\"181\":12480,\"182\":12479,\"183\":12478,\"184\":12477,\"185\":12476,\"186\":12475,\"187\":12474,\"188\":12473,\"189\":12472,\"190\":12471,\"191\":12470,\"192\":12469,\"193\":12468,\"194\":12467,\"195\":12466,\"196\":12465,\"197\":12464,\"198\":12463,\"199\":12462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("99", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "e0a7220b7171717ce1e910ef23dbb683", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:58", "2024-03-18 18:15:58", "0", "[{\"id\":18168,\"batched_data\":{\"200\":12461,\"201\":12460,\"202\":12459,\"203\":12458,\"204\":12457,\"205\":12456,\"206\":12455,\"207\":12454,\"208\":12453,\"209\":12452,\"210\":12451,\"211\":12450,\"212\":12449,\"213\":12448,\"214\":12447,\"215\":12446,\"216\":12445,\"217\":12444,\"218\":12443,\"219\":12442,\"220\":12441,\"221\":12440,\"222\":12439,\"223\":12438,\"224\":12437,\"225\":12436,\"226\":12435,\"227\":12434,\"228\":12433,\"229\":12432,\"230\":12431,\"231\":12430,\"232\":12429,\"233\":12428,\"234\":12427,\"235\":12426,\"236\":12425,\"237\":12424,\"238\":12423,\"239\":12422,\"240\":12421,\"241\":12420,\"242\":12419,\"243\":12418,\"244\":12417,\"245\":12416,\"246\":12415,\"247\":12414,\"248\":12413,\"249\":12412,\"250\":12411,\"251\":12410,\"252\":12409,\"253\":12408,\"254\":12407,\"255\":12406,\"256\":12405,\"257\":12404,\"258\":12403,\"259\":12402,\"260\":12401,\"261\":12400,\"262\":12399,\"263\":12398,\"264\":12397,\"265\":12396,\"266\":12395,\"267\":12394,\"268\":12393,\"269\":12392,\"270\":12391,\"271\":12390,\"272\":12389,\"273\":12388,\"274\":12387,\"275\":12386,\"276\":12385,\"277\":12384,\"278\":12383,\"279\":12382,\"280\":12381,\"281\":12380,\"282\":12379,\"283\":12378,\"284\":12377,\"285\":12376,\"286\":12375,\"287\":12374,\"288\":12373,\"289\":12372,\"290\":12371,\"291\":12370,\"292\":12369,\"293\":12368,\"294\":12367,\"295\":12366,\"296\":12365,\"297\":12364,\"298\":12363,\"299\":12362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("100", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "9d18715e53a67b6ece07c8e7b8bed0d1", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "0", "[{\"id\":18168,\"batched_data\":{\"300\":12361,\"301\":12360,\"302\":12359,\"303\":12358,\"304\":12357,\"305\":12356,\"306\":12355,\"307\":12354,\"308\":12353,\"309\":12352,\"310\":12351,\"311\":12350,\"312\":12349,\"313\":12348,\"314\":12347,\"315\":12346,\"316\":12345,\"317\":12344,\"318\":12343,\"319\":12342,\"320\":12341,\"321\":12340,\"322\":12339,\"323\":12338,\"324\":12337,\"325\":12336,\"326\":12335,\"327\":12334,\"328\":12333,\"329\":12332,\"330\":12331,\"331\":12330,\"332\":12329,\"333\":12328,\"334\":12327,\"335\":12326,\"336\":12325,\"337\":12324,\"338\":12323,\"339\":12322,\"340\":12321,\"341\":12320,\"342\":12319,\"343\":12318,\"344\":12317,\"345\":12316,\"346\":12315,\"347\":12314,\"348\":12313,\"349\":12312,\"350\":12311,\"351\":12310,\"352\":12309,\"353\":12308,\"354\":12307,\"355\":12306,\"356\":12305,\"357\":12304,\"358\":12303,\"359\":12302,\"360\":12301,\"361\":12300,\"362\":12299,\"363\":12298,\"364\":12297,\"365\":12296,\"366\":12295,\"367\":12294,\"368\":12293,\"369\":12292,\"370\":12291,\"371\":12290,\"372\":12289,\"373\":12288,\"374\":12287,\"375\":12286,\"376\":12285,\"377\":12284,\"378\":12283,\"379\":12282,\"380\":12281,\"381\":12280,\"382\":12279,\"383\":12278,\"384\":12277,\"385\":12276,\"386\":12275,\"387\":12274,\"388\":12273,\"389\":12272,\"390\":12271,\"391\":12270,\"392\":12269,\"393\":12268,\"394\":12267,\"395\":12266,\"396\":12265,\"397\":12264,\"398\":12263,\"399\":12262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("101", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "bf6a78e63d9d3ae255386b11288edd11", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "0", "[{\"id\":18168,\"batched_data\":{\"400\":12261,\"401\":12260,\"402\":12259,\"403\":12258,\"404\":12257,\"405\":12256,\"406\":12255,\"407\":12254,\"408\":12253,\"409\":12252,\"410\":12251,\"411\":12250,\"412\":12249,\"413\":12248,\"414\":12247,\"415\":12246,\"416\":12245,\"417\":12244,\"418\":12243,\"419\":12242,\"420\":12241,\"421\":12240,\"422\":12239,\"423\":12238,\"424\":12237,\"425\":12236,\"426\":12235,\"427\":12234,\"428\":12233,\"429\":12232,\"430\":12231,\"431\":12230,\"432\":12229,\"433\":12228,\"434\":12227,\"435\":12226,\"436\":12225,\"437\":12224,\"438\":12223,\"439\":12222,\"440\":12221,\"441\":12220,\"442\":12219,\"443\":12218,\"444\":12217,\"445\":12216,\"446\":12215,\"447\":12214,\"448\":12213,\"449\":12212,\"450\":12211,\"451\":12210,\"452\":12209,\"453\":12208,\"454\":12207,\"455\":12206,\"456\":12205,\"457\":12204,\"458\":12203,\"459\":12202,\"460\":12201,\"461\":12200,\"462\":12199,\"463\":12198,\"464\":12197,\"465\":12196,\"466\":12195,\"467\":12194,\"468\":12193,\"469\":12192,\"470\":12191,\"471\":12190,\"472\":12189,\"473\":12188,\"474\":12187,\"475\":12186,\"476\":12185,\"477\":12184,\"478\":12183,\"479\":12182,\"480\":12181,\"481\":12180,\"482\":12179,\"483\":12178,\"484\":12177,\"485\":12176,\"486\":12175,\"487\":12174,\"488\":12173,\"489\":12172,\"490\":12171,\"491\":12170,\"492\":12169,\"493\":12168,\"494\":12167,\"495\":12166,\"496\":12165,\"497\":12164,\"498\":12163,\"499\":12162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":5500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("102", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:57", "2024-03-18 18:15:57", "[{\"id\":18168,\"offset\":6000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("103", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "557d2f8205aa84964d77276c31ea35f9", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "0", "[{\"id\":18168,\"batched_data\":[12161,12160,12159,12158,12157,12156,12155,12154,12153,12152,12151,12150,12149,12148,12147,12146,12145,12144,12143,12142,12141,12140,12139,12138,12137,12136,12135,12134,12133,12132,12131,12130,12129,12128,12127,12126,12125,12124,12123,12122,12121,12120,12119,12118,12117,12116,12115,12114,12113,12112,12111,12110,12109,12108,12107,12106,12105,12104,12103,12102,12101,12100,12099,12098,12097,12096,12095,12094,12093,12092,12091,12090,12089,12088,12087,12086,12085,12084,12083,12082,12081,12080,12079,12078,12077,12076,12075,12074,12073,12072,12071,12070,12069,12068,12067,12066,12065,12064,12063,12062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("104", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "4a39c85c42fa4347b588d1ec7116a692", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "0", "[{\"id\":18168,\"batched_data\":{\"100\":12061,\"101\":12060,\"102\":12059,\"103\":12058,\"104\":12057,\"105\":12056,\"106\":12055,\"107\":12054,\"108\":12053,\"109\":12052,\"110\":12051,\"111\":12050,\"112\":12049,\"113\":12048,\"114\":12047,\"115\":12046,\"116\":12045,\"117\":12044,\"118\":12043,\"119\":12042,\"120\":12041,\"121\":12040,\"122\":12039,\"123\":12038,\"124\":12037,\"125\":12036,\"126\":12035,\"127\":12034,\"128\":12033,\"129\":12032,\"130\":12031,\"131\":12030,\"132\":12029,\"133\":12028,\"134\":12027,\"135\":12026,\"136\":12025,\"137\":12024,\"138\":12023,\"139\":12022,\"140\":12021,\"141\":12020,\"142\":12019,\"143\":12018,\"144\":12017,\"145\":12016,\"146\":12015,\"147\":12014,\"148\":12013,\"149\":12012,\"150\":12011,\"151\":12010,\"152\":12009,\"153\":12008,\"154\":12007,\"155\":12006,\"156\":12005,\"157\":12004,\"158\":12003,\"159\":12002,\"160\":12001,\"161\":12000,\"162\":11999,\"163\":11998,\"164\":11997,\"165\":11996,\"166\":11995,\"167\":11994,\"168\":11993,\"169\":11992,\"170\":11991,\"171\":11990,\"172\":11989,\"173\":11988,\"174\":11987,\"175\":11986,\"176\":11985,\"177\":11984,\"178\":11983,\"179\":11982,\"180\":11981,\"181\":11980,\"182\":11979,\"183\":11978,\"184\":11977,\"185\":11976,\"186\":11975,\"187\":11974,\"188\":11973,\"189\":11972,\"190\":11971,\"191\":11970,\"192\":11969,\"193\":11968,\"194\":11967,\"195\":11966,\"196\":11965,\"197\":11964,\"198\":11963,\"199\":11962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("105", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "31adef27acfda52bc1ac2b9fc8a09a11", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "0", "[{\"id\":18168,\"batched_data\":{\"200\":11961,\"201\":11960,\"202\":11959,\"203\":11958,\"204\":11957,\"205\":11956,\"206\":11955,\"207\":11954,\"208\":11953,\"209\":11952,\"210\":11951,\"211\":11950,\"212\":11949,\"213\":11948,\"214\":11947,\"215\":11946,\"216\":11945,\"217\":11944,\"218\":11943,\"219\":11942,\"220\":11941,\"221\":11940,\"222\":11939,\"223\":11938,\"224\":11937,\"225\":11936,\"226\":11935,\"227\":11934,\"228\":11933,\"229\":11932,\"230\":11931,\"231\":11930,\"232\":11929,\"233\":11928,\"234\":11927,\"235\":11926,\"236\":11925,\"237\":11924,\"238\":11923,\"239\":11922,\"240\":11921,\"241\":11920,\"242\":11919,\"243\":11918,\"244\":11917,\"245\":11916,\"246\":11915,\"247\":11914,\"248\":11913,\"249\":11912,\"250\":11911,\"251\":11910,\"252\":11909,\"253\":11908,\"254\":11907,\"255\":11906,\"256\":11905,\"257\":11904,\"258\":11903,\"259\":11902,\"260\":11901,\"261\":11900,\"262\":11899,\"263\":11898,\"264\":11897,\"265\":11896,\"266\":11895,\"267\":11894,\"268\":11893,\"269\":11892,\"270\":11891,\"271\":11890,\"272\":11889,\"273\":11888,\"274\":11887,\"275\":11886,\"276\":11885,\"277\":11884,\"278\":11883,\"279\":11882,\"280\":11881,\"281\":11880,\"282\":11879,\"283\":11878,\"284\":11877,\"285\":11876,\"286\":11875,\"287\":11874,\"288\":11873,\"289\":11872,\"290\":11871,\"291\":11870,\"292\":11869,\"293\":11868,\"294\":11867,\"295\":11866,\"296\":11865,\"297\":11864,\"298\":11863,\"299\":11862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("106", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "9fe3714bc993357fd21d94be6bbcb8e5", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "0", "[{\"id\":18168,\"batched_data\":{\"300\":11861,\"301\":11860,\"302\":11859,\"303\":11858,\"304\":11857,\"305\":11856,\"306\":11855,\"307\":11854,\"308\":11853,\"309\":11852,\"310\":11851,\"311\":11850,\"312\":11849,\"313\":11848,\"314\":11847,\"315\":11846,\"316\":11845,\"317\":11844,\"318\":11843,\"319\":11842,\"320\":11841,\"321\":11840,\"322\":11839,\"323\":11838,\"324\":11837,\"325\":11836,\"326\":11835,\"327\":11834,\"328\":11833,\"329\":11832,\"330\":11831,\"331\":11830,\"332\":11829,\"333\":11828,\"334\":11827,\"335\":11826,\"336\":11825,\"337\":11824,\"338\":11823,\"339\":11822,\"340\":11821,\"341\":11820,\"342\":11819,\"343\":11818,\"344\":11817,\"345\":11816,\"346\":11815,\"347\":11814,\"348\":11813,\"349\":11812,\"350\":11811,\"351\":11810,\"352\":11809,\"353\":11808,\"354\":11807,\"355\":11806,\"356\":11805,\"357\":11804,\"358\":11803,\"359\":11802,\"360\":11801,\"361\":11800,\"362\":11799,\"363\":11798,\"364\":11797,\"365\":11796,\"366\":11795,\"367\":11794,\"368\":11793,\"369\":11792,\"370\":11791,\"371\":11790,\"372\":11789,\"373\":11788,\"374\":11787,\"375\":11786,\"376\":11785,\"377\":11784,\"378\":11783,\"379\":11782,\"380\":11781,\"381\":11780,\"382\":11779,\"383\":11778,\"384\":11777,\"385\":11776,\"386\":11775,\"387\":11774,\"388\":11773,\"389\":11772,\"390\":11771,\"391\":11770,\"392\":11769,\"393\":11768,\"394\":11767,\"395\":11766,\"396\":11765,\"397\":11764,\"398\":11763,\"399\":11762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("107", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "e371ebd38df9e0c6b22d771dc02cc494", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "0", "[{\"id\":18168,\"batched_data\":{\"400\":11761,\"401\":11760,\"402\":11759,\"403\":11758,\"404\":11757,\"405\":11756,\"406\":11755,\"407\":11754,\"408\":11753,\"409\":11752,\"410\":11751,\"411\":11750,\"412\":11749,\"413\":11748,\"414\":11747,\"415\":11746,\"416\":11745,\"417\":11744,\"418\":11743,\"419\":11742,\"420\":11741,\"421\":11740,\"422\":11739,\"423\":11738,\"424\":11737,\"425\":11736,\"426\":11735,\"427\":11734,\"428\":11733,\"429\":11732,\"430\":11731,\"431\":11730,\"432\":11729,\"433\":11728,\"434\":11727,\"435\":11726,\"436\":11725,\"437\":11724,\"438\":11723,\"439\":11722,\"440\":11721,\"441\":11720,\"442\":11719,\"443\":11718,\"444\":11717,\"445\":11716,\"446\":11715,\"447\":11714,\"448\":11713,\"449\":11712,\"450\":11711,\"451\":11710,\"452\":11709,\"453\":11708,\"454\":11707,\"455\":11706,\"456\":11705,\"457\":11704,\"458\":11703,\"459\":11702,\"460\":11701,\"461\":11700,\"462\":11699,\"463\":11698,\"464\":11697,\"465\":11696,\"466\":11695,\"467\":11694,\"468\":11693,\"469\":11692,\"470\":11691,\"471\":11690,\"472\":11689,\"473\":11688,\"474\":11687,\"475\":11686,\"476\":11685,\"477\":11684,\"478\":11683,\"479\":11682,\"480\":11681,\"481\":11680,\"482\":11679,\"483\":11678,\"484\":11677,\"485\":11676,\"486\":11675,\"487\":11674,\"488\":11673,\"489\":11672,\"490\":11671,\"491\":11670,\"492\":11669,\"493\":11668,\"494\":11667,\"495\":11666,\"496\":11665,\"497\":11664,\"498\":11663,\"499\":11662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("108", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:15:59", "2024-03-18 18:15:59", "[{\"id\":18168,\"offset\":6500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("109", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "0c883d37a2878420a9abf28cc2a89380", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "0", "[{\"id\":18168,\"batched_data\":[11661,11660,11659,11658,11657,11656,11655,11654,11653,11652,11651,11650,11649,11648,11647,11646,11645,11644,11643,11642,11641,11640,11639,11638,11637,11636,11635,11634,11633,11632,11631,11630,11629,11628,11627,11626,11625,11624,11623,11622,11621,11620,11619,11618,11617,11616,11615,11614,11613,11612,11611,11610,11609,11608,11607,11606,11605,11604,11603,11602,11601,11600,11599,11598,11597,11596,11595,11594,11593,11592,11591,11590,11589,11588,11587,11586,11585,11584,11583,11582,11581,11580,11579,11578,11577,11576,11575,11574,11573,11572,11571,11570,11569,11568,11567,11566,11565,11564,11563,11562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("110", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "f7d381b5c3f93a67ac01c6a2c4f0f656", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "0", "[{\"id\":18168,\"batched_data\":{\"100\":11561,\"101\":11560,\"102\":11559,\"103\":11558,\"104\":11557,\"105\":11556,\"106\":11555,\"107\":11554,\"108\":11553,\"109\":11552,\"110\":11551,\"111\":11550,\"112\":11549,\"113\":11548,\"114\":11547,\"115\":11546,\"116\":11545,\"117\":11544,\"118\":11543,\"119\":11542,\"120\":11541,\"121\":11540,\"122\":11539,\"123\":11538,\"124\":11537,\"125\":11536,\"126\":11535,\"127\":11534,\"128\":11533,\"129\":11532,\"130\":11531,\"131\":11530,\"132\":11529,\"133\":11528,\"134\":11527,\"135\":11526,\"136\":11525,\"137\":11524,\"138\":11523,\"139\":11522,\"140\":11521,\"141\":11520,\"142\":11519,\"143\":11518,\"144\":11517,\"145\":11516,\"146\":11515,\"147\":11514,\"148\":11513,\"149\":11512,\"150\":11511,\"151\":11510,\"152\":11509,\"153\":11508,\"154\":11507,\"155\":11506,\"156\":11505,\"157\":11504,\"158\":11503,\"159\":11502,\"160\":11501,\"161\":11500,\"162\":11499,\"163\":11498,\"164\":11497,\"165\":11496,\"166\":11495,\"167\":11494,\"168\":11493,\"169\":11492,\"170\":11491,\"171\":11490,\"172\":11489,\"173\":11488,\"174\":11487,\"175\":11486,\"176\":11485,\"177\":11484,\"178\":11483,\"179\":11482,\"180\":11481,\"181\":11480,\"182\":11479,\"183\":11478,\"184\":11477,\"185\":11476,\"186\":11475,\"187\":11474,\"188\":11473,\"189\":11472,\"190\":11471,\"191\":11470,\"192\":11469,\"193\":11468,\"194\":11467,\"195\":11466,\"196\":11465,\"197\":11464,\"198\":11463,\"199\":11462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("111", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "d540468466d0b01b8f88c656ddfc43c0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "0", "[{\"id\":18168,\"batched_data\":{\"200\":11461,\"201\":11460,\"202\":11459,\"203\":11458,\"204\":11457,\"205\":11456,\"206\":11455,\"207\":11454,\"208\":11453,\"209\":11452,\"210\":11451,\"211\":11450,\"212\":11449,\"213\":11448,\"214\":11447,\"215\":11446,\"216\":11445,\"217\":11444,\"218\":11443,\"219\":11442,\"220\":11441,\"221\":11440,\"222\":11439,\"223\":11438,\"224\":11437,\"225\":11436,\"226\":11435,\"227\":11434,\"228\":11433,\"229\":11432,\"230\":11431,\"231\":11430,\"232\":11429,\"233\":11428,\"234\":11427,\"235\":11426,\"236\":11425,\"237\":11424,\"238\":11423,\"239\":11422,\"240\":11421,\"241\":11420,\"242\":11419,\"243\":11418,\"244\":11417,\"245\":11416,\"246\":11415,\"247\":11414,\"248\":11413,\"249\":11412,\"250\":11411,\"251\":11410,\"252\":11409,\"253\":11408,\"254\":11407,\"255\":11406,\"256\":11405,\"257\":11404,\"258\":11403,\"259\":11402,\"260\":11401,\"261\":11400,\"262\":11399,\"263\":11398,\"264\":11397,\"265\":11396,\"266\":11395,\"267\":11394,\"268\":11393,\"269\":11392,\"270\":11391,\"271\":11390,\"272\":11389,\"273\":11388,\"274\":11387,\"275\":11386,\"276\":11385,\"277\":11384,\"278\":11383,\"279\":11382,\"280\":11381,\"281\":11380,\"282\":11379,\"283\":11378,\"284\":11377,\"285\":11376,\"286\":11375,\"287\":11374,\"288\":11373,\"289\":11372,\"290\":11371,\"291\":11370,\"292\":11369,\"293\":11368,\"294\":11367,\"295\":11366,\"296\":11365,\"297\":11364,\"298\":11363,\"299\":11362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("112", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "a3b0ca89a9e3757fce18ef6d2af3d533", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "0", "[{\"id\":18168,\"batched_data\":{\"300\":11361,\"301\":11360,\"302\":11359,\"303\":11358,\"304\":11357,\"305\":11356,\"306\":11355,\"307\":11354,\"308\":11353,\"309\":11352,\"310\":11351,\"311\":11350,\"312\":11349,\"313\":11348,\"314\":11347,\"315\":11346,\"316\":11345,\"317\":11344,\"318\":11343,\"319\":11342,\"320\":11341,\"321\":11340,\"322\":11339,\"323\":11338,\"324\":11337,\"325\":11336,\"326\":11335,\"327\":11334,\"328\":11333,\"329\":11332,\"330\":11331,\"331\":11330,\"332\":11329,\"333\":11328,\"334\":11327,\"335\":11326,\"336\":11325,\"337\":11324,\"338\":11323,\"339\":11322,\"340\":11321,\"341\":11320,\"342\":11319,\"343\":11318,\"344\":11317,\"345\":11316,\"346\":11315,\"347\":11314,\"348\":11313,\"349\":11312,\"350\":11311,\"351\":11310,\"352\":11309,\"353\":11308,\"354\":11307,\"355\":11306,\"356\":11305,\"357\":11304,\"358\":11303,\"359\":11302,\"360\":11301,\"361\":11300,\"362\":11299,\"363\":11298,\"364\":11297,\"365\":11296,\"366\":11295,\"367\":11294,\"368\":11293,\"369\":11292,\"370\":11291,\"371\":11290,\"372\":11289,\"373\":11288,\"374\":11287,\"375\":11286,\"376\":11285,\"377\":11284,\"378\":11283,\"379\":11282,\"380\":11281,\"381\":11280,\"382\":11279,\"383\":11278,\"384\":11277,\"385\":11276,\"386\":11275,\"387\":11274,\"388\":11273,\"389\":11272,\"390\":11271,\"391\":11270,\"392\":11269,\"393\":11268,\"394\":11267,\"395\":11266,\"396\":11265,\"397\":11264,\"398\":11263,\"399\":11262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("113", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "61ef74d870d83f07adce9d21656c0885", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "0", "[{\"id\":18168,\"batched_data\":{\"400\":11261,\"401\":11260,\"402\":11259,\"403\":11258,\"404\":11257,\"405\":11256,\"406\":11255,\"407\":11254,\"408\":11253,\"409\":11252,\"410\":11251,\"411\":11250,\"412\":11249,\"413\":11248,\"414\":11247,\"415\":11246,\"416\":11245,\"417\":11244,\"418\":11243,\"419\":11242,\"420\":11241,\"421\":11240,\"422\":11239,\"423\":11238,\"424\":11237,\"425\":11236,\"426\":11235,\"427\":11234,\"428\":11233,\"429\":11232,\"430\":11231,\"431\":11230,\"432\":11229,\"433\":11228,\"434\":11227,\"435\":11226,\"436\":11225,\"437\":11224,\"438\":11223,\"439\":11222,\"440\":11221,\"441\":11220,\"442\":11219,\"443\":11218,\"444\":11217,\"445\":11216,\"446\":11215,\"447\":11214,\"448\":11213,\"449\":11212,\"450\":11211,\"451\":11210,\"452\":11209,\"453\":11208,\"454\":11207,\"455\":11206,\"456\":11205,\"457\":11204,\"458\":11203,\"459\":11202,\"460\":11201,\"461\":11200,\"462\":11199,\"463\":11198,\"464\":11197,\"465\":11196,\"466\":11195,\"467\":11194,\"468\":11193,\"469\":11192,\"470\":11191,\"471\":11190,\"472\":11189,\"473\":11188,\"474\":11187,\"475\":11186,\"476\":11185,\"477\":11184,\"478\":11183,\"479\":11182,\"480\":11181,\"481\":11180,\"482\":11179,\"483\":11178,\"484\":11177,\"485\":11176,\"486\":11175,\"487\":11174,\"488\":11173,\"489\":11172,\"490\":11171,\"491\":11170,\"492\":11169,\"493\":11168,\"494\":11167,\"495\":11166,\"496\":11165,\"497\":11164,\"498\":11163,\"499\":11162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":6500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("114", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:00", "2024-03-18 18:16:00", "[{\"id\":18168,\"offset\":7000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("115", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "faa33b91522f48dc7881cdad1ad570ea", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "0", "[{\"id\":18168,\"batched_data\":[11161,11160,11159,11158,11157,11156,11155,11154,11153,11152,11151,11150,11149,11148,11147,11146,11145,11144,11143,11142,11141,11140,11139,11138,11137,11136,11135,11134,11133,11132,11131,11130,11129,11128,11127,11126,11125,11124,11123,11122,11121,11120,11119,11118,11117,11116,11115,11114,11113,11112,11111,11110,11109,11108,11107,11106,11105,11104,11103,11102,11101,11100,11099,11098,11097,11096,11095,11094,11093,11092,11091,11090,11089,11088,11087,11086,11085,11084,11083,11082,11081,11080,11079,11078,11077,11076,11075,11074,11073,11072,11071,11070,11069,11068,11067,11066,11065,11064,11063,11062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("116", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "4333359421385a372950863138f05375", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:02", "2024-03-18 18:16:02", "0", "[{\"id\":18168,\"batched_data\":{\"100\":11061,\"101\":11060,\"102\":11059,\"103\":11058,\"104\":11057,\"105\":11056,\"106\":11055,\"107\":11054,\"108\":11053,\"109\":11052,\"110\":11051,\"111\":11050,\"112\":11049,\"113\":11048,\"114\":11047,\"115\":11046,\"116\":11045,\"117\":11044,\"118\":11043,\"119\":11042,\"120\":11041,\"121\":11040,\"122\":11039,\"123\":11038,\"124\":11037,\"125\":11036,\"126\":11035,\"127\":11034,\"128\":11033,\"129\":11032,\"130\":11031,\"131\":11030,\"132\":11029,\"133\":11028,\"134\":11027,\"135\":11026,\"136\":11025,\"137\":11024,\"138\":11023,\"139\":11022,\"140\":11021,\"141\":11020,\"142\":11019,\"143\":11018,\"144\":11017,\"145\":11016,\"146\":11015,\"147\":11014,\"148\":11013,\"149\":11012,\"150\":11011,\"151\":11010,\"152\":11009,\"153\":11008,\"154\":11007,\"155\":11006,\"156\":11005,\"157\":11004,\"158\":11003,\"159\":11002,\"160\":11001,\"161\":11000,\"162\":10999,\"163\":10998,\"164\":10997,\"165\":10996,\"166\":10995,\"167\":10994,\"168\":10993,\"169\":10992,\"170\":10991,\"171\":10990,\"172\":10989,\"173\":10988,\"174\":10987,\"175\":10986,\"176\":10985,\"177\":10984,\"178\":10983,\"179\":10982,\"180\":10981,\"181\":10980,\"182\":10979,\"183\":10978,\"184\":10977,\"185\":10976,\"186\":10975,\"187\":10974,\"188\":10973,\"189\":10972,\"190\":10971,\"191\":10970,\"192\":10969,\"193\":10968,\"194\":10967,\"195\":10966,\"196\":10965,\"197\":10964,\"198\":10963,\"199\":10962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("117", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "f054aec29add16e6a67e8a278457f704", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:02", "2024-03-18 18:16:02", "0", "[{\"id\":18168,\"batched_data\":{\"200\":10961,\"201\":10960,\"202\":10959,\"203\":10958,\"204\":10957,\"205\":10956,\"206\":10955,\"207\":10954,\"208\":10953,\"209\":10952,\"210\":10951,\"211\":10950,\"212\":10949,\"213\":10948,\"214\":10947,\"215\":10946,\"216\":10945,\"217\":10944,\"218\":10943,\"219\":10942,\"220\":10941,\"221\":10940,\"222\":10939,\"223\":10938,\"224\":10937,\"225\":10936,\"226\":10935,\"227\":10934,\"228\":10933,\"229\":10932,\"230\":10931,\"231\":10930,\"232\":10929,\"233\":10928,\"234\":10927,\"235\":10926,\"236\":10925,\"237\":10924,\"238\":10923,\"239\":10922,\"240\":10921,\"241\":10920,\"242\":10919,\"243\":10918,\"244\":10917,\"245\":10916,\"246\":10915,\"247\":10914,\"248\":10913,\"249\":10912,\"250\":10911,\"251\":10910,\"252\":10909,\"253\":10908,\"254\":10907,\"255\":10906,\"256\":10905,\"257\":10904,\"258\":10903,\"259\":10902,\"260\":10901,\"261\":10900,\"262\":10899,\"263\":10898,\"264\":10897,\"265\":10896,\"266\":10895,\"267\":10894,\"268\":10893,\"269\":10892,\"270\":10891,\"271\":10890,\"272\":10889,\"273\":10888,\"274\":10887,\"275\":10886,\"276\":10885,\"277\":10884,\"278\":10883,\"279\":10882,\"280\":10881,\"281\":10880,\"282\":10879,\"283\":10878,\"284\":10877,\"285\":10876,\"286\":10875,\"287\":10874,\"288\":10873,\"289\":10872,\"290\":10871,\"291\":10870,\"292\":10869,\"293\":10868,\"294\":10867,\"295\":10866,\"296\":10865,\"297\":10864,\"298\":10863,\"299\":10862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("118", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "a623988c853703697e65b98dde78350b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:02", "2024-03-18 18:16:02", "0", "[{\"id\":18168,\"batched_data\":{\"300\":10861,\"301\":10860,\"302\":10859,\"303\":10858,\"304\":10857,\"305\":10856,\"306\":10855,\"307\":10854,\"308\":10853,\"309\":10852,\"310\":10851,\"311\":10850,\"312\":10849,\"313\":10848,\"314\":10847,\"315\":10846,\"316\":10845,\"317\":10844,\"318\":10843,\"319\":10842,\"320\":10841,\"321\":10840,\"322\":10839,\"323\":10838,\"324\":10837,\"325\":10836,\"326\":10835,\"327\":10834,\"328\":10833,\"329\":10832,\"330\":10831,\"331\":10830,\"332\":10829,\"333\":10828,\"334\":10827,\"335\":10826,\"336\":10825,\"337\":10824,\"338\":10823,\"339\":10822,\"340\":10821,\"341\":10820,\"342\":10819,\"343\":10818,\"344\":10817,\"345\":10816,\"346\":10815,\"347\":10814,\"348\":10813,\"349\":10812,\"350\":10811,\"351\":10810,\"352\":10809,\"353\":10808,\"354\":10807,\"355\":10806,\"356\":10805,\"357\":10804,\"358\":10803,\"359\":10802,\"360\":10801,\"361\":10800,\"362\":10799,\"363\":10798,\"364\":10797,\"365\":10796,\"366\":10795,\"367\":10794,\"368\":10793,\"369\":10792,\"370\":10791,\"371\":10790,\"372\":10789,\"373\":10788,\"374\":10787,\"375\":10786,\"376\":10785,\"377\":10784,\"378\":10783,\"379\":10782,\"380\":10781,\"381\":10780,\"382\":10779,\"383\":10778,\"384\":10777,\"385\":10776,\"386\":10775,\"387\":10774,\"388\":10773,\"389\":10772,\"390\":10771,\"391\":10770,\"392\":10769,\"393\":10768,\"394\":10767,\"395\":10766,\"396\":10765,\"397\":10764,\"398\":10763,\"399\":10762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("119", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "aadd24b45778bb0be17567d5b7276f0a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:03", "2024-03-18 18:16:03", "0", "[{\"id\":18168,\"batched_data\":{\"400\":10761,\"401\":10760,\"402\":10759,\"403\":10758,\"404\":10757,\"405\":10756,\"406\":10755,\"407\":10754,\"408\":10753,\"409\":10752,\"410\":10751,\"411\":10750,\"412\":10749,\"413\":10748,\"414\":10747,\"415\":10746,\"416\":10745,\"417\":10744,\"418\":10743,\"419\":10742,\"420\":10741,\"421\":10740,\"422\":10739,\"423\":10738,\"424\":10737,\"425\":10736,\"426\":10735,\"427\":10734,\"428\":10733,\"429\":10732,\"430\":10731,\"431\":10730,\"432\":10729,\"433\":10728,\"434\":10727,\"435\":10726,\"436\":10725,\"437\":10724,\"438\":10723,\"439\":10722,\"440\":10721,\"441\":10720,\"442\":10719,\"443\":10718,\"444\":10717,\"445\":10716,\"446\":10715,\"447\":10714,\"448\":10713,\"449\":10712,\"450\":10711,\"451\":10710,\"452\":10709,\"453\":10708,\"454\":10707,\"455\":10706,\"456\":10705,\"457\":10704,\"458\":10703,\"459\":10702,\"460\":10701,\"461\":10700,\"462\":10699,\"463\":10698,\"464\":10697,\"465\":10696,\"466\":10695,\"467\":10694,\"468\":10693,\"469\":10692,\"470\":10691,\"471\":10690,\"472\":10689,\"473\":10688,\"474\":10687,\"475\":10686,\"476\":10685,\"477\":10684,\"478\":10683,\"479\":10682,\"480\":10681,\"481\":10680,\"482\":10679,\"483\":10678,\"484\":10677,\"485\":10676,\"486\":10675,\"487\":10674,\"488\":10673,\"489\":10672,\"490\":10671,\"491\":10670,\"492\":10669,\"493\":10668,\"494\":10667,\"495\":10666,\"496\":10665,\"497\":10664,\"498\":10663,\"499\":10662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("120", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:01", "2024-03-18 18:16:01", "[{\"id\":18168,\"offset\":7500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("121", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "9930a25a7a6c446056ea842dd1a19ca5", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "0", "[{\"id\":18168,\"batched_data\":[10661,10660,10659,10658,10657,10656,10655,10654,10653,10652,10651,10650,10649,10648,10647,10646,10645,10644,10643,10642,10641,10640,10639,10638,10637,10636,10635,10634,10633,10632,10631,10630,10629,10628,10627,10626,10625,10624,10623,10622,10621,10620,10619,10618,10617,10616,10615,10614,10613,10612,10611,10610,10609,10608,10607,10606,10605,10604,10603,10602,10601,10600,10599,10598,10597,10596,10595,10594,10593,10592,10591,10590,10589,10588,10587,10586,10585,10584,10583,10582,10581,10580,10579,10578,10577,10576,10575,10574,10573,10572,10571,10570,10569,10568,10567,10566,10565,10564,10563,10562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("122", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "a27dfac25d38ad728a7a4283b2f422a0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "0", "[{\"id\":18168,\"batched_data\":{\"100\":10561,\"101\":10560,\"102\":10559,\"103\":10558,\"104\":10557,\"105\":10556,\"106\":10555,\"107\":10554,\"108\":10553,\"109\":10552,\"110\":10551,\"111\":10550,\"112\":10549,\"113\":10548,\"114\":10547,\"115\":10546,\"116\":10545,\"117\":10544,\"118\":10543,\"119\":10542,\"120\":10541,\"121\":10540,\"122\":10539,\"123\":10538,\"124\":10537,\"125\":10536,\"126\":10535,\"127\":10534,\"128\":10533,\"129\":10532,\"130\":10531,\"131\":10530,\"132\":10529,\"133\":10528,\"134\":10527,\"135\":10526,\"136\":10525,\"137\":10524,\"138\":10523,\"139\":10522,\"140\":10521,\"141\":10520,\"142\":10519,\"143\":10518,\"144\":10517,\"145\":10516,\"146\":10515,\"147\":10514,\"148\":10513,\"149\":10512,\"150\":10511,\"151\":10510,\"152\":10509,\"153\":10508,\"154\":10507,\"155\":10506,\"156\":10505,\"157\":10504,\"158\":10503,\"159\":10502,\"160\":10501,\"161\":10500,\"162\":10499,\"163\":10498,\"164\":10497,\"165\":10496,\"166\":10495,\"167\":10494,\"168\":10493,\"169\":10492,\"170\":10491,\"171\":10490,\"172\":10489,\"173\":10488,\"174\":10487,\"175\":10486,\"176\":10485,\"177\":10484,\"178\":10483,\"179\":10482,\"180\":10481,\"181\":10480,\"182\":10479,\"183\":10478,\"184\":10477,\"185\":10476,\"186\":10475,\"187\":10474,\"188\":10473,\"189\":10472,\"190\":10471,\"191\":10470,\"192\":10469,\"193\":10468,\"194\":10467,\"195\":10466,\"196\":10465,\"197\":10464,\"198\":10463,\"199\":10462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("123", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "525563db7b2be888d782d0b690296873", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "0", "[{\"id\":18168,\"batched_data\":{\"200\":10461,\"201\":10460,\"202\":10459,\"203\":10458,\"204\":10457,\"205\":10456,\"206\":10455,\"207\":10454,\"208\":10453,\"209\":10452,\"210\":10451,\"211\":10450,\"212\":10449,\"213\":10448,\"214\":10447,\"215\":10446,\"216\":10445,\"217\":10444,\"218\":10443,\"219\":10442,\"220\":10441,\"221\":10440,\"222\":10439,\"223\":10438,\"224\":10437,\"225\":10436,\"226\":10435,\"227\":10434,\"228\":10433,\"229\":10432,\"230\":10431,\"231\":10430,\"232\":10429,\"233\":10428,\"234\":10427,\"235\":10426,\"236\":10425,\"237\":10424,\"238\":10423,\"239\":10422,\"240\":10421,\"241\":10420,\"242\":10419,\"243\":10418,\"244\":10417,\"245\":10416,\"246\":10415,\"247\":10414,\"248\":10413,\"249\":10412,\"250\":10411,\"251\":10410,\"252\":10409,\"253\":10408,\"254\":10407,\"255\":10406,\"256\":10405,\"257\":10404,\"258\":10403,\"259\":10402,\"260\":10401,\"261\":10400,\"262\":10399,\"263\":10398,\"264\":10397,\"265\":10396,\"266\":10395,\"267\":10394,\"268\":10393,\"269\":10392,\"270\":10391,\"271\":10390,\"272\":10389,\"273\":10388,\"274\":10387,\"275\":10386,\"276\":10385,\"277\":10384,\"278\":10383,\"279\":10382,\"280\":10381,\"281\":10380,\"282\":10379,\"283\":10378,\"284\":10377,\"285\":10376,\"286\":10375,\"287\":10374,\"288\":10373,\"289\":10372,\"290\":10371,\"291\":10370,\"292\":10369,\"293\":10368,\"294\":10367,\"295\":10366,\"296\":10365,\"297\":10364,\"298\":10363,\"299\":10362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("124", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "080a6a9501648d12da3747b84ea6f0dd", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:05", "2024-03-18 18:16:05", "0", "[{\"id\":18168,\"batched_data\":{\"300\":10361,\"301\":10360,\"302\":10359,\"303\":10358,\"304\":10357,\"305\":10356,\"306\":10355,\"307\":10354,\"308\":10353,\"309\":10352,\"310\":10351,\"311\":10350,\"312\":10349,\"313\":10348,\"314\":10347,\"315\":10346,\"316\":10345,\"317\":10344,\"318\":10343,\"319\":10342,\"320\":10341,\"321\":10340,\"322\":10339,\"323\":10338,\"324\":10337,\"325\":10336,\"326\":10335,\"327\":10334,\"328\":10333,\"329\":10332,\"330\":10331,\"331\":10330,\"332\":10329,\"333\":10328,\"334\":10327,\"335\":10326,\"336\":10325,\"337\":10324,\"338\":10323,\"339\":10322,\"340\":10321,\"341\":10320,\"342\":10319,\"343\":10318,\"344\":10317,\"345\":10316,\"346\":10315,\"347\":10314,\"348\":10313,\"349\":10312,\"350\":10311,\"351\":10310,\"352\":10309,\"353\":10308,\"354\":10307,\"355\":10306,\"356\":10305,\"357\":10304,\"358\":10303,\"359\":10302,\"360\":10301,\"361\":10300,\"362\":10299,\"363\":10298,\"364\":10297,\"365\":10296,\"366\":10295,\"367\":10294,\"368\":10293,\"369\":10292,\"370\":10291,\"371\":10290,\"372\":10289,\"373\":10288,\"374\":10287,\"375\":10286,\"376\":10285,\"377\":10284,\"378\":10283,\"379\":10282,\"380\":10281,\"381\":10280,\"382\":10279,\"383\":10278,\"384\":10277,\"385\":10276,\"386\":10275,\"387\":10274,\"388\":10273,\"389\":10272,\"390\":10271,\"391\":10270,\"392\":10269,\"393\":10268,\"394\":10267,\"395\":10266,\"396\":10265,\"397\":10264,\"398\":10263,\"399\":10262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("125", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "df97be26641f40c9fa178850e1cbd921", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:05", "2024-03-18 18:16:05", "0", "[{\"id\":18168,\"batched_data\":{\"400\":10261,\"401\":10260,\"402\":10259,\"403\":10258,\"404\":10257,\"405\":10256,\"406\":10255,\"407\":10254,\"408\":10253,\"409\":10252,\"410\":10251,\"411\":10250,\"412\":10249,\"413\":10248,\"414\":10247,\"415\":10246,\"416\":10245,\"417\":10244,\"418\":10243,\"419\":10242,\"420\":10241,\"421\":10240,\"422\":10239,\"423\":10238,\"424\":10237,\"425\":10236,\"426\":10235,\"427\":10234,\"428\":10233,\"429\":10232,\"430\":10231,\"431\":10230,\"432\":10229,\"433\":10228,\"434\":10227,\"435\":10226,\"436\":10225,\"437\":10224,\"438\":10223,\"439\":10222,\"440\":10221,\"441\":10220,\"442\":10219,\"443\":10218,\"444\":10217,\"445\":10216,\"446\":10215,\"447\":10214,\"448\":10213,\"449\":10212,\"450\":10211,\"451\":10210,\"452\":10209,\"453\":10208,\"454\":10207,\"455\":10206,\"456\":10205,\"457\":10204,\"458\":10203,\"459\":10202,\"460\":10201,\"461\":10200,\"462\":10199,\"463\":10198,\"464\":10197,\"465\":10196,\"466\":10195,\"467\":10194,\"468\":10193,\"469\":10192,\"470\":10191,\"471\":10190,\"472\":10189,\"473\":10188,\"474\":10187,\"475\":10186,\"476\":10185,\"477\":10184,\"478\":10183,\"479\":10182,\"480\":10181,\"481\":10180,\"482\":10179,\"483\":10178,\"484\":10177,\"485\":10176,\"486\":10175,\"487\":10174,\"488\":10173,\"489\":10172,\"490\":10171,\"491\":10170,\"492\":10169,\"493\":10168,\"494\":10167,\"495\":10166,\"496\":10165,\"497\":10164,\"498\":10163,\"499\":10162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":7500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("126", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:04", "2024-03-18 18:16:04", "[{\"id\":18168,\"offset\":8000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:05", "2024-03-18 18:16:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("127", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:05", "2024-03-18 18:16:05", "4eff4ed9ae7fa61105c84e977fce28d3", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "0", "[{\"id\":18168,\"batched_data\":[10161,10160,10159,10158,10157,10156,10155,10154,10153,10152,10151,10150,10149,10148,10147,10146,10145,10144,10143,10142,10141,10140,10139,10138,10137,10136,10135,10134,10133,10132,10131,10130,10129,10128,10127,10126,10125,10124,10123,10122,10121,10120,10119,10118,10117,10116,10115,10114,10113,10112,10111,10110,10109,10108,10107,10106,10105,10104,10103,10102,10101,10100,10099,10098,10097,10096,10095,10094,10093,10092,10091,10090,10089,10088,10087,10086,10085,10084,10083,10082,10081,10080,10079,10078,10077,10076,10075,10074,10073,10072,10071,10070,10069,10068,10067,10066,10065,10064,10063,10062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("128", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:05", "2024-03-18 18:16:05", "08d92ab2cdce80f8042c4d101fe61117", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "0", "[{\"id\":18168,\"batched_data\":{\"100\":10061,\"101\":10060,\"102\":10059,\"103\":10058,\"104\":10057,\"105\":10056,\"106\":10055,\"107\":10054,\"108\":10053,\"109\":10052,\"110\":10051,\"111\":10050,\"112\":10049,\"113\":10048,\"114\":10047,\"115\":10046,\"116\":10045,\"117\":10044,\"118\":10043,\"119\":10042,\"120\":10041,\"121\":10040,\"122\":10039,\"123\":10038,\"124\":10037,\"125\":10036,\"126\":10035,\"127\":10034,\"128\":10033,\"129\":10032,\"130\":10031,\"131\":10030,\"132\":10029,\"133\":10028,\"134\":10027,\"135\":10026,\"136\":10025,\"137\":10024,\"138\":10023,\"139\":10022,\"140\":10021,\"141\":10020,\"142\":10019,\"143\":10018,\"144\":10017,\"145\":10016,\"146\":10015,\"147\":10014,\"148\":10013,\"149\":10012,\"150\":10011,\"151\":10010,\"152\":10009,\"153\":10008,\"154\":10007,\"155\":10006,\"156\":10005,\"157\":10004,\"158\":10003,\"159\":10002,\"160\":10001,\"161\":10000,\"162\":9999,\"163\":9998,\"164\":9997,\"165\":9996,\"166\":9995,\"167\":9994,\"168\":9993,\"169\":9992,\"170\":9991,\"171\":9990,\"172\":9989,\"173\":9988,\"174\":9987,\"175\":9986,\"176\":9985,\"177\":9984,\"178\":9983,\"179\":9982,\"180\":9981,\"181\":9980,\"182\":9979,\"183\":9978,\"184\":9977,\"185\":9976,\"186\":9975,\"187\":9974,\"188\":9973,\"189\":9972,\"190\":9971,\"191\":9970,\"192\":9969,\"193\":9968,\"194\":9967,\"195\":9966,\"196\":9965,\"197\":9964,\"198\":9963,\"199\":9962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("129", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:05", "2024-03-18 18:16:05", "7edc2707455026c80d61b2046754a668", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "0", "[{\"id\":18168,\"batched_data\":{\"200\":9961,\"201\":9960,\"202\":9959,\"203\":9958,\"204\":9957,\"205\":9956,\"206\":9955,\"207\":9954,\"208\":9953,\"209\":9952,\"210\":9951,\"211\":9950,\"212\":9949,\"213\":9948,\"214\":9947,\"215\":9946,\"216\":9945,\"217\":9944,\"218\":9943,\"219\":9942,\"220\":9941,\"221\":9940,\"222\":9939,\"223\":9938,\"224\":9937,\"225\":9936,\"226\":9935,\"227\":9934,\"228\":9933,\"229\":9932,\"230\":9931,\"231\":9930,\"232\":9929,\"233\":9928,\"234\":9927,\"235\":9926,\"236\":9925,\"237\":9924,\"238\":9923,\"239\":9922,\"240\":9921,\"241\":9920,\"242\":9919,\"243\":9918,\"244\":9917,\"245\":9916,\"246\":9915,\"247\":9914,\"248\":9913,\"249\":9912,\"250\":9911,\"251\":9910,\"252\":9909,\"253\":9908,\"254\":9907,\"255\":9906,\"256\":9905,\"257\":9904,\"258\":9903,\"259\":9902,\"260\":9901,\"261\":9900,\"262\":9899,\"263\":9898,\"264\":9897,\"265\":9896,\"266\":9895,\"267\":9894,\"268\":9893,\"269\":9892,\"270\":9891,\"271\":9890,\"272\":9889,\"273\":9888,\"274\":9887,\"275\":9886,\"276\":9885,\"277\":9884,\"278\":9883,\"279\":9882,\"280\":9881,\"281\":9880,\"282\":9879,\"283\":9878,\"284\":9877,\"285\":9876,\"286\":9875,\"287\":9874,\"288\":9873,\"289\":9872,\"290\":9871,\"291\":9870,\"292\":9869,\"293\":9868,\"294\":9867,\"295\":9866,\"296\":9865,\"297\":9864,\"298\":9863,\"299\":9862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("130", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:05", "2024-03-18 18:16:05", "9716c895e80bca08a927490d457daf67", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "0", "[{\"id\":18168,\"batched_data\":{\"300\":9861,\"301\":9860,\"302\":9859,\"303\":9858,\"304\":9857,\"305\":9856,\"306\":9855,\"307\":9854,\"308\":9853,\"309\":9852,\"310\":9851,\"311\":9850,\"312\":9849,\"313\":9848,\"314\":9847,\"315\":9846,\"316\":9845,\"317\":9844,\"318\":9843,\"319\":9842,\"320\":9841,\"321\":9840,\"322\":9839,\"323\":9838,\"324\":9837,\"325\":9836,\"326\":9835,\"327\":9834,\"328\":9833,\"329\":9832,\"330\":9831,\"331\":9830,\"332\":9829,\"333\":9828,\"334\":9827,\"335\":9826,\"336\":9825,\"337\":9824,\"338\":9823,\"339\":9822,\"340\":9821,\"341\":9820,\"342\":9819,\"343\":9818,\"344\":9817,\"345\":9816,\"346\":9815,\"347\":9814,\"348\":9813,\"349\":9812,\"350\":9811,\"351\":9810,\"352\":9809,\"353\":9808,\"354\":9807,\"355\":9806,\"356\":9805,\"357\":9804,\"358\":9803,\"359\":9802,\"360\":9801,\"361\":9800,\"362\":9799,\"363\":9798,\"364\":9797,\"365\":9796,\"366\":9795,\"367\":9794,\"368\":9793,\"369\":9792,\"370\":9791,\"371\":9790,\"372\":9789,\"373\":9788,\"374\":9787,\"375\":9786,\"376\":9785,\"377\":9784,\"378\":9783,\"379\":9782,\"380\":9781,\"381\":9780,\"382\":9779,\"383\":9778,\"384\":9777,\"385\":9776,\"386\":9775,\"387\":9774,\"388\":9773,\"389\":9772,\"390\":9771,\"391\":9770,\"392\":9769,\"393\":9768,\"394\":9767,\"395\":9766,\"396\":9765,\"397\":9764,\"398\":9763,\"399\":9762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("131", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:05", "2024-03-18 18:16:05", "ffb4b77d28af0ef0a20a57a24b715a87", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "0", "[{\"id\":18168,\"batched_data\":{\"400\":9761,\"401\":9760,\"402\":9759,\"403\":9758,\"404\":9757,\"405\":9756,\"406\":9755,\"407\":9754,\"408\":9753,\"409\":9752,\"410\":9751,\"411\":9750,\"412\":9749,\"413\":9748,\"414\":9747,\"415\":9746,\"416\":9745,\"417\":9744,\"418\":9743,\"419\":9742,\"420\":9741,\"421\":9740,\"422\":9739,\"423\":9738,\"424\":9737,\"425\":9736,\"426\":9735,\"427\":9734,\"428\":9733,\"429\":9732,\"430\":9731,\"431\":9730,\"432\":9729,\"433\":9728,\"434\":9727,\"435\":9726,\"436\":9725,\"437\":9724,\"438\":9723,\"439\":9722,\"440\":9721,\"441\":9720,\"442\":9719,\"443\":9718,\"444\":9717,\"445\":9716,\"446\":9715,\"447\":9714,\"448\":9713,\"449\":9712,\"450\":9711,\"451\":9710,\"452\":9709,\"453\":9708,\"454\":9707,\"455\":9706,\"456\":9705,\"457\":9704,\"458\":9703,\"459\":9702,\"460\":9701,\"461\":9700,\"462\":9699,\"463\":9698,\"464\":9697,\"465\":9696,\"466\":9695,\"467\":9694,\"468\":9693,\"469\":9692,\"470\":9691,\"471\":9690,\"472\":9689,\"473\":9688,\"474\":9687,\"475\":9686,\"476\":9685,\"477\":9684,\"478\":9683,\"479\":9682,\"480\":9681,\"481\":9680,\"482\":9679,\"483\":9678,\"484\":9677,\"485\":9676,\"486\":9675,\"487\":9674,\"488\":9673,\"489\":9672,\"490\":9671,\"491\":9670,\"492\":9669,\"493\":9668,\"494\":9667,\"495\":9666,\"496\":9665,\"497\":9664,\"498\":9663,\"499\":9662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("132", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:05", "2024-03-18 18:16:05", "[{\"id\":18168,\"offset\":8500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("133", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "8587381d64cc3d03195bc43b67adfe4c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "0", "[{\"id\":18168,\"batched_data\":[9661,9660,9659,9658,9657,9656,9655,9654,9653,9652,9651,9650,9649,9648,9647,9646,9645,9644,9643,9642,9641,9640,9639,9638,9637,9636,9635,9634,9633,9632,9631,9630,9629,9628,9627,9626,9625,9624,9623,9622,9621,9620,9619,9618,9617,9616,9615,9614,9613,9612,9611,9610,9609,9608,9607,9606,9605,9604,9603,9602,9601,9600,9599,9598,9597,9596,9595,9594,9593,9592,9591,9590,9589,9588,9587,9586,9585,9584,9583,9582,9581,9580,9579,9578,9577,9576,9575,9574,9573,9572,9571,9570,9569,9568,9567,9566,9565,9564,9563,9562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("134", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "82282c848ccc62b7c5fd660da8b4264d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "0", "[{\"id\":18168,\"batched_data\":{\"100\":9561,\"101\":9560,\"102\":9559,\"103\":9558,\"104\":9557,\"105\":9556,\"106\":9555,\"107\":9554,\"108\":9553,\"109\":9552,\"110\":9551,\"111\":9550,\"112\":9549,\"113\":9548,\"114\":9547,\"115\":9546,\"116\":9545,\"117\":9544,\"118\":9543,\"119\":9542,\"120\":9541,\"121\":9540,\"122\":9539,\"123\":9538,\"124\":9537,\"125\":9536,\"126\":9535,\"127\":9534,\"128\":9533,\"129\":9532,\"130\":9531,\"131\":9530,\"132\":9529,\"133\":9528,\"134\":9527,\"135\":9526,\"136\":9525,\"137\":9524,\"138\":9523,\"139\":9522,\"140\":9521,\"141\":9520,\"142\":9519,\"143\":9518,\"144\":9517,\"145\":9516,\"146\":9515,\"147\":9514,\"148\":9513,\"149\":9512,\"150\":9511,\"151\":9510,\"152\":9509,\"153\":9508,\"154\":9507,\"155\":9506,\"156\":9505,\"157\":9504,\"158\":9503,\"159\":9502,\"160\":9501,\"161\":9500,\"162\":9499,\"163\":9498,\"164\":9497,\"165\":9496,\"166\":9495,\"167\":9494,\"168\":9493,\"169\":9492,\"170\":9491,\"171\":9490,\"172\":9489,\"173\":9488,\"174\":9487,\"175\":9486,\"176\":9485,\"177\":9484,\"178\":9483,\"179\":9482,\"180\":9481,\"181\":9480,\"182\":9479,\"183\":9478,\"184\":9477,\"185\":9476,\"186\":9475,\"187\":9474,\"188\":9473,\"189\":9472,\"190\":9471,\"191\":9470,\"192\":9469,\"193\":9468,\"194\":9467,\"195\":9466,\"196\":9465,\"197\":9464,\"198\":9463,\"199\":9462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("135", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "1c7f1bb8a0898c668d2102ab2c83997a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "0", "[{\"id\":18168,\"batched_data\":{\"200\":9461,\"201\":9460,\"202\":9459,\"203\":9458,\"204\":9457,\"205\":9456,\"206\":9455,\"207\":9454,\"208\":9453,\"209\":9452,\"210\":9451,\"211\":9450,\"212\":9449,\"213\":9448,\"214\":9447,\"215\":9446,\"216\":9445,\"217\":9444,\"218\":9443,\"219\":9442,\"220\":9441,\"221\":9440,\"222\":9439,\"223\":9438,\"224\":9437,\"225\":9436,\"226\":9435,\"227\":9434,\"228\":9433,\"229\":9432,\"230\":9431,\"231\":9430,\"232\":9429,\"233\":9428,\"234\":9427,\"235\":9426,\"236\":9425,\"237\":9424,\"238\":9423,\"239\":9422,\"240\":9421,\"241\":9420,\"242\":9419,\"243\":9418,\"244\":9417,\"245\":9416,\"246\":9415,\"247\":9414,\"248\":9413,\"249\":9412,\"250\":9411,\"251\":9410,\"252\":9409,\"253\":9408,\"254\":9407,\"255\":9406,\"256\":9405,\"257\":9404,\"258\":9403,\"259\":9402,\"260\":9401,\"261\":9400,\"262\":9399,\"263\":9398,\"264\":9397,\"265\":9396,\"266\":9395,\"267\":9394,\"268\":9393,\"269\":9392,\"270\":9391,\"271\":9390,\"272\":9389,\"273\":9388,\"274\":9387,\"275\":9386,\"276\":9385,\"277\":9384,\"278\":9383,\"279\":9382,\"280\":9381,\"281\":9380,\"282\":9379,\"283\":9378,\"284\":9377,\"285\":9376,\"286\":9375,\"287\":9374,\"288\":9373,\"289\":9372,\"290\":9371,\"291\":9370,\"292\":9369,\"293\":9368,\"294\":9367,\"295\":9366,\"296\":9365,\"297\":9364,\"298\":9363,\"299\":9362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("136", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "21da0d85da5cfec70f2c732ade6ea65d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "0", "[{\"id\":18168,\"batched_data\":{\"300\":9361,\"301\":9360,\"302\":9359,\"303\":9358,\"304\":9357,\"305\":9356,\"306\":9355,\"307\":9354,\"308\":9353,\"309\":9352,\"310\":9351,\"311\":9350,\"312\":9349,\"313\":9348,\"314\":9347,\"315\":9346,\"316\":9345,\"317\":9344,\"318\":9343,\"319\":9342,\"320\":9341,\"321\":9340,\"322\":9339,\"323\":9338,\"324\":9337,\"325\":9336,\"326\":9335,\"327\":9334,\"328\":9333,\"329\":9332,\"330\":9331,\"331\":9330,\"332\":9329,\"333\":9328,\"334\":9327,\"335\":9326,\"336\":9325,\"337\":9324,\"338\":9323,\"339\":9322,\"340\":9321,\"341\":9320,\"342\":9319,\"343\":9318,\"344\":9317,\"345\":9316,\"346\":9315,\"347\":9314,\"348\":9313,\"349\":9312,\"350\":9311,\"351\":9310,\"352\":9309,\"353\":9308,\"354\":9307,\"355\":9306,\"356\":9305,\"357\":9304,\"358\":9303,\"359\":9302,\"360\":9301,\"361\":9300,\"362\":9299,\"363\":9298,\"364\":9297,\"365\":9296,\"366\":9295,\"367\":9294,\"368\":9293,\"369\":9292,\"370\":9291,\"371\":9290,\"372\":9289,\"373\":9288,\"374\":9287,\"375\":9286,\"376\":9285,\"377\":9284,\"378\":9283,\"379\":9282,\"380\":9281,\"381\":9280,\"382\":9279,\"383\":9278,\"384\":9277,\"385\":9276,\"386\":9275,\"387\":9274,\"388\":9273,\"389\":9272,\"390\":9271,\"391\":9270,\"392\":9269,\"393\":9268,\"394\":9267,\"395\":9266,\"396\":9265,\"397\":9264,\"398\":9263,\"399\":9262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("137", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "bfdc186be18df7aca0999a134d18ecca", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "0", "[{\"id\":18168,\"batched_data\":{\"400\":9261,\"401\":9260,\"402\":9259,\"403\":9258,\"404\":9257,\"405\":9256,\"406\":9255,\"407\":9254,\"408\":9253,\"409\":9252,\"410\":9251,\"411\":9250,\"412\":9249,\"413\":9248,\"414\":9247,\"415\":9246,\"416\":9245,\"417\":9244,\"418\":9243,\"419\":9242,\"420\":9241,\"421\":9240,\"422\":9239,\"423\":9238,\"424\":9237,\"425\":9236,\"426\":9235,\"427\":9234,\"428\":9233,\"429\":9232,\"430\":9231,\"431\":9230,\"432\":9229,\"433\":9228,\"434\":9227,\"435\":9226,\"436\":9225,\"437\":9224,\"438\":9223,\"439\":9222,\"440\":9221,\"441\":9220,\"442\":9219,\"443\":9218,\"444\":9217,\"445\":9216,\"446\":9215,\"447\":9214,\"448\":9213,\"449\":9212,\"450\":9211,\"451\":9210,\"452\":9209,\"453\":9208,\"454\":9207,\"455\":9206,\"456\":9205,\"457\":9204,\"458\":9203,\"459\":9202,\"460\":9201,\"461\":9200,\"462\":9199,\"463\":9198,\"464\":9197,\"465\":9196,\"466\":9195,\"467\":9194,\"468\":9193,\"469\":9192,\"470\":9191,\"471\":9190,\"472\":9189,\"473\":9188,\"474\":9187,\"475\":9186,\"476\":9185,\"477\":9184,\"478\":9183,\"479\":9182,\"480\":9181,\"481\":9180,\"482\":9179,\"483\":9178,\"484\":9177,\"485\":9176,\"486\":9175,\"487\":9174,\"488\":9173,\"489\":9172,\"490\":9171,\"491\":9170,\"492\":9169,\"493\":9168,\"494\":9167,\"495\":9166,\"496\":9165,\"497\":9164,\"498\":9163,\"499\":9162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":8500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("138", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:06", "2024-03-18 18:16:06", "[{\"id\":18168,\"offset\":9000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("139", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "ca75dcb9375dd4e55a5ce812edd0cb5d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:08", "2024-03-18 18:16:08", "0", "[{\"id\":18168,\"batched_data\":[9161,9160,9159,9158,9157,9156,9155,9154,9153,9152,9151,9150,9149,9148,9147,9146,9145,9144,9143,9142,9141,9140,9139,9138,9137,9136,9135,9134,9133,9132,9131,9130,9129,9128,9127,9126,9125,9124,9123,9122,9121,9120,9119,9118,9117,9116,9115,9114,9113,9112,9111,9110,9109,9108,9107,9106,9105,9104,9103,9102,9101,9100,9099,9098,9097,9096,9095,9094,9093,9092,9091,9090,9089,9088,9087,9086,9085,9084,9083,9082,9081,9080,9079,9078,9077,9076,9075,9074,9073,9072,9071,9070,9069,9068,9067,9066,9065,9064,9063,9062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("140", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "29ce54c4836758c0cf51097b1efae87e", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:08", "2024-03-18 18:16:08", "0", "[{\"id\":18168,\"batched_data\":{\"100\":9061,\"101\":9060,\"102\":9059,\"103\":9058,\"104\":9057,\"105\":9056,\"106\":9055,\"107\":9054,\"108\":9053,\"109\":9052,\"110\":9051,\"111\":9050,\"112\":9049,\"113\":9048,\"114\":9047,\"115\":9046,\"116\":9045,\"117\":9044,\"118\":9043,\"119\":9042,\"120\":9041,\"121\":9040,\"122\":9039,\"123\":9038,\"124\":9037,\"125\":9036,\"126\":9035,\"127\":9034,\"128\":9033,\"129\":9032,\"130\":9031,\"131\":9030,\"132\":9029,\"133\":9028,\"134\":9027,\"135\":9026,\"136\":9025,\"137\":9024,\"138\":9023,\"139\":9022,\"140\":9021,\"141\":9020,\"142\":9019,\"143\":9018,\"144\":9017,\"145\":9016,\"146\":9015,\"147\":9014,\"148\":9013,\"149\":9012,\"150\":9011,\"151\":9010,\"152\":9009,\"153\":9008,\"154\":9007,\"155\":9006,\"156\":9005,\"157\":9004,\"158\":9003,\"159\":9002,\"160\":9001,\"161\":9000,\"162\":8999,\"163\":8998,\"164\":8997,\"165\":8996,\"166\":8995,\"167\":8994,\"168\":8993,\"169\":8992,\"170\":8991,\"171\":8990,\"172\":8989,\"173\":8988,\"174\":8987,\"175\":8986,\"176\":8985,\"177\":8984,\"178\":8983,\"179\":8982,\"180\":8981,\"181\":8980,\"182\":8979,\"183\":8978,\"184\":8977,\"185\":8976,\"186\":8975,\"187\":8974,\"188\":8973,\"189\":8972,\"190\":8971,\"191\":8970,\"192\":8969,\"193\":8968,\"194\":8967,\"195\":8966,\"196\":8965,\"197\":8964,\"198\":8963,\"199\":8962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("141", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "87848bc7e326335983887850b11f7a46", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:08", "2024-03-18 18:16:08", "0", "[{\"id\":18168,\"batched_data\":{\"200\":8961,\"201\":8960,\"202\":8959,\"203\":8958,\"204\":8957,\"205\":8956,\"206\":8955,\"207\":8954,\"208\":8953,\"209\":8952,\"210\":8951,\"211\":8950,\"212\":8949,\"213\":8948,\"214\":8947,\"215\":8946,\"216\":8945,\"217\":8944,\"218\":8943,\"219\":8942,\"220\":8941,\"221\":8940,\"222\":8939,\"223\":8938,\"224\":8937,\"225\":8936,\"226\":8935,\"227\":8934,\"228\":8933,\"229\":8932,\"230\":8931,\"231\":8930,\"232\":8929,\"233\":8928,\"234\":8927,\"235\":8926,\"236\":8925,\"237\":8924,\"238\":8923,\"239\":8922,\"240\":8921,\"241\":8920,\"242\":8919,\"243\":8918,\"244\":8917,\"245\":8916,\"246\":8915,\"247\":8914,\"248\":8913,\"249\":8912,\"250\":8911,\"251\":8910,\"252\":8909,\"253\":8908,\"254\":8907,\"255\":8906,\"256\":8905,\"257\":8904,\"258\":8903,\"259\":8902,\"260\":8901,\"261\":8900,\"262\":8899,\"263\":8898,\"264\":8897,\"265\":8896,\"266\":8895,\"267\":8894,\"268\":8893,\"269\":8892,\"270\":8891,\"271\":8890,\"272\":8889,\"273\":8888,\"274\":8887,\"275\":8886,\"276\":8885,\"277\":8884,\"278\":8883,\"279\":8882,\"280\":8881,\"281\":8880,\"282\":8879,\"283\":8878,\"284\":8877,\"285\":8876,\"286\":8875,\"287\":8874,\"288\":8873,\"289\":8872,\"290\":8871,\"291\":8870,\"292\":8869,\"293\":8868,\"294\":8867,\"295\":8866,\"296\":8865,\"297\":8864,\"298\":8863,\"299\":8862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("142", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "8aaf9a879fbae8ac84f38da287937fba", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:09", "2024-03-18 18:16:09", "0", "[{\"id\":18168,\"batched_data\":{\"300\":8861,\"301\":8860,\"302\":8859,\"303\":8858,\"304\":8857,\"305\":8856,\"306\":8855,\"307\":8854,\"308\":8853,\"309\":8852,\"310\":8851,\"311\":8850,\"312\":8849,\"313\":8848,\"314\":8847,\"315\":8846,\"316\":8845,\"317\":8844,\"318\":8843,\"319\":8842,\"320\":8841,\"321\":8840,\"322\":8839,\"323\":8838,\"324\":8837,\"325\":8836,\"326\":8835,\"327\":8834,\"328\":8833,\"329\":8832,\"330\":8831,\"331\":8830,\"332\":8829,\"333\":8828,\"334\":8827,\"335\":8826,\"336\":8825,\"337\":8824,\"338\":8823,\"339\":8822,\"340\":8821,\"341\":8820,\"342\":8819,\"343\":8818,\"344\":8817,\"345\":8816,\"346\":8815,\"347\":8814,\"348\":8813,\"349\":8812,\"350\":8811,\"351\":8810,\"352\":8809,\"353\":8808,\"354\":8807,\"355\":8806,\"356\":8805,\"357\":8804,\"358\":8803,\"359\":8802,\"360\":8801,\"361\":8800,\"362\":8799,\"363\":8798,\"364\":8797,\"365\":8796,\"366\":8795,\"367\":8794,\"368\":8793,\"369\":8792,\"370\":8791,\"371\":8790,\"372\":8789,\"373\":8788,\"374\":8787,\"375\":8786,\"376\":8785,\"377\":8784,\"378\":8783,\"379\":8782,\"380\":8781,\"381\":8780,\"382\":8779,\"383\":8778,\"384\":8777,\"385\":8776,\"386\":8775,\"387\":8774,\"388\":8773,\"389\":8772,\"390\":8771,\"391\":8770,\"392\":8769,\"393\":8768,\"394\":8767,\"395\":8766,\"396\":8765,\"397\":8764,\"398\":8763,\"399\":8762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("143", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "2ae7a1f2a4c0238d5631b13366621120", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:09", "2024-03-18 18:16:09", "0", "[{\"id\":18168,\"batched_data\":{\"400\":8761,\"401\":8760,\"402\":8759,\"403\":8758,\"404\":8757,\"405\":8756,\"406\":8755,\"407\":8754,\"408\":8753,\"409\":8752,\"410\":8751,\"411\":8750,\"412\":8749,\"413\":8748,\"414\":8747,\"415\":8746,\"416\":8745,\"417\":8744,\"418\":8743,\"419\":8742,\"420\":8741,\"421\":8740,\"422\":8739,\"423\":8738,\"424\":8737,\"425\":8736,\"426\":8735,\"427\":8734,\"428\":8733,\"429\":8732,\"430\":8731,\"431\":8730,\"432\":8729,\"433\":8728,\"434\":8727,\"435\":8726,\"436\":8725,\"437\":8724,\"438\":8723,\"439\":8722,\"440\":8721,\"441\":8720,\"442\":8719,\"443\":8718,\"444\":8717,\"445\":8716,\"446\":8715,\"447\":8714,\"448\":8713,\"449\":8712,\"450\":8711,\"451\":8710,\"452\":8709,\"453\":8708,\"454\":8707,\"455\":8706,\"456\":8705,\"457\":8704,\"458\":8703,\"459\":8702,\"460\":8701,\"461\":8700,\"462\":8699,\"463\":8698,\"464\":8697,\"465\":8696,\"466\":8695,\"467\":8694,\"468\":8693,\"469\":8692,\"470\":8691,\"471\":8690,\"472\":8689,\"473\":8688,\"474\":8687,\"475\":8686,\"476\":8685,\"477\":8684,\"478\":8683,\"479\":8682,\"480\":8681,\"481\":8680,\"482\":8679,\"483\":8678,\"484\":8677,\"485\":8676,\"486\":8675,\"487\":8674,\"488\":8673,\"489\":8672,\"490\":8671,\"491\":8670,\"492\":8669,\"493\":8668,\"494\":8667,\"495\":8666,\"496\":8665,\"497\":8664,\"498\":8663,\"499\":8662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("144", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:07", "2024-03-18 18:16:07", "[{\"id\":18168,\"offset\":9500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:09", "2024-03-18 18:16:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("145", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:09", "2024-03-18 18:16:09", "1df22deced84a900d4e66e394feb8e8a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:10", "2024-03-18 18:16:10", "0", "[{\"id\":18168,\"batched_data\":[8661,8660,8659,8658,8657,8656,8655,8654,8653,8652,8651,8650,8649,8648,8647,8646,8645,8644,8643,8642,8641,8640,8639,8638,8637,8636,8635,8634,8633,8632,8631,8630,8629,8628,8627,8626,8625,8624,8623,8622,8621,8620,8619,8618,8617,8616,8615,8614,8613,8612,8611,8610,8609,8608,8607,8606,8605,8604,8603,8602,8601,8600,8599,8598,8597,8596,8595,8594,8593,8592,8591,8590,8589,8588,8587,8586,8585,8584,8583,8582,8581,8580,8579,8578,8577,8576,8575,8574,8573,8572,8571,8570,8569,8568,8567,8566,8565,8564,8563,8562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("146", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:09", "2024-03-18 18:16:09", "8f8e082678ebaeee7f8f6c4a0a105d34", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:10", "2024-03-18 18:16:10", "0", "[{\"id\":18168,\"batched_data\":{\"100\":8561,\"101\":8560,\"102\":8559,\"103\":8558,\"104\":8557,\"105\":8556,\"106\":8555,\"107\":8554,\"108\":8553,\"109\":8552,\"110\":8551,\"111\":8550,\"112\":8549,\"113\":8548,\"114\":8547,\"115\":8546,\"116\":8545,\"117\":8544,\"118\":8543,\"119\":8542,\"120\":8541,\"121\":8540,\"122\":8539,\"123\":8538,\"124\":8537,\"125\":8536,\"126\":8535,\"127\":8534,\"128\":8533,\"129\":8532,\"130\":8531,\"131\":8530,\"132\":8529,\"133\":8528,\"134\":8527,\"135\":8526,\"136\":8525,\"137\":8524,\"138\":8523,\"139\":8522,\"140\":8521,\"141\":8520,\"142\":8519,\"143\":8518,\"144\":8517,\"145\":8516,\"146\":8515,\"147\":8514,\"148\":8513,\"149\":8512,\"150\":8511,\"151\":8510,\"152\":8509,\"153\":8508,\"154\":8507,\"155\":8506,\"156\":8505,\"157\":8504,\"158\":8503,\"159\":8502,\"160\":8501,\"161\":8500,\"162\":8499,\"163\":8498,\"164\":8497,\"165\":8496,\"166\":8495,\"167\":8494,\"168\":8493,\"169\":8492,\"170\":8491,\"171\":8490,\"172\":8489,\"173\":8488,\"174\":8487,\"175\":8486,\"176\":8485,\"177\":8484,\"178\":8483,\"179\":8482,\"180\":8481,\"181\":8480,\"182\":8479,\"183\":8478,\"184\":8477,\"185\":8476,\"186\":8475,\"187\":8474,\"188\":8473,\"189\":8472,\"190\":8471,\"191\":8470,\"192\":8469,\"193\":8468,\"194\":8467,\"195\":8466,\"196\":8465,\"197\":8464,\"198\":8463,\"199\":8462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("147", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:09", "2024-03-18 18:16:09", "62a2204b98a64158a1e5aa1c6582005b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:10", "2024-03-18 18:16:10", "0", "[{\"id\":18168,\"batched_data\":{\"200\":8461,\"201\":8460,\"202\":8459,\"203\":8458,\"204\":8457,\"205\":8456,\"206\":8455,\"207\":8454,\"208\":8453,\"209\":8452,\"210\":8451,\"211\":8450,\"212\":8449,\"213\":8448,\"214\":8447,\"215\":8446,\"216\":8445,\"217\":8444,\"218\":8443,\"219\":8442,\"220\":8441,\"221\":8440,\"222\":8439,\"223\":8438,\"224\":8437,\"225\":8436,\"226\":8435,\"227\":8434,\"228\":8433,\"229\":8432,\"230\":8431,\"231\":8430,\"232\":8429,\"233\":8428,\"234\":8427,\"235\":8426,\"236\":8425,\"237\":8424,\"238\":8423,\"239\":8422,\"240\":8421,\"241\":8420,\"242\":8419,\"243\":8418,\"244\":8417,\"245\":8416,\"246\":8415,\"247\":8414,\"248\":8413,\"249\":8412,\"250\":8411,\"251\":8410,\"252\":8409,\"253\":8408,\"254\":8407,\"255\":8406,\"256\":8405,\"257\":8404,\"258\":8403,\"259\":8402,\"260\":8401,\"261\":8400,\"262\":8399,\"263\":8398,\"264\":8397,\"265\":8396,\"266\":8395,\"267\":8394,\"268\":8393,\"269\":8392,\"270\":8391,\"271\":8390,\"272\":8389,\"273\":8388,\"274\":8387,\"275\":8386,\"276\":8385,\"277\":8384,\"278\":8383,\"279\":8382,\"280\":8381,\"281\":8380,\"282\":8379,\"283\":8378,\"284\":8377,\"285\":8376,\"286\":8375,\"287\":8374,\"288\":8373,\"289\":8372,\"290\":8371,\"291\":8370,\"292\":8369,\"293\":8368,\"294\":8367,\"295\":8366,\"296\":8365,\"297\":8364,\"298\":8363,\"299\":8362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("148", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:09", "2024-03-18 18:16:09", "efd3fcb5afbbea298c588798516608fe", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:10", "2024-03-18 18:16:10", "0", "[{\"id\":18168,\"batched_data\":{\"300\":8361,\"301\":8360,\"302\":8359,\"303\":8358,\"304\":8357,\"305\":8356,\"306\":8355,\"307\":8354,\"308\":8353,\"309\":8352,\"310\":8351,\"311\":8350,\"312\":8349,\"313\":8348,\"314\":8347,\"315\":8346,\"316\":8345,\"317\":8344,\"318\":8343,\"319\":8342,\"320\":8341,\"321\":8340,\"322\":8339,\"323\":8338,\"324\":8337,\"325\":8336,\"326\":8335,\"327\":8334,\"328\":8333,\"329\":8332,\"330\":8331,\"331\":8330,\"332\":8329,\"333\":8328,\"334\":8327,\"335\":8326,\"336\":8325,\"337\":8324,\"338\":8323,\"339\":8322,\"340\":8321,\"341\":8320,\"342\":8319,\"343\":8318,\"344\":8317,\"345\":8316,\"346\":8315,\"347\":8314,\"348\":8313,\"349\":8312,\"350\":8311,\"351\":8310,\"352\":8309,\"353\":8308,\"354\":8307,\"355\":8306,\"356\":8305,\"357\":8304,\"358\":8303,\"359\":8302,\"360\":8301,\"361\":8300,\"362\":8299,\"363\":8298,\"364\":8297,\"365\":8296,\"366\":8295,\"367\":8294,\"368\":8293,\"369\":8292,\"370\":8291,\"371\":8290,\"372\":8289,\"373\":8288,\"374\":8287,\"375\":8286,\"376\":8285,\"377\":8284,\"378\":8283,\"379\":8282,\"380\":8281,\"381\":8280,\"382\":8279,\"383\":8278,\"384\":8277,\"385\":8276,\"386\":8275,\"387\":8274,\"388\":8273,\"389\":8272,\"390\":8271,\"391\":8270,\"392\":8269,\"393\":8268,\"394\":8267,\"395\":8266,\"396\":8265,\"397\":8264,\"398\":8263,\"399\":8262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("149", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:09", "2024-03-18 18:16:09", "ac65ab2aae79e914cc7363c2d7d0ef26", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "0", "[{\"id\":18168,\"batched_data\":{\"400\":8261,\"401\":8260,\"402\":8259,\"403\":8258,\"404\":8257,\"405\":8256,\"406\":8255,\"407\":8254,\"408\":8253,\"409\":8252,\"410\":8251,\"411\":8250,\"412\":8249,\"413\":8248,\"414\":8247,\"415\":8246,\"416\":8245,\"417\":8244,\"418\":8243,\"419\":8242,\"420\":8241,\"421\":8240,\"422\":8239,\"423\":8238,\"424\":8237,\"425\":8236,\"426\":8235,\"427\":8234,\"428\":8233,\"429\":8232,\"430\":8231,\"431\":8230,\"432\":8229,\"433\":8228,\"434\":8227,\"435\":8226,\"436\":8225,\"437\":8224,\"438\":8223,\"439\":8222,\"440\":8221,\"441\":8220,\"442\":8219,\"443\":8218,\"444\":8217,\"445\":8216,\"446\":8215,\"447\":8214,\"448\":8213,\"449\":8212,\"450\":8211,\"451\":8210,\"452\":8209,\"453\":8208,\"454\":8207,\"455\":8206,\"456\":8205,\"457\":8204,\"458\":8203,\"459\":8202,\"460\":8201,\"461\":8200,\"462\":8199,\"463\":8198,\"464\":8197,\"465\":8196,\"466\":8195,\"467\":8194,\"468\":8193,\"469\":8192,\"470\":8191,\"471\":8190,\"472\":8189,\"473\":8188,\"474\":8187,\"475\":8186,\"476\":8185,\"477\":8184,\"478\":8183,\"479\":8182,\"480\":8181,\"481\":8180,\"482\":8179,\"483\":8178,\"484\":8177,\"485\":8176,\"486\":8175,\"487\":8174,\"488\":8173,\"489\":8172,\"490\":8171,\"491\":8170,\"492\":8169,\"493\":8168,\"494\":8167,\"495\":8166,\"496\":8165,\"497\":8164,\"498\":8163,\"499\":8162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":9500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("150", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:09", "2024-03-18 18:16:09", "[{\"id\":18168,\"offset\":10000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("151", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "5bfd488e697ead4c0acafe26a968a648", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "0", "[{\"id\":18168,\"batched_data\":[8161,8160,8159,8158,8157,8156,8155,8154,8153,8152,8151,8150,8149,8148,8147,8146,8145,8144,8143,8142,8141,8140,8139,8138,8137,8136,8135,8134,8133,8132,8131,8130,8129,8128,8127,8126,8125,8124,8123,8122,8121,8120,8119,8118,8117,8116,8115,8114,8113,8112,8111,8110,8109,8108,8107,8106,8105,8104,8103,8102,8101,8100,8099,8098,8097,8096,8095,8094,8093,8092,8091,8090,8089,8088,8087,8086,8085,8084,8083,8082,8081,8080,8079,8078,8077,8076,8075,8074,8073,8072,8071,8070,8069,8068,8067,8066,8065,8064,8063,8062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("152", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "f8ad1d89a001a70fc6068443c9835f04", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "0", "[{\"id\":18168,\"batched_data\":{\"100\":8061,\"101\":8060,\"102\":8059,\"103\":8058,\"104\":8057,\"105\":8056,\"106\":8055,\"107\":8054,\"108\":8053,\"109\":8052,\"110\":8051,\"111\":8050,\"112\":8049,\"113\":8048,\"114\":8047,\"115\":8046,\"116\":8045,\"117\":8044,\"118\":8043,\"119\":8042,\"120\":8041,\"121\":8040,\"122\":8039,\"123\":8038,\"124\":8037,\"125\":8036,\"126\":8035,\"127\":8034,\"128\":8033,\"129\":8032,\"130\":8031,\"131\":8030,\"132\":8029,\"133\":8028,\"134\":8027,\"135\":8026,\"136\":8025,\"137\":8024,\"138\":8023,\"139\":8022,\"140\":8021,\"141\":8020,\"142\":8019,\"143\":8018,\"144\":8017,\"145\":8016,\"146\":8015,\"147\":8014,\"148\":8013,\"149\":8012,\"150\":8011,\"151\":8010,\"152\":8009,\"153\":8008,\"154\":8007,\"155\":8006,\"156\":8005,\"157\":8004,\"158\":8003,\"159\":8002,\"160\":8001,\"161\":8000,\"162\":7999,\"163\":7998,\"164\":7997,\"165\":7996,\"166\":7995,\"167\":7994,\"168\":7993,\"169\":7992,\"170\":7991,\"171\":7990,\"172\":7989,\"173\":7988,\"174\":7987,\"175\":7986,\"176\":7985,\"177\":7984,\"178\":7983,\"179\":7982,\"180\":7981,\"181\":7980,\"182\":7979,\"183\":7978,\"184\":7977,\"185\":7976,\"186\":7975,\"187\":7974,\"188\":7973,\"189\":7972,\"190\":7971,\"191\":7970,\"192\":7969,\"193\":7968,\"194\":7967,\"195\":7966,\"196\":7965,\"197\":7964,\"198\":7963,\"199\":7962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("153", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "ce59e2d89ac84d4dd9460644c1215218", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "0", "[{\"id\":18168,\"batched_data\":{\"200\":7961,\"201\":7960,\"202\":7959,\"203\":7958,\"204\":7957,\"205\":7956,\"206\":7955,\"207\":7954,\"208\":7953,\"209\":7952,\"210\":7951,\"211\":7950,\"212\":7949,\"213\":7948,\"214\":7947,\"215\":7946,\"216\":7945,\"217\":7944,\"218\":7943,\"219\":7942,\"220\":7941,\"221\":7940,\"222\":7939,\"223\":7938,\"224\":7937,\"225\":7936,\"226\":7935,\"227\":7934,\"228\":7933,\"229\":7932,\"230\":7931,\"231\":7930,\"232\":7929,\"233\":7928,\"234\":7927,\"235\":7926,\"236\":7925,\"237\":7924,\"238\":7923,\"239\":7922,\"240\":7921,\"241\":7920,\"242\":7919,\"243\":7918,\"244\":7917,\"245\":7916,\"246\":7915,\"247\":7914,\"248\":7913,\"249\":7912,\"250\":7911,\"251\":7910,\"252\":7909,\"253\":7908,\"254\":7907,\"255\":7906,\"256\":7905,\"257\":7904,\"258\":7903,\"259\":7902,\"260\":7901,\"261\":7900,\"262\":7899,\"263\":7898,\"264\":7897,\"265\":7896,\"266\":7895,\"267\":7894,\"268\":7893,\"269\":7892,\"270\":7891,\"271\":7890,\"272\":7889,\"273\":7888,\"274\":7887,\"275\":7886,\"276\":7885,\"277\":7884,\"278\":7883,\"279\":7882,\"280\":7881,\"281\":7880,\"282\":7879,\"283\":7878,\"284\":7877,\"285\":7876,\"286\":7875,\"287\":7874,\"288\":7873,\"289\":7872,\"290\":7871,\"291\":7870,\"292\":7869,\"293\":7868,\"294\":7867,\"295\":7866,\"296\":7865,\"297\":7864,\"298\":7863,\"299\":7862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("154", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "8c0f56890a0e4d40a2618ce8eed14f02", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "0", "[{\"id\":18168,\"batched_data\":{\"300\":7861,\"301\":7860,\"302\":7859,\"303\":7858,\"304\":7857,\"305\":7856,\"306\":7855,\"307\":7854,\"308\":7853,\"309\":7852,\"310\":7851,\"311\":7850,\"312\":7849,\"313\":7848,\"314\":7847,\"315\":7846,\"316\":7845,\"317\":7844,\"318\":7843,\"319\":7842,\"320\":7841,\"321\":7840,\"322\":7839,\"323\":7838,\"324\":7837,\"325\":7836,\"326\":7835,\"327\":7834,\"328\":7833,\"329\":7832,\"330\":7831,\"331\":7830,\"332\":7829,\"333\":7828,\"334\":7827,\"335\":7826,\"336\":7825,\"337\":7824,\"338\":7823,\"339\":7822,\"340\":7821,\"341\":7820,\"342\":7819,\"343\":7818,\"344\":7817,\"345\":7816,\"346\":7815,\"347\":7814,\"348\":7813,\"349\":7812,\"350\":7811,\"351\":7810,\"352\":7809,\"353\":7808,\"354\":7807,\"355\":7806,\"356\":7805,\"357\":7804,\"358\":7803,\"359\":7802,\"360\":7801,\"361\":7800,\"362\":7799,\"363\":7798,\"364\":7797,\"365\":7796,\"366\":7795,\"367\":7794,\"368\":7793,\"369\":7792,\"370\":7791,\"371\":7790,\"372\":7789,\"373\":7788,\"374\":7787,\"375\":7786,\"376\":7785,\"377\":7784,\"378\":7783,\"379\":7782,\"380\":7781,\"381\":7780,\"382\":7779,\"383\":7778,\"384\":7777,\"385\":7776,\"386\":7775,\"387\":7774,\"388\":7773,\"389\":7772,\"390\":7771,\"391\":7770,\"392\":7769,\"393\":7768,\"394\":7767,\"395\":7766,\"396\":7765,\"397\":7764,\"398\":7763,\"399\":7762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("155", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "49bb1d7e4c347abe3d27ab44116b3846", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "0", "[{\"id\":18168,\"batched_data\":{\"400\":7761,\"401\":7760,\"402\":7759,\"403\":7758,\"404\":7757,\"405\":7756,\"406\":7755,\"407\":7754,\"408\":7753,\"409\":7752,\"410\":7751,\"411\":7750,\"412\":7749,\"413\":7748,\"414\":7747,\"415\":7746,\"416\":7745,\"417\":7744,\"418\":7743,\"419\":7742,\"420\":7741,\"421\":7740,\"422\":7739,\"423\":7738,\"424\":7737,\"425\":7736,\"426\":7735,\"427\":7734,\"428\":7733,\"429\":7732,\"430\":7731,\"431\":7730,\"432\":7729,\"433\":7728,\"434\":7727,\"435\":7726,\"436\":7725,\"437\":7724,\"438\":7723,\"439\":7722,\"440\":7721,\"441\":7720,\"442\":7719,\"443\":7718,\"444\":7717,\"445\":7716,\"446\":7715,\"447\":7714,\"448\":7713,\"449\":7712,\"450\":7711,\"451\":7710,\"452\":7709,\"453\":7708,\"454\":7707,\"455\":7706,\"456\":7705,\"457\":7704,\"458\":7703,\"459\":7702,\"460\":7701,\"461\":7700,\"462\":7699,\"463\":7698,\"464\":7697,\"465\":7696,\"466\":7695,\"467\":7694,\"468\":7693,\"469\":7692,\"470\":7691,\"471\":7690,\"472\":7689,\"473\":7688,\"474\":7687,\"475\":7686,\"476\":7685,\"477\":7684,\"478\":7683,\"479\":7682,\"480\":7681,\"481\":7680,\"482\":7679,\"483\":7678,\"484\":7677,\"485\":7676,\"486\":7675,\"487\":7674,\"488\":7673,\"489\":7672,\"490\":7671,\"491\":7670,\"492\":7669,\"493\":7668,\"494\":7667,\"495\":7666,\"496\":7665,\"497\":7664,\"498\":7663,\"499\":7662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("156", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:11", "2024-03-18 18:16:11", "[{\"id\":18168,\"offset\":10500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("157", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "1b7749de710dfd8fbc8ab26d97a61b09", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "0", "[{\"id\":18168,\"batched_data\":[7661,7660,7659,7658,7657,7656,7655,7654,7653,7652,7651,7650,7649,7648,7647,7646,7645,7644,7643,7642,7641,7640,7639,7638,7637,7636,7635,7634,7633,7632,7631,7630,7629,7628,7627,7626,7625,7624,7623,7622,7621,7620,7619,7618,7617,7616,7615,7614,7613,7612,7611,7610,7609,7608,7607,7606,7605,7604,7603,7602,7601,7600,7599,7598,7597,7596,7595,7594,7593,7592,7591,7590,7589,7588,7587,7586,7585,7584,7583,7582,7581,7580,7579,7578,7577,7576,7575,7574,7573,7572,7571,7570,7569,7568,7567,7566,7565,7564,7563,7562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("158", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "f9eb9832bde76369703887476b52ec78", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "0", "[{\"id\":18168,\"batched_data\":{\"100\":7561,\"101\":7560,\"102\":7559,\"103\":7558,\"104\":7557,\"105\":7556,\"106\":7555,\"107\":7554,\"108\":7553,\"109\":7552,\"110\":7551,\"111\":7550,\"112\":7549,\"113\":7548,\"114\":7547,\"115\":7546,\"116\":7545,\"117\":7544,\"118\":7543,\"119\":7542,\"120\":7541,\"121\":7540,\"122\":7539,\"123\":7538,\"124\":7537,\"125\":7536,\"126\":7535,\"127\":7534,\"128\":7533,\"129\":7532,\"130\":7531,\"131\":7530,\"132\":7529,\"133\":7528,\"134\":7527,\"135\":7526,\"136\":7525,\"137\":7524,\"138\":7523,\"139\":7522,\"140\":7521,\"141\":7520,\"142\":7519,\"143\":7518,\"144\":7517,\"145\":7516,\"146\":7515,\"147\":7514,\"148\":7513,\"149\":7512,\"150\":7511,\"151\":7510,\"152\":7509,\"153\":7508,\"154\":7507,\"155\":7506,\"156\":7505,\"157\":7504,\"158\":7503,\"159\":7502,\"160\":7501,\"161\":7500,\"162\":7499,\"163\":7498,\"164\":7497,\"165\":7496,\"166\":7495,\"167\":7494,\"168\":7493,\"169\":7492,\"170\":7491,\"171\":7490,\"172\":7489,\"173\":7488,\"174\":7487,\"175\":7486,\"176\":7485,\"177\":7484,\"178\":7483,\"179\":7482,\"180\":7481,\"181\":7480,\"182\":7479,\"183\":7478,\"184\":7477,\"185\":7476,\"186\":7475,\"187\":7474,\"188\":7473,\"189\":7472,\"190\":7471,\"191\":7470,\"192\":7469,\"193\":7468,\"194\":7467,\"195\":7466,\"196\":7465,\"197\":7464,\"198\":7463,\"199\":7462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("159", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "8a7254257128bfd2ef91de27a5ec641c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "0", "[{\"id\":18168,\"batched_data\":{\"200\":7461,\"201\":7460,\"202\":7459,\"203\":7458,\"204\":7457,\"205\":7456,\"206\":7455,\"207\":7454,\"208\":7453,\"209\":7452,\"210\":7451,\"211\":7450,\"212\":7449,\"213\":7448,\"214\":7447,\"215\":7446,\"216\":7445,\"217\":7444,\"218\":7443,\"219\":7442,\"220\":7441,\"221\":7440,\"222\":7439,\"223\":7438,\"224\":7437,\"225\":7436,\"226\":7435,\"227\":7434,\"228\":7433,\"229\":7432,\"230\":7431,\"231\":7430,\"232\":7429,\"233\":7428,\"234\":7427,\"235\":7426,\"236\":7425,\"237\":7424,\"238\":7423,\"239\":7422,\"240\":7421,\"241\":7420,\"242\":7419,\"243\":7418,\"244\":7417,\"245\":7416,\"246\":7415,\"247\":7414,\"248\":7413,\"249\":7412,\"250\":7411,\"251\":7410,\"252\":7409,\"253\":7408,\"254\":7407,\"255\":7406,\"256\":7405,\"257\":7404,\"258\":7403,\"259\":7402,\"260\":7401,\"261\":7400,\"262\":7399,\"263\":7398,\"264\":7397,\"265\":7396,\"266\":7395,\"267\":7394,\"268\":7393,\"269\":7392,\"270\":7391,\"271\":7390,\"272\":7389,\"273\":7388,\"274\":7387,\"275\":7386,\"276\":7385,\"277\":7384,\"278\":7383,\"279\":7382,\"280\":7381,\"281\":7380,\"282\":7379,\"283\":7378,\"284\":7377,\"285\":7376,\"286\":7375,\"287\":7374,\"288\":7373,\"289\":7372,\"290\":7371,\"291\":7370,\"292\":7369,\"293\":7368,\"294\":7367,\"295\":7366,\"296\":7365,\"297\":7364,\"298\":7363,\"299\":7362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("160", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "47c942f163e9091daebcea7f223eb86d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:13", "2024-03-18 18:16:13", "0", "[{\"id\":18168,\"batched_data\":{\"300\":7361,\"301\":7360,\"302\":7359,\"303\":7358,\"304\":7357,\"305\":7356,\"306\":7355,\"307\":7354,\"308\":7353,\"309\":7352,\"310\":7351,\"311\":7350,\"312\":7349,\"313\":7348,\"314\":7347,\"315\":7346,\"316\":7345,\"317\":7344,\"318\":7343,\"319\":7342,\"320\":7341,\"321\":7340,\"322\":7339,\"323\":7338,\"324\":7337,\"325\":7336,\"326\":7335,\"327\":7334,\"328\":7333,\"329\":7332,\"330\":7331,\"331\":7330,\"332\":7329,\"333\":7328,\"334\":7327,\"335\":7326,\"336\":7325,\"337\":7324,\"338\":7323,\"339\":7322,\"340\":7321,\"341\":7320,\"342\":7319,\"343\":7318,\"344\":7317,\"345\":7316,\"346\":7315,\"347\":7314,\"348\":7313,\"349\":7312,\"350\":7311,\"351\":7310,\"352\":7309,\"353\":7308,\"354\":7307,\"355\":7306,\"356\":7305,\"357\":7304,\"358\":7303,\"359\":7302,\"360\":7301,\"361\":7300,\"362\":7299,\"363\":7298,\"364\":7297,\"365\":7296,\"366\":7295,\"367\":7294,\"368\":7293,\"369\":7292,\"370\":7291,\"371\":7290,\"372\":7289,\"373\":7288,\"374\":7287,\"375\":7286,\"376\":7285,\"377\":7284,\"378\":7283,\"379\":7282,\"380\":7281,\"381\":7280,\"382\":7279,\"383\":7278,\"384\":7277,\"385\":7276,\"386\":7275,\"387\":7274,\"388\":7273,\"389\":7272,\"390\":7271,\"391\":7270,\"392\":7269,\"393\":7268,\"394\":7267,\"395\":7266,\"396\":7265,\"397\":7264,\"398\":7263,\"399\":7262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("161", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "c997556a1fd1e9ce3d72effa4d55fe87", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:13", "2024-03-18 18:16:13", "0", "[{\"id\":18168,\"batched_data\":{\"400\":7261,\"401\":7260,\"402\":7259,\"403\":7258,\"404\":7257,\"405\":7256,\"406\":7255,\"407\":7254,\"408\":7253,\"409\":7252,\"410\":7251,\"411\":7250,\"412\":7249,\"413\":7248,\"414\":7247,\"415\":7246,\"416\":7245,\"417\":7244,\"418\":7243,\"419\":7242,\"420\":7241,\"421\":7240,\"422\":7239,\"423\":7238,\"424\":7237,\"425\":7236,\"426\":7235,\"427\":7234,\"428\":7233,\"429\":7232,\"430\":7231,\"431\":7230,\"432\":7229,\"433\":7228,\"434\":7227,\"435\":7226,\"436\":7225,\"437\":7224,\"438\":7223,\"439\":7222,\"440\":7221,\"441\":7220,\"442\":7219,\"443\":7218,\"444\":7217,\"445\":7216,\"446\":7215,\"447\":7214,\"448\":7213,\"449\":7212,\"450\":7211,\"451\":7210,\"452\":7209,\"453\":7208,\"454\":7207,\"455\":7206,\"456\":7205,\"457\":7204,\"458\":7203,\"459\":7202,\"460\":7201,\"461\":7200,\"462\":7199,\"463\":7198,\"464\":7197,\"465\":7196,\"466\":7195,\"467\":7194,\"468\":7193,\"469\":7192,\"470\":7191,\"471\":7190,\"472\":7189,\"473\":7188,\"474\":7187,\"475\":7186,\"476\":7185,\"477\":7184,\"478\":7183,\"479\":7182,\"480\":7181,\"481\":7180,\"482\":7179,\"483\":7178,\"484\":7177,\"485\":7176,\"486\":7175,\"487\":7174,\"488\":7173,\"489\":7172,\"490\":7171,\"491\":7170,\"492\":7169,\"493\":7168,\"494\":7167,\"495\":7166,\"496\":7165,\"497\":7164,\"498\":7163,\"499\":7162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":10500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("162", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:12", "2024-03-18 18:16:12", "[{\"id\":18168,\"offset\":11000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:13", "2024-03-18 18:16:13", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("163", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:13", "2024-03-18 18:16:13", "50819746a448ebae19b0ec2177d68919", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:14", "2024-03-18 18:16:14", "0", "[{\"id\":18168,\"batched_data\":[7161,7160,7159,7158,7157,7156,7155,7154,7153,7152,7151,7150,7149,7148,7147,7146,7145,7144,7143,7142,7141,7140,7139,7138,7137,7136,7135,7134,7133,7132,7131,7130,7129,7128,7127,7126,7125,7124,7123,7122,7121,7120,7119,7118,7117,7116,7115,7114,7113,7112,7111,7110,7109,7108,7107,7106,7105,7104,7103,7102,7101,7100,7099,7098,7097,7096,7095,7094,7093,7092,7091,7090,7089,7088,7087,7086,7085,7084,7083,7082,7081,7080,7079,7078,7077,7076,7075,7074,7073,7072,7071,7070,7069,7068,7067,7066,7065,7064,7063,7062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("164", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:13", "2024-03-18 18:16:13", "0a79440cd7f8ef50a93655bb3b539941", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:21", "2024-03-18 18:16:21", "0", "[{\"id\":18168,\"batched_data\":{\"100\":7061,\"101\":7060,\"102\":7059,\"103\":7058,\"104\":7057,\"105\":7056,\"106\":7055,\"107\":7054,\"108\":7053,\"109\":7052,\"110\":7051,\"111\":7050,\"112\":7049,\"113\":7048,\"114\":7047,\"115\":7046,\"116\":7045,\"117\":7044,\"118\":7043,\"119\":7042,\"120\":7041,\"121\":7040,\"122\":7039,\"123\":7038,\"124\":7037,\"125\":7036,\"126\":7035,\"127\":7034,\"128\":7033,\"129\":7032,\"130\":7031,\"131\":7030,\"132\":7029,\"133\":7028,\"134\":7027,\"135\":7026,\"136\":7025,\"137\":7024,\"138\":7023,\"139\":7022,\"140\":7021,\"141\":7020,\"142\":7019,\"143\":7018,\"144\":7017,\"145\":7016,\"146\":7015,\"147\":7014,\"148\":7013,\"149\":7012,\"150\":7011,\"151\":7010,\"152\":7009,\"153\":7008,\"154\":7007,\"155\":7006,\"156\":7005,\"157\":7004,\"158\":7003,\"159\":7002,\"160\":7001,\"161\":7000,\"162\":6999,\"163\":6998,\"164\":6997,\"165\":6996,\"166\":6995,\"167\":6994,\"168\":6993,\"169\":6992,\"170\":6991,\"171\":6990,\"172\":6989,\"173\":6988,\"174\":6987,\"175\":6986,\"176\":6985,\"177\":6984,\"178\":6983,\"179\":6982,\"180\":6981,\"181\":6980,\"182\":6979,\"183\":6978,\"184\":6977,\"185\":6976,\"186\":6975,\"187\":6974,\"188\":6973,\"189\":6972,\"190\":6971,\"191\":6970,\"192\":6969,\"193\":6968,\"194\":6967,\"195\":6966,\"196\":6965,\"197\":6964,\"198\":6963,\"199\":6962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("165", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:13", "2024-03-18 18:16:13", "0cb3e00eb93a30837eff9d7c2a26b92e", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:21", "2024-03-18 18:16:21", "0", "[{\"id\":18168,\"batched_data\":{\"200\":6961,\"201\":6960,\"202\":6959,\"203\":6958,\"204\":6957,\"205\":6956,\"206\":6955,\"207\":6954,\"208\":6953,\"209\":6952,\"210\":6951,\"211\":6950,\"212\":6949,\"213\":6948,\"214\":6947,\"215\":6946,\"216\":6945,\"217\":6944,\"218\":6943,\"219\":6942,\"220\":6941,\"221\":6940,\"222\":6939,\"223\":6938,\"224\":6937,\"225\":6936,\"226\":6935,\"227\":6934,\"228\":6933,\"229\":6932,\"230\":6931,\"231\":6930,\"232\":6929,\"233\":6928,\"234\":6927,\"235\":6926,\"236\":6925,\"237\":6924,\"238\":6923,\"239\":6922,\"240\":6921,\"241\":6920,\"242\":6919,\"243\":6918,\"244\":6917,\"245\":6916,\"246\":6915,\"247\":6914,\"248\":6913,\"249\":6912,\"250\":6911,\"251\":6910,\"252\":6909,\"253\":6908,\"254\":6907,\"255\":6906,\"256\":6905,\"257\":6904,\"258\":6903,\"259\":6902,\"260\":6901,\"261\":6900,\"262\":6899,\"263\":6898,\"264\":6897,\"265\":6896,\"266\":6895,\"267\":6894,\"268\":6893,\"269\":6892,\"270\":6891,\"271\":6890,\"272\":6889,\"273\":6888,\"274\":6887,\"275\":6886,\"276\":6885,\"277\":6884,\"278\":6883,\"279\":6882,\"280\":6881,\"281\":6880,\"282\":6879,\"283\":6878,\"284\":6877,\"285\":6876,\"286\":6875,\"287\":6874,\"288\":6873,\"289\":6872,\"290\":6871,\"291\":6870,\"292\":6869,\"293\":6868,\"294\":6867,\"295\":6866,\"296\":6865,\"297\":6864,\"298\":6863,\"299\":6862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("166", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:13", "2024-03-18 18:16:13", "29bc9ed03b84192f3920b39adb2fc96c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "0", "[{\"id\":18168,\"batched_data\":{\"300\":6861,\"301\":6860,\"302\":6859,\"303\":6858,\"304\":6857,\"305\":6856,\"306\":6855,\"307\":6854,\"308\":6853,\"309\":6852,\"310\":6851,\"311\":6850,\"312\":6849,\"313\":6848,\"314\":6847,\"315\":6846,\"316\":6845,\"317\":6844,\"318\":6843,\"319\":6842,\"320\":6841,\"321\":6840,\"322\":6839,\"323\":6838,\"324\":6837,\"325\":6836,\"326\":6835,\"327\":6834,\"328\":6833,\"329\":6832,\"330\":6831,\"331\":6830,\"332\":6829,\"333\":6828,\"334\":6827,\"335\":6826,\"336\":6825,\"337\":6824,\"338\":6823,\"339\":6822,\"340\":6821,\"341\":6820,\"342\":6819,\"343\":6818,\"344\":6817,\"345\":6816,\"346\":6815,\"347\":6814,\"348\":6813,\"349\":6812,\"350\":6811,\"351\":6810,\"352\":6809,\"353\":6808,\"354\":6807,\"355\":6806,\"356\":6805,\"357\":6804,\"358\":6803,\"359\":6802,\"360\":6801,\"361\":6800,\"362\":6799,\"363\":6798,\"364\":6797,\"365\":6796,\"366\":6795,\"367\":6794,\"368\":6793,\"369\":6792,\"370\":6791,\"371\":6790,\"372\":6789,\"373\":6788,\"374\":6787,\"375\":6786,\"376\":6785,\"377\":6784,\"378\":6783,\"379\":6782,\"380\":6781,\"381\":6780,\"382\":6779,\"383\":6778,\"384\":6777,\"385\":6776,\"386\":6775,\"387\":6774,\"388\":6773,\"389\":6772,\"390\":6771,\"391\":6770,\"392\":6769,\"393\":6768,\"394\":6767,\"395\":6766,\"396\":6765,\"397\":6764,\"398\":6763,\"399\":6762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("167", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:13", "2024-03-18 18:16:13", "cb8845dd1718b66660c77566314a7df9", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "0", "[{\"id\":18168,\"batched_data\":{\"400\":6761,\"401\":6760,\"402\":6759,\"403\":6758,\"404\":6757,\"405\":6756,\"406\":6755,\"407\":6754,\"408\":6753,\"409\":6752,\"410\":6751,\"411\":6750,\"412\":6749,\"413\":6748,\"414\":6747,\"415\":6746,\"416\":6745,\"417\":6744,\"418\":6743,\"419\":6742,\"420\":6741,\"421\":6740,\"422\":6739,\"423\":6738,\"424\":6737,\"425\":6736,\"426\":6735,\"427\":6734,\"428\":6733,\"429\":6732,\"430\":6731,\"431\":6730,\"432\":6729,\"433\":6728,\"434\":6727,\"435\":6726,\"436\":6725,\"437\":6724,\"438\":6723,\"439\":6722,\"440\":6721,\"441\":6720,\"442\":6719,\"443\":6718,\"444\":6717,\"445\":6716,\"446\":6715,\"447\":6714,\"448\":6713,\"449\":6712,\"450\":6711,\"451\":6710,\"452\":6709,\"453\":6708,\"454\":6707,\"455\":6706,\"456\":6705,\"457\":6704,\"458\":6703,\"459\":6702,\"460\":6701,\"461\":6700,\"462\":6699,\"463\":6698,\"464\":6697,\"465\":6696,\"466\":6695,\"467\":6694,\"468\":6693,\"469\":6692,\"470\":6691,\"471\":6690,\"472\":6689,\"473\":6688,\"474\":6687,\"475\":6686,\"476\":6685,\"477\":6684,\"478\":6683,\"479\":6682,\"480\":6681,\"481\":6680,\"482\":6679,\"483\":6678,\"484\":6677,\"485\":6676,\"486\":6675,\"487\":6674,\"488\":6673,\"489\":6672,\"490\":6671,\"491\":6670,\"492\":6669,\"493\":6668,\"494\":6667,\"495\":6666,\"496\":6665,\"497\":6664,\"498\":6663,\"499\":6662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("168", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:13", "2024-03-18 18:16:13", "[{\"id\":18168,\"offset\":11500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("169", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "ca61ef287377e5ed16acb260878cd787", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "0", "[{\"id\":18168,\"batched_data\":[6661,6660,6659,6658,6657,6656,6655,6654,6653,6652,6651,6650,6649,6648,6647,6646,6645,6644,6643,6642,6641,6640,6639,6638,6637,6636,6635,6634,6633,6632,6631,6630,6629,6628,6627,6626,6625,6624,6623,6622,6621,6620,6619,6618,6617,6616,6615,6614,6613,6612,6611,6610,6609,6608,6607,6606,6605,6604,6603,6602,6601,6600,6599,6598,6597,6596,6595,6594,6593,6592,6591,6590,6589,6588,6587,6586,6585,6584,6583,6582,6581,6580,6579,6578,6577,6576,6575,6574,6573,6572,6571,6570,6569,6568,6567,6566,6565,6564,6563,6562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("170", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "dc8072f252c642ffc4da965df1d94f36", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "0", "[{\"id\":18168,\"batched_data\":{\"100\":6561,\"101\":6560,\"102\":6559,\"103\":6558,\"104\":6557,\"105\":6556,\"106\":6555,\"107\":6554,\"108\":6553,\"109\":6552,\"110\":6551,\"111\":6550,\"112\":6549,\"113\":6548,\"114\":6547,\"115\":6546,\"116\":6545,\"117\":6544,\"118\":6543,\"119\":6542,\"120\":6541,\"121\":6540,\"122\":6539,\"123\":6538,\"124\":6537,\"125\":6536,\"126\":6535,\"127\":6534,\"128\":6533,\"129\":6532,\"130\":6531,\"131\":6530,\"132\":6529,\"133\":6528,\"134\":6527,\"135\":6526,\"136\":6525,\"137\":6524,\"138\":6523,\"139\":6522,\"140\":6521,\"141\":6520,\"142\":6519,\"143\":6518,\"144\":6517,\"145\":6516,\"146\":6515,\"147\":6514,\"148\":6513,\"149\":6512,\"150\":6511,\"151\":6510,\"152\":6509,\"153\":6508,\"154\":6507,\"155\":6506,\"156\":6505,\"157\":6504,\"158\":6503,\"159\":6502,\"160\":6501,\"161\":6500,\"162\":6499,\"163\":6498,\"164\":6497,\"165\":6496,\"166\":6495,\"167\":6494,\"168\":6493,\"169\":6492,\"170\":6491,\"171\":6490,\"172\":6489,\"173\":6488,\"174\":6487,\"175\":6486,\"176\":6485,\"177\":6484,\"178\":6483,\"179\":6482,\"180\":6481,\"181\":6480,\"182\":6479,\"183\":6478,\"184\":6477,\"185\":6476,\"186\":6475,\"187\":6474,\"188\":6473,\"189\":6472,\"190\":6471,\"191\":6470,\"192\":6469,\"193\":6468,\"194\":6467,\"195\":6466,\"196\":6465,\"197\":6464,\"198\":6463,\"199\":6462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("171", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "c9035122ee0dab0be72579df24080ca9", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "0", "[{\"id\":18168,\"batched_data\":{\"200\":6461,\"201\":6460,\"202\":6459,\"203\":6458,\"204\":6457,\"205\":6456,\"206\":6455,\"207\":6454,\"208\":6453,\"209\":6452,\"210\":6451,\"211\":6450,\"212\":6449,\"213\":6448,\"214\":6447,\"215\":6446,\"216\":6445,\"217\":6444,\"218\":6443,\"219\":6442,\"220\":6441,\"221\":6440,\"222\":6439,\"223\":6438,\"224\":6437,\"225\":6436,\"226\":6435,\"227\":6434,\"228\":6433,\"229\":6432,\"230\":6431,\"231\":6430,\"232\":6429,\"233\":6428,\"234\":6427,\"235\":6426,\"236\":6425,\"237\":6424,\"238\":6423,\"239\":6422,\"240\":6421,\"241\":6420,\"242\":6419,\"243\":6418,\"244\":6417,\"245\":6416,\"246\":6415,\"247\":6414,\"248\":6413,\"249\":6412,\"250\":6411,\"251\":6410,\"252\":6409,\"253\":6408,\"254\":6407,\"255\":6406,\"256\":6405,\"257\":6404,\"258\":6403,\"259\":6402,\"260\":6401,\"261\":6400,\"262\":6399,\"263\":6398,\"264\":6397,\"265\":6396,\"266\":6395,\"267\":6394,\"268\":6393,\"269\":6392,\"270\":6391,\"271\":6390,\"272\":6389,\"273\":6388,\"274\":6387,\"275\":6386,\"276\":6385,\"277\":6384,\"278\":6383,\"279\":6382,\"280\":6381,\"281\":6380,\"282\":6379,\"283\":6378,\"284\":6377,\"285\":6376,\"286\":6375,\"287\":6374,\"288\":6373,\"289\":6372,\"290\":6371,\"291\":6370,\"292\":6369,\"293\":6368,\"294\":6367,\"295\":6366,\"296\":6365,\"297\":6364,\"298\":6363,\"299\":6362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("172", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "7865643c18313c0169eee1bb03f01ecc", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "0", "[{\"id\":18168,\"batched_data\":{\"300\":6361,\"301\":6360,\"302\":6359,\"303\":6358,\"304\":6357,\"305\":6356,\"306\":6355,\"307\":6354,\"308\":6353,\"309\":6352,\"310\":6351,\"311\":6350,\"312\":6349,\"313\":6348,\"314\":6347,\"315\":6346,\"316\":6345,\"317\":6344,\"318\":6343,\"319\":6342,\"320\":6341,\"321\":6340,\"322\":6339,\"323\":6338,\"324\":6337,\"325\":6336,\"326\":6335,\"327\":6334,\"328\":6333,\"329\":6332,\"330\":6331,\"331\":6330,\"332\":6329,\"333\":6328,\"334\":6327,\"335\":6326,\"336\":6325,\"337\":6324,\"338\":6323,\"339\":6322,\"340\":6321,\"341\":6320,\"342\":6319,\"343\":6318,\"344\":6317,\"345\":6316,\"346\":6315,\"347\":6314,\"348\":6313,\"349\":6312,\"350\":6311,\"351\":6310,\"352\":6309,\"353\":6308,\"354\":6307,\"355\":6306,\"356\":6305,\"357\":6304,\"358\":6303,\"359\":6302,\"360\":6301,\"361\":6300,\"362\":6299,\"363\":6298,\"364\":6297,\"365\":6296,\"366\":6295,\"367\":6294,\"368\":6293,\"369\":6292,\"370\":6291,\"371\":6290,\"372\":6289,\"373\":6288,\"374\":6287,\"375\":6286,\"376\":6285,\"377\":6284,\"378\":6283,\"379\":6282,\"380\":6281,\"381\":6280,\"382\":6279,\"383\":6278,\"384\":6277,\"385\":6276,\"386\":6275,\"387\":6274,\"388\":6273,\"389\":6272,\"390\":6271,\"391\":6270,\"392\":6269,\"393\":6268,\"394\":6267,\"395\":6266,\"396\":6265,\"397\":6264,\"398\":6263,\"399\":6262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("173", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "c9e27925fa1132533b22f1194ff46815", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "0", "[{\"id\":18168,\"batched_data\":{\"400\":6261,\"401\":6260,\"402\":6259,\"403\":6258,\"404\":6257,\"405\":6256,\"406\":6255,\"407\":6254,\"408\":6253,\"409\":6252,\"410\":6251,\"411\":6250,\"412\":6249,\"413\":6248,\"414\":6247,\"415\":6246,\"416\":6245,\"417\":6244,\"418\":6243,\"419\":6242,\"420\":6241,\"421\":6240,\"422\":6239,\"423\":6238,\"424\":6237,\"425\":6236,\"426\":6235,\"427\":6234,\"428\":6233,\"429\":6232,\"430\":6231,\"431\":6230,\"432\":6229,\"433\":6228,\"434\":6227,\"435\":6226,\"436\":6225,\"437\":6224,\"438\":6223,\"439\":6222,\"440\":6221,\"441\":6220,\"442\":6219,\"443\":6218,\"444\":6217,\"445\":6216,\"446\":6215,\"447\":6214,\"448\":6213,\"449\":6212,\"450\":6211,\"451\":6210,\"452\":6209,\"453\":6208,\"454\":6207,\"455\":6206,\"456\":6205,\"457\":6204,\"458\":6203,\"459\":6202,\"460\":6201,\"461\":6200,\"462\":6199,\"463\":6198,\"464\":6197,\"465\":6196,\"466\":6195,\"467\":6194,\"468\":6193,\"469\":6192,\"470\":6191,\"471\":6190,\"472\":6189,\"473\":6188,\"474\":6187,\"475\":6186,\"476\":6185,\"477\":6184,\"478\":6183,\"479\":6182,\"480\":6181,\"481\":6180,\"482\":6179,\"483\":6178,\"484\":6177,\"485\":6176,\"486\":6175,\"487\":6174,\"488\":6173,\"489\":6172,\"490\":6171,\"491\":6170,\"492\":6169,\"493\":6168,\"494\":6167,\"495\":6166,\"496\":6165,\"497\":6164,\"498\":6163,\"499\":6162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":11500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("174", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:22", "2024-03-18 18:16:22", "[{\"id\":18168,\"offset\":12000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("175", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "b6af322a4f037dc41e5f5d9f21120d5d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "0", "[{\"id\":18168,\"batched_data\":[6161,6160,6159,6158,6157,6156,6155,6154,6153,6152,6151,6150,6149,6148,6147,6146,6145,6144,6143,6142,6141,6140,6139,6138,6137,6136,6135,6134,6133,6132,6131,6130,6129,6128,6127,6126,6125,6124,6123,6122,6121,6120,6119,6118,6117,6116,6115,6114,6113,6112,6111,6110,6109,6108,6107,6106,6105,6104,6103,6102,6101,6100,6099,6098,6097,6096,6095,6094,6093,6092,6091,6090,6089,6088,6087,6086,6085,6084,6083,6082,6081,6080,6079,6078,6077,6076,6075,6074,6073,6072,6071,6070,6069,6068,6067,6066,6065,6064,6063,6062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("176", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "302873b2742a2f2c6e0678e1a2dc7883", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:24", "2024-03-18 18:16:24", "0", "[{\"id\":18168,\"batched_data\":{\"100\":6061,\"101\":6060,\"102\":6059,\"103\":6058,\"104\":6057,\"105\":6056,\"106\":6055,\"107\":6054,\"108\":6053,\"109\":6052,\"110\":6051,\"111\":6050,\"112\":6049,\"113\":6048,\"114\":6047,\"115\":6046,\"116\":6045,\"117\":6044,\"118\":6043,\"119\":6042,\"120\":6041,\"121\":6040,\"122\":6039,\"123\":6038,\"124\":6037,\"125\":6036,\"126\":6035,\"127\":6034,\"128\":6033,\"129\":6032,\"130\":6031,\"131\":6030,\"132\":6029,\"133\":6028,\"134\":6027,\"135\":6026,\"136\":6025,\"137\":6024,\"138\":6023,\"139\":6022,\"140\":6021,\"141\":6020,\"142\":6019,\"143\":6018,\"144\":6017,\"145\":6016,\"146\":6015,\"147\":6014,\"148\":6013,\"149\":6012,\"150\":6011,\"151\":6010,\"152\":6009,\"153\":6008,\"154\":6007,\"155\":6006,\"156\":6005,\"157\":6004,\"158\":6003,\"159\":6002,\"160\":6001,\"161\":6000,\"162\":5999,\"163\":5998,\"164\":5997,\"165\":5996,\"166\":5995,\"167\":5994,\"168\":5993,\"169\":5992,\"170\":5991,\"171\":5990,\"172\":5989,\"173\":5988,\"174\":5987,\"175\":5986,\"176\":5985,\"177\":5984,\"178\":5983,\"179\":5982,\"180\":5981,\"181\":5980,\"182\":5979,\"183\":5978,\"184\":5977,\"185\":5976,\"186\":5975,\"187\":5974,\"188\":5973,\"189\":5972,\"190\":5971,\"191\":5970,\"192\":5969,\"193\":5968,\"194\":5967,\"195\":5966,\"196\":5965,\"197\":5964,\"198\":5963,\"199\":5962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("177", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "3ee25b7803a6c180f4cb4e45cf63057c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:24", "2024-03-18 18:16:24", "0", "[{\"id\":18168,\"batched_data\":{\"200\":5961,\"201\":5960,\"202\":5959,\"203\":5958,\"204\":5957,\"205\":5956,\"206\":5955,\"207\":5954,\"208\":5953,\"209\":5952,\"210\":5951,\"211\":5950,\"212\":5949,\"213\":5948,\"214\":5947,\"215\":5946,\"216\":5945,\"217\":5944,\"218\":5943,\"219\":5942,\"220\":5941,\"221\":5940,\"222\":5939,\"223\":5938,\"224\":5937,\"225\":5936,\"226\":5935,\"227\":5934,\"228\":5933,\"229\":5932,\"230\":5931,\"231\":5930,\"232\":5929,\"233\":5928,\"234\":5927,\"235\":5926,\"236\":5925,\"237\":5924,\"238\":5923,\"239\":5922,\"240\":5921,\"241\":5920,\"242\":5919,\"243\":5918,\"244\":5917,\"245\":5916,\"246\":5915,\"247\":5914,\"248\":5913,\"249\":5912,\"250\":5911,\"251\":5910,\"252\":5909,\"253\":5908,\"254\":5907,\"255\":5906,\"256\":5905,\"257\":5904,\"258\":5903,\"259\":5902,\"260\":5901,\"261\":5900,\"262\":5899,\"263\":5898,\"264\":5897,\"265\":5896,\"266\":5895,\"267\":5894,\"268\":5893,\"269\":5892,\"270\":5891,\"271\":5890,\"272\":5889,\"273\":5888,\"274\":5887,\"275\":5886,\"276\":5885,\"277\":5884,\"278\":5883,\"279\":5882,\"280\":5881,\"281\":5880,\"282\":5879,\"283\":5878,\"284\":5877,\"285\":5876,\"286\":5875,\"287\":5874,\"288\":5873,\"289\":5872,\"290\":5871,\"291\":5870,\"292\":5869,\"293\":5868,\"294\":5867,\"295\":5866,\"296\":5865,\"297\":5864,\"298\":5863,\"299\":5862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("178", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "0da7abf6c02fdbb9247c2dbecacc0ea9", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:24", "2024-03-18 18:16:24", "0", "[{\"id\":18168,\"batched_data\":{\"300\":5861,\"301\":5860,\"302\":5859,\"303\":5858,\"304\":5857,\"305\":5856,\"306\":5855,\"307\":5854,\"308\":5853,\"309\":5852,\"310\":5851,\"311\":5850,\"312\":5849,\"313\":5848,\"314\":5847,\"315\":5846,\"316\":5845,\"317\":5844,\"318\":5843,\"319\":5842,\"320\":5841,\"321\":5840,\"322\":5839,\"323\":5838,\"324\":5837,\"325\":5836,\"326\":5835,\"327\":5834,\"328\":5833,\"329\":5832,\"330\":5831,\"331\":5830,\"332\":5829,\"333\":5828,\"334\":5827,\"335\":5826,\"336\":5825,\"337\":5824,\"338\":5823,\"339\":5822,\"340\":5821,\"341\":5820,\"342\":5819,\"343\":5818,\"344\":5817,\"345\":5816,\"346\":5815,\"347\":5814,\"348\":5813,\"349\":5812,\"350\":5811,\"351\":5810,\"352\":5809,\"353\":5808,\"354\":5807,\"355\":5806,\"356\":5805,\"357\":5804,\"358\":5803,\"359\":5802,\"360\":5801,\"361\":5800,\"362\":5799,\"363\":5798,\"364\":5797,\"365\":5796,\"366\":5795,\"367\":5794,\"368\":5793,\"369\":5792,\"370\":5791,\"371\":5790,\"372\":5789,\"373\":5788,\"374\":5787,\"375\":5786,\"376\":5785,\"377\":5784,\"378\":5783,\"379\":5782,\"380\":5781,\"381\":5780,\"382\":5779,\"383\":5778,\"384\":5777,\"385\":5776,\"386\":5775,\"387\":5774,\"388\":5773,\"389\":5772,\"390\":5771,\"391\":5770,\"392\":5769,\"393\":5768,\"394\":5767,\"395\":5766,\"396\":5765,\"397\":5764,\"398\":5763,\"399\":5762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("179", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "6eb438991b9e2e4384a5e78ea3514960", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "0", "[{\"id\":18168,\"batched_data\":{\"400\":5761,\"401\":5760,\"402\":5759,\"403\":5758,\"404\":5757,\"405\":5756,\"406\":5755,\"407\":5754,\"408\":5753,\"409\":5752,\"410\":5751,\"411\":5750,\"412\":5749,\"413\":5748,\"414\":5747,\"415\":5746,\"416\":5745,\"417\":5744,\"418\":5743,\"419\":5742,\"420\":5741,\"421\":5740,\"422\":5739,\"423\":5738,\"424\":5737,\"425\":5736,\"426\":5735,\"427\":5734,\"428\":5733,\"429\":5732,\"430\":5731,\"431\":5730,\"432\":5729,\"433\":5728,\"434\":5727,\"435\":5726,\"436\":5725,\"437\":5724,\"438\":5723,\"439\":5722,\"440\":5721,\"441\":5720,\"442\":5719,\"443\":5718,\"444\":5717,\"445\":5716,\"446\":5715,\"447\":5714,\"448\":5713,\"449\":5712,\"450\":5711,\"451\":5710,\"452\":5709,\"453\":5708,\"454\":5707,\"455\":5706,\"456\":5705,\"457\":5704,\"458\":5703,\"459\":5702,\"460\":5701,\"461\":5700,\"462\":5699,\"463\":5698,\"464\":5697,\"465\":5696,\"466\":5695,\"467\":5694,\"468\":5693,\"469\":5692,\"470\":5691,\"471\":5690,\"472\":5689,\"473\":5688,\"474\":5687,\"475\":5686,\"476\":5685,\"477\":5684,\"478\":5683,\"479\":5682,\"480\":5681,\"481\":5680,\"482\":5679,\"483\":5678,\"484\":5677,\"485\":5676,\"486\":5675,\"487\":5674,\"488\":5673,\"489\":5672,\"490\":5671,\"491\":5670,\"492\":5669,\"493\":5668,\"494\":5667,\"495\":5666,\"496\":5665,\"497\":5664,\"498\":5663,\"499\":5662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("180", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:23", "2024-03-18 18:16:23", "[{\"id\":18168,\"offset\":12500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("181", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "3ea5f1e813e31c3895537600d0d22bf8", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "0", "[{\"id\":18168,\"batched_data\":[5661,5660,5659,5658,5657,5656,5655,5654,5653,5652,5651,5650,5649,5648,5647,5646,5645,5644,5643,5642,5641,5640,5639,5638,5637,5636,5635,5634,5633,5632,5631,5630,5629,5628,5627,5626,5625,5624,5623,5622,5621,5620,5619,5618,5617,5616,5615,5614,5613,5612,5611,5610,5609,5608,5607,5606,5605,5604,5603,5602,5601,5600,5599,5598,5597,5596,5595,5594,5593,5592,5591,5590,5589,5588,5587,5586,5585,5584,5583,5582,5581,5580,5579,5578,5577,5576,5575,5574,5573,5572,5571,5570,5569,5568,5567,5566,5565,5564,5563,5562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("182", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "9e5d367f0533d1ea00bce832b778e747", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "0", "[{\"id\":18168,\"batched_data\":{\"100\":5561,\"101\":5560,\"102\":5559,\"103\":5558,\"104\":5557,\"105\":5556,\"106\":5555,\"107\":5554,\"108\":5553,\"109\":5552,\"110\":5551,\"111\":5550,\"112\":5549,\"113\":5548,\"114\":5547,\"115\":5546,\"116\":5545,\"117\":5544,\"118\":5543,\"119\":5542,\"120\":5541,\"121\":5540,\"122\":5539,\"123\":5538,\"124\":5537,\"125\":5536,\"126\":5535,\"127\":5534,\"128\":5533,\"129\":5532,\"130\":5531,\"131\":5530,\"132\":5529,\"133\":5528,\"134\":5527,\"135\":5526,\"136\":5525,\"137\":5524,\"138\":5523,\"139\":5522,\"140\":5521,\"141\":5520,\"142\":5519,\"143\":5518,\"144\":5517,\"145\":5516,\"146\":5515,\"147\":5514,\"148\":5513,\"149\":5512,\"150\":5511,\"151\":5510,\"152\":5509,\"153\":5508,\"154\":5507,\"155\":5506,\"156\":5505,\"157\":5504,\"158\":5503,\"159\":5502,\"160\":5501,\"161\":5500,\"162\":5499,\"163\":5498,\"164\":5497,\"165\":5496,\"166\":5495,\"167\":5494,\"168\":5493,\"169\":5492,\"170\":5491,\"171\":5490,\"172\":5489,\"173\":5488,\"174\":5487,\"175\":5486,\"176\":5485,\"177\":5484,\"178\":5483,\"179\":5482,\"180\":5481,\"181\":5480,\"182\":5479,\"183\":5478,\"184\":5477,\"185\":5476,\"186\":5475,\"187\":5474,\"188\":5473,\"189\":5472,\"190\":5471,\"191\":5470,\"192\":5469,\"193\":5468,\"194\":5467,\"195\":5466,\"196\":5465,\"197\":5464,\"198\":5463,\"199\":5462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("183", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "68fce1ca8e4eab123e7a18260fe79eb4", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "0", "[{\"id\":18168,\"batched_data\":{\"200\":5461,\"201\":5460,\"202\":5459,\"203\":5458,\"204\":5457,\"205\":5456,\"206\":5455,\"207\":5454,\"208\":5453,\"209\":5452,\"210\":5451,\"211\":5450,\"212\":5449,\"213\":5448,\"214\":5447,\"215\":5446,\"216\":5445,\"217\":5444,\"218\":5443,\"219\":5442,\"220\":5441,\"221\":5440,\"222\":5439,\"223\":5438,\"224\":5437,\"225\":5436,\"226\":5435,\"227\":5434,\"228\":5433,\"229\":5432,\"230\":5431,\"231\":5430,\"232\":5429,\"233\":5428,\"234\":5427,\"235\":5426,\"236\":5425,\"237\":5424,\"238\":5423,\"239\":5422,\"240\":5421,\"241\":5420,\"242\":5419,\"243\":5418,\"244\":5417,\"245\":5416,\"246\":5415,\"247\":5414,\"248\":5413,\"249\":5412,\"250\":5411,\"251\":5410,\"252\":5409,\"253\":5408,\"254\":5407,\"255\":5406,\"256\":5405,\"257\":5404,\"258\":5403,\"259\":5402,\"260\":5401,\"261\":5400,\"262\":5399,\"263\":5398,\"264\":5397,\"265\":5396,\"266\":5395,\"267\":5394,\"268\":5393,\"269\":5392,\"270\":5391,\"271\":5390,\"272\":5389,\"273\":5388,\"274\":5387,\"275\":5386,\"276\":5385,\"277\":5384,\"278\":5383,\"279\":5382,\"280\":5381,\"281\":5380,\"282\":5379,\"283\":5378,\"284\":5377,\"285\":5376,\"286\":5375,\"287\":5374,\"288\":5373,\"289\":5372,\"290\":5371,\"291\":5370,\"292\":5369,\"293\":5368,\"294\":5367,\"295\":5366,\"296\":5365,\"297\":5364,\"298\":5363,\"299\":5362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("184", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "d752f1dad9ca3e9e519b052b31414844", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "0", "[{\"id\":18168,\"batched_data\":{\"300\":5361,\"301\":5360,\"302\":5359,\"303\":5358,\"304\":5357,\"305\":5356,\"306\":5355,\"307\":5354,\"308\":5353,\"309\":5352,\"310\":5351,\"311\":5350,\"312\":5349,\"313\":5348,\"314\":5347,\"315\":5346,\"316\":5345,\"317\":5344,\"318\":5343,\"319\":5342,\"320\":5341,\"321\":5340,\"322\":5339,\"323\":5338,\"324\":5337,\"325\":5336,\"326\":5335,\"327\":5334,\"328\":5333,\"329\":5332,\"330\":5331,\"331\":5330,\"332\":5329,\"333\":5328,\"334\":5327,\"335\":5326,\"336\":5325,\"337\":5324,\"338\":5323,\"339\":5322,\"340\":5321,\"341\":5320,\"342\":5319,\"343\":5318,\"344\":5317,\"345\":5316,\"346\":5315,\"347\":5314,\"348\":5313,\"349\":5312,\"350\":5311,\"351\":5310,\"352\":5309,\"353\":5308,\"354\":5307,\"355\":5306,\"356\":5305,\"357\":5304,\"358\":5303,\"359\":5302,\"360\":5301,\"361\":5300,\"362\":5299,\"363\":5298,\"364\":5297,\"365\":5296,\"366\":5295,\"367\":5294,\"368\":5293,\"369\":5292,\"370\":5291,\"371\":5290,\"372\":5289,\"373\":5288,\"374\":5287,\"375\":5286,\"376\":5285,\"377\":5284,\"378\":5283,\"379\":5282,\"380\":5281,\"381\":5280,\"382\":5279,\"383\":5278,\"384\":5277,\"385\":5276,\"386\":5275,\"387\":5274,\"388\":5273,\"389\":5272,\"390\":5271,\"391\":5270,\"392\":5269,\"393\":5268,\"394\":5267,\"395\":5266,\"396\":5265,\"397\":5264,\"398\":5263,\"399\":5262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("185", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "d7fb7bc86b8cb4bdfb1cfd5c83eeda87", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "0", "[{\"id\":18168,\"batched_data\":{\"400\":5261,\"401\":5260,\"402\":5259,\"403\":5258,\"404\":5257,\"405\":5256,\"406\":5255,\"407\":5254,\"408\":5253,\"409\":5252,\"410\":5251,\"411\":5250,\"412\":5249,\"413\":5248,\"414\":5247,\"415\":5246,\"416\":5245,\"417\":5244,\"418\":5243,\"419\":5242,\"420\":5241,\"421\":5240,\"422\":5239,\"423\":5238,\"424\":5237,\"425\":5236,\"426\":5235,\"427\":5234,\"428\":5233,\"429\":5232,\"430\":5231,\"431\":5230,\"432\":5229,\"433\":5228,\"434\":5227,\"435\":5226,\"436\":5225,\"437\":5224,\"438\":5223,\"439\":5222,\"440\":5221,\"441\":5220,\"442\":5219,\"443\":5218,\"444\":5217,\"445\":5216,\"446\":5215,\"447\":5214,\"448\":5213,\"449\":5212,\"450\":5211,\"451\":5210,\"452\":5209,\"453\":5208,\"454\":5207,\"455\":5206,\"456\":5205,\"457\":5204,\"458\":5203,\"459\":5202,\"460\":5201,\"461\":5200,\"462\":5199,\"463\":5198,\"464\":5197,\"465\":5196,\"466\":5195,\"467\":5194,\"468\":5193,\"469\":5192,\"470\":5191,\"471\":5190,\"472\":5189,\"473\":5188,\"474\":5187,\"475\":5186,\"476\":5185,\"477\":5184,\"478\":5183,\"479\":5182,\"480\":5181,\"481\":5180,\"482\":5179,\"483\":5178,\"484\":5177,\"485\":5176,\"486\":5175,\"487\":5174,\"488\":5173,\"489\":5172,\"490\":5171,\"491\":5170,\"492\":5169,\"493\":5168,\"494\":5167,\"495\":5166,\"496\":5165,\"497\":5164,\"498\":5163,\"499\":5162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":12500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("186", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:25", "2024-03-18 18:16:25", "[{\"id\":18168,\"offset\":13000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("187", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "ada6c303c828e50bd29bbc36cf8df28c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "0", "[{\"id\":18168,\"batched_data\":[5161,5160,5159,5158,5157,5156,5155,5154,5153,5152,5151,5150,5149,5148,5147,5146,5145,5144,5143,5142,5141,5140,5139,5138,5137,5136,5135,5134,5133,5132,5131,5130,5129,5128,5127,5126,5125,5124,5123,5122,5121,5120,5119,5118,5117,5116,5115,5114,5113,5112,5111,5110,5109,5108,5107,5106,5105,5104,5103,5102,5101,5100,5099,5098,5097,5096,5095,5094,5093,5092,5091,5090,5089,5088,5087,5086,5085,5084,5083,5082,5081,5080,5079,5078,5077,5076,5075,5074,5073,5072,5071,5070,5069,5068,5067,5066,5065,5064,5063,5062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("188", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "fc9b9e7e25ecfe67e6423ead8deb1465", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "0", "[{\"id\":18168,\"batched_data\":{\"100\":5061,\"101\":5060,\"102\":5059,\"103\":5058,\"104\":5057,\"105\":5056,\"106\":5055,\"107\":5054,\"108\":5053,\"109\":5052,\"110\":5051,\"111\":5050,\"112\":5049,\"113\":5048,\"114\":5047,\"115\":5046,\"116\":5045,\"117\":5044,\"118\":5043,\"119\":5042,\"120\":5041,\"121\":5040,\"122\":5039,\"123\":5038,\"124\":5037,\"125\":5036,\"126\":5035,\"127\":5034,\"128\":5033,\"129\":5032,\"130\":5031,\"131\":5030,\"132\":5029,\"133\":5028,\"134\":5027,\"135\":5026,\"136\":5025,\"137\":5024,\"138\":5023,\"139\":5022,\"140\":5021,\"141\":5020,\"142\":5019,\"143\":5018,\"144\":5017,\"145\":5016,\"146\":5015,\"147\":5014,\"148\":5013,\"149\":5012,\"150\":5011,\"151\":5010,\"152\":5009,\"153\":5008,\"154\":5007,\"155\":5006,\"156\":5005,\"157\":5004,\"158\":5003,\"159\":5002,\"160\":5001,\"161\":5000,\"162\":4999,\"163\":4998,\"164\":4997,\"165\":4996,\"166\":4995,\"167\":4994,\"168\":4993,\"169\":4992,\"170\":4991,\"171\":4990,\"172\":4989,\"173\":4988,\"174\":4987,\"175\":4986,\"176\":4985,\"177\":4984,\"178\":4983,\"179\":4982,\"180\":4981,\"181\":4980,\"182\":4979,\"183\":4978,\"184\":4977,\"185\":4976,\"186\":4975,\"187\":4974,\"188\":4973,\"189\":4972,\"190\":4971,\"191\":4970,\"192\":4969,\"193\":4968,\"194\":4967,\"195\":4966,\"196\":4965,\"197\":4964,\"198\":4963,\"199\":4962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("189", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "ec0f84c2d3810e39a4d5eb536b86be5a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "0", "[{\"id\":18168,\"batched_data\":{\"200\":4961,\"201\":4960,\"202\":4959,\"203\":4958,\"204\":4957,\"205\":4956,\"206\":4955,\"207\":4954,\"208\":4953,\"209\":4952,\"210\":4951,\"211\":4950,\"212\":4949,\"213\":4948,\"214\":4947,\"215\":4946,\"216\":4945,\"217\":4944,\"218\":4943,\"219\":4942,\"220\":4941,\"221\":4940,\"222\":4939,\"223\":4938,\"224\":4937,\"225\":4936,\"226\":4935,\"227\":4934,\"228\":4933,\"229\":4932,\"230\":4931,\"231\":4930,\"232\":4929,\"233\":4928,\"234\":4927,\"235\":4926,\"236\":4925,\"237\":4924,\"238\":4923,\"239\":4922,\"240\":4921,\"241\":4920,\"242\":4919,\"243\":4918,\"244\":4917,\"245\":4916,\"246\":4915,\"247\":4914,\"248\":4913,\"249\":4912,\"250\":4911,\"251\":4910,\"252\":4909,\"253\":4908,\"254\":4907,\"255\":4906,\"256\":4905,\"257\":4904,\"258\":4903,\"259\":4902,\"260\":4901,\"261\":4900,\"262\":4899,\"263\":4898,\"264\":4897,\"265\":4896,\"266\":4895,\"267\":4894,\"268\":4893,\"269\":4892,\"270\":4891,\"271\":4890,\"272\":4889,\"273\":4888,\"274\":4887,\"275\":4886,\"276\":4885,\"277\":4884,\"278\":4883,\"279\":4882,\"280\":4881,\"281\":4880,\"282\":4879,\"283\":4878,\"284\":4877,\"285\":4876,\"286\":4875,\"287\":4874,\"288\":4873,\"289\":4872,\"290\":4871,\"291\":4870,\"292\":4869,\"293\":4868,\"294\":4867,\"295\":4866,\"296\":4865,\"297\":4864,\"298\":4863,\"299\":4862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("190", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "a11671075f716b754298e8516dac04ab", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "0", "[{\"id\":18168,\"batched_data\":{\"300\":4861,\"301\":4860,\"302\":4859,\"303\":4858,\"304\":4857,\"305\":4856,\"306\":4855,\"307\":4854,\"308\":4853,\"309\":4852,\"310\":4851,\"311\":4850,\"312\":4849,\"313\":4848,\"314\":4847,\"315\":4846,\"316\":4845,\"317\":4844,\"318\":4843,\"319\":4842,\"320\":4841,\"321\":4840,\"322\":4839,\"323\":4838,\"324\":4837,\"325\":4836,\"326\":4835,\"327\":4834,\"328\":4833,\"329\":4832,\"330\":4831,\"331\":4830,\"332\":4829,\"333\":4828,\"334\":4827,\"335\":4826,\"336\":4825,\"337\":4824,\"338\":4823,\"339\":4822,\"340\":4821,\"341\":4820,\"342\":4819,\"343\":4818,\"344\":4817,\"345\":4816,\"346\":4815,\"347\":4814,\"348\":4813,\"349\":4812,\"350\":4811,\"351\":4810,\"352\":4809,\"353\":4808,\"354\":4807,\"355\":4806,\"356\":4805,\"357\":4804,\"358\":4803,\"359\":4802,\"360\":4801,\"361\":4800,\"362\":4799,\"363\":4798,\"364\":4797,\"365\":4796,\"366\":4795,\"367\":4794,\"368\":4793,\"369\":4792,\"370\":4791,\"371\":4790,\"372\":4789,\"373\":4788,\"374\":4787,\"375\":4786,\"376\":4785,\"377\":4784,\"378\":4783,\"379\":4782,\"380\":4781,\"381\":4780,\"382\":4779,\"383\":4778,\"384\":4777,\"385\":4776,\"386\":4775,\"387\":4774,\"388\":4773,\"389\":4772,\"390\":4771,\"391\":4770,\"392\":4769,\"393\":4768,\"394\":4767,\"395\":4766,\"396\":4765,\"397\":4764,\"398\":4763,\"399\":4762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("191", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "83979f430c8ffae61343644ceac6c667", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "0", "[{\"id\":18168,\"batched_data\":{\"400\":4761,\"401\":4760,\"402\":4759,\"403\":4758,\"404\":4757,\"405\":4756,\"406\":4755,\"407\":4754,\"408\":4753,\"409\":4752,\"410\":4751,\"411\":4750,\"412\":4749,\"413\":4748,\"414\":4747,\"415\":4746,\"416\":4745,\"417\":4744,\"418\":4743,\"419\":4742,\"420\":4741,\"421\":4740,\"422\":4739,\"423\":4738,\"424\":4737,\"425\":4736,\"426\":4735,\"427\":4734,\"428\":4733,\"429\":4732,\"430\":4731,\"431\":4730,\"432\":4729,\"433\":4728,\"434\":4727,\"435\":4726,\"436\":4725,\"437\":4724,\"438\":4723,\"439\":4722,\"440\":4721,\"441\":4720,\"442\":4719,\"443\":4718,\"444\":4717,\"445\":4716,\"446\":4715,\"447\":4714,\"448\":4713,\"449\":4712,\"450\":4711,\"451\":4710,\"452\":4709,\"453\":4708,\"454\":4707,\"455\":4706,\"456\":4705,\"457\":4704,\"458\":4703,\"459\":4702,\"460\":4701,\"461\":4700,\"462\":4699,\"463\":4698,\"464\":4697,\"465\":4696,\"466\":4695,\"467\":4694,\"468\":4693,\"469\":4692,\"470\":4691,\"471\":4690,\"472\":4689,\"473\":4688,\"474\":4687,\"475\":4686,\"476\":4685,\"477\":4684,\"478\":4683,\"479\":4682,\"480\":4681,\"481\":4680,\"482\":4679,\"483\":4678,\"484\":4677,\"485\":4676,\"486\":4675,\"487\":4674,\"488\":4673,\"489\":4672,\"490\":4671,\"491\":4670,\"492\":4669,\"493\":4668,\"494\":4667,\"495\":4666,\"496\":4665,\"497\":4664,\"498\":4663,\"499\":4662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("192", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "[{\"id\":18168,\"offset\":13500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("193", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "a057f9cca581ed155f678846ac50caed", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", "[{\"id\":18168,\"batched_data\":[4661,4660,4659,4658,4657,4656,4655,4654,4653,4652,4651,4650,4649,4648,4647,4646,4645,4644,4643,4642,4641,4640,4639,4638,4637,4636,4635,4634,4633,4632,4631,4630,4629,4628,4627,4626,4625,4624,4623,4622,4621,4620,4619,4618,4617,4616,4615,4614,4613,4612,4611,4610,4609,4608,4607,4606,4605,4604,4603,4602,4601,4600,4599,4598,4597,4596,4595,4594,4593,4592,4591,4590,4589,4588,4587,4586,4585,4584,4583,4582,4581,4580,4579,4578,4577,4576,4575,4574,4573,4572,4571,4570,4569,4568,4567,4566,4565,4564,4563,4562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("194", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "d18d31207414cdd2efa344e4419e6e9b", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", "[{\"id\":18168,\"batched_data\":{\"100\":4561,\"101\":4560,\"102\":4559,\"103\":4558,\"104\":4557,\"105\":4556,\"106\":4555,\"107\":4554,\"108\":4553,\"109\":4552,\"110\":4551,\"111\":4550,\"112\":4549,\"113\":4548,\"114\":4547,\"115\":4546,\"116\":4545,\"117\":4544,\"118\":4543,\"119\":4542,\"120\":4541,\"121\":4540,\"122\":4539,\"123\":4538,\"124\":4537,\"125\":4536,\"126\":4535,\"127\":4534,\"128\":4533,\"129\":4532,\"130\":4531,\"131\":4530,\"132\":4529,\"133\":4528,\"134\":4527,\"135\":4526,\"136\":4525,\"137\":4524,\"138\":4523,\"139\":4522,\"140\":4521,\"141\":4520,\"142\":4519,\"143\":4518,\"144\":4517,\"145\":4516,\"146\":4515,\"147\":4514,\"148\":4513,\"149\":4512,\"150\":4511,\"151\":4510,\"152\":4509,\"153\":4508,\"154\":4507,\"155\":4506,\"156\":4505,\"157\":4504,\"158\":4503,\"159\":4502,\"160\":4501,\"161\":4500,\"162\":4499,\"163\":4498,\"164\":4497,\"165\":4496,\"166\":4495,\"167\":4494,\"168\":4493,\"169\":4492,\"170\":4491,\"171\":4490,\"172\":4489,\"173\":4488,\"174\":4487,\"175\":4486,\"176\":4485,\"177\":4484,\"178\":4483,\"179\":4482,\"180\":4481,\"181\":4480,\"182\":4479,\"183\":4478,\"184\":4477,\"185\":4476,\"186\":4475,\"187\":4474,\"188\":4473,\"189\":4472,\"190\":4471,\"191\":4470,\"192\":4469,\"193\":4468,\"194\":4467,\"195\":4466,\"196\":4465,\"197\":4464,\"198\":4463,\"199\":4462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("195", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "76a68a031075627872efc4914372ee59", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", "[{\"id\":18168,\"batched_data\":{\"200\":4461,\"201\":4460,\"202\":4459,\"203\":4458,\"204\":4457,\"205\":4456,\"206\":4455,\"207\":4454,\"208\":4453,\"209\":4452,\"210\":4451,\"211\":4450,\"212\":4449,\"213\":4448,\"214\":4447,\"215\":4446,\"216\":4445,\"217\":4444,\"218\":4443,\"219\":4442,\"220\":4441,\"221\":4440,\"222\":4439,\"223\":4438,\"224\":4437,\"225\":4436,\"226\":4435,\"227\":4434,\"228\":4433,\"229\":4432,\"230\":4431,\"231\":4430,\"232\":4429,\"233\":4428,\"234\":4427,\"235\":4426,\"236\":4425,\"237\":4424,\"238\":4423,\"239\":4422,\"240\":4421,\"241\":4420,\"242\":4419,\"243\":4418,\"244\":4417,\"245\":4416,\"246\":4415,\"247\":4414,\"248\":4413,\"249\":4412,\"250\":4411,\"251\":4410,\"252\":4409,\"253\":4408,\"254\":4407,\"255\":4406,\"256\":4405,\"257\":4404,\"258\":4403,\"259\":4402,\"260\":4401,\"261\":4400,\"262\":4399,\"263\":4398,\"264\":4397,\"265\":4396,\"266\":4395,\"267\":4394,\"268\":4393,\"269\":4392,\"270\":4391,\"271\":4390,\"272\":4389,\"273\":4388,\"274\":4387,\"275\":4386,\"276\":4385,\"277\":4384,\"278\":4383,\"279\":4382,\"280\":4381,\"281\":4380,\"282\":4379,\"283\":4378,\"284\":4377,\"285\":4376,\"286\":4375,\"287\":4374,\"288\":4373,\"289\":4372,\"290\":4371,\"291\":4370,\"292\":4369,\"293\":4368,\"294\":4367,\"295\":4366,\"296\":4365,\"297\":4364,\"298\":4363,\"299\":4362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("196", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "29e194ac5287e4de74e8d1dcdb9eb8d1", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", "[{\"id\":18168,\"batched_data\":{\"300\":4361,\"301\":4360,\"302\":4359,\"303\":4358,\"304\":4357,\"305\":4356,\"306\":4355,\"307\":4354,\"308\":4353,\"309\":4352,\"310\":4351,\"311\":4350,\"312\":4349,\"313\":4348,\"314\":4347,\"315\":4346,\"316\":4345,\"317\":4344,\"318\":4343,\"319\":4342,\"320\":4341,\"321\":4340,\"322\":4339,\"323\":4338,\"324\":4337,\"325\":4336,\"326\":4335,\"327\":4334,\"328\":4333,\"329\":4332,\"330\":4331,\"331\":4330,\"332\":4329,\"333\":4328,\"334\":4327,\"335\":4326,\"336\":4325,\"337\":4324,\"338\":4323,\"339\":4322,\"340\":4321,\"341\":4320,\"342\":4319,\"343\":4318,\"344\":4317,\"345\":4316,\"346\":4315,\"347\":4314,\"348\":4313,\"349\":4312,\"350\":4311,\"351\":4310,\"352\":4309,\"353\":4308,\"354\":4307,\"355\":4306,\"356\":4305,\"357\":4304,\"358\":4303,\"359\":4302,\"360\":4301,\"361\":4300,\"362\":4299,\"363\":4298,\"364\":4297,\"365\":4296,\"366\":4295,\"367\":4294,\"368\":4293,\"369\":4292,\"370\":4291,\"371\":4290,\"372\":4289,\"373\":4288,\"374\":4287,\"375\":4286,\"376\":4285,\"377\":4284,\"378\":4283,\"379\":4282,\"380\":4281,\"381\":4280,\"382\":4279,\"383\":4278,\"384\":4277,\"385\":4276,\"386\":4275,\"387\":4274,\"388\":4273,\"389\":4272,\"390\":4271,\"391\":4270,\"392\":4269,\"393\":4268,\"394\":4267,\"395\":4266,\"396\":4265,\"397\":4264,\"398\":4263,\"399\":4262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("197", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:26", "2024-03-18 18:16:26", "4b8999ff7ef13351a06003af9d71fafd", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", "[{\"id\":18168,\"batched_data\":{\"400\":4261,\"401\":4260,\"402\":4259,\"403\":4258,\"404\":4257,\"405\":4256,\"406\":4255,\"407\":4254,\"408\":4253,\"409\":4252,\"410\":4251,\"411\":4250,\"412\":4249,\"413\":4248,\"414\":4247,\"415\":4246,\"416\":4245,\"417\":4244,\"418\":4243,\"419\":4242,\"420\":4241,\"421\":4240,\"422\":4239,\"423\":4238,\"424\":4237,\"425\":4236,\"426\":4235,\"427\":4234,\"428\":4233,\"429\":4232,\"430\":4231,\"431\":4230,\"432\":4229,\"433\":4228,\"434\":4227,\"435\":4226,\"436\":4225,\"437\":4224,\"438\":4223,\"439\":4222,\"440\":4221,\"441\":4220,\"442\":4219,\"443\":4218,\"444\":4217,\"445\":4216,\"446\":4215,\"447\":4214,\"448\":4213,\"449\":4212,\"450\":4211,\"451\":4210,\"452\":4209,\"453\":4208,\"454\":4207,\"455\":4206,\"456\":4205,\"457\":4204,\"458\":4203,\"459\":4202,\"460\":4201,\"461\":4200,\"462\":4199,\"463\":4198,\"464\":4197,\"465\":4196,\"466\":4195,\"467\":4194,\"468\":4193,\"469\":4192,\"470\":4191,\"471\":4190,\"472\":4189,\"473\":4188,\"474\":4187,\"475\":4186,\"476\":4185,\"477\":4184,\"478\":4183,\"479\":4182,\"480\":4181,\"481\":4180,\"482\":4179,\"483\":4178,\"484\":4177,\"485\":4176,\"486\":4175,\"487\":4174,\"488\":4173,\"489\":4172,\"490\":4171,\"491\":4170,\"492\":4169,\"493\":4168,\"494\":4167,\"495\":4166,\"496\":4165,\"497\":4164,\"498\":4163,\"499\":4162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":13500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("198", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "[{\"id\":18168,\"offset\":14000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("199", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "42afc4799b75a048269974d67c1d1967", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", "[{\"id\":18168,\"batched_data\":[4161,4160,4159,4158,4157,4156,4155,4154,4153,4152,4151,4150,4149,4148,4147,4146,4145,4144,4143,4142,4141,4140,4139,4138,4137,4136,4135,4134,4133,4132,4131,4130,4129,4128,4127,4126,4125,4124,4123,4122,4121,4120,4119,4118,4117,4116,4115,4114,4113,4112,4111,4110,4109,4108,4107,4106,4105,4104,4103,4102,4101,4100,4099,4098,4097,4096,4095,4094,4093,4092,4091,4090,4089,4088,4087,4086,4085,4084,4083,4082,4081,4080,4079,4078,4077,4076,4075,4074,4073,4072,4071,4070,4069,4068,4067,4066,4065,4064,4063,4062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("200", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "690d001278e572d7a095944a825d88d9", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", "[{\"id\":18168,\"batched_data\":{\"100\":4061,\"101\":4060,\"102\":4059,\"103\":4058,\"104\":4057,\"105\":4056,\"106\":4055,\"107\":4054,\"108\":4053,\"109\":4052,\"110\":4051,\"111\":4050,\"112\":4049,\"113\":4048,\"114\":4047,\"115\":4046,\"116\":4045,\"117\":4044,\"118\":4043,\"119\":4042,\"120\":4041,\"121\":4040,\"122\":4039,\"123\":4038,\"124\":4037,\"125\":4036,\"126\":4035,\"127\":4034,\"128\":4033,\"129\":4032,\"130\":4031,\"131\":4030,\"132\":4029,\"133\":4028,\"134\":4027,\"135\":4026,\"136\":4025,\"137\":4024,\"138\":4023,\"139\":4022,\"140\":4021,\"141\":4020,\"142\":4019,\"143\":4018,\"144\":4017,\"145\":4016,\"146\":4015,\"147\":4014,\"148\":4013,\"149\":4012,\"150\":4011,\"151\":4010,\"152\":4009,\"153\":4008,\"154\":4007,\"155\":4006,\"156\":4005,\"157\":4004,\"158\":4003,\"159\":4002,\"160\":4001,\"161\":4000,\"162\":3999,\"163\":3998,\"164\":3997,\"165\":3996,\"166\":3995,\"167\":3994,\"168\":3993,\"169\":3992,\"170\":3991,\"171\":3990,\"172\":3989,\"173\":3988,\"174\":3987,\"175\":3986,\"176\":3985,\"177\":3984,\"178\":3983,\"179\":3982,\"180\":3981,\"181\":3980,\"182\":3979,\"183\":3978,\"184\":3977,\"185\":3976,\"186\":3975,\"187\":3974,\"188\":3973,\"189\":3972,\"190\":3971,\"191\":3970,\"192\":3969,\"193\":3968,\"194\":3967,\"195\":3966,\"196\":3965,\"197\":3964,\"198\":3963,\"199\":3962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("201", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "507f91ae0561c967cc4174d681320e66", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "0", "[{\"id\":18168,\"batched_data\":{\"200\":3961,\"201\":3960,\"202\":3959,\"203\":3958,\"204\":3957,\"205\":3956,\"206\":3955,\"207\":3954,\"208\":3953,\"209\":3952,\"210\":3951,\"211\":3950,\"212\":3949,\"213\":3948,\"214\":3947,\"215\":3946,\"216\":3945,\"217\":3944,\"218\":3943,\"219\":3942,\"220\":3941,\"221\":3940,\"222\":3939,\"223\":3938,\"224\":3937,\"225\":3936,\"226\":3935,\"227\":3934,\"228\":3933,\"229\":3932,\"230\":3931,\"231\":3930,\"232\":3929,\"233\":3928,\"234\":3927,\"235\":3926,\"236\":3925,\"237\":3924,\"238\":3923,\"239\":3922,\"240\":3921,\"241\":3920,\"242\":3919,\"243\":3918,\"244\":3917,\"245\":3916,\"246\":3915,\"247\":3914,\"248\":3913,\"249\":3912,\"250\":3911,\"251\":3910,\"252\":3909,\"253\":3908,\"254\":3907,\"255\":3906,\"256\":3905,\"257\":3904,\"258\":3903,\"259\":3902,\"260\":3901,\"261\":3900,\"262\":3899,\"263\":3898,\"264\":3897,\"265\":3896,\"266\":3895,\"267\":3894,\"268\":3893,\"269\":3892,\"270\":3891,\"271\":3890,\"272\":3889,\"273\":3888,\"274\":3887,\"275\":3886,\"276\":3885,\"277\":3884,\"278\":3883,\"279\":3882,\"280\":3881,\"281\":3880,\"282\":3879,\"283\":3878,\"284\":3877,\"285\":3876,\"286\":3875,\"287\":3874,\"288\":3873,\"289\":3872,\"290\":3871,\"291\":3870,\"292\":3869,\"293\":3868,\"294\":3867,\"295\":3866,\"296\":3865,\"297\":3864,\"298\":3863,\"299\":3862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("202", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "de961ebd4aaed5b367d3fa530fb576e0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "0", "[{\"id\":18168,\"batched_data\":{\"300\":3861,\"301\":3860,\"302\":3859,\"303\":3858,\"304\":3857,\"305\":3856,\"306\":3855,\"307\":3854,\"308\":3853,\"309\":3852,\"310\":3851,\"311\":3850,\"312\":3849,\"313\":3848,\"314\":3847,\"315\":3846,\"316\":3845,\"317\":3844,\"318\":3843,\"319\":3842,\"320\":3841,\"321\":3840,\"322\":3839,\"323\":3838,\"324\":3837,\"325\":3836,\"326\":3835,\"327\":3834,\"328\":3833,\"329\":3832,\"330\":3831,\"331\":3830,\"332\":3829,\"333\":3828,\"334\":3827,\"335\":3826,\"336\":3825,\"337\":3824,\"338\":3823,\"339\":3822,\"340\":3821,\"341\":3820,\"342\":3819,\"343\":3818,\"344\":3817,\"345\":3816,\"346\":3815,\"347\":3814,\"348\":3813,\"349\":3812,\"350\":3811,\"351\":3810,\"352\":3809,\"353\":3808,\"354\":3807,\"355\":3806,\"356\":3805,\"357\":3804,\"358\":3803,\"359\":3802,\"360\":3801,\"361\":3800,\"362\":3799,\"363\":3798,\"364\":3797,\"365\":3796,\"366\":3795,\"367\":3794,\"368\":3793,\"369\":3792,\"370\":3791,\"371\":3790,\"372\":3789,\"373\":3788,\"374\":3787,\"375\":3786,\"376\":3785,\"377\":3784,\"378\":3783,\"379\":3782,\"380\":3781,\"381\":3780,\"382\":3779,\"383\":3778,\"384\":3777,\"385\":3776,\"386\":3775,\"387\":3774,\"388\":3773,\"389\":3772,\"390\":3771,\"391\":3770,\"392\":3769,\"393\":3768,\"394\":3767,\"395\":3766,\"396\":3765,\"397\":3764,\"398\":3763,\"399\":3762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("203", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "ec2bf1d615c15af0d3e4231bc9bc3df0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "0", "[{\"id\":18168,\"batched_data\":{\"400\":3761,\"401\":3760,\"402\":3759,\"403\":3758,\"404\":3757,\"405\":3756,\"406\":3755,\"407\":3754,\"408\":3753,\"409\":3752,\"410\":3751,\"411\":3750,\"412\":3749,\"413\":3748,\"414\":3747,\"415\":3746,\"416\":3745,\"417\":3744,\"418\":3743,\"419\":3742,\"420\":3741,\"421\":3740,\"422\":3739,\"423\":3738,\"424\":3737,\"425\":3736,\"426\":3735,\"427\":3734,\"428\":3733,\"429\":3732,\"430\":3731,\"431\":3730,\"432\":3729,\"433\":3728,\"434\":3727,\"435\":3726,\"436\":3725,\"437\":3724,\"438\":3723,\"439\":3722,\"440\":3721,\"441\":3720,\"442\":3719,\"443\":3718,\"444\":3717,\"445\":3716,\"446\":3715,\"447\":3714,\"448\":3713,\"449\":3712,\"450\":3711,\"451\":3710,\"452\":3709,\"453\":3708,\"454\":3707,\"455\":3706,\"456\":3705,\"457\":3704,\"458\":3703,\"459\":3702,\"460\":3701,\"461\":3700,\"462\":3699,\"463\":3698,\"464\":3697,\"465\":3696,\"466\":3695,\"467\":3694,\"468\":3693,\"469\":3692,\"470\":3691,\"471\":3690,\"472\":3689,\"473\":3688,\"474\":3687,\"475\":3686,\"476\":3685,\"477\":3684,\"478\":3683,\"479\":3682,\"480\":3681,\"481\":3680,\"482\":3679,\"483\":3678,\"484\":3677,\"485\":3676,\"486\":3675,\"487\":3674,\"488\":3673,\"489\":3672,\"490\":3671,\"491\":3670,\"492\":3669,\"493\":3668,\"494\":3667,\"495\":3666,\"496\":3665,\"497\":3664,\"498\":3663,\"499\":3662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("204", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:27", "2024-03-18 18:16:27", "[{\"id\":18168,\"offset\":14500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("205", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "3c96b3d97bdeb85b6887258c9b42d999", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "0", "[{\"id\":18168,\"batched_data\":[3661,3660,3659,3658,3657,3656,3655,3654,3653,3652,3651,3650,3649,3648,3647,3646,3645,3644,3643,3642,3641,3640,3639,3638,3637,3636,3635,3634,3633,3632,3631,3630,3629,3628,3627,3626,3625,3624,3623,3622,3621,3620,3619,3618,3617,3616,3615,3614,3613,3612,3611,3610,3609,3608,3607,3606,3605,3604,3603,3602,3601,3600,3599,3598,3597,3596,3595,3594,3593,3592,3591,3590,3589,3588,3587,3586,3585,3584,3583,3582,3581,3580,3579,3578,3577,3576,3575,3574,3573,3572,3571,3570,3569,3568,3567,3566,3565,3564,3563,3562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("206", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "291ddbe6bdeb8d58599b5cba99a58805", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "0", "[{\"id\":18168,\"batched_data\":{\"100\":3561,\"101\":3560,\"102\":3559,\"103\":3558,\"104\":3557,\"105\":3556,\"106\":3555,\"107\":3554,\"108\":3553,\"109\":3552,\"110\":3551,\"111\":3550,\"112\":3549,\"113\":3548,\"114\":3547,\"115\":3546,\"116\":3545,\"117\":3544,\"118\":3543,\"119\":3542,\"120\":3541,\"121\":3540,\"122\":3539,\"123\":3538,\"124\":3537,\"125\":3536,\"126\":3535,\"127\":3534,\"128\":3533,\"129\":3532,\"130\":3531,\"131\":3530,\"132\":3529,\"133\":3528,\"134\":3527,\"135\":3526,\"136\":3525,\"137\":3524,\"138\":3523,\"139\":3522,\"140\":3521,\"141\":3520,\"142\":3519,\"143\":3518,\"144\":3517,\"145\":3516,\"146\":3515,\"147\":3514,\"148\":3513,\"149\":3512,\"150\":3511,\"151\":3510,\"152\":3509,\"153\":3508,\"154\":3507,\"155\":3506,\"156\":3505,\"157\":3504,\"158\":3503,\"159\":3502,\"160\":3501,\"161\":3500,\"162\":3499,\"163\":3498,\"164\":3497,\"165\":3496,\"166\":3495,\"167\":3494,\"168\":3493,\"169\":3492,\"170\":3491,\"171\":3490,\"172\":3489,\"173\":3488,\"174\":3487,\"175\":3486,\"176\":3485,\"177\":3484,\"178\":3483,\"179\":3482,\"180\":3481,\"181\":3480,\"182\":3479,\"183\":3478,\"184\":3477,\"185\":3476,\"186\":3475,\"187\":3474,\"188\":3473,\"189\":3472,\"190\":3471,\"191\":3470,\"192\":3469,\"193\":3468,\"194\":3467,\"195\":3466,\"196\":3465,\"197\":3464,\"198\":3463,\"199\":3462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("207", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "42ad2a5e996bb1fb2a2911b963530a30", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "0", "[{\"id\":18168,\"batched_data\":{\"200\":3461,\"201\":3460,\"202\":3459,\"203\":3458,\"204\":3457,\"205\":3456,\"206\":3455,\"207\":3454,\"208\":3453,\"209\":3452,\"210\":3451,\"211\":3450,\"212\":3449,\"213\":3448,\"214\":3447,\"215\":3446,\"216\":3445,\"217\":3444,\"218\":3443,\"219\":3442,\"220\":3441,\"221\":3440,\"222\":3439,\"223\":3438,\"224\":3437,\"225\":3436,\"226\":3435,\"227\":3434,\"228\":3433,\"229\":3432,\"230\":3431,\"231\":3430,\"232\":3429,\"233\":3428,\"234\":3427,\"235\":3426,\"236\":3425,\"237\":3424,\"238\":3423,\"239\":3422,\"240\":3421,\"241\":3420,\"242\":3419,\"243\":3418,\"244\":3417,\"245\":3416,\"246\":3415,\"247\":3414,\"248\":3413,\"249\":3412,\"250\":3411,\"251\":3410,\"252\":3409,\"253\":3408,\"254\":3407,\"255\":3406,\"256\":3405,\"257\":3404,\"258\":3403,\"259\":3402,\"260\":3401,\"261\":3400,\"262\":3399,\"263\":3398,\"264\":3397,\"265\":3396,\"266\":3395,\"267\":3394,\"268\":3393,\"269\":3392,\"270\":3391,\"271\":3390,\"272\":3389,\"273\":3388,\"274\":3387,\"275\":3386,\"276\":3385,\"277\":3384,\"278\":3383,\"279\":3382,\"280\":3381,\"281\":3380,\"282\":3379,\"283\":3378,\"284\":3377,\"285\":3376,\"286\":3375,\"287\":3374,\"288\":3373,\"289\":3372,\"290\":3371,\"291\":3370,\"292\":3369,\"293\":3368,\"294\":3367,\"295\":3366,\"296\":3365,\"297\":3364,\"298\":3363,\"299\":3362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("208", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "4a3a5a04a8b79e52b7fb84b928ebcf2d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "0", "[{\"id\":18168,\"batched_data\":{\"300\":3361,\"301\":3360,\"302\":3359,\"303\":3358,\"304\":3357,\"305\":3356,\"306\":3355,\"307\":3354,\"308\":3353,\"309\":3352,\"310\":3351,\"311\":3350,\"312\":3349,\"313\":3348,\"314\":3347,\"315\":3346,\"316\":3345,\"317\":3344,\"318\":3343,\"319\":3342,\"320\":3341,\"321\":3340,\"322\":3339,\"323\":3338,\"324\":3337,\"325\":3336,\"326\":3335,\"327\":3334,\"328\":3333,\"329\":3332,\"330\":3331,\"331\":3330,\"332\":3329,\"333\":3328,\"334\":3327,\"335\":3326,\"336\":3325,\"337\":3324,\"338\":3323,\"339\":3322,\"340\":3321,\"341\":3320,\"342\":3319,\"343\":3318,\"344\":3317,\"345\":3316,\"346\":3315,\"347\":3314,\"348\":3313,\"349\":3312,\"350\":3311,\"351\":3310,\"352\":3309,\"353\":3308,\"354\":3307,\"355\":3306,\"356\":3305,\"357\":3304,\"358\":3303,\"359\":3302,\"360\":3301,\"361\":3300,\"362\":3299,\"363\":3298,\"364\":3297,\"365\":3296,\"366\":3295,\"367\":3294,\"368\":3293,\"369\":3292,\"370\":3291,\"371\":3290,\"372\":3289,\"373\":3288,\"374\":3287,\"375\":3286,\"376\":3285,\"377\":3284,\"378\":3283,\"379\":3282,\"380\":3281,\"381\":3280,\"382\":3279,\"383\":3278,\"384\":3277,\"385\":3276,\"386\":3275,\"387\":3274,\"388\":3273,\"389\":3272,\"390\":3271,\"391\":3270,\"392\":3269,\"393\":3268,\"394\":3267,\"395\":3266,\"396\":3265,\"397\":3264,\"398\":3263,\"399\":3262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("209", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "bc06e397b4d12b7305eee8d410c3a2fb", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "0", "[{\"id\":18168,\"batched_data\":{\"400\":3261,\"401\":3260,\"402\":3259,\"403\":3258,\"404\":3257,\"405\":3256,\"406\":3255,\"407\":3254,\"408\":3253,\"409\":3252,\"410\":3251,\"411\":3250,\"412\":3249,\"413\":3248,\"414\":3247,\"415\":3246,\"416\":3245,\"417\":3244,\"418\":3243,\"419\":3242,\"420\":3241,\"421\":3240,\"422\":3239,\"423\":3238,\"424\":3237,\"425\":3236,\"426\":3235,\"427\":3234,\"428\":3233,\"429\":3232,\"430\":3231,\"431\":3230,\"432\":3229,\"433\":3228,\"434\":3227,\"435\":3226,\"436\":3225,\"437\":3224,\"438\":3223,\"439\":3222,\"440\":3221,\"441\":3220,\"442\":3219,\"443\":3218,\"444\":3217,\"445\":3216,\"446\":3215,\"447\":3214,\"448\":3213,\"449\":3212,\"450\":3211,\"451\":3210,\"452\":3209,\"453\":3208,\"454\":3207,\"455\":3206,\"456\":3205,\"457\":3204,\"458\":3203,\"459\":3202,\"460\":3201,\"461\":3200,\"462\":3199,\"463\":3198,\"464\":3197,\"465\":3196,\"466\":3195,\"467\":3194,\"468\":3193,\"469\":3192,\"470\":3191,\"471\":3190,\"472\":3189,\"473\":3188,\"474\":3187,\"475\":3186,\"476\":3185,\"477\":3184,\"478\":3183,\"479\":3182,\"480\":3181,\"481\":3180,\"482\":3179,\"483\":3178,\"484\":3177,\"485\":3176,\"486\":3175,\"487\":3174,\"488\":3173,\"489\":3172,\"490\":3171,\"491\":3170,\"492\":3169,\"493\":3168,\"494\":3167,\"495\":3166,\"496\":3165,\"497\":3164,\"498\":3163,\"499\":3162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":14500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("210", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "[{\"id\":18168,\"offset\":15000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("211", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "c923cd89eae58b94ea98e18582bd8c4a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "0", "[{\"id\":18168,\"batched_data\":[3161,3160,3159,3158,3157,3156,3155,3154,3153,3152,3151,3150,3149,3148,3147,3146,3145,3144,3143,3142,3141,3140,3139,3138,3137,3136,3135,3134,3133,3132,3131,3130,3129,3128,3127,3126,3125,3124,3123,3122,3121,3120,3119,3118,3117,3116,3115,3114,3113,3112,3111,3110,3109,3108,3107,3106,3105,3104,3103,3102,3101,3100,3099,3098,3097,3096,3095,3094,3093,3092,3091,3090,3089,3088,3087,3086,3085,3084,3083,3082,3081,3080,3079,3078,3077,3076,3075,3074,3073,3072,3071,3070,3069,3068,3067,3066,3065,3064,3063,3062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("212", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "2df081b7010fbebcbed41026e26d6220", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "0", "[{\"id\":18168,\"batched_data\":{\"100\":3061,\"101\":3060,\"102\":3059,\"103\":3058,\"104\":3057,\"105\":3056,\"106\":3055,\"107\":3054,\"108\":3053,\"109\":3052,\"110\":3051,\"111\":3050,\"112\":3049,\"113\":3048,\"114\":3047,\"115\":3046,\"116\":3045,\"117\":3044,\"118\":3043,\"119\":3042,\"120\":3041,\"121\":3040,\"122\":3039,\"123\":3038,\"124\":3037,\"125\":3036,\"126\":3035,\"127\":3034,\"128\":3033,\"129\":3032,\"130\":3031,\"131\":3030,\"132\":3029,\"133\":3028,\"134\":3027,\"135\":3026,\"136\":3025,\"137\":3024,\"138\":3023,\"139\":3022,\"140\":3021,\"141\":3020,\"142\":3019,\"143\":3018,\"144\":3017,\"145\":3016,\"146\":3015,\"147\":3014,\"148\":3013,\"149\":3012,\"150\":3011,\"151\":3010,\"152\":3009,\"153\":3008,\"154\":3007,\"155\":3006,\"156\":3005,\"157\":3004,\"158\":3003,\"159\":3002,\"160\":3001,\"161\":3000,\"162\":2999,\"163\":2998,\"164\":2997,\"165\":2996,\"166\":2995,\"167\":2994,\"168\":2993,\"169\":2992,\"170\":2991,\"171\":2990,\"172\":2989,\"173\":2988,\"174\":2987,\"175\":2986,\"176\":2985,\"177\":2984,\"178\":2983,\"179\":2982,\"180\":2981,\"181\":2980,\"182\":2979,\"183\":2978,\"184\":2977,\"185\":2976,\"186\":2975,\"187\":2974,\"188\":2973,\"189\":2972,\"190\":2971,\"191\":2970,\"192\":2969,\"193\":2968,\"194\":2967,\"195\":2966,\"196\":2965,\"197\":2964,\"198\":2963,\"199\":2962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("213", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "d6eda739a8e2d3ee7ce52df323c15359", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "0", "[{\"id\":18168,\"batched_data\":{\"200\":2961,\"201\":2960,\"202\":2959,\"203\":2958,\"204\":2957,\"205\":2956,\"206\":2955,\"207\":2954,\"208\":2953,\"209\":2952,\"210\":2951,\"211\":2950,\"212\":2949,\"213\":2948,\"214\":2947,\"215\":2946,\"216\":2945,\"217\":2944,\"218\":2943,\"219\":2942,\"220\":2941,\"221\":2940,\"222\":2939,\"223\":2938,\"224\":2937,\"225\":2936,\"226\":2935,\"227\":2934,\"228\":2933,\"229\":2932,\"230\":2931,\"231\":2930,\"232\":2929,\"233\":2928,\"234\":2927,\"235\":2926,\"236\":2925,\"237\":2924,\"238\":2923,\"239\":2922,\"240\":2921,\"241\":2920,\"242\":2919,\"243\":2918,\"244\":2917,\"245\":2916,\"246\":2915,\"247\":2914,\"248\":2913,\"249\":2912,\"250\":2911,\"251\":2910,\"252\":2909,\"253\":2908,\"254\":2907,\"255\":2906,\"256\":2905,\"257\":2904,\"258\":2903,\"259\":2902,\"260\":2901,\"261\":2900,\"262\":2899,\"263\":2898,\"264\":2897,\"265\":2896,\"266\":2895,\"267\":2894,\"268\":2893,\"269\":2892,\"270\":2891,\"271\":2890,\"272\":2889,\"273\":2888,\"274\":2887,\"275\":2886,\"276\":2885,\"277\":2884,\"278\":2883,\"279\":2882,\"280\":2881,\"281\":2880,\"282\":2879,\"283\":2878,\"284\":2877,\"285\":2876,\"286\":2875,\"287\":2874,\"288\":2873,\"289\":2872,\"290\":2871,\"291\":2870,\"292\":2869,\"293\":2868,\"294\":2867,\"295\":2866,\"296\":2865,\"297\":2864,\"298\":2863,\"299\":2862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("214", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "d249d8fab0016a6f8b002c4afe3bb829", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "0", "[{\"id\":18168,\"batched_data\":{\"300\":2861,\"301\":2860,\"302\":2859,\"303\":2858,\"304\":2857,\"305\":2856,\"306\":2855,\"307\":2854,\"308\":2853,\"309\":2852,\"310\":2851,\"311\":2850,\"312\":2849,\"313\":2848,\"314\":2847,\"315\":2846,\"316\":2845,\"317\":2844,\"318\":2843,\"319\":2842,\"320\":2841,\"321\":2840,\"322\":2839,\"323\":2838,\"324\":2837,\"325\":2836,\"326\":2835,\"327\":2834,\"328\":2833,\"329\":2832,\"330\":2831,\"331\":2830,\"332\":2829,\"333\":2828,\"334\":2827,\"335\":2826,\"336\":2825,\"337\":2824,\"338\":2823,\"339\":2822,\"340\":2821,\"341\":2820,\"342\":2819,\"343\":2818,\"344\":2817,\"345\":2816,\"346\":2815,\"347\":2814,\"348\":2813,\"349\":2812,\"350\":2811,\"351\":2810,\"352\":2809,\"353\":2808,\"354\":2807,\"355\":2806,\"356\":2805,\"357\":2804,\"358\":2803,\"359\":2802,\"360\":2801,\"361\":2800,\"362\":2799,\"363\":2798,\"364\":2797,\"365\":2796,\"366\":2795,\"367\":2794,\"368\":2793,\"369\":2792,\"370\":2791,\"371\":2790,\"372\":2789,\"373\":2788,\"374\":2787,\"375\":2786,\"376\":2785,\"377\":2784,\"378\":2783,\"379\":2782,\"380\":2781,\"381\":2780,\"382\":2779,\"383\":2778,\"384\":2777,\"385\":2776,\"386\":2775,\"387\":2774,\"388\":2773,\"389\":2772,\"390\":2771,\"391\":2770,\"392\":2769,\"393\":2768,\"394\":2767,\"395\":2766,\"396\":2765,\"397\":2764,\"398\":2763,\"399\":2762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("215", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "4ba1f1056efcc5ccc5eeaf80687f728a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "0", "[{\"id\":18168,\"batched_data\":{\"400\":2761,\"401\":2760,\"402\":2759,\"403\":2758,\"404\":2757,\"405\":2756,\"406\":2755,\"407\":2754,\"408\":2753,\"409\":2752,\"410\":2751,\"411\":2750,\"412\":2749,\"413\":2748,\"414\":2747,\"415\":2746,\"416\":2745,\"417\":2744,\"418\":2743,\"419\":2742,\"420\":2741,\"421\":2740,\"422\":2739,\"423\":2738,\"424\":2737,\"425\":2736,\"426\":2735,\"427\":2734,\"428\":2733,\"429\":2732,\"430\":2731,\"431\":2730,\"432\":2729,\"433\":2728,\"434\":2727,\"435\":2726,\"436\":2725,\"437\":2724,\"438\":2723,\"439\":2722,\"440\":2721,\"441\":2720,\"442\":2719,\"443\":2718,\"444\":2717,\"445\":2716,\"446\":2715,\"447\":2714,\"448\":2713,\"449\":2712,\"450\":2711,\"451\":2710,\"452\":2709,\"453\":2708,\"454\":2707,\"455\":2706,\"456\":2705,\"457\":2704,\"458\":2703,\"459\":2702,\"460\":2701,\"461\":2700,\"462\":2699,\"463\":2698,\"464\":2697,\"465\":2696,\"466\":2695,\"467\":2694,\"468\":2693,\"469\":2692,\"470\":2691,\"471\":2690,\"472\":2689,\"473\":2688,\"474\":2687,\"475\":2686,\"476\":2685,\"477\":2684,\"478\":2683,\"479\":2682,\"480\":2681,\"481\":2680,\"482\":2679,\"483\":2678,\"484\":2677,\"485\":2676,\"486\":2675,\"487\":2674,\"488\":2673,\"489\":2672,\"490\":2671,\"491\":2670,\"492\":2669,\"493\":2668,\"494\":2667,\"495\":2666,\"496\":2665,\"497\":2664,\"498\":2663,\"499\":2662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("216", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:28", "2024-03-18 18:16:28", "[{\"id\":18168,\"offset\":15500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("217", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "c37796f066d72be2e7936f59446d162c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "0", "[{\"id\":18168,\"batched_data\":[2661,2660,2659,2658,2657,2656,2655,2654,2653,2652,2651,2650,2649,2648,2647,2646,2645,2644,2643,2642,2641,2640,2639,2638,2637,2636,2635,2634,2633,2632,2631,2630,2629,2628,2627,2626,2625,2624,2623,2622,2621,2620,2619,2618,2617,2616,2615,2614,2613,2612,2611,2610,2609,2608,2607,2606,2605,2604,2603,2602,2601,2600,2599,2598,2597,2596,2595,2594,2593,2592,2591,2590,2589,2588,2587,2586,2585,2584,2583,2582,2581,2580,2579,2578,2577,2576,2575,2574,2573,2572,2571,2570,2569,2568,2567,2566,2565,2564,2563,2562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("218", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "f877b6ace2cfded4837ff40dc58e223d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "0", "[{\"id\":18168,\"batched_data\":{\"100\":2561,\"101\":2560,\"102\":2559,\"103\":2558,\"104\":2557,\"105\":2556,\"106\":2555,\"107\":2554,\"108\":2553,\"109\":2552,\"110\":2551,\"111\":2550,\"112\":2549,\"113\":2548,\"114\":2547,\"115\":2546,\"116\":2545,\"117\":2544,\"118\":2543,\"119\":2542,\"120\":2541,\"121\":2540,\"122\":2539,\"123\":2538,\"124\":2537,\"125\":2536,\"126\":2535,\"127\":2534,\"128\":2533,\"129\":2532,\"130\":2531,\"131\":2530,\"132\":2529,\"133\":2528,\"134\":2527,\"135\":2526,\"136\":2525,\"137\":2524,\"138\":2523,\"139\":2522,\"140\":2521,\"141\":2520,\"142\":2519,\"143\":2518,\"144\":2517,\"145\":2516,\"146\":2515,\"147\":2514,\"148\":2513,\"149\":2512,\"150\":2511,\"151\":2510,\"152\":2509,\"153\":2508,\"154\":2507,\"155\":2506,\"156\":2505,\"157\":2504,\"158\":2503,\"159\":2502,\"160\":2501,\"161\":2500,\"162\":2499,\"163\":2498,\"164\":2497,\"165\":2496,\"166\":2495,\"167\":2494,\"168\":2493,\"169\":2492,\"170\":2491,\"171\":2490,\"172\":2489,\"173\":2488,\"174\":2487,\"175\":2486,\"176\":2485,\"177\":2484,\"178\":2483,\"179\":2482,\"180\":2481,\"181\":2480,\"182\":2479,\"183\":2478,\"184\":2477,\"185\":2476,\"186\":2475,\"187\":2474,\"188\":2473,\"189\":2472,\"190\":2471,\"191\":2470,\"192\":2469,\"193\":2468,\"194\":2467,\"195\":2466,\"196\":2465,\"197\":2464,\"198\":2463,\"199\":2462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("219", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "281006bcec932ad61239f395cbfbb055", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "0", "[{\"id\":18168,\"batched_data\":{\"200\":2461,\"201\":2460,\"202\":2459,\"203\":2458,\"204\":2457,\"205\":2456,\"206\":2455,\"207\":2454,\"208\":2453,\"209\":2452,\"210\":2451,\"211\":2450,\"212\":2449,\"213\":2448,\"214\":2447,\"215\":2446,\"216\":2445,\"217\":2444,\"218\":2443,\"219\":2442,\"220\":2441,\"221\":2440,\"222\":2439,\"223\":2438,\"224\":2437,\"225\":2436,\"226\":2435,\"227\":2434,\"228\":2433,\"229\":2432,\"230\":2431,\"231\":2430,\"232\":2429,\"233\":2428,\"234\":2427,\"235\":2426,\"236\":2425,\"237\":2424,\"238\":2423,\"239\":2422,\"240\":2421,\"241\":2420,\"242\":2419,\"243\":2418,\"244\":2417,\"245\":2416,\"246\":2415,\"247\":2414,\"248\":2413,\"249\":2412,\"250\":2411,\"251\":2410,\"252\":2409,\"253\":2408,\"254\":2407,\"255\":2406,\"256\":2405,\"257\":2404,\"258\":2403,\"259\":2402,\"260\":2401,\"261\":2400,\"262\":2399,\"263\":2398,\"264\":2397,\"265\":2396,\"266\":2395,\"267\":2394,\"268\":2393,\"269\":2392,\"270\":2391,\"271\":2390,\"272\":2389,\"273\":2388,\"274\":2387,\"275\":2386,\"276\":2385,\"277\":2384,\"278\":2383,\"279\":2382,\"280\":2381,\"281\":2380,\"282\":2379,\"283\":2378,\"284\":2377,\"285\":2376,\"286\":2375,\"287\":2374,\"288\":2373,\"289\":2372,\"290\":2371,\"291\":2370,\"292\":2369,\"293\":2368,\"294\":2367,\"295\":2366,\"296\":2365,\"297\":2364,\"298\":2363,\"299\":2362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("220", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "c0fdfc06aa2e9faa6c02cf453d297e46", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "0", "[{\"id\":18168,\"batched_data\":{\"300\":2361,\"301\":2360,\"302\":2359,\"303\":2358,\"304\":2357,\"305\":2356,\"306\":2355,\"307\":2354,\"308\":2353,\"309\":2352,\"310\":2351,\"311\":2350,\"312\":2349,\"313\":2348,\"314\":2347,\"315\":2346,\"316\":2345,\"317\":2344,\"318\":2343,\"319\":2342,\"320\":2341,\"321\":2340,\"322\":2339,\"323\":2338,\"324\":2337,\"325\":2336,\"326\":2335,\"327\":2334,\"328\":2333,\"329\":2332,\"330\":2331,\"331\":2330,\"332\":2329,\"333\":2328,\"334\":2327,\"335\":2326,\"336\":2325,\"337\":2324,\"338\":2323,\"339\":2322,\"340\":2321,\"341\":2320,\"342\":2319,\"343\":2318,\"344\":2317,\"345\":2316,\"346\":2315,\"347\":2314,\"348\":2313,\"349\":2312,\"350\":2311,\"351\":2310,\"352\":2309,\"353\":2308,\"354\":2307,\"355\":2306,\"356\":2305,\"357\":2304,\"358\":2303,\"359\":2302,\"360\":2301,\"361\":2300,\"362\":2299,\"363\":2298,\"364\":2297,\"365\":2296,\"366\":2295,\"367\":2294,\"368\":2293,\"369\":2292,\"370\":2291,\"371\":2290,\"372\":2289,\"373\":2288,\"374\":2287,\"375\":2286,\"376\":2285,\"377\":2284,\"378\":2283,\"379\":2282,\"380\":2281,\"381\":2280,\"382\":2279,\"383\":2278,\"384\":2277,\"385\":2276,\"386\":2275,\"387\":2274,\"388\":2273,\"389\":2272,\"390\":2271,\"391\":2270,\"392\":2269,\"393\":2268,\"394\":2267,\"395\":2266,\"396\":2265,\"397\":2264,\"398\":2263,\"399\":2262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("221", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "5311ec3eb74b01c681c5eed7e13e0ee0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "0", "[{\"id\":18168,\"batched_data\":{\"400\":2261,\"401\":2260,\"402\":2259,\"403\":2258,\"404\":2257,\"405\":2256,\"406\":2255,\"407\":2254,\"408\":2253,\"409\":2252,\"410\":2251,\"411\":2250,\"412\":2249,\"413\":2248,\"414\":2247,\"415\":2246,\"416\":2245,\"417\":2244,\"418\":2243,\"419\":2242,\"420\":2241,\"421\":2240,\"422\":2239,\"423\":2238,\"424\":2237,\"425\":2236,\"426\":2235,\"427\":2234,\"428\":2233,\"429\":2232,\"430\":2231,\"431\":2230,\"432\":2229,\"433\":2228,\"434\":2227,\"435\":2226,\"436\":2225,\"437\":2224,\"438\":2223,\"439\":2222,\"440\":2221,\"441\":2220,\"442\":2219,\"443\":2218,\"444\":2217,\"445\":2216,\"446\":2215,\"447\":2214,\"448\":2213,\"449\":2212,\"450\":2211,\"451\":2210,\"452\":2209,\"453\":2208,\"454\":2207,\"455\":2206,\"456\":2205,\"457\":2204,\"458\":2203,\"459\":2202,\"460\":2201,\"461\":2200,\"462\":2199,\"463\":2198,\"464\":2197,\"465\":2196,\"466\":2195,\"467\":2194,\"468\":2193,\"469\":2192,\"470\":2191,\"471\":2190,\"472\":2189,\"473\":2188,\"474\":2187,\"475\":2186,\"476\":2185,\"477\":2184,\"478\":2183,\"479\":2182,\"480\":2181,\"481\":2180,\"482\":2179,\"483\":2178,\"484\":2177,\"485\":2176,\"486\":2175,\"487\":2174,\"488\":2173,\"489\":2172,\"490\":2171,\"491\":2170,\"492\":2169,\"493\":2168,\"494\":2167,\"495\":2166,\"496\":2165,\"497\":2164,\"498\":2163,\"499\":2162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":15500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("222", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:29", "2024-03-18 18:16:29", "[{\"id\":18168,\"offset\":16000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("223", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "bb4f55293d7005e24b93678ab2d3075f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "0", "[{\"id\":18168,\"batched_data\":[2161,2160,2159,2158,2157,2156,2155,2154,2153,2152,2151,2150,2149,2148,2147,2146,2145,2144,2143,2142,2141,2140,2139,2138,2137,2136,2135,2134,2133,2132,2131,2130,2129,2128,2127,2126,2125,2124,2123,2122,2121,2120,2119,2118,2117,2116,2115,2114,2113,2112,2111,2110,2109,2108,2107,2106,2105,2104,2103,2102,2101,2100,2099,2098,2097,2096,2095,2094,2093,2092,2091,2090,2089,2088,2087,2086,2085,2084,2083,2082,2081,2080,2079,2078,2077,2076,2075,2074,2073,2072,2071,2070,2069,2068,2067,2066,2065,2064,2063,2062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("224", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "8b40e510459d2624d1b32679c898d00a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "0", "[{\"id\":18168,\"batched_data\":{\"100\":2061,\"101\":2060,\"102\":2059,\"103\":2058,\"104\":2057,\"105\":2056,\"106\":2055,\"107\":2054,\"108\":2053,\"109\":2052,\"110\":2051,\"111\":2050,\"112\":2049,\"113\":2048,\"114\":2047,\"115\":2046,\"116\":2045,\"117\":2044,\"118\":2043,\"119\":2042,\"120\":2041,\"121\":2040,\"122\":2039,\"123\":2038,\"124\":2037,\"125\":2036,\"126\":2035,\"127\":2034,\"128\":2033,\"129\":2032,\"130\":2031,\"131\":2030,\"132\":2029,\"133\":2028,\"134\":2027,\"135\":2026,\"136\":2025,\"137\":2024,\"138\":2023,\"139\":2022,\"140\":2021,\"141\":2020,\"142\":2019,\"143\":2018,\"144\":2017,\"145\":2016,\"146\":2015,\"147\":2014,\"148\":2013,\"149\":2012,\"150\":2011,\"151\":2010,\"152\":2009,\"153\":2008,\"154\":2007,\"155\":2006,\"156\":2005,\"157\":2004,\"158\":2003,\"159\":2002,\"160\":2001,\"161\":2000,\"162\":1999,\"163\":1998,\"164\":1997,\"165\":1996,\"166\":1995,\"167\":1994,\"168\":1993,\"169\":1992,\"170\":1991,\"171\":1990,\"172\":1989,\"173\":1988,\"174\":1987,\"175\":1986,\"176\":1985,\"177\":1984,\"178\":1983,\"179\":1982,\"180\":1981,\"181\":1980,\"182\":1979,\"183\":1978,\"184\":1977,\"185\":1976,\"186\":1975,\"187\":1974,\"188\":1973,\"189\":1972,\"190\":1971,\"191\":1970,\"192\":1969,\"193\":1968,\"194\":1967,\"195\":1966,\"196\":1965,\"197\":1964,\"198\":1963,\"199\":1962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("225", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "f93d69b27b3695eb15f723b070f69c82", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "0", "[{\"id\":18168,\"batched_data\":{\"200\":1961,\"201\":1960,\"202\":1959,\"203\":1958,\"204\":1957,\"205\":1956,\"206\":1955,\"207\":1954,\"208\":1953,\"209\":1952,\"210\":1951,\"211\":1950,\"212\":1949,\"213\":1948,\"214\":1947,\"215\":1946,\"216\":1945,\"217\":1944,\"218\":1943,\"219\":1942,\"220\":1941,\"221\":1940,\"222\":1939,\"223\":1938,\"224\":1937,\"225\":1936,\"226\":1935,\"227\":1934,\"228\":1933,\"229\":1932,\"230\":1931,\"231\":1930,\"232\":1929,\"233\":1928,\"234\":1927,\"235\":1926,\"236\":1925,\"237\":1924,\"238\":1923,\"239\":1922,\"240\":1921,\"241\":1920,\"242\":1919,\"243\":1918,\"244\":1917,\"245\":1916,\"246\":1915,\"247\":1914,\"248\":1913,\"249\":1912,\"250\":1911,\"251\":1910,\"252\":1909,\"253\":1908,\"254\":1907,\"255\":1906,\"256\":1905,\"257\":1904,\"258\":1903,\"259\":1902,\"260\":1901,\"261\":1900,\"262\":1899,\"263\":1898,\"264\":1897,\"265\":1896,\"266\":1895,\"267\":1894,\"268\":1893,\"269\":1892,\"270\":1891,\"271\":1890,\"272\":1889,\"273\":1888,\"274\":1887,\"275\":1886,\"276\":1885,\"277\":1884,\"278\":1883,\"279\":1882,\"280\":1881,\"281\":1880,\"282\":1879,\"283\":1878,\"284\":1877,\"285\":1876,\"286\":1875,\"287\":1874,\"288\":1873,\"289\":1872,\"290\":1871,\"291\":1870,\"292\":1869,\"293\":1868,\"294\":1867,\"295\":1866,\"296\":1865,\"297\":1864,\"298\":1863,\"299\":1862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("226", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "5763c6de26c8a1c100f63fc8926dfa7d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "0", "[{\"id\":18168,\"batched_data\":{\"300\":1861,\"301\":1860,\"302\":1859,\"303\":1858,\"304\":1857,\"305\":1856,\"306\":1855,\"307\":1854,\"308\":1853,\"309\":1852,\"310\":1851,\"311\":1850,\"312\":1849,\"313\":1848,\"314\":1847,\"315\":1846,\"316\":1845,\"317\":1844,\"318\":1843,\"319\":1842,\"320\":1841,\"321\":1840,\"322\":1839,\"323\":1838,\"324\":1837,\"325\":1836,\"326\":1835,\"327\":1834,\"328\":1833,\"329\":1832,\"330\":1831,\"331\":1830,\"332\":1829,\"333\":1828,\"334\":1827,\"335\":1826,\"336\":1825,\"337\":1824,\"338\":1823,\"339\":1822,\"340\":1821,\"341\":1820,\"342\":1819,\"343\":1818,\"344\":1817,\"345\":1816,\"346\":1815,\"347\":1814,\"348\":1813,\"349\":1812,\"350\":1811,\"351\":1810,\"352\":1809,\"353\":1808,\"354\":1807,\"355\":1806,\"356\":1805,\"357\":1804,\"358\":1803,\"359\":1802,\"360\":1801,\"361\":1800,\"362\":1799,\"363\":1798,\"364\":1797,\"365\":1796,\"366\":1795,\"367\":1794,\"368\":1793,\"369\":1792,\"370\":1791,\"371\":1790,\"372\":1789,\"373\":1788,\"374\":1787,\"375\":1786,\"376\":1785,\"377\":1784,\"378\":1783,\"379\":1782,\"380\":1781,\"381\":1780,\"382\":1779,\"383\":1778,\"384\":1777,\"385\":1776,\"386\":1775,\"387\":1774,\"388\":1773,\"389\":1772,\"390\":1771,\"391\":1770,\"392\":1769,\"393\":1768,\"394\":1767,\"395\":1766,\"396\":1765,\"397\":1764,\"398\":1763,\"399\":1762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("227", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "002c81a77282bd1fae6ec140daf7b17e", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "0", "[{\"id\":18168,\"batched_data\":{\"400\":1761,\"401\":1760,\"402\":1759,\"403\":1758,\"404\":1757,\"405\":1756,\"406\":1755,\"407\":1754,\"408\":1753,\"409\":1752,\"410\":1751,\"411\":1750,\"412\":1749,\"413\":1748,\"414\":1747,\"415\":1746,\"416\":1745,\"417\":1744,\"418\":1743,\"419\":1742,\"420\":1741,\"421\":1740,\"422\":1739,\"423\":1738,\"424\":1737,\"425\":1736,\"426\":1735,\"427\":1734,\"428\":1733,\"429\":1732,\"430\":1731,\"431\":1730,\"432\":1729,\"433\":1728,\"434\":1727,\"435\":1726,\"436\":1725,\"437\":1724,\"438\":1723,\"439\":1722,\"440\":1721,\"441\":1720,\"442\":1719,\"443\":1718,\"444\":1717,\"445\":1716,\"446\":1715,\"447\":1714,\"448\":1713,\"449\":1712,\"450\":1711,\"451\":1710,\"452\":1709,\"453\":1708,\"454\":1707,\"455\":1706,\"456\":1705,\"457\":1704,\"458\":1703,\"459\":1702,\"460\":1701,\"461\":1700,\"462\":1699,\"463\":1698,\"464\":1697,\"465\":1696,\"466\":1695,\"467\":1694,\"468\":1693,\"469\":1692,\"470\":1691,\"471\":1690,\"472\":1689,\"473\":1688,\"474\":1687,\"475\":1686,\"476\":1685,\"477\":1684,\"478\":1683,\"479\":1682,\"480\":1681,\"481\":1680,\"482\":1679,\"483\":1678,\"484\":1677,\"485\":1676,\"486\":1675,\"487\":1674,\"488\":1673,\"489\":1672,\"490\":1671,\"491\":1670,\"492\":1669,\"493\":1668,\"494\":1667,\"495\":1666,\"496\":1665,\"497\":1664,\"498\":1663,\"499\":1662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("228", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "[{\"id\":18168,\"offset\":16500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("229", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "6580d1ffa21abf3c7d86411dd93da93d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:31", "2024-03-18 18:16:31", "0", "[{\"id\":18168,\"batched_data\":[1661,1660,1659,1658,1657,1656,1655,1654,1653,1652,1651,1650,1649,1648,1647,1646,1645,1644,1643,1642,1641,1640,1639,1638,1637,1636,1635,1634,1633,1632,1631,1630,1629,1628,1627,1626,1625,1624,1623,1622,1621,1620,1619,1618,1617,1616,1615,1614,1613,1612,1611,1610,1609,1608,1607,1606,1605,1604,1603,1602,1601,1600,1599,1598,1597,1596,1595,1594,1593,1592,1591,1590,1589,1588,1587,1586,1585,1584,1583,1582,1581,1580,1579,1578,1577,1576,1575,1574,1573,1572,1571,1570,1569,1568,1567,1566,1565,1564,1563,1562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("230", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "4608654dc58c2e7761d23fb22e3b9f1a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:31", "2024-03-18 18:16:31", "0", "[{\"id\":18168,\"batched_data\":{\"100\":1561,\"101\":1560,\"102\":1559,\"103\":1558,\"104\":1557,\"105\":1556,\"106\":1555,\"107\":1554,\"108\":1553,\"109\":1552,\"110\":1551,\"111\":1550,\"112\":1549,\"113\":1548,\"114\":1547,\"115\":1546,\"116\":1545,\"117\":1544,\"118\":1543,\"119\":1542,\"120\":1541,\"121\":1540,\"122\":1539,\"123\":1538,\"124\":1537,\"125\":1536,\"126\":1535,\"127\":1534,\"128\":1533,\"129\":1532,\"130\":1531,\"131\":1530,\"132\":1529,\"133\":1528,\"134\":1527,\"135\":1526,\"136\":1525,\"137\":1524,\"138\":1523,\"139\":1522,\"140\":1521,\"141\":1520,\"142\":1519,\"143\":1518,\"144\":1517,\"145\":1516,\"146\":1515,\"147\":1514,\"148\":1513,\"149\":1512,\"150\":1511,\"151\":1510,\"152\":1509,\"153\":1508,\"154\":1507,\"155\":1506,\"156\":1505,\"157\":1504,\"158\":1503,\"159\":1502,\"160\":1501,\"161\":1500,\"162\":1499,\"163\":1498,\"164\":1497,\"165\":1496,\"166\":1495,\"167\":1494,\"168\":1493,\"169\":1492,\"170\":1491,\"171\":1490,\"172\":1489,\"173\":1488,\"174\":1487,\"175\":1486,\"176\":1485,\"177\":1484,\"178\":1483,\"179\":1482,\"180\":1481,\"181\":1480,\"182\":1479,\"183\":1478,\"184\":1477,\"185\":1476,\"186\":1475,\"187\":1474,\"188\":1473,\"189\":1472,\"190\":1471,\"191\":1470,\"192\":1469,\"193\":1468,\"194\":1467,\"195\":1466,\"196\":1465,\"197\":1464,\"198\":1463,\"199\":1462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("231", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "eaec5da7cbe5df5178359552931d2a4f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:31", "2024-03-18 18:16:31", "0", "[{\"id\":18168,\"batched_data\":{\"200\":1461,\"201\":1460,\"202\":1459,\"203\":1458,\"204\":1457,\"205\":1456,\"206\":1455,\"207\":1454,\"208\":1453,\"209\":1452,\"210\":1451,\"211\":1450,\"212\":1449,\"213\":1448,\"214\":1447,\"215\":1446,\"216\":1445,\"217\":1444,\"218\":1443,\"219\":1442,\"220\":1441,\"221\":1440,\"222\":1439,\"223\":1438,\"224\":1437,\"225\":1436,\"226\":1435,\"227\":1434,\"228\":1433,\"229\":1432,\"230\":1431,\"231\":1430,\"232\":1429,\"233\":1428,\"234\":1427,\"235\":1426,\"236\":1425,\"237\":1424,\"238\":1423,\"239\":1422,\"240\":1421,\"241\":1420,\"242\":1419,\"243\":1418,\"244\":1417,\"245\":1416,\"246\":1415,\"247\":1414,\"248\":1413,\"249\":1412,\"250\":1411,\"251\":1410,\"252\":1409,\"253\":1408,\"254\":1407,\"255\":1406,\"256\":1405,\"257\":1404,\"258\":1403,\"259\":1402,\"260\":1401,\"261\":1400,\"262\":1399,\"263\":1398,\"264\":1397,\"265\":1396,\"266\":1395,\"267\":1394,\"268\":1393,\"269\":1392,\"270\":1391,\"271\":1390,\"272\":1389,\"273\":1388,\"274\":1387,\"275\":1386,\"276\":1385,\"277\":1384,\"278\":1383,\"279\":1382,\"280\":1381,\"281\":1380,\"282\":1379,\"283\":1378,\"284\":1377,\"285\":1376,\"286\":1375,\"287\":1374,\"288\":1373,\"289\":1372,\"290\":1371,\"291\":1370,\"292\":1369,\"293\":1368,\"294\":1367,\"295\":1366,\"296\":1365,\"297\":1364,\"298\":1363,\"299\":1362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("232", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "ec8972ffaef5913e2f21d778c687895f", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:31", "2024-03-18 18:16:31", "0", "[{\"id\":18168,\"batched_data\":{\"300\":1361,\"301\":1360,\"302\":1359,\"303\":1358,\"304\":1357,\"305\":1356,\"306\":1355,\"307\":1354,\"308\":1353,\"309\":1352,\"310\":1351,\"311\":1350,\"312\":1349,\"313\":1348,\"314\":1347,\"315\":1346,\"316\":1345,\"317\":1344,\"318\":1343,\"319\":1342,\"320\":1341,\"321\":1340,\"322\":1339,\"323\":1338,\"324\":1337,\"325\":1336,\"326\":1335,\"327\":1334,\"328\":1333,\"329\":1332,\"330\":1331,\"331\":1330,\"332\":1329,\"333\":1328,\"334\":1327,\"335\":1326,\"336\":1325,\"337\":1324,\"338\":1323,\"339\":1322,\"340\":1321,\"341\":1320,\"342\":1319,\"343\":1318,\"344\":1317,\"345\":1316,\"346\":1315,\"347\":1314,\"348\":1313,\"349\":1312,\"350\":1311,\"351\":1310,\"352\":1309,\"353\":1308,\"354\":1307,\"355\":1306,\"356\":1305,\"357\":1304,\"358\":1303,\"359\":1302,\"360\":1301,\"361\":1300,\"362\":1299,\"363\":1298,\"364\":1297,\"365\":1296,\"366\":1295,\"367\":1294,\"368\":1293,\"369\":1292,\"370\":1291,\"371\":1290,\"372\":1289,\"373\":1288,\"374\":1287,\"375\":1286,\"376\":1285,\"377\":1284,\"378\":1283,\"379\":1282,\"380\":1281,\"381\":1280,\"382\":1279,\"383\":1278,\"384\":1277,\"385\":1276,\"386\":1275,\"387\":1274,\"388\":1273,\"389\":1272,\"390\":1271,\"391\":1270,\"392\":1269,\"393\":1268,\"394\":1267,\"395\":1266,\"396\":1265,\"397\":1264,\"398\":1263,\"399\":1262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("233", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "39d84461092a53c4a1ebcd090f331b9a", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "0", "[{\"id\":18168,\"batched_data\":{\"400\":1261,\"401\":1260,\"402\":1259,\"403\":1258,\"404\":1257,\"405\":1256,\"406\":1255,\"407\":1254,\"408\":1253,\"409\":1252,\"410\":1251,\"411\":1250,\"412\":1249,\"413\":1248,\"414\":1247,\"415\":1246,\"416\":1245,\"417\":1244,\"418\":1243,\"419\":1242,\"420\":1241,\"421\":1240,\"422\":1239,\"423\":1238,\"424\":1237,\"425\":1236,\"426\":1235,\"427\":1234,\"428\":1233,\"429\":1232,\"430\":1231,\"431\":1230,\"432\":1229,\"433\":1228,\"434\":1227,\"435\":1226,\"436\":1225,\"437\":1224,\"438\":1223,\"439\":1222,\"440\":1221,\"441\":1220,\"442\":1219,\"443\":1218,\"444\":1217,\"445\":1216,\"446\":1215,\"447\":1214,\"448\":1213,\"449\":1212,\"450\":1211,\"451\":1210,\"452\":1209,\"453\":1208,\"454\":1207,\"455\":1206,\"456\":1205,\"457\":1204,\"458\":1203,\"459\":1202,\"460\":1201,\"461\":1200,\"462\":1199,\"463\":1198,\"464\":1197,\"465\":1196,\"466\":1195,\"467\":1194,\"468\":1193,\"469\":1192,\"470\":1191,\"471\":1190,\"472\":1189,\"473\":1188,\"474\":1187,\"475\":1186,\"476\":1185,\"477\":1184,\"478\":1183,\"479\":1182,\"480\":1181,\"481\":1180,\"482\":1179,\"483\":1178,\"484\":1177,\"485\":1176,\"486\":1175,\"487\":1174,\"488\":1173,\"489\":1172,\"490\":1171,\"491\":1170,\"492\":1169,\"493\":1168,\"494\":1167,\"495\":1166,\"496\":1165,\"497\":1164,\"498\":1163,\"499\":1162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":16500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("234", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:30", "2024-03-18 18:16:30", "[{\"id\":18168,\"offset\":17000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("235", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "c2b6abd33c3f1b173286e776539f6e1d", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "0", "[{\"id\":18168,\"batched_data\":[1161,1160,1159,1158,1157,1156,1155,1154,1153,1152,1151,1150,1149,1148,1147,1146,1145,1144,1143,1142,1141,1140,1139,1138,1137,1136,1135,1134,1133,1132,1131,1130,1129,1128,1127,1126,1125,1124,1123,1122,1121,1120,1119,1118,1117,1116,1115,1114,1113,1112,1111,1110,1109,1108,1107,1106,1105,1104,1103,1102,1101,1100,1099,1098,1097,1096,1095,1094,1093,1092,1091,1090,1089,1088,1087,1086,1085,1084,1083,1082,1081,1080,1079,1078,1077,1076,1075,1074,1073,1072,1071,1070,1069,1068,1067,1066,1065,1064,1063,1062],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("236", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "d133398576a0d062f16eff1908531078", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "0", "[{\"id\":18168,\"batched_data\":{\"100\":1061,\"101\":1060,\"102\":1059,\"103\":1058,\"104\":1057,\"105\":1056,\"106\":1055,\"107\":1054,\"108\":1053,\"109\":1052,\"110\":1051,\"111\":1050,\"112\":1049,\"113\":1048,\"114\":1047,\"115\":1046,\"116\":1045,\"117\":1044,\"118\":1043,\"119\":1042,\"120\":1041,\"121\":1040,\"122\":1039,\"123\":1038,\"124\":1037,\"125\":1036,\"126\":1035,\"127\":1034,\"128\":1033,\"129\":1032,\"130\":1031,\"131\":1030,\"132\":1029,\"133\":1028,\"134\":1027,\"135\":1026,\"136\":1025,\"137\":1024,\"138\":1023,\"139\":1022,\"140\":1021,\"141\":1020,\"142\":1019,\"143\":1018,\"144\":1017,\"145\":1016,\"146\":1015,\"147\":1014,\"148\":1013,\"149\":1012,\"150\":1011,\"151\":1010,\"152\":1009,\"153\":1008,\"154\":1007,\"155\":1006,\"156\":1005,\"157\":1004,\"158\":1003,\"159\":1002,\"160\":1001,\"161\":1000,\"162\":999,\"163\":998,\"164\":997,\"165\":996,\"166\":995,\"167\":994,\"168\":993,\"169\":992,\"170\":991,\"171\":990,\"172\":989,\"173\":988,\"174\":987,\"175\":986,\"176\":985,\"177\":984,\"178\":983,\"179\":982,\"180\":981,\"181\":980,\"182\":979,\"183\":978,\"184\":977,\"185\":976,\"186\":975,\"187\":974,\"188\":973,\"189\":972,\"190\":971,\"191\":970,\"192\":969,\"193\":968,\"194\":967,\"195\":966,\"196\":965,\"197\":964,\"198\":963,\"199\":962},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("237", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "e5408cf8b3d0b4eafef09c53be1e59d0", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "0", "[{\"id\":18168,\"batched_data\":{\"200\":961,\"201\":960,\"202\":959,\"203\":958,\"204\":957,\"205\":956,\"206\":955,\"207\":954,\"208\":953,\"209\":952,\"210\":951,\"211\":950,\"212\":949,\"213\":948,\"214\":947,\"215\":946,\"216\":945,\"217\":944,\"218\":943,\"219\":942,\"220\":941,\"221\":940,\"222\":939,\"223\":938,\"224\":937,\"225\":936,\"226\":935,\"227\":934,\"228\":933,\"229\":932,\"230\":931,\"231\":930,\"232\":929,\"233\":928,\"234\":927,\"235\":926,\"236\":925,\"237\":924,\"238\":923,\"239\":922,\"240\":921,\"241\":920,\"242\":919,\"243\":918,\"244\":917,\"245\":916,\"246\":915,\"247\":914,\"248\":913,\"249\":912,\"250\":911,\"251\":910,\"252\":909,\"253\":908,\"254\":907,\"255\":906,\"256\":905,\"257\":904,\"258\":903,\"259\":902,\"260\":901,\"261\":900,\"262\":899,\"263\":898,\"264\":897,\"265\":896,\"266\":895,\"267\":894,\"268\":893,\"269\":892,\"270\":891,\"271\":890,\"272\":889,\"273\":888,\"274\":887,\"275\":886,\"276\":885,\"277\":884,\"278\":883,\"279\":882,\"280\":881,\"281\":880,\"282\":879,\"283\":878,\"284\":877,\"285\":876,\"286\":875,\"287\":874,\"288\":873,\"289\":872,\"290\":871,\"291\":870,\"292\":869,\"293\":868,\"294\":867,\"295\":866,\"296\":865,\"297\":864,\"298\":863,\"299\":862},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("238", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "ad5dce5a2e999ea8ef3521943c37d824", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "0", "[{\"id\":18168,\"batched_data\":{\"300\":861,\"301\":860,\"302\":859,\"303\":858,\"304\":857,\"305\":856,\"306\":855,\"307\":854,\"308\":853,\"309\":852,\"310\":851,\"311\":850,\"312\":849,\"313\":848,\"314\":847,\"315\":846,\"316\":845,\"317\":844,\"318\":843,\"319\":842,\"320\":841,\"321\":840,\"322\":839,\"323\":838,\"324\":837,\"325\":836,\"326\":835,\"327\":834,\"328\":833,\"329\":832,\"330\":831,\"331\":830,\"332\":829,\"333\":828,\"334\":827,\"335\":826,\"336\":825,\"337\":824,\"338\":823,\"339\":822,\"340\":821,\"341\":820,\"342\":819,\"343\":818,\"344\":817,\"345\":816,\"346\":815,\"347\":814,\"348\":813,\"349\":812,\"350\":811,\"351\":810,\"352\":809,\"353\":808,\"354\":807,\"355\":806,\"356\":805,\"357\":804,\"358\":803,\"359\":802,\"360\":801,\"361\":800,\"362\":799,\"363\":798,\"364\":797,\"365\":796,\"366\":795,\"367\":794,\"368\":793,\"369\":792,\"370\":791,\"371\":790,\"372\":789,\"373\":788,\"374\":787,\"375\":786,\"376\":785,\"377\":784,\"378\":783,\"379\":782,\"380\":781,\"381\":780,\"382\":779,\"383\":778,\"384\":777,\"385\":776,\"386\":775,\"387\":774,\"388\":773,\"389\":772,\"390\":771,\"391\":770,\"392\":769,\"393\":768,\"394\":767,\"395\":766,\"396\":765,\"397\":764,\"398\":763,\"399\":762},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("239", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "e01ecb7f69346eb755707b67cd2bb785", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "0", "[{\"id\":18168,\"batched_data\":{\"400\":761,\"401\":760,\"402\":759,\"403\":758,\"404\":757,\"405\":756,\"406\":755,\"407\":754,\"408\":753,\"409\":752,\"410\":751,\"411\":750,\"412\":749,\"413\":748,\"414\":747,\"415\":746,\"416\":745,\"417\":744,\"418\":743,\"419\":742,\"420\":741,\"421\":740,\"422\":739,\"423\":738,\"424\":737,\"425\":736,\"426\":735,\"427\":734,\"428\":733,\"429\":732,\"430\":731,\"431\":730,\"432\":729,\"433\":728,\"434\":727,\"435\":726,\"436\":725,\"437\":724,\"438\":723,\"439\":722,\"440\":721,\"441\":720,\"442\":719,\"443\":718,\"444\":717,\"445\":716,\"446\":715,\"447\":714,\"448\":713,\"449\":712,\"450\":711,\"451\":710,\"452\":709,\"453\":708,\"454\":707,\"455\":706,\"456\":705,\"457\":704,\"458\":703,\"459\":702,\"460\":701,\"461\":700,\"462\":699,\"463\":698,\"464\":697,\"465\":696,\"466\":695,\"467\":694,\"468\":693,\"469\":692,\"470\":691,\"471\":690,\"472\":689,\"473\":688,\"474\":687,\"475\":686,\"476\":685,\"477\":684,\"478\":683,\"479\":682,\"480\":681,\"481\":680,\"482\":679,\"483\":678,\"484\":677,\"485\":676,\"486\":675,\"487\":674,\"488\":673,\"489\":672,\"490\":671,\"491\":670,\"492\":669,\"493\":668,\"494\":667,\"495\":666,\"496\":665,\"497\":664,\"498\":663,\"499\":662},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("240", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:32", "2024-03-18 18:16:32", "[{\"id\":18168,\"offset\":17500,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("241", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "e10f8dabee6e4efc317697634a0b021c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "0", "[{\"id\":18168,\"batched_data\":[661,660,659,658,657,656,655,654,653,652,651,650,649,648,647,646,645,644,643,642,641,640,639,638,637,636,635,634,633,632,631,630,629,628,627,626,625,624,623,622,621,620,619,618,617,616,615,614,613,612,611,610,609,608,607,606,605,604,603,602,601,600,599,598,597,596,595,594,593,592,591,590,589,588,587,586,585,584,583,582,581,580,579,578,577,576,575,574,573,572,571,570,569,568,567,566,565,564,563,562],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("242", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "d5789c87f15d74c7e52002d251ae306c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "0", "[{\"id\":18168,\"batched_data\":{\"100\":561,\"101\":560,\"102\":559,\"103\":558,\"104\":557,\"105\":556,\"106\":555,\"107\":554,\"108\":553,\"109\":552,\"110\":551,\"111\":550,\"112\":549,\"113\":548,\"114\":547,\"115\":546,\"116\":545,\"117\":544,\"118\":543,\"119\":542,\"120\":541,\"121\":540,\"122\":539,\"123\":538,\"124\":537,\"125\":536,\"126\":535,\"127\":534,\"128\":533,\"129\":532,\"130\":531,\"131\":530,\"132\":529,\"133\":528,\"134\":527,\"135\":526,\"136\":525,\"137\":524,\"138\":523,\"139\":522,\"140\":521,\"141\":520,\"142\":519,\"143\":518,\"144\":517,\"145\":516,\"146\":515,\"147\":514,\"148\":513,\"149\":512,\"150\":511,\"151\":510,\"152\":509,\"153\":508,\"154\":507,\"155\":506,\"156\":505,\"157\":504,\"158\":503,\"159\":502,\"160\":501,\"161\":500,\"162\":499,\"163\":498,\"164\":497,\"165\":496,\"166\":495,\"167\":494,\"168\":493,\"169\":492,\"170\":491,\"171\":490,\"172\":489,\"173\":488,\"174\":487,\"175\":486,\"176\":485,\"177\":484,\"178\":483,\"179\":482,\"180\":481,\"181\":480,\"182\":479,\"183\":478,\"184\":477,\"185\":476,\"186\":475,\"187\":474,\"188\":473,\"189\":472,\"190\":471,\"191\":470,\"192\":469,\"193\":468,\"194\":467,\"195\":466,\"196\":465,\"197\":464,\"198\":463,\"199\":462},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("243", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "52e6be9f9049c5553a34d6d47dc94806", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "0", "[{\"id\":18168,\"batched_data\":{\"200\":461,\"201\":460,\"202\":459,\"203\":458,\"204\":457,\"205\":456,\"206\":455,\"207\":454,\"208\":453,\"209\":452,\"210\":451,\"211\":450,\"212\":449,\"213\":448,\"214\":447,\"215\":446,\"216\":445,\"217\":444,\"218\":443,\"219\":442,\"220\":441,\"221\":440,\"222\":439,\"223\":438,\"224\":437,\"225\":436,\"226\":435,\"227\":434,\"228\":433,\"229\":432,\"230\":431,\"231\":430,\"232\":429,\"233\":428,\"234\":427,\"235\":426,\"236\":425,\"237\":424,\"238\":423,\"239\":422,\"240\":421,\"241\":420,\"242\":419,\"243\":418,\"244\":417,\"245\":416,\"246\":415,\"247\":414,\"248\":413,\"249\":412,\"250\":411,\"251\":410,\"252\":409,\"253\":408,\"254\":407,\"255\":406,\"256\":405,\"257\":404,\"258\":403,\"259\":402,\"260\":401,\"261\":400,\"262\":399,\"263\":398,\"264\":397,\"265\":396,\"266\":395,\"267\":394,\"268\":393,\"269\":392,\"270\":391,\"271\":390,\"272\":389,\"273\":388,\"274\":387,\"275\":386,\"276\":385,\"277\":384,\"278\":383,\"279\":382,\"280\":381,\"281\":380,\"282\":379,\"283\":378,\"284\":377,\"285\":376,\"286\":375,\"287\":374,\"288\":373,\"289\":372,\"290\":371,\"291\":370,\"292\":369,\"293\":368,\"294\":367,\"295\":366,\"296\":365,\"297\":364,\"298\":363,\"299\":362},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("244", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "f73a68b5ba2f8a950d8e05810d4de266", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "0", "[{\"id\":18168,\"batched_data\":{\"300\":361,\"301\":360,\"302\":359,\"303\":358,\"304\":357,\"305\":356,\"306\":355,\"307\":354,\"308\":353,\"309\":352,\"310\":351,\"311\":350,\"312\":349,\"313\":348,\"314\":347,\"315\":346,\"316\":345,\"317\":344,\"318\":343,\"319\":342,\"320\":341,\"321\":340,\"322\":339,\"323\":338,\"324\":337,\"325\":336,\"326\":335,\"327\":334,\"328\":333,\"329\":332,\"330\":331,\"331\":330,\"332\":329,\"333\":328,\"334\":327,\"335\":326,\"336\":325,\"337\":324,\"338\":323,\"339\":322,\"340\":321,\"341\":320,\"342\":319,\"343\":318,\"344\":317,\"345\":316,\"346\":315,\"347\":314,\"348\":313,\"349\":312,\"350\":311,\"351\":310,\"352\":309,\"353\":308,\"354\":307,\"355\":306,\"356\":305,\"357\":304,\"358\":303,\"359\":302,\"360\":301,\"361\":300,\"362\":299,\"363\":298,\"364\":297,\"365\":296,\"366\":295,\"367\":294,\"368\":293,\"369\":292,\"370\":291,\"371\":290,\"372\":289,\"373\":288,\"374\":287,\"375\":286,\"376\":285,\"377\":284,\"378\":283,\"379\":282,\"380\":281,\"381\":280,\"382\":279,\"383\":278,\"384\":277,\"385\":276,\"386\":275,\"387\":274,\"388\":273,\"389\":272,\"390\":271,\"391\":270,\"392\":269,\"393\":268,\"394\":267,\"395\":266,\"396\":265,\"397\":264,\"398\":263,\"399\":262},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("245", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "6d8df6eff1c7f11b14730ec32a8867cb", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:34", "2024-03-18 18:16:34", "0", "[{\"id\":18168,\"batched_data\":{\"400\":261,\"401\":260,\"402\":259,\"403\":258,\"404\":257,\"405\":256,\"406\":255,\"407\":254,\"408\":253,\"409\":252,\"410\":251,\"411\":250,\"412\":249,\"413\":248,\"414\":247,\"415\":246,\"416\":245,\"417\":244,\"418\":243,\"419\":242,\"420\":241,\"421\":240,\"422\":239,\"423\":238,\"424\":237,\"425\":236,\"426\":235,\"427\":234,\"428\":233,\"429\":232,\"430\":231,\"431\":230,\"432\":229,\"433\":228,\"434\":227,\"435\":226,\"436\":225,\"437\":224,\"438\":223,\"439\":222,\"440\":221,\"441\":220,\"442\":219,\"443\":218,\"444\":217,\"445\":216,\"446\":215,\"447\":214,\"448\":213,\"449\":212,\"450\":211,\"451\":210,\"452\":209,\"453\":208,\"454\":207,\"455\":206,\"456\":205,\"457\":204,\"458\":203,\"459\":202,\"460\":201,\"461\":200,\"462\":199,\"463\":198,\"464\":197,\"465\":196,\"466\":195,\"467\":194,\"468\":193,\"469\":192,\"470\":191,\"471\":190,\"472\":189,\"473\":188,\"474\":187,\"475\":186,\"476\":185,\"477\":184,\"478\":183,\"479\":182,\"480\":181,\"481\":180,\"482\":179,\"483\":178,\"484\":177,\"485\":176,\"486\":175,\"487\":174,\"488\":173,\"489\":172,\"490\":171,\"491\":170,\"492\":169,\"493\":168,\"494\":167,\"495\":166,\"496\":165,\"497\":164,\"498\":163,\"499\":162},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":17500}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("246", "ilj_set_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:33", "2024-03-18 18:16:33", "[{\"id\":18168,\"offset\":18000,\"start_time\":1710785744.820649,\"type\":\"post\",\"build_type\":\"post\",\"link_type\":\"incoming\"}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:34", "2024-03-18 18:16:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("247", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:34", "2024-03-18 18:16:34", "ebbc2525d2ff564674cb2d3604beac18", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:34", "2024-03-18 18:16:34", "0", "[{\"id\":18168,\"batched_data\":[161,160,159,158,157,156,155,154,153,152,151,150,149,148,147,146,145,144,143,142,141,140,139,138,137,136,135,134,133,132,131,130,129,128,127,126,125,124,123,122,121,120,119,118,117,116,115,114,113,112,111,110,109,108,107,106,105,104,103,102,101,100,99,98,97,96,95,94,93,92,91,90,89,88,87,86,85,84,83,82,81,80,79,78,77,76,75,74,73,72,71,70,69,68,67,66,65,64,63,62],\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":18000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("248", "ilj_individual_index_rebuild_incoming", "complete", "2024-03-18 18:16:34", "2024-03-18 18:16:34", "1477d86a98410c576bdf22441299dce3", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:34", "2024-03-18 18:16:34", "0", "[{\"id\":18168,\"batched_data\":{\"100\":61,\"101\":60,\"102\":59,\"103\":58,\"104\":57,\"105\":56,\"106\":55,\"107\":54,\"108\":53,\"109\":52,\"110\":51,\"111\":50,\"112\":49,\"113\":48,\"114\":47,\"115\":46,\"116\":45,\"117\":44,\"118\":43,\"119\":42,\"120\":41,\"121\":40,\"122\":39,\"123\":38,\"124\":37,\"125\":36,\"126\":35,\"127\":34,\"128\":33,\"129\":32,\"130\":31,\"131\":30,\"132\":29,\"133\":27,\"134\":26,\"135\":24,\"136\":23,\"137\":19,\"138\":18,\"139\":17,\"140\":3},\"batched_data_type\":\"post\",\"type\":\"post\",\"build_type\":\"post\",\"start_time\":1710785744.820649,\"link_type\":\"incoming\",\"offset\":18000}]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("249", "ilj_update_statistics_info", "complete", "2024-03-18 18:16:34", "2024-03-18 18:16:34", "[{\"switch\":false}]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2024-03-18 18:16:34", "2024-03-18 18:16:34", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "ilj_async_link_index");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("61", "30", "action created", "2024-03-18 18:15:29", "2024-03-18 18:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("62", "30", "action started via WP Cron", "2024-03-18 18:15:44", "2024-03-18 18:15:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("63", "31", "action created", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("64", "32", "action created", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("65", "33", "action created", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("66", "34", "action created", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("67", "35", "action created", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("68", "36", "action created", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("69", "30", "action complete via WP Cron", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("70", "31", "action started via WP Cron", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("71", "31", "action complete via WP Cron", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("72", "32", "action started via WP Cron", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("73", "32", "action complete via WP Cron", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("74", "33", "action started via WP Cron", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("75", "33", "action complete via WP Cron", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("76", "34", "action started via WP Cron", "2024-03-18 18:15:45", "2024-03-18 18:15:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("77", "34", "action complete via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("78", "35", "action started via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("79", "35", "action complete via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("80", "36", "action started via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("81", "37", "action created", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("82", "38", "action created", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("83", "39", "action created", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("84", "40", "action created", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("85", "41", "action created", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("86", "42", "action created", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("87", "36", "action complete via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("88", "37", "action started via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("89", "37", "action complete via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("90", "38", "action started via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("91", "38", "action complete via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("92", "39", "action started via WP Cron", "2024-03-18 18:15:46", "2024-03-18 18:15:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("93", "39", "action complete via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("94", "40", "action started via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("95", "40", "action complete via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("96", "41", "action started via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("97", "41", "action complete via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("98", "42", "action started via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("99", "43", "action created", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("100", "44", "action created", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("101", "45", "action created", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("102", "46", "action created", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("103", "47", "action created", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("104", "48", "action created", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("105", "42", "action complete via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("106", "43", "action started via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("107", "43", "action complete via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("108", "44", "action started via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("109", "44", "action complete via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("110", "45", "action started via WP Cron", "2024-03-18 18:15:47", "2024-03-18 18:15:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("111", "45", "action complete via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("112", "46", "action started via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("113", "46", "action complete via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("114", "47", "action started via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("115", "47", "action complete via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("116", "48", "action started via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("117", "49", "action created", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("118", "50", "action created", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("119", "51", "action created", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("120", "52", "action created", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("121", "53", "action created", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("122", "54", "action created", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("123", "48", "action complete via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("124", "49", "action started via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("125", "49", "action complete via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("126", "50", "action started via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("127", "50", "action complete via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("128", "51", "action started via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("129", "51", "action complete via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("130", "52", "action started via WP Cron", "2024-03-18 18:15:48", "2024-03-18 18:15:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("131", "52", "action complete via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("132", "53", "action started via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("133", "53", "action complete via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("134", "54", "action started via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("135", "55", "action created", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("136", "56", "action created", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("137", "57", "action created", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("138", "58", "action created", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("139", "59", "action created", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("140", "60", "action created", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("141", "54", "action complete via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("142", "55", "action started via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("143", "55", "action complete via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("144", "56", "action started via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("145", "56", "action complete via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("146", "57", "action started via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("147", "57", "action complete via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("148", "58", "action started via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("149", "58", "action complete via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("150", "59", "action started via WP Cron", "2024-03-18 18:15:49", "2024-03-18 18:15:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("151", "59", "action complete via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("152", "60", "action started via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("153", "61", "action created", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("154", "62", "action created", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("155", "63", "action created", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("156", "64", "action created", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("157", "65", "action created", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("158", "66", "action created", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("159", "60", "action complete via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("160", "61", "action started via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("161", "61", "action complete via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("162", "62", "action started via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("163", "62", "action complete via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("164", "63", "action started via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("165", "63", "action complete via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("166", "64", "action started via WP Cron", "2024-03-18 18:15:50", "2024-03-18 18:15:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("167", "64", "action complete via WP Cron", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("168", "65", "action started via WP Cron", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("169", "65", "action complete via WP Cron", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("170", "66", "action started via WP Cron", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("171", "67", "action created", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("172", "68", "action created", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("173", "69", "action created", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("174", "70", "action created", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("175", "71", "action created", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("176", "72", "action created", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("177", "66", "action complete via WP Cron", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("178", "67", "action started via WP Cron", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("179", "67", "action complete via WP Cron", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("180", "68", "action started via WP Cron", "2024-03-18 18:15:51", "2024-03-18 18:15:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("181", "68", "action complete via WP Cron", "2024-03-18 18:15:53", "2024-03-18 18:15:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("182", "69", "action started via WP Cron", "2024-03-18 18:15:53", "2024-03-18 18:15:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("183", "69", "action complete via WP Cron", "2024-03-18 18:15:53", "2024-03-18 18:15:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("184", "70", "action started via WP Cron", "2024-03-18 18:15:53", "2024-03-18 18:15:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("185", "70", "action complete via WP Cron", "2024-03-18 18:15:53", "2024-03-18 18:15:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("186", "71", "action started via WP Cron", "2024-03-18 18:15:53", "2024-03-18 18:15:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("187", "71", "action complete via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("188", "72", "action started via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("189", "73", "action created", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("190", "74", "action created", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("191", "75", "action created", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("192", "76", "action created", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("193", "77", "action created", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("194", "78", "action created", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("195", "72", "action complete via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("196", "73", "action started via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("197", "73", "action complete via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("198", "74", "action started via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("199", "74", "action complete via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("200", "75", "action started via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("201", "75", "action complete via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("202", "76", "action started via WP Cron", "2024-03-18 18:15:54", "2024-03-18 18:15:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("203", "76", "action complete via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("204", "77", "action started via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("205", "77", "action complete via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("206", "78", "action started via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("207", "79", "action created", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("208", "80", "action created", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("209", "81", "action created", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("210", "82", "action created", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("211", "83", "action created", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("212", "84", "action created", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("213", "78", "action complete via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("214", "79", "action started via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("215", "79", "action complete via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("216", "80", "action started via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("217", "80", "action complete via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("218", "81", "action started via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("219", "81", "action complete via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("220", "82", "action started via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("221", "82", "action complete via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("222", "83", "action started via WP Cron", "2024-03-18 18:15:55", "2024-03-18 18:15:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("223", "83", "action complete via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("224", "84", "action started via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("225", "85", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("226", "86", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("227", "87", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("228", "88", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("229", "89", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("230", "90", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("231", "84", "action complete via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("232", "85", "action started via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("233", "85", "action complete via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("234", "86", "action started via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("235", "86", "action complete via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("236", "87", "action started via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("237", "87", "action complete via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("238", "88", "action started via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("239", "88", "action complete via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("240", "89", "action started via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("241", "89", "action complete via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("242", "90", "action started via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("243", "91", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("244", "92", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("245", "93", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("246", "94", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("247", "95", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("248", "96", "action created", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("249", "90", "action complete via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("250", "91", "action started via WP Cron", "2024-03-18 18:15:56", "2024-03-18 18:15:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("251", "91", "action complete via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("252", "92", "action started via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("253", "92", "action complete via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("254", "93", "action started via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("255", "93", "action complete via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("256", "94", "action started via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("257", "94", "action complete via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("258", "95", "action started via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("259", "95", "action complete via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("260", "96", "action started via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("261", "97", "action created", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("262", "98", "action created", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("263", "99", "action created", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("264", "100", "action created", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("265", "101", "action created", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("266", "102", "action created", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("267", "96", "action complete via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("268", "97", "action started via WP Cron", "2024-03-18 18:15:57", "2024-03-18 18:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("269", "97", "action complete via WP Cron", "2024-03-18 18:15:58", "2024-03-18 18:15:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("270", "98", "action started via WP Cron", "2024-03-18 18:15:58", "2024-03-18 18:15:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("271", "98", "action complete via WP Cron", "2024-03-18 18:15:58", "2024-03-18 18:15:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("272", "99", "action started via WP Cron", "2024-03-18 18:15:58", "2024-03-18 18:15:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("273", "99", "action complete via WP Cron", "2024-03-18 18:15:58", "2024-03-18 18:15:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("274", "100", "action started via WP Cron", "2024-03-18 18:15:58", "2024-03-18 18:15:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("275", "100", "action complete via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("276", "101", "action started via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("277", "101", "action complete via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("278", "102", "action started via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("279", "103", "action created", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("280", "104", "action created", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("281", "105", "action created", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("282", "106", "action created", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("283", "107", "action created", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("284", "108", "action created", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("285", "102", "action complete via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("286", "103", "action started via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("287", "103", "action complete via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("288", "104", "action started via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("289", "104", "action complete via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("290", "105", "action started via WP Cron", "2024-03-18 18:15:59", "2024-03-18 18:15:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("291", "105", "action complete via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("292", "106", "action started via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("293", "106", "action complete via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("294", "107", "action started via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("295", "107", "action complete via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("296", "108", "action started via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("297", "109", "action created", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("298", "110", "action created", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("299", "111", "action created", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("300", "112", "action created", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("301", "113", "action created", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("302", "114", "action created", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("303", "108", "action complete via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("304", "109", "action started via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("305", "109", "action complete via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("306", "110", "action started via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("307", "110", "action complete via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("308", "111", "action started via WP Cron", "2024-03-18 18:16:00", "2024-03-18 18:16:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("309", "111", "action complete via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("310", "112", "action started via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("311", "112", "action complete via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("312", "113", "action started via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("313", "113", "action complete via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("314", "114", "action started via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("315", "115", "action created", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("316", "116", "action created", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("317", "117", "action created", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("318", "118", "action created", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("319", "119", "action created", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("320", "120", "action created", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("321", "114", "action complete via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("322", "115", "action started via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("323", "115", "action complete via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("324", "116", "action started via WP Cron", "2024-03-18 18:16:01", "2024-03-18 18:16:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("325", "116", "action complete via WP Cron", "2024-03-18 18:16:02", "2024-03-18 18:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("326", "117", "action started via WP Cron", "2024-03-18 18:16:02", "2024-03-18 18:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("327", "117", "action complete via WP Cron", "2024-03-18 18:16:02", "2024-03-18 18:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("328", "118", "action started via WP Cron", "2024-03-18 18:16:02", "2024-03-18 18:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("329", "118", "action complete via WP Cron", "2024-03-18 18:16:02", "2024-03-18 18:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("330", "119", "action started via WP Cron", "2024-03-18 18:16:02", "2024-03-18 18:16:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("331", "119", "action complete via WP Cron", "2024-03-18 18:16:03", "2024-03-18 18:16:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("332", "120", "action started via WP Cron", "2024-03-18 18:16:03", "2024-03-18 18:16:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("333", "121", "action created", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("334", "122", "action created", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("335", "123", "action created", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("336", "124", "action created", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("337", "125", "action created", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("338", "126", "action created", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("339", "120", "action complete via WP Cron", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("340", "121", "action started via WP Cron", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("341", "121", "action complete via WP Cron", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("342", "122", "action started via WP Cron", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("343", "122", "action complete via WP Cron", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("344", "123", "action started via WP Cron", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("345", "123", "action complete via WP Cron", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("346", "124", "action started via WP Cron", "2024-03-18 18:16:04", "2024-03-18 18:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("347", "124", "action complete via WP Cron", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("348", "125", "action started via WP Cron", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("349", "125", "action complete via WP Cron", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("350", "126", "action started via WP Cron", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("351", "127", "action created", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("352", "128", "action created", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("353", "129", "action created", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("354", "130", "action created", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("355", "131", "action created", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("356", "132", "action created", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("357", "126", "action complete via WP Cron", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("358", "127", "action started via WP Cron", "2024-03-18 18:16:05", "2024-03-18 18:16:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("359", "127", "action complete via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("360", "128", "action started via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("361", "128", "action complete via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("362", "129", "action started via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("363", "129", "action complete via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("364", "130", "action started via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("365", "130", "action complete via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("366", "131", "action started via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("367", "131", "action complete via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("368", "132", "action started via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("369", "133", "action created", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("370", "134", "action created", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("371", "135", "action created", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("372", "136", "action created", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("373", "137", "action created", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("374", "138", "action created", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("375", "132", "action complete via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("376", "133", "action started via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("377", "133", "action complete via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("378", "134", "action started via WP Cron", "2024-03-18 18:16:06", "2024-03-18 18:16:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("379", "134", "action complete via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("380", "135", "action started via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("381", "135", "action complete via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("382", "136", "action started via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("383", "136", "action complete via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("384", "137", "action started via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("385", "137", "action complete via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("386", "138", "action started via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("387", "139", "action created", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("388", "140", "action created", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("389", "141", "action created", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("390", "142", "action created", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("391", "143", "action created", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("392", "144", "action created", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("393", "138", "action complete via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("394", "139", "action started via WP Cron", "2024-03-18 18:16:07", "2024-03-18 18:16:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("395", "139", "action complete via WP Cron", "2024-03-18 18:16:08", "2024-03-18 18:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("396", "140", "action started via WP Cron", "2024-03-18 18:16:08", "2024-03-18 18:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("397", "140", "action complete via WP Cron", "2024-03-18 18:16:08", "2024-03-18 18:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("398", "141", "action started via WP Cron", "2024-03-18 18:16:08", "2024-03-18 18:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("399", "141", "action complete via WP Cron", "2024-03-18 18:16:08", "2024-03-18 18:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("400", "142", "action started via WP Cron", "2024-03-18 18:16:08", "2024-03-18 18:16:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("401", "142", "action complete via WP Cron", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("402", "143", "action started via WP Cron", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("403", "143", "action complete via WP Cron", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("404", "144", "action started via WP Cron", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("405", "145", "action created", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("406", "146", "action created", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("407", "147", "action created", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("408", "148", "action created", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("409", "149", "action created", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("410", "150", "action created", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("411", "144", "action complete via WP Cron", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("412", "145", "action started via WP Cron", "2024-03-18 18:16:09", "2024-03-18 18:16:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("413", "145", "action complete via WP Cron", "2024-03-18 18:16:10", "2024-03-18 18:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("414", "146", "action started via WP Cron", "2024-03-18 18:16:10", "2024-03-18 18:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("415", "146", "action complete via WP Cron", "2024-03-18 18:16:10", "2024-03-18 18:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("416", "147", "action started via WP Cron", "2024-03-18 18:16:10", "2024-03-18 18:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("417", "147", "action complete via WP Cron", "2024-03-18 18:16:10", "2024-03-18 18:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("418", "148", "action started via WP Cron", "2024-03-18 18:16:10", "2024-03-18 18:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("419", "148", "action complete via WP Cron", "2024-03-18 18:16:10", "2024-03-18 18:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("420", "149", "action started via WP Cron", "2024-03-18 18:16:10", "2024-03-18 18:16:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("421", "149", "action complete via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("422", "150", "action started via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("423", "151", "action created", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("424", "152", "action created", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("425", "153", "action created", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("426", "154", "action created", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("427", "155", "action created", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("428", "156", "action created", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("429", "150", "action complete via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("430", "151", "action started via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("431", "151", "action complete via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("432", "152", "action started via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("433", "152", "action complete via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("434", "153", "action started via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("435", "153", "action complete via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("436", "154", "action started via WP Cron", "2024-03-18 18:16:11", "2024-03-18 18:16:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("437", "154", "action complete via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("438", "155", "action started via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("439", "155", "action complete via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("440", "156", "action started via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("441", "157", "action created", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("442", "158", "action created", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("443", "159", "action created", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("444", "160", "action created", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("445", "161", "action created", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("446", "162", "action created", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("447", "156", "action complete via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("448", "157", "action started via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("449", "157", "action complete via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("450", "158", "action started via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("451", "158", "action complete via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("452", "159", "action started via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("453", "159", "action complete via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("454", "160", "action started via WP Cron", "2024-03-18 18:16:12", "2024-03-18 18:16:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("455", "160", "action complete via WP Cron", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("456", "161", "action started via WP Cron", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("457", "161", "action complete via WP Cron", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("458", "162", "action started via WP Cron", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("459", "163", "action created", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("460", "164", "action created", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("461", "165", "action created", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("462", "166", "action created", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("463", "167", "action created", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("464", "168", "action created", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("465", "162", "action complete via WP Cron", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("466", "163", "action started via WP Cron", "2024-03-18 18:16:13", "2024-03-18 18:16:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("467", "163", "action complete via WP Cron", "2024-03-18 18:16:14", "2024-03-18 18:16:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("468", "164", "action started via Async Request", "2024-03-18 18:16:20", "2024-03-18 18:16:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("469", "164", "action complete via Async Request", "2024-03-18 18:16:21", "2024-03-18 18:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("470", "165", "action started via Async Request", "2024-03-18 18:16:21", "2024-03-18 18:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("471", "165", "action complete via Async Request", "2024-03-18 18:16:21", "2024-03-18 18:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("472", "166", "action started via Async Request", "2024-03-18 18:16:21", "2024-03-18 18:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("473", "166", "action complete via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("474", "167", "action started via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("475", "167", "action complete via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("476", "168", "action started via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("477", "169", "action created", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("478", "170", "action created", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("479", "171", "action created", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("480", "172", "action created", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("481", "173", "action created", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("482", "174", "action created", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("483", "168", "action complete via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("484", "169", "action started via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("485", "169", "action complete via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("486", "170", "action started via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("487", "170", "action complete via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("488", "171", "action started via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("489", "171", "action complete via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("490", "172", "action started via Async Request", "2024-03-18 18:16:22", "2024-03-18 18:16:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("491", "172", "action complete via Async Request", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("492", "173", "action started via Async Request", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("493", "173", "action complete via Async Request", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("494", "174", "action started via Async Request", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("495", "175", "action created", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("496", "176", "action created", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("497", "177", "action created", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("498", "178", "action created", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("499", "179", "action created", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("500", "180", "action created", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("501", "174", "action complete via Async Request", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("502", "175", "action started via Async Request", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("503", "175", "action complete via Async Request", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("504", "176", "action started via Async Request", "2024-03-18 18:16:23", "2024-03-18 18:16:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("505", "176", "action complete via Async Request", "2024-03-18 18:16:24", "2024-03-18 18:16:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("506", "177", "action started via Async Request", "2024-03-18 18:16:24", "2024-03-18 18:16:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("507", "177", "action complete via Async Request", "2024-03-18 18:16:24", "2024-03-18 18:16:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("508", "178", "action started via Async Request", "2024-03-18 18:16:24", "2024-03-18 18:16:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("509", "178", "action complete via Async Request", "2024-03-18 18:16:24", "2024-03-18 18:16:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("510", "179", "action started via Async Request", "2024-03-18 18:16:24", "2024-03-18 18:16:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("511", "179", "action complete via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("512", "180", "action started via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("513", "181", "action created", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("514", "182", "action created", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("515", "183", "action created", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("516", "184", "action created", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("517", "185", "action created", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("518", "186", "action created", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("519", "180", "action complete via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("520", "181", "action started via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("521", "181", "action complete via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("522", "182", "action started via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("523", "182", "action complete via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("524", "183", "action started via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("525", "183", "action complete via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("526", "184", "action started via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("527", "184", "action complete via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("528", "185", "action started via Async Request", "2024-03-18 18:16:25", "2024-03-18 18:16:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("529", "185", "action complete via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("530", "186", "action started via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("531", "187", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("532", "188", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("533", "189", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("534", "190", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("535", "191", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("536", "192", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("537", "186", "action complete via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("538", "187", "action started via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("539", "187", "action complete via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("540", "188", "action started via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("541", "188", "action complete via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("542", "189", "action started via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("543", "189", "action complete via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("544", "190", "action started via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("545", "190", "action complete via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("546", "191", "action started via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("547", "191", "action complete via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("548", "192", "action started via Async Request", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("549", "193", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("550", "194", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("551", "195", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("552", "196", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("553", "197", "action created", "2024-03-18 18:16:26", "2024-03-18 18:16:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("554", "198", "action created", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("555", "192", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("556", "193", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("557", "193", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("558", "194", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("559", "194", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("560", "195", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("561", "195", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("562", "196", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("563", "196", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("564", "197", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("565", "197", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("566", "198", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("567", "199", "action created", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("568", "200", "action created", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("569", "201", "action created", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("570", "202", "action created", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("571", "203", "action created", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("572", "204", "action created", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("573", "198", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("574", "199", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("575", "199", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("576", "200", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("577", "200", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("578", "201", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("579", "201", "action complete via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("580", "202", "action started via Async Request", "2024-03-18 18:16:27", "2024-03-18 18:16:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("581", "202", "action complete via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("582", "203", "action started via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("583", "203", "action complete via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("584", "204", "action started via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("585", "205", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("586", "206", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("587", "207", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("588", "208", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("589", "209", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("590", "210", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("591", "204", "action complete via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("592", "205", "action started via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("593", "205", "action complete via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("594", "206", "action started via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("595", "206", "action complete via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("596", "207", "action started via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("597", "207", "action complete via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("598", "208", "action started via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("599", "208", "action complete via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("600", "209", "action started via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("601", "209", "action complete via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("602", "210", "action started via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("603", "211", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("604", "212", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("605", "213", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("606", "214", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("607", "215", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("608", "216", "action created", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("609", "210", "action complete via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("610", "211", "action started via Async Request", "2024-03-18 18:16:28", "2024-03-18 18:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("611", "211", "action complete via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("612", "212", "action started via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("613", "212", "action complete via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("614", "213", "action started via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("615", "213", "action complete via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("616", "214", "action started via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("617", "214", "action complete via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("618", "215", "action started via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("619", "215", "action complete via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("620", "216", "action started via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("621", "217", "action created", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("622", "218", "action created", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("623", "219", "action created", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("624", "220", "action created", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("625", "221", "action created", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("626", "222", "action created", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("627", "216", "action complete via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("628", "217", "action started via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("629", "217", "action complete via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("630", "218", "action started via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("631", "218", "action complete via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("632", "219", "action started via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("633", "219", "action complete via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("634", "220", "action started via Async Request", "2024-03-18 18:16:29", "2024-03-18 18:16:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("635", "220", "action complete via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("636", "221", "action started via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("637", "221", "action complete via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("638", "222", "action started via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("639", "223", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("640", "224", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("641", "225", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("642", "226", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("643", "227", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("644", "228", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("645", "222", "action complete via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("646", "223", "action started via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("647", "223", "action complete via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("648", "224", "action started via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("649", "224", "action complete via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("650", "225", "action started via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("651", "225", "action complete via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("652", "226", "action started via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("653", "226", "action complete via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("654", "227", "action started via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("655", "227", "action complete via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("656", "228", "action started via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("657", "229", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("658", "230", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("659", "231", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("660", "232", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("661", "233", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("662", "234", "action created", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("663", "228", "action complete via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("664", "229", "action started via Async Request", "2024-03-18 18:16:30", "2024-03-18 18:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("665", "229", "action complete via Async Request", "2024-03-18 18:16:31", "2024-03-18 18:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("666", "230", "action started via Async Request", "2024-03-18 18:16:31", "2024-03-18 18:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("667", "230", "action complete via Async Request", "2024-03-18 18:16:31", "2024-03-18 18:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("668", "231", "action started via Async Request", "2024-03-18 18:16:31", "2024-03-18 18:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("669", "231", "action complete via Async Request", "2024-03-18 18:16:31", "2024-03-18 18:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("670", "232", "action started via Async Request", "2024-03-18 18:16:31", "2024-03-18 18:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("671", "232", "action complete via Async Request", "2024-03-18 18:16:31", "2024-03-18 18:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("672", "233", "action started via Async Request", "2024-03-18 18:16:31", "2024-03-18 18:16:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("673", "233", "action complete via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("674", "234", "action started via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("675", "235", "action created", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("676", "236", "action created", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("677", "237", "action created", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("678", "238", "action created", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("679", "239", "action created", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("680", "240", "action created", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("681", "234", "action complete via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("682", "235", "action started via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("683", "235", "action complete via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("684", "236", "action started via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("685", "236", "action complete via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("686", "237", "action started via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("687", "237", "action complete via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("688", "238", "action started via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("689", "238", "action complete via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("690", "239", "action started via Async Request", "2024-03-18 18:16:32", "2024-03-18 18:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("691", "239", "action complete via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("692", "240", "action started via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("693", "241", "action created", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("694", "242", "action created", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("695", "243", "action created", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("696", "244", "action created", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("697", "245", "action created", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("698", "246", "action created", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("699", "240", "action complete via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("700", "241", "action started via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("701", "241", "action complete via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("702", "242", "action started via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("703", "242", "action complete via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("704", "243", "action started via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("705", "243", "action complete via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("706", "244", "action started via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("707", "244", "action complete via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("708", "245", "action started via Async Request", "2024-03-18 18:16:33", "2024-03-18 18:16:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("709", "245", "action complete via Async Request", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("710", "246", "action started via Async Request", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("711", "247", "action created", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("712", "248", "action created", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("713", "246", "action complete via Async Request", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("714", "247", "action started via Async Request", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("715", "247", "action complete via Async Request", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("716", "248", "action started via Async Request", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("717", "248", "action complete via Async Request", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("718", "249", "action created", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("719", "249", "action started via Async Request", "2024-03-18 18:16:34", "2024-03-18 18:16:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("720", "249", "action complete via Async Request", "2024-03-18 18:16:34", "2024-03-18 18:16:34");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("1", "20240318_wpquickassist", "dde4aa9709cb4a0f5928_20240318181711", "22", "2024-03-18 18:17:22", "team", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-03-18 18:17:11\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:7:\"10.5.23\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:1;s:4:\"Name\";s:22:\"20240318_wpquickassist\";s:4:\"Hash\";s:35:\"dde4aa9709cb4a0f5928_20240318181711\";s:8:\"NameHash\";s:58:\"20240318_wpquickassist_dde4aa9709cb4a0f5928_20240318181711\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:68:\"20240318_wpquickassist_dde4aa9709cb4a0f5928_20240318181711_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.7\";s:6:\"WPUser\";s:4:\"team\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:70:\"20240318_wpquickassist_dde4aa9709cb4a0f5928_20240318181711_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:52:\"/home/fundamen/domains/wpquickassist.com/public_html\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2790;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:11278;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-03-18 18:17:11\";s:7:\"Version\";s:7:\"1.5.8.1\";s:9:\"VersionWP\";s:5:\"6.4.3\";s:9:\"VersionDB\";s:7:\"10.5.23\";s:10:\"VersionPHP\";s:6:\"8.0.30\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:22:\"20240318_wpquickassist\";s:4:\"Hash\";s:35:\"dde4aa9709cb4a0f5928_20240318181711\";s:8:\"NameHash\";s:58:\"20240318_wpquickassist_dde4aa9709cb4a0f5928_20240318181711\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:76:\"20240318_wpquickassist_dde4aa9709cb4a0f5928_20240318181711_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:66:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:71:\"20240318_wpquickassist_dde4aa9709cb4a0f5928_20240318181711_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:156:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-content/backups-dup-lite/tmp/20240318_wpquickassist_dde4aa9709cb4a0f5928_20240318181711_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:61:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-admin\";i:1;s:64:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-includes\";i:2;s:73:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:52:\"/home/fundamen/domains/wpquickassist.com/public_html\";i:1;s:52:\"/home/fundamen/domains/wpquickassist.com/public_html\";i:2;s:63:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-content\";i:3;s:71:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-content/uploads\";i:4;s:71:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-content/plugins\";i:5;s:74:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-content/mu-plugins\";i:6;s:70:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:84:\"/home/fundamen/domains/wpquickassist.com/public_html/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_link_juice_keeper */
INSERT INTO `wp_link_juice_keeper` VALUES("1", "2023-03-30 09:24:32", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2", "2023-03-30 09:24:32", "/debug/default/view?panel=config", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("3", "2023-03-30 09:24:32", "/s/2313e2734313e213e2439313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("4", "2023-03-30 09:24:33", "/login.action", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("5", "2023-03-30 09:24:33", "/api/search?folderIds=0", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("6", "2023-03-30 09:24:33", "/s/0393e2734313e213e2439313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("7", "2023-03-30 09:24:33", "/telescope/requests", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("8", "2023-03-30 09:24:34", "/config.json", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("9", "2023-03-30 09:24:34", "/.DS_Store", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("10", "2023-03-30 09:24:34", "/v2/_catalog", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("11", "2023-03-30 09:24:34", "/.vscode/sftp.json", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("12", "2023-03-30 09:24:35", "/info.php", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("13", "2023-03-30 09:24:35", "/server-status", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("14", "2023-03-30 09:24:35", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("15", "2023-03-30 09:24:35", "/info.php", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("16", "2023-03-30 09:24:36", "/v2/_catalog", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("17", "2023-03-30 09:24:36", "/api/search?folderIds=0", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("18", "2023-03-30 09:24:36", "/.env", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("19", "2023-03-30 09:24:36", "/.DS_Store", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("20", "2023-03-30 09:24:36", "/.env", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("21", "2023-03-30 09:24:36", "/debug/default/view?panel=config", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("22", "2023-03-30 09:24:37", "/server-status", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("23", "2023-03-30 09:24:37", "/about", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("24", "2023-03-30 09:24:37", "/.vscode/sftp.json", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("25", "2023-03-30 09:24:37", "/telescope/requests", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("26", "2023-03-30 09:24:37", "/about", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("27", "2023-03-30 09:24:38", "/api/search?folderIds=0", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("28", "2023-03-30 09:24:38", "/config.json", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("29", "2023-03-30 09:24:38", "/login.action", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("30", "2023-03-30 09:24:38", "/server-status", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("31", "2023-03-30 09:24:38", "/.DS_Store", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("32", "2023-03-30 09:24:38", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("33", "2023-03-30 09:24:38", "/.env", "", "137.184.150.232", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("34", "2023-03-30 09:24:38", "/telescope/requests", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("35", "2023-03-30 09:24:39", "/s/0393e2734313e213e2439313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("36", "2023-03-30 09:24:39", "/login.action", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("37", "2023-03-30 09:24:39", "/server-status", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("38", "2023-03-30 09:24:39", "/config.json", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("39", "2023-03-30 09:24:39", "/config.json", "", "45.55.193.222", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("40", "2023-03-30 09:24:40", "/v2/_catalog", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("41", "2023-03-30 09:24:40", "/.env", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("42", "2023-03-30 09:24:40", "/telescope/requests", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("43", "2023-03-30 09:24:40", "/info.php", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("44", "2023-03-30 09:24:41", "/.vscode/sftp.json", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("45", "2023-03-30 09:24:41", "/about", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("46", "2023-03-30 09:24:41", "/about", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("47", "2023-03-30 09:24:41", "/debug/default/view?panel=config", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("48", "2023-03-30 09:24:42", "/info.php", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("49", "2023-03-30 09:24:42", "/debug/default/view?panel=config", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("50", "2023-03-30 09:24:43", "/ecp/Current/exporttool/microsoft.exchange.ediscovery.exporttool.application", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("51", "2023-03-30 09:24:43", "/v2/_catalog", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("52", "2023-03-30 09:24:44", "/s/2313e2734313e213e2439313/_/;/META-INF/maven/com.atlassian.jira/jira-webapp-dist/pom.properties", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("53", "2023-03-30 09:24:44", "/login.action", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("54", "2023-03-30 09:24:44", "/.vscode/sftp.json", "", "147.182.130.98", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("55", "2023-03-30 09:24:44", "/api/search?folderIds=0", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("56", "2023-03-30 09:24:44", "/.DS_Store", "", "159.203.94.228", "Go-http-client/1.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("57", "2023-03-30 09:46:48", "/customize.php?return=wp-admin&#038;message=ModifySiteTitle&#038;UploadFavicon", "https://www.wpquickassist.com/?customize_changeset_uuid=e04969cf-af4f-4d4e-938f-d4a2d714c76c&#038;customize_theme=twentytwentythree&#038;customize_messenger_channel=preview-0", "88.68.125.230", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("58", "2023-03-30 09:48:38", "/admin.php?page=wpseo_dashboard", "https://www.wpquickassist.com/?customize_changeset_uuid=c8c13034-6dd6-476c-bce8-d17ed7e02806&#038;customize_theme=twentytwentythree&#038;customize_messenger_channel=preview-18&#038;customize_autosaved=on", "88.68.125.230", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("59", "2023-03-30 10:53:59", "/wp-content/uploads/2019/11/favicon-64x50.png", "", "66.249.73.51", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("60", "2023-03-30 10:53:59", "/wp-content/uploads/2019/11/favicon.png", "", "66.249.73.55", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("61", "2023-03-30 11:06:44", "/wp-content/plugins/cbxpetition/README.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("62", "2023-03-30 12:42:36", "/fix-sidebar-below-content-error-in-wordpress", "", "87.250.224.213", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("63", "2023-03-30 12:43:45", "/tag/wordpress-keeps-logging-out", "", "17.241.75.90", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("64", "2023-03-30 12:52:49", "/fix-image-upload-issue-in-wordpress", "", "216.244.66.234", "Mozilla/5.0 (compatible; DotBot/1.2; +https://opensiteexplorer.org/dotbot; help@moz.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("65", "2023-03-30 13:15:28", "/tag/image-upload-issue", "", "17.241.75.173", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("66", "2023-03-30 13:42:21", "/fix-sidebar-below-content-error-in-wordpress", "", "3.87.152.37", "Quora-Bot/1.0 (http://www.quora.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("67", "2023-03-30 14:25:03", "/wp-content/plugins/background-image-cropper/moduless.php", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("68", "2023-03-30 18:00:44", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "23.83.89.46", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("69", "2023-03-30 19:23:58", "/ads.txt", "https://wpquickassist.com/ads.txt", "107.22.46.53", "Go-http-client/2.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("70", "2023-03-30 21:13:03", "/how-to-fix-wordpress-login-redirect-loop-issue", "", "5.255.231.70", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("71", "2023-03-30 22:46:29", "/wso112233.php", "", "20.77.49.95", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("72", "2023-03-30 22:46:40", "/wp-includes/wp-class.php", "", "20.77.49.95", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("73", "2023-03-30 22:46:52", "/wp-content/shell20211028.php", "", "20.77.49.95", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("74", "2023-03-30 22:47:03", "/xleet-shell.php", "", "20.77.49.95", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("75", "2023-03-30 22:47:14", "/wp-content/themes/seotheme/db.php?u", "", "20.77.49.95", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("76", "2023-03-30 22:47:30", "/wp-content/plugins/ccx", "", "20.77.49.95", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("77", "2023-03-30 22:52:11", "/fix-500-internal-server-error-on-wordpress", "", "54.236.1.11", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("78", "2023-03-31 00:08:36", "/wp-content/uploads/2021/03/fix-thumbnail-1024x537.jpg", "", "124.156.138.20", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("79", "2023-03-31 00:20:26", "/how-to-change-wordpress-theme-without-losing-content", "", "77.75.79.95", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("80", "2023-03-31 00:24:34", "/wp-content/plugins/wp-user-avatar/changelog.txt", "http://yahoo.com", "194.87.151.73", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/90.0.4430.85 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("81", "2023-03-31 01:11:19", "/use.php?1915", "http://wpquickassist.com", "68.79.77.134", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("82", "2023-03-31 01:11:50", "/admin.php?1944", "http://wpquickassist.com", "68.79.77.134", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("83", "2023-03-31 01:14:19", "/use.php?1915", "http://wpquickassist.com", "68.79.77.134", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("84", "2023-03-31 01:23:05", "/contact", "", "23.81.120.166", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("85", "2023-03-31 01:27:04", "/wp-content/db-cache.php", "", "152.89.196.13", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:68.0) Gecko/20100101 Firefox/68.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("86", "2023-03-31 01:36:43", "/wp-admin/css/colors/blue/uploader.php", "", "151.80.35.213", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("87", "2023-03-31 02:13:46", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "107.175.77.149", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("88", "2023-03-31 02:41:19", "/wp-content/uploads/2019/11/favicon.png", "", "17.241.75.180", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("89", "2023-03-31 02:51:05", "/wp-content/uploads/2019/11/fix-responsiveness1-1.jpg", "", "18.237.66.59", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("90", "2023-03-31 03:17:08", "/git/config", "", "51.81.198.222", "Mozilla/5.0 (Linux; Android 5.1.1; SM-J111F) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/73.0.3683.90 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("91", "2023-03-31 04:11:29", "/home", "", "66.249.73.51", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("92", "2023-03-31 04:15:43", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "154.13.50.184", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("93", "2023-03-31 04:30:10", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "51.255.3.118", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("94", "2023-03-31 04:52:34", "/tag/wordpress-404-error", "", "17.241.219.131", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("95", "2023-03-31 04:59:06", "/how-to-fix-your-webs", "", "40.77.167.222", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("96", "2023-03-31 05:03:28", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "104.168.82.34", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("97", "2023-03-31 05:39:42", "/home", "", "66.249.73.55", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("98", "2023-03-31 06:15:58", "/how-to-fix-wordpress-rss-feed-errors", "", "17.241.75.60", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("99", "2023-03-31 06:21:59", "/wp-content/uploads/2020/10/wordPress-not-uploading-images.jpg", "", "119.96.11.234", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("100", "2023-03-31 08:11:47", "/wp-content/uploads/2019/11/wp-logo1.png", "", "66.249.73.51", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("101", "2023-03-31 09:14:07", "/wp-content/plugins/videowhisper-live-streaming-integration/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("102", "2023-03-31 10:47:39", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "107.175.14.161", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("103", "2023-03-31 10:53:49", "/fix-sidebar-below-content-error-in-wordpress/Sidebar", "", "52.167.144.168", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("104", "2023-03-31 11:40:42", "/testimonial-sitemap.xml", "", "66.249.73.59", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("105", "2023-03-31 12:23:36", "/wp-content/uploads/2020/10/wordpress-memory-exhausted.jpg", "", "34.172.212.68", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("106", "2023-03-31 13:22:45", "/portfolio", "", "77.75.78.171", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("107", "2023-03-31 13:41:50", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("108", "2023-03-31 13:41:51", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("109", "2023-03-31 15:18:20", "/wp-content/uploads/2019/11/favicon.png", "", "66.249.73.51", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("110", "2023-03-31 15:18:20", "/wp-content/uploads/2019/11/favicon-64x50.png", "", "66.249.73.51", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("111", "2023-03-31 15:36:47", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "102.129.240.188", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("112", "2023-03-31 17:22:55", "/how-to-block-failed-login-attempts-on-wordpress", "", "66.249.73.55", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("113", "2023-03-31 17:42:04", "/wp-content/uploads/2019/11/fix-responsiveness1-1.jpg", "", "203.119.241.120", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("114", "2023-03-31 17:56:29", "/wp-content/uploads/2021/06/fix-php-errors-1024x537.jpg", "", "34.29.53.9", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("115", "2023-03-31 19:01:15", "/wp-content/uploads/2020/10/how-to-fix-wp-404-error.jpg", "", "173.252.107.25", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("116", "2023-03-31 19:36:23", "/wp-admin/shell20211028.php", "", "151.80.35.213", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("117", "2023-03-31 20:15:11", "/wp-content/plugins/woocommerce-payments/dist/blocks-checkout.css", "", "193.33.133.219", "Mozilla/5.0 (Linux; Android 7.1.2; Redmi 4X Build/N2G47H) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/67.0.3396.81 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("118", "2023-03-31 20:21:33", "/wp-content/uploads/2021/06/password-reset-key-1024x537.jpg", "", "34.70.45.18", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("119", "2023-03-31 20:51:12", "/wp-content/uploads/2021/06/password-reset-key.jpg", "", "34.172.212.68", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("120", "2023-03-31 21:11:56", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "103.211.15.150", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_13_2) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.84 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("121", "2023-03-31 22:33:34", "/wp-content/plugins/core-fork", "http://wpquickassist.com", "150.254.192.2", "Mozilla/5.1 (Windows NT 6.0; WOW64) AppleWebKit/537.37 (KHTML, like Gecko) Chrome/58.0.1145.75 Safari/537.37", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("122", "2023-03-31 22:34:02", "/wp-content/plugins/core-stab", "http://wpquickassist.com", "150.254.192.2", "Mozilla/5.1 (Windows NT 6.0; WOW64) AppleWebKit/537.37 (KHTML, like Gecko) Chrome/58.0.1145.75 Safari/537.37", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("123", "2023-03-31 23:22:22", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "62.210.127.188", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("124", "2023-04-01 00:31:59", "/wp-content/plugins/task-controller", "http://wpquickassist.com", "139.59.77.216", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("125", "2023-04-01 00:33:04", "/wp-admin/theme.php?f20230218", "http://wpquickassist.com", "139.59.77.216", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("126", "2023-04-01 01:53:35", "/wp-content/uploads/2020/10/wordpress-login-loop-issue.jpg", "", "34.70.45.18", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("127", "2023-04-01 01:57:21", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "91.121.113.133", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("128", "2023-04-01 02:05:23", "/fix-image-upload-issue-in-wordpress", "", "52.167.144.62", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("129", "2023-04-01 02:15:26", "/fix-wordpress-login-page-refreshing-redirecting-issue", "", "66.249.73.55", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("130", "2023-04-01 02:33:01", "/wp/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("131", "2023-04-01 02:33:03", "/new/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("132", "2023-04-01 02:33:04", "/old/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("133", "2023-04-01 02:33:05", "/wordpress/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("134", "2023-04-01 02:33:06", "/test/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("135", "2023-04-01 02:33:07", "/blog/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("136", "2023-04-01 02:33:08", "/cms/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("137", "2023-04-01 02:33:09", "/web/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("138", "2023-04-01 02:33:11", "/backup/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("139", "2023-04-01 02:33:12", "/site/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("140", "2023-04-01 02:33:13", "/oldsite/wp-admin/install.php", "", "134.209.144.226", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("141", "2023-04-01 02:35:33", "/professional-planning", "", "95.108.213.108", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("142", "2023-04-01 02:45:23", "/save-time-money-in-your-business", "", "5.255.231.6", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("143", "2023-04-01 02:47:00", "/fix-sidebar-below-content-error-in-wordpress/embed", "", "213.180.203.50", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("144", "2023-04-01 02:55:03", "/wso112233.php", "http://www.google.com", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("145", "2023-04-01 02:55:08", "/wp-content/wso112233.php", "http://www.google.com", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("146", "2023-04-01 02:55:13", "/bala.php", "http://www.google.com", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("147", "2023-04-01 02:55:17", "/wp-content/plugins/sid/sidwso.php", "http://www.google.com", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("148", "2023-04-01 02:55:31", "/wp-content/shell20211028.php", "http://www.google.com", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("149", "2023-04-01 02:55:51", "/wp-includes/wp-class.php", "http://www.google.com", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("150", "2023-04-01 02:56:09", "/wp-class.php", "http://www.google.com", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("151", "2023-04-01 02:56:12", "/xleet-shell.php", "http://www.google.com", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("152", "2023-04-01 05:19:19", "/wp-includes/compat/embed/theme", "", "158.69.23.79", "Linux Mozilla", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("153", "2023-04-01 05:19:20", "/wp-includes/rest-api/fields/cache", "", "158.69.23.79", "Linux Mozilla", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("154", "2023-04-01 05:19:22", "/wp-includes/blocks/table/int/tmpl", "", "158.69.23.79", "Linux Mozilla", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("155", "2023-04-01 05:24:40", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "154.13.50.70", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("156", "2023-04-01 05:51:08", "/fix-sidebar-below-content-error-in-wordpress", "", "192.0.112.114", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) HeadlessChrome/111.0.5555.0 Safari/537.36 WordPress.com mShots", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("157", "2023-04-01 06:12:42", "/protection", "", "213.180.203.81", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("158", "2023-04-01 06:54:58", "/wp-content/uploads/2020/10/how-to-fix-wp-404-error.jpg", "", "34.29.53.9", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("159", "2023-04-01 08:53:12", "/wp-content/plugins/elementor-pro/changelog.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("160", "2023-04-01 09:07:49", "/how-to-fix-wordpress-login-redirect-loop-issue", "", "54.236.1.11", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("161", "2023-04-01 09:35:48", "/wp-content/plugins/ninja-forms-uploads/readme.txt", "", "20.117.105.198", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:28.0) Gecko/20100101 Firefox/28.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("162", "2023-04-01 09:36:52", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "87.132.177.76", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("163", "2023-04-01 10:42:14", "/how-to-change-wordpress-theme-without-losing-content", "", "66.249.79.192", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("164", "2023-04-01 11:29:24", "/sftp-config.json", "", "192.119.74.129", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("165", "2023-04-01 11:32:55", "/fix-image-upload-issue-in-wordpress", "", "17.241.219.197", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("166", "2023-04-01 14:24:23", "/0.php", "https://www.wpquickassist.com/0.php", "194.113.235.169", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("167", "2023-04-01 14:33:09", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "91.245.37.46", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("168", "2023-04-01 15:14:52", "/business-solutions", "", "95.108.213.145", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("169", "2023-04-01 16:39:29", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "89.185.79.203", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("170", "2023-04-01 17:02:03", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "154.3.99.132", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("171", "2023-04-01 17:32:12", "/tag/change-the-menu-color-in-wordpress", "", "216.244.66.234", "Mozilla/5.0 (compatible; DotBot/1.2; +https://opensiteexplorer.org/dotbot; help@moz.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("172", "2023-04-01 17:33:29", "/tag/change-blog-name-on-wordpress/feed", "", "216.244.66.234", "Mozilla/5.0 (compatible; DotBot/1.2; +https://opensiteexplorer.org/dotbot; help@moz.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("173", "2023-04-01 17:34:02", "/how-to-fix-wordpress-not-uploading-images-issue/feed", "", "216.244.66.234", "Mozilla/5.0 (compatible; DotBot/1.2; +https://opensiteexplorer.org/dotbot; help@moz.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("174", "2023-04-01 17:43:26", "/shell4.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("175", "2023-04-01 17:43:28", "/ups.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("176", "2023-04-01 17:43:29", "/ru.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("177", "2023-04-01 17:43:30", "/if.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("178", "2023-04-01 17:43:32", "/vuln.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("179", "2023-04-01 17:43:34", "/fw.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("180", "2023-04-01 17:43:35", "/skipper.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("181", "2023-04-01 17:43:36", "/skippershell.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("182", "2023-04-01 17:43:38", "/tttt.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("183", "2023-04-01 17:43:39", "/tshop.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("184", "2023-04-01 17:43:41", "/alfa.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("185", "2023-04-01 17:43:43", "/shell.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("186", "2023-04-01 17:43:44", "/inje3ctor.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("187", "2023-04-01 17:43:46", "/saudi.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("188", "2023-04-01 17:43:47", "/wso.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("189", "2023-04-01 17:43:49", "/alfashell.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("190", "2023-04-01 17:43:51", "/my_alfa.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("191", "2023-04-01 17:43:52", "/uploader.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("192", "2023-04-01 17:43:54", "/up.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("193", "2023-04-01 17:43:55", "/hacked.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("194", "2023-04-01 17:43:57", "/c99.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("195", "2023-04-01 17:43:59", "/priv8.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("196", "2023-04-01 17:44:01", "/Navir.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("197", "2023-04-01 17:44:02", "/cmd13.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("198", "2023-04-01 17:44:03", "/inc20k1.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("199", "2023-04-01 17:44:04", "/1index.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("200", "2023-04-01 17:44:06", "/404.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("201", "2023-04-01 17:44:08", "/swm.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("202", "2023-04-01 17:44:09", "/wp.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("203", "2023-04-01 17:44:10", "/doc.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("204", "2023-04-01 17:44:11", "/shx.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("205", "2023-04-01 17:44:13", "/ws.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("206", "2023-04-01 17:44:14", "/m.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("207", "2023-04-01 17:44:15", "/edit-form.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("208", "2023-04-01 17:44:17", "/LEAF.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("209", "2023-04-01 17:44:18", "/leafmailer.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("210", "2023-04-01 17:44:20", "/mailer.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("211", "2023-04-01 17:44:21", "/leafmailer2.8.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("212", "2023-04-01 17:44:23", "/Leaf.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("213", "2023-04-01 17:44:24", "/leaf.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("214", "2023-04-01 17:44:25", "/x.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("215", "2023-04-01 17:44:27", "/srx.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("216", "2023-04-01 17:44:28", "/1337.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("217", "2023-04-01 17:44:30", "/xx.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("218", "2023-04-01 17:44:31", "/XxX.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("219", "2023-04-01 17:44:33", "/lf.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("220", "2023-04-01 17:44:34", "/alex.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("221", "2023-04-01 17:44:36", "/new.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("222", "2023-04-01 17:44:37", "/marijuana.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("223", "2023-04-01 17:44:38", "/gaza.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("224", "2023-04-01 17:44:40", "/wp-admin.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("225", "2023-04-01 17:44:42", "/3index.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("226", "2023-04-01 17:44:43", "/wikindex.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("227", "2023-04-01 17:44:45", "/wso1.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("228", "2023-04-01 17:44:46", "/bb.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("229", "2023-04-01 17:44:48", "/Lux.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("230", "2023-04-01 17:44:49", "/haxor.php", "https://www.google.com", "4.234.111.199", "Mozilla/5.0 (Windows NT 10.0; WOW64; rv:52.0) Gecko/20100101 Firefox/52.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("231", "2023-04-01 17:49:58", "/how-is-our-firm-committed", "", "40.77.167.222", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("232", "2023-04-01 18:17:09", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "185.121.138.208", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("233", "2023-04-01 19:08:38", "/tag/rss-feed-errors", "", "77.75.79.62", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("234", "2023-04-01 19:30:41", "/how-to-fix-wordpress-not-uploading-images-issue", "", "17.241.227.248", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("235", "2023-04-01 19:45:52", "/wp-content/plugins/gift-voucher/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("236", "2023-04-01 19:49:25", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "115.187.32.188", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("237", "2023-04-01 21:17:16", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "183.89.77.160", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("238", "2023-04-01 21:25:20", "/wp-content/uploads/2021/03/fix-thumbnail-1024x537.jpg", "", "128.30.195.65", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("239", "2023-04-01 22:30:36", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "64.137.42.135", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("240", "2023-04-01 22:50:07", "/wp-admin/css/colors/blue/uploader.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("241", "2023-04-01 23:15:25", "/wp-content/plugins/seoox/alfa-rex.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("242", "2023-04-01 23:16:11", "/wp-content/plugins/seoox/alfanew.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("243", "2023-04-01 23:20:07", "/wp-admin/shell20211028.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("244", "2023-04-01 23:20:19", "/wp-admin/css/colors/blue/uploader.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("245", "2023-04-01 23:30:49", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "10.244.0.1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("246", "2023-04-02 01:06:23", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "107.181.152.21", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("247", "2023-04-02 01:08:04", "/wp-content/themes/pridmag/db.php?u", "", "40.76.202.16", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("248", "2023-04-02 01:08:30", "/wp-content/themes/seotheme/db.php?u", "", "40.76.202.16", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("249", "2023-04-02 01:30:36", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "162.254.144.89", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("250", "2023-04-02 02:46:23", "/.well-known/apple-app-site-association", "", "72.14.199.222", "AdsBot-Google (+http://www.google.com/adsbot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("251", "2023-04-02 02:58:19", "/apple-app-site-association", "", "72.14.199.222", "AdsBot-Google (+http://www.google.com/adsbot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("252", "2023-04-02 05:03:33", "/wso112233.php", "", "40.76.202.16", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("253", "2023-04-02 05:03:48", "/wp-includes/wp-class.php", "", "40.76.202.16", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("254", "2023-04-02 05:04:07", "/wp-content/shell20211028.php", "", "40.76.202.16", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("255", "2023-04-02 05:04:11", "/xleet-shell.php", "", "40.76.202.16", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("256", "2023-04-02 05:04:15", "/wp-content/themes/seotheme/db.php?u", "", "40.76.202.16", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("257", "2023-04-02 05:04:19", "/wp-content/plugins/ccx", "", "40.76.202.16", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("258", "2023-04-02 05:42:05", "/?action=svgonload=confirmaction&#038;cat=svgonload=confirmcat&#038;id=svgonload=confirmid&#038;key=svgonload=confirmkey&#038;keyword=svgonload=confirmkeyword&#038;keywords=svgonload=confirmkeywords&#038;name=svgonload=confirmname&#038;p=svgonload=confirmp&#038;page=svgonload=confirmpage&#038;q=svgonload=confirmq&#038;query=svgonload=confirmquery&#038;s=svgonload=confirms&#038;search=svgonload=confirmsearch&#038;url=svgonload=confirmurl&#038;view=svgonload=confirmview", "", "146.196.32.254", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/89.0.4389.114 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("259", "2023-04-02 06:40:47", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "119.96.11.234", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("260", "2023-04-02 08:59:58", "/wp-content/plugins/seoox/alfa-rex.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("261", "2023-04-02 09:02:11", "/wp-content/plugins/seoox/alfanew.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("262", "2023-04-02 09:48:19", "/wp-content/plugins/wc-fields-factory/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("263", "2023-04-02 10:12:25", "/500-internal-server-error", "", "17.241.227.143", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("264", "2023-04-02 10:55:04", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "192.252.216.81", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("265", "2023-04-02 11:02:44", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "154.13.50.83", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("266", "2023-04-02 11:21:15", "/turn-off-php-errors-in-wordpress", "", "17.241.227.108", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("267", "2023-04-02 12:07:51", "/.ftpconfig", "", "192.119.74.134", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/92.0.4515.107 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("268", "2023-04-02 13:38:32", "/wp-admin/includes/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("269", "2023-04-02 13:38:58", "/wp-includes/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("270", "2023-04-02 13:39:23", "/.well-known/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("271", "2023-04-02 13:39:47", "/css/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("272", "2023-04-02 13:40:05", "/images/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("273", "2023-04-02 13:40:20", "/wp-content/languages/plugins/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("274", "2023-04-02 13:40:36", "/wp-includes/images/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("275", "2023-04-02 13:40:41", "/wp-admin/user/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("276", "2023-04-02 13:41:09", "/wp-content/languages/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("277", "2023-04-02 13:41:16", "/wp-content/upgrade/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("278", "2023-04-02 13:41:30", "/wp-content/uploads/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("279", "2023-04-02 13:41:51", "/wp-admin/network/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("280", "2023-04-02 13:42:09", "/wp-admin/js/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("281", "2023-04-02 13:42:18", "/wp-admin/css/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("282", "2023-04-02 13:42:28", "/wp-admin/css/colors/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("283", "2023-04-02 13:42:31", "/wp-admin/maint/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("284", "2023-04-02 13:42:36", "/wp-content/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("285", "2023-04-02 13:42:40", "/wp-admin/css/colors/blue/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("286", "2023-04-02 13:42:47", "/wp-admin/css/colors/coffee/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("287", "2023-04-02 13:43:12", "/wp-admin/css/colors/ectoplasm/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("288", "2023-04-02 13:43:21", "/wp-admin/css/colors/midnight/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("289", "2023-04-02 13:43:33", "/wp-admin/css/colors/modern/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("290", "2023-04-02 13:43:53", "/.well-known/pki-validation/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("291", "2023-04-02 13:44:12", "/wp-admin/images/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("292", "2023-04-02 13:44:26", "/wp-admin/css/colors/ocean/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("293", "2023-04-02 13:44:39", "/wp-admin/js/widgets/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("294", "2023-04-02 13:44:46", "/wp-includes/customize/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("295", "2023-04-02 13:44:55", "/wp-includes/pomo/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("296", "2023-04-02 13:45:15", "/wp-includes/ID3/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("297", "2023-04-02 13:45:26", "/wp-includes/IXR/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("298", "2023-04-02 13:45:33", "/wp-includes/PHPMailer/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("299", "2023-04-02 13:45:40", "/wp-includes/Requests/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("300", "2023-04-02 13:45:52", "/wp-includes/SimplePie/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("301", "2023-04-02 13:46:07", "/wp-includes/Text/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("302", "2023-04-02 13:46:55", "/wp-includes/assets/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("303", "2023-04-02 13:47:05", "/wp-includes/block-patterns/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("304", "2023-04-02 13:47:14", "/wp-includes/block-supports/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("305", "2023-04-02 13:47:28", "/wp-includes/blocks/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("306", "2023-04-02 13:48:03", "/wp-includes/certificates/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("307", "2023-04-02 13:48:09", "/wp-includes/css/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("308", "2023-04-02 13:48:22", "/wp-includes/fonts/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("309", "2023-04-02 13:48:28", "/wp-includes/js/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("310", "2023-04-02 13:48:32", "/wp-includes/php-compat/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("311", "2023-04-02 13:48:35", "/wp-includes/random_compat/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("312", "2023-04-02 13:48:46", "/wp-includes/rest-api/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("313", "2023-04-02 13:49:07", "/wp-includes/sitemaps/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("314", "2023-04-02 13:49:21", "/wp-includes/sodium_compat/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("315", "2023-04-02 13:49:31", "/wp-includes/style-engine/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("316", "2023-04-02 13:49:42", "/wp-includes/theme-compat/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("317", "2023-04-02 13:50:00", "/wp-includes/widgets/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("318", "2023-04-02 14:32:48", "/wp-content/uploads/2019/11/favicon-64x50.png", "", "17.241.227.60", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("319", "2023-04-02 14:33:00", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "17.241.219.64", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("320", "2023-04-02 14:48:26", "/wso112233.php", "", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("321", "2023-04-02 14:48:32", "/wp-includes/wp-class.php", "", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("322", "2023-04-02 14:48:33", "/wp-content/shell20211028.php", "", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("323", "2023-04-02 14:48:43", "/xleet-shell.php", "", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("324", "2023-04-02 14:48:48", "/wp-content/themes/seotheme/db.php?u", "", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("325", "2023-04-02 14:48:52", "/wp-content/plugins/ccx", "", "52.140.118.164", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("326", "2023-04-02 16:18:50", "/portfolios/panoroof", "", "5.45.207.174", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("327", "2023-04-02 16:54:33", "/how-to-fix-add-media-button-not-working-in-wordpress", "", "77.75.77.101", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("328", "2023-04-02 17:05:50", "/tag/ux", "", "213.180.203.124", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("329", "2023-04-02 17:08:21", "/wp-content/plugins/apikey/apikey.php", "http://www.google.com", "20.117.105.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("330", "2023-04-02 17:08:22", "/wp-content/plugins/apikey/cypher.php", "http://www.google.com", "20.117.105.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("331", "2023-04-02 17:58:59", "/wp-admin/includes/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("332", "2023-04-02 17:59:23", "/wp-includes/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("333", "2023-04-02 17:59:42", "/.well-known/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("334", "2023-04-02 17:59:56", "/css/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("335", "2023-04-02 18:00:27", "/images/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("336", "2023-04-02 18:00:35", "/wp-content/languages/plugins/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("337", "2023-04-02 18:00:58", "/wp-includes/images/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("338", "2023-04-02 18:01:10", "/wp-admin/user/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("339", "2023-04-02 18:01:31", "/wp-content/languages/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("340", "2023-04-02 18:01:51", "/wp-content/upgrade/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("341", "2023-04-02 18:02:12", "/wp-content/uploads/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("342", "2023-04-02 18:02:44", "/wp-admin/network/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("343", "2023-04-02 18:03:02", "/wp-admin/js/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("344", "2023-04-02 18:03:25", "/wp-admin/css/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("345", "2023-04-02 18:03:51", "/wp-admin/css/colors/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("346", "2023-04-02 18:04:00", "/wp-admin/maint/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("347", "2023-04-02 18:04:18", "/wp-content/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("348", "2023-04-02 18:04:29", "/wp-admin/css/colors/blue/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("349", "2023-04-02 18:04:45", "/wp-admin/css/colors/coffee/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("350", "2023-04-02 18:04:48", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "192.3.114.36", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("351", "2023-04-02 18:05:19", "/wp-admin/css/colors/ectoplasm/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("352", "2023-04-02 18:05:40", "/wp-admin/css/colors/midnight/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("353", "2023-04-02 18:05:46", "/wp-admin/css/colors/modern/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("354", "2023-04-02 18:05:51", "/.well-known/pki-validation/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("355", "2023-04-02 18:06:13", "/wp-admin/images/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("356", "2023-04-02 18:06:32", "/wp-admin/css/colors/ocean/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("357", "2023-04-02 18:07:16", "/wp-admin/js/widgets/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("358", "2023-04-02 18:07:36", "/wp-includes/customize/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("359", "2023-04-02 18:07:44", "/wp-includes/pomo/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("360", "2023-04-02 18:08:01", "/wp-includes/ID3/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("361", "2023-04-02 18:08:15", "/wp-includes/IXR/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("362", "2023-04-02 18:08:24", "/wp-includes/PHPMailer/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("363", "2023-04-02 18:08:31", "/wp-includes/Requests/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("364", "2023-04-02 18:08:37", "/wp-includes/SimplePie/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("365", "2023-04-02 18:08:45", "/wp-includes/Text/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("366", "2023-04-02 18:08:58", "/wp-includes/assets/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("367", "2023-04-02 18:09:07", "/wp-includes/block-patterns/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("368", "2023-04-02 18:09:26", "/wp-includes/block-supports/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("369", "2023-04-02 18:09:47", "/wp-includes/blocks/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("370", "2023-04-02 18:10:20", "/wp-includes/certificates/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("371", "2023-04-02 18:10:26", "/wp-includes/css/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("372", "2023-04-02 18:10:34", "/wp-includes/fonts/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("373", "2023-04-02 18:10:42", "/wp-includes/js/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("374", "2023-04-02 18:10:49", "/wp-includes/php-compat/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("375", "2023-04-02 18:10:54", "/wp-includes/random_compat/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("376", "2023-04-02 18:11:05", "/wp-includes/rest-api/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("377", "2023-04-02 18:11:20", "/wp-includes/sitemaps/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("378", "2023-04-02 18:11:36", "/wp-includes/sodium_compat/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("379", "2023-04-02 18:11:51", "/wp-includes/style-engine/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("380", "2023-04-02 18:11:55", "/wp-includes/theme-compat/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("381", "2023-04-02 18:12:00", "/wp-includes/widgets/moon.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("382", "2023-04-02 18:34:39", "/how-to-block-failed-login-attempts-on-wordpress", "", "66.249.73.51", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("383", "2023-04-02 18:47:17", "/fix-wordpress-login-page-refreshing-redirecting-issue", "", "5.45.207.173", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("384", "2023-04-02 20:38:50", "/tag/services", "", "95.108.213.151", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("385", "2023-04-02 20:45:47", "/wordpress-not-sending-emails", "", "17.241.219.90", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("386", "2023-04-02 20:54:23", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "128.30.195.59", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("387", "2023-04-02 21:31:12", "/terms-of-service", "", "77.75.79.101", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("388", "2023-04-02 22:19:05", "/tag/web", "", "213.180.203.119", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("389", "2023-04-03 00:52:20", "/_ignition/health-check", "https://wpquickassist.com/_ignition/health-check/", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("390", "2023-04-03 00:52:23", "/public/_ignition/health-check", "https://wpquickassist.com/public/_ignition/health-check/", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("391", "2023-04-03 01:32:48", "/tag/consultant", "", "95.108.213.180", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("392", "2023-04-03 02:25:35", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "185.87.123.170", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("393", "2023-04-03 02:34:04", "/fix-wordpress-login-page-refreshing-redirecting-issue", "", "66.249.73.55", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("394", "2023-04-03 03:45:18", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "15.235.182.146", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("395", "2023-04-03 03:45:18", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "15.235.182.146", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("396", "2023-04-03 03:45:22", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "174.138.167.178", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("397", "2023-04-03 04:00:27", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "162.254.144.89", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("398", "2023-04-03 04:03:33", "/fix-facebook-incorrect-thumbnail-issue-in-wordpress/WordPress/a", "", "103.66.74.201", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("399", "2023-04-03 05:13:54", "/tag/wordpress-stuck-in-maintenance-mode", "", "216.244.66.234", "Mozilla/5.0 (compatible; DotBot/1.2; +https://opensiteexplorer.org/dotbot; help@moz.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("400", "2023-04-03 05:31:08", "/humans.txt", "https://wpquickassist.com/humans.txt", "185.27.99.126", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("401", "2023-04-03 05:31:09", "/ads.txt", "https://wpquickassist.com/ads.txt", "185.27.99.136", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("402", "2023-04-03 05:55:07", "/fix-facebook-incorrect-thumbnail-issue-in-wordpress", "", "54.236.1.11", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("403", "2023-04-03 06:29:23", "/main.js", "", "178.62.219.65", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("404", "2023-04-03 06:30:33", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "103.253.147.80", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("405", "2023-04-03 06:30:35", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "103.253.147.80", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("406", "2023-04-03 06:30:36", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "103.253.147.80", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("407", "2023-04-03 06:30:37", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "103.253.147.80", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("408", "2023-04-03 06:35:55", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "103.253.147.80", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("409", "2023-04-03 06:35:57", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "103.253.147.80", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("410", "2023-04-03 07:14:14", "/tag/wordpress-memory-exhausted-error", "", "17.241.227.113", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("411", "2023-04-03 08:26:06", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "150.109.109.160", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("412", "2023-04-03 08:34:28", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "87.133.114.154", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("413", "2023-04-03 08:41:56", "/wp-content/plugins/armember-membership/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("414", "2023-04-03 08:55:12", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "119.96.11.234", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("415", "2023-04-03 09:32:28", "/wp/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("416", "2023-04-03 09:32:33", "/new/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("417", "2023-04-03 09:32:37", "/old/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("418", "2023-04-03 09:32:41", "/wordpress/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("419", "2023-04-03 09:32:45", "/test/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("420", "2023-04-03 09:32:49", "/blog/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("421", "2023-04-03 09:32:52", "/cms/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("422", "2023-04-03 09:32:53", "/wp-content/uploads/2021/03/fix-thumbnail-1024x537.jpg", "", "34.229.0.213", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("423", "2023-04-03 09:32:56", "/web/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("424", "2023-04-03 09:32:59", "/backup/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("425", "2023-04-03 09:33:03", "/site/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("426", "2023-04-03 09:33:08", "/oldsite/wp-admin/install.php", "", "159.65.235.95", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("427", "2023-04-03 10:58:59", "/how-to-change-wordpress-theme-without-losing-content", "", "66.249.73.51", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("428", "2023-04-03 12:25:40", "/how-to-fix-add-media-button-not-working-in-wordpress/feed", "", "95.108.213.89", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("429", "2023-04-03 12:41:26", "/fix-password-reset-key-error-in-wordpress", "", "95.108.213.107", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("430", "2023-04-03 16:11:20", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "196.196.247.127", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("431", "2023-04-03 18:49:45", "/wp/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("432", "2023-04-03 18:49:47", "/new/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("433", "2023-04-03 18:49:48", "/old/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("434", "2023-04-03 18:49:49", "/wordpress/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("435", "2023-04-03 18:49:50", "/test/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("436", "2023-04-03 18:49:51", "/blog/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("437", "2023-04-03 18:49:53", "/cms/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("438", "2023-04-03 18:49:53", "/web/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("439", "2023-04-03 18:49:54", "/backup/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("440", "2023-04-03 18:49:55", "/site/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("441", "2023-04-03 18:49:56", "/oldsite/wp-admin/install.php", "", "103.253.147.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("442", "2023-04-03 19:14:25", "/leverage-customer-analytics", "", "87.250.224.203", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("443", "2023-04-03 20:58:14", "/admin.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("444", "2023-04-03 21:32:12", "/wp-content/plugins/apikey/apikey.php?test=hello", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("445", "2023-04-03 21:41:32", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "45.67.3.25", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("446", "2023-04-03 22:48:09", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "104.171.202.67", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("447", "2023-04-03 22:57:04", "/how-to-fix-your-website-stuck-in-wordpress-maintenance-mode", "https://www.wpquickassist.com/", "188.126.89.48", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("448", "2023-04-03 23:23:17", "/how-to-fix-wordpress-keeps-logging-out-problem", "", "77.75.77.109", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("449", "2023-04-03 23:58:46", "/fix-error-establishing-a-database-connection-in-wordpress", "", "95.108.213.139", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("450", "2023-04-04 01:06:43", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("451", "2023-04-04 01:06:45", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("452", "2023-04-04 01:09:10", "/wp-includes/class-index-wordpress.php", "", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("453", "2023-04-04 01:09:11", "/wp-includes/wp-system-cloud.php", "", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("454", "2023-04-04 01:09:12", "/wp-includes/class-wp-page-icon.php", "", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("455", "2023-04-04 01:09:13", "/wp-includes/class-wordpress-license.php", "", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("456", "2023-04-04 01:35:30", "/wallet/wallet.dat", "", "37.46.113.170", "Mozilla/5.0 (Windows NT 5.1; rv:13.0) Gecko/20100101 Firefox/13.0.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("457", "2023-04-04 01:37:44", "/btc/wallet.dat", "", "37.46.113.170", "Mozilla/5.0 (Windows NT 10.0; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("458", "2023-04-04 01:38:17", "/backup/bitcoin/wallet.dat", "", "37.46.113.170", "Opera/9.80 (Windows NT 5.1; U; en) Presto/2.10.289 Version/12.01", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("459", "2023-04-04 01:38:45", "/backups/wallet.dat", "", "37.46.113.170", "Opera/9.80 (Windows NT 5.1; U; en) Presto/2.10.289 Version/12.01", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("460", "2023-04-04 01:39:04", "/wallet.dat", "", "37.46.113.170", "Mozilla/5.0 (Windows NT 10.0; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("461", "2023-04-04 01:39:27", "/bitcoin/wallet.dat", "", "37.46.113.170", "Mozilla/5.0 (Windows NT 10.0; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("462", "2023-04-04 01:40:40", "/wallets/wallet.dat", "", "37.46.113.170", "Mozilla/5.0 (Windows NT 5.1; rv:13.0) Gecko/20100101 Firefox/13.0.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("463", "2023-04-04 01:45:57", "/Bitcoin/wallet.dat", "", "37.46.113.170", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("464", "2023-04-04 01:46:04", "/backup/Bitcoin/wallet.dat", "", "37.46.113.170", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; SV1; .NET CLR 2.0.50727)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("465", "2023-04-04 01:47:35", "/BTC/wallet.dat", "", "37.46.113.170", "Mozilla/5.0 (Windows NT 5.1; rv:13.0) Gecko/20100101 Firefox/13.0.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("466", "2023-04-04 01:49:05", "/bitcoin/backup/wallet.dat", "", "37.46.113.170", "Mozilla/5.0 (X11; U; Linux x86_64; de; rv:1.9.2.8) Gecko/20100723 Ubuntu/10.04 (lucid) Firefox/3.6.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("467", "2023-04-04 01:49:18", "/Btc/wallet.dat", "", "37.46.113.170", "Mozilla/5.0 (X11; U; Linux x86_64; de; rv:1.9.2.8) Gecko/20100723 Ubuntu/10.04 (lucid) Firefox/3.6.8", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("468", "2023-04-04 01:53:04", "/wp-content/uploads/2021/06/fix-php-errors.jpg", "", "69.171.249.8", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("469", "2023-04-04 01:54:39", "/backup/wallet.dat", "", "37.46.113.170", "Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; Trident/4.0; .NET CLR 2.0.50727; .NET CLR 3.0.4506.2152; .NET CLR 3.5.30729)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("470", "2023-04-04 01:57:27", "/portfolios-sitemap.xml", "", "66.249.73.51", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("471", "2023-04-04 01:59:06", "/portfolios/yummy-tummy-kids", "", "213.180.203.21", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("472", "2023-04-04 02:32:40", "/wp/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("473", "2023-04-04 02:32:41", "/new/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("474", "2023-04-04 02:32:46", "/old/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("475", "2023-04-04 02:32:50", "/tag/web-desgin", "", "5.255.231.71", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("476", "2023-04-04 02:32:51", "/wordpress/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("477", "2023-04-04 02:32:55", "/test/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("478", "2023-04-04 02:32:57", "/blog/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("479", "2023-04-04 02:33:05", "/cms/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("480", "2023-04-04 02:33:09", "/web/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("481", "2023-04-04 02:33:13", "/backup/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("482", "2023-04-04 02:33:16", "/site/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("483", "2023-04-04 02:33:18", "/oldsite/wp-admin/install.php", "", "167.71.192.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("484", "2023-04-04 02:44:25", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "159.223.49.94", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("485", "2023-04-04 02:44:27", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "159.223.49.94", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("486", "2023-04-04 03:34:50", "/fix-error-too-many-redirects-in-wordpress", "https://www.quora.com/", "169.150.218.72", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("487", "2023-04-04 03:45:33", "/wp-content/uploads/2021/06/password-reset-key.jpg", "", "17.241.219.79", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("488", "2023-04-04 03:52:44", "/wp/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("489", "2023-04-04 03:52:46", "/new/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("490", "2023-04-04 03:52:47", "/old/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("491", "2023-04-04 03:52:48", "/wordpress/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("492", "2023-04-04 03:52:49", "/test/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("493", "2023-04-04 03:52:50", "/blog/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("494", "2023-04-04 03:52:51", "/cms/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("495", "2023-04-04 03:52:53", "/web/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("496", "2023-04-04 03:52:53", "/backup/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("497", "2023-04-04 03:52:55", "/site/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("498", "2023-04-04 03:52:56", "/oldsite/wp-admin/install.php", "", "159.223.49.94", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("499", "2023-04-04 04:27:59", "/portfolios/page/3", "", "213.180.203.75", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("500", "2023-04-04 04:50:35", "/assets/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("501", "2023-04-04 05:25:55", "/optimize", "", "5.45.207.67", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("502", "2023-04-04 06:01:25", "/wp-content/uploads/kaswara/fonts_icon/a57bze8931/.__a57bze8931.php", "http://www.google.com", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("503", "2023-04-04 06:01:27", "/wp-content/plugins/apikey/apikey.php", "http://www.google.com", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("504", "2023-04-04 06:01:32", "/wp-content/plugins/apikey/a57bze8931.php", "http://www.google.com", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("505", "2023-04-04 06:01:40", "/abruzi.php4", "http://www.google.com", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("506", "2023-04-04 06:01:43", "/wp-content/x.php?1=system", "http://www.google.com", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("507", "2023-04-04 06:01:44", "/wp-content/king.php", "http://www.google.com", "167.71.192.121", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("508", "2023-04-04 07:57:37", "/effective-solutions", "", "213.180.203.121", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("509", "2023-04-04 08:21:33", "/500-internal-server-error", "", "77.75.79.101", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("510", "2023-04-04 09:38:20", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://www.wpquickassist.com/", "95.142.121.36", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("511", "2023-04-04 09:39:15", "/fix-wordpress-not-sending-email-issue", "", "5.255.231.151", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("512", "2023-04-04 10:29:46", "/how-to-fix-wordpress-404-error", "", "5.102.173.71", "Mozilla/5.0 (compatible; MojeekBot/0.11; +https://www.mojeek.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("513", "2023-04-04 10:37:41", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "107.20.125.66", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("514", "2023-04-04 10:52:13", "/wp-content/plugins/wp-slimstat/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("515", "2023-04-04 11:03:14", "/wp-admin/includes/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("516", "2023-04-04 11:03:23", "/wp-includes/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("517", "2023-04-04 11:04:10", "/.well-known/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("518", "2023-04-04 11:04:24", "/css/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("519", "2023-04-04 11:04:45", "/home/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("520", "2023-04-04 11:05:11", "/images/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("521", "2023-04-04 11:05:21", "/wp-includes/images/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("522", "2023-04-04 11:05:39", "/wp-admin/user/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("523", "2023-04-04 11:06:22", "/wp-content/languages/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("524", "2023-04-04 11:06:36", "/wp-content/upgrade/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("525", "2023-04-04 11:06:47", "/wp-content/uploads/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("526", "2023-04-04 11:07:11", "/wp-admin/network/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("527", "2023-04-04 11:07:17", "/wp-admin/js/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("528", "2023-04-04 11:07:26", "/wp-admin/css/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("529", "2023-04-04 11:07:37", "/wp-admin/css/colors/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("530", "2023-04-04 11:07:44", "/wp-admin/maint/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("531", "2023-04-04 11:07:58", "/wp-content/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("532", "2023-04-04 11:08:25", "/wp-admin/css/colors/blue/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("533", "2023-04-04 11:08:43", "/wp-admin/css/colors/coffee/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("534", "2023-04-04 11:09:05", "/wp-admin/css/colors/ectoplasm/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("535", "2023-04-04 11:09:21", "/wp-admin/css/colors/midnight/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("536", "2023-04-04 11:09:34", "/wp-admin/css/colors/modern/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("537", "2023-04-04 11:09:50", "/.well-known/pki-validation/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("538", "2023-04-04 11:10:08", "/wp-admin/images/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("539", "2023-04-04 11:10:44", "/wp-admin/css/colors/ocean/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("540", "2023-04-04 11:10:49", "/wp-admin/js/widgets/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("541", "2023-04-04 11:11:01", "/wp-includes/customize/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("542", "2023-04-04 11:11:16", "/wp-includes/pomo/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("543", "2023-04-04 11:11:24", "/wp-includes/ID3/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("544", "2023-04-04 11:11:44", "/wp-includes/IXR/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("545", "2023-04-04 12:20:24", "/wp-content/uploads/2019/11/favicon-64x50.png", "", "213.180.203.76", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("546", "2023-04-04 12:42:56", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "180.247.238.225", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("547", "2023-04-04 13:32:49", "/wp-content/themes/exs-church/fnc.php", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:67.0) Gecko/20100101 Firefox/67.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("548", "2023-04-04 15:00:46", "/turn-off-php-errors-in-wordpress", "", "5.255.231.151", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("549", "2023-04-04 15:34:45", "/tag/wordpress-404-error", "", "213.180.203.145", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("550", "2023-04-04 18:38:35", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("551", "2023-04-04 18:38:35", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("552", "2023-04-04 20:06:48", "/how-to-block-failed-login-attempts-on-wordpress", "", "66.249.75.160", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("553", "2023-04-04 20:29:40", "/fix-facebook-incorrect-thumbnail-issue-in-wordpress", "", "17.241.227.117", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("554", "2023-04-04 21:53:36", "/portfolios", "", "95.108.213.241", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("555", "2023-04-04 22:57:32", "/ALFA_DATA/alfacgiapi/perl.alfa", "http://www.google.com", "69.167.14.132", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("556", "2023-04-04 22:57:32", "/wp-plain.php", "http://www.google.com", "69.167.14.132", "Mozilla/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("557", "2023-04-04 22:57:33", "/wp-content/plugins/apikey/apikey.php?test=hello", "", "69.167.14.132", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("558", "2023-04-04 22:57:34", "/plugins/content/apismtp/apismtp.php?test=hello", "", "69.167.14.132", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("559", "2023-04-04 22:57:34", "/wp-content/plugins/apikey/apikey.php.suspected?test=hello", "", "69.167.14.132", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("560", "2023-04-04 22:57:35", "/plugins/content/apismtp/apismtp.php.suspected?test=hello", "", "69.167.14.132", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("561", "2023-04-04 22:57:36", "/alfacgiapi/perl.alfa", "http://www.google.com", "69.167.14.132", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("562", "2023-04-04 23:28:42", "/how-to-fix-wordpress-memory-exhausted-error", "", "17.241.227.129", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("563", "2023-04-05 01:54:35", "/fix-image-upload-issue-in-wordpress", "", "77.75.79.62", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("564", "2023-04-05 04:37:57", "/portfolios/page/4", "", "5.255.231.78", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("565", "2023-04-05 05:07:39", "/fix-wordpress-login-page-refreshing-redirecting-issue", "", "66.249.75.173", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("566", "2023-04-05 05:31:04", "/wp-content/plugins/animated-live-wall/plugin.php", "", "152.89.196.13", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.157 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("567", "2023-04-05 06:43:41", "/wp-content/uploads/2019/11/security-monitoring.jpg", "", "77.75.79.95", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("568", "2023-04-05 08:09:41", "/tag/wordpress-not-sending-emails", "", "77.75.79.62", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("569", "2023-04-05 08:52:51", "/author/john-smith", "", "77.75.78.171", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("570", "2023-04-05 09:05:47", "/2020/10", "", "213.180.203.27", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("571", "2023-04-05 09:49:05", "/wp-content/plugins/waiting/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("572", "2023-04-05 10:01:27", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "89.185.79.166", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("573", "2023-04-05 10:14:21", "/wp-content/uploads/2019/11/favicon-64x50.png", "", "95.108.213.169", "Mozilla/5.0 (compatible; YandexFavicons/1.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("574", "2023-04-05 11:45:53", "/how-to-change-wordpress-theme-without-losing-content", "", "66.249.70.107", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("575", "2023-04-05 12:54:51", "/assets/global/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("576", "2023-04-05 13:38:41", "/fix-password-reset-key-error-in-wordpress", "", "17.241.219.54", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("577", "2023-04-05 13:51:33", "/wp-content/plugins/about.php", "", "152.89.196.13", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10.14; rv:68.0) Gecko/20100101 Firefox/68.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("578", "2023-04-05 16:16:08", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "173.213.84.25", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("579", "2023-04-05 16:34:55", "/tag/wordpress-keeps-logging-out", "", "17.241.227.72", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("580", "2023-04-05 16:50:33", "/wp-content/uploads/2019/11/favicon.png", "", "66.249.70.97", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("581", "2023-04-05 16:50:33", "/wp-content/uploads/2019/11/favicon-64x50.png", "", "66.249.70.96", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("582", "2023-04-05 16:51:58", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "180.210.205.225", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("583", "2023-04-05 18:34:38", "/wp-content/uploads/2019/11/favicon.png", "", "95.108.213.223", "Mozilla/5.0 (compatible; YandexFavicons/1.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("584", "2023-04-05 18:37:07", "/about", "", "213.180.203.151", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("585", "2023-04-05 18:39:45", "/portfolios/fincas-sanchez", "", "95.108.213.182", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("586", "2023-04-05 19:11:59", "/new", "", "194.26.192.189", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("587", "2023-04-05 19:12:00", "/old", "", "194.26.192.189", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("588", "2023-04-05 19:12:04", "/newsite", "", "194.26.192.189", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("589", "2023-04-05 19:12:13", "/demo", "", "194.26.192.189", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("590", "2023-04-05 19:12:14", "/home", "", "194.26.192.189", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("591", "2023-04-05 19:12:15", "/tmp", "", "194.26.192.189", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("592", "2023-04-05 19:12:19", "/cms", "", "194.26.192.189", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("593", "2023-04-05 19:12:20", "/portal", "", "194.26.192.189", "", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("594", "2023-04-05 19:16:08", "/how-to-fix-wordpress-404-error", "", "95.108.213.184", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("595", "2023-04-05 21:20:46", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "23.95.219.207", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("596", "2023-04-05 21:43:37", "/tag/sidebar-below-content-error", "", "77.75.79.109", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("597", "2023-04-05 22:22:06", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/fix-sidebar-below-content-error-in-wordpress/", "45.86.200.8", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("598", "2023-04-05 23:53:27", "/wp-content/uploads/2021/03/fix-thumbnail-1024x537.jpg", "", "38.32.70.139", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("599", "2023-04-06 01:57:34", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "154.3.99.109", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("600", "2023-04-06 02:10:19", "/500-internal-server-error", "", "77.75.76.172", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("601", "2023-04-06 03:12:28", "/tag/ui", "", "5.255.231.84", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("602", "2023-04-06 03:26:55", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("603", "2023-04-06 03:26:57", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("604", "2023-04-06 03:26:59", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("605", "2023-04-06 03:27:00", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("606", "2023-04-06 03:49:53", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "192.210.176.172", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("607", "2023-04-06 03:51:26", "/ALFA_DATA/alfacgiapi/perl.alfa", "http://www.google.com", "194.26.192.189", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("608", "2023-04-06 03:51:28", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "194.26.192.189", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("609", "2023-04-06 03:51:29", "/alfacgiapi/perl.alfa", "http://www.google.com", "194.26.192.189", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("610", "2023-04-06 03:51:30", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "194.26.192.189", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("611", "2023-04-06 03:51:32", "/wp-content/plugins/apikey/apikey.php?test=hello", "", "194.26.192.189", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("612", "2023-04-06 03:51:32", "/plugins/content/apismtp/apismtp.php?test=hello", "", "194.26.192.189", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("613", "2023-04-06 03:51:33", "/wp-content/plugins/apikey/apikey.php.suspected?test=hello", "", "194.26.192.189", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("614", "2023-04-06 03:51:33", "/wp-plain.php", "http://www.google.com", "194.26.192.189", "Mozilla/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("615", "2023-04-06 03:51:34", "/plugins/content/apismtp/apismtp.php.suspected?test=hello", "", "194.26.192.189", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("616", "2023-04-06 04:07:24", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("617", "2023-04-06 04:07:25", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("618", "2023-04-06 04:09:55", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("619", "2023-04-06 04:09:57", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("620", "2023-04-06 04:10:02", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("621", "2023-04-06 04:10:04", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("622", "2023-04-06 04:38:02", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("623", "2023-04-06 04:38:05", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("624", "2023-04-06 05:22:48", "/wp-content/uploads/2019/11/favicon.png", "", "95.108.213.120", "Mozilla/5.0 (compatible; YandexFavicons/1.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("625", "2023-04-06 06:31:42", "/wp-includes/class-index-wordpress.php", "", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("626", "2023-04-06 06:31:43", "/wp-includes/wp-system-cloud.php", "", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("627", "2023-04-06 06:31:44", "/wp-includes/class-wp-page-icon.php", "", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("628", "2023-04-06 06:31:45", "/wp-includes/class-wordpress-license.php", "", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("629", "2023-04-06 06:37:34", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "27.130.68.200", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("630", "2023-04-06 06:38:23", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "138.128.81.48", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("631", "2023-04-06 06:55:42", "/wp-includes/class-index-wordpress.php", "", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("632", "2023-04-06 06:55:44", "/wp-includes/wp-system-cloud.php", "", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("633", "2023-04-06 06:55:46", "/wp-includes/class-wp-page-icon.php", "", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("634", "2023-04-06 06:55:49", "/wp-includes/class-wordpress-license.php", "", "143.198.222.57", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("635", "2023-04-06 06:59:51", "/2021/04", "", "77.75.77.109", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("636", "2023-04-06 07:51:04", "/about", "", "195.191.219.132", "Mozilla/5.0 (compatible; MJ12bot/v1.4.8; http://mj12bot.com/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("637", "2023-04-06 08:00:08", "/tag/change-header-color-in-wordpress", "", "77.75.79.101", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("638", "2023-04-06 08:20:02", "/wp-content/uploads/2019/11/plugin.jpg", "", "77.75.77.62", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("639", "2023-04-06 08:36:49", "/2021/07", "", "77.75.79.54", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("640", "2023-04-06 09:08:58", "/fix-image-upload-issue-in-wordpress", "https://www.ffw-hammer.de/allgemein/mauris-posuere/", "52.17.1.235", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("641", "2023-04-06 10:10:14", "/.well-known/wp-2019.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("642", "2023-04-06 10:20:46", "/how-to-fix-wordpress-memory-exhausted-error", "", "17.241.219.76", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("643", "2023-04-06 10:23:19", "/wp/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("644", "2023-04-06 10:23:21", "/new/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("645", "2023-04-06 10:23:22", "/old/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("646", "2023-04-06 10:23:23", "/wordpress/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("647", "2023-04-06 10:23:24", "/test/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("648", "2023-04-06 10:23:26", "/blog/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("649", "2023-04-06 10:23:27", "/cms/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("650", "2023-04-06 10:23:28", "/web/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("651", "2023-04-06 10:23:29", "/backup/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("652", "2023-04-06 10:23:30", "/site/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("653", "2023-04-06 10:23:31", "/oldsite/wp-admin/install.php", "", "139.59.227.231", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("654", "2023-04-06 10:26:53", "/tag/facebook-incorrect-thumbnail-issue", "", "77.75.77.54", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("655", "2023-04-06 10:48:01", "/magmi-git/magmi/web/head.php", "https://wpquickassist.com/magmi-git/magmi/web/head.php", "194.147.78.14", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/96.0.4664.110 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("656", "2023-04-06 11:35:34", "/how-to-fix-wordpress-login-redirect-loop-issue/feed", "", "66.249.75.171", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("657", "2023-04-06 11:37:14", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "196.240.109.253", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("658", "2023-04-06 11:44:00", "/how-to-fix-wordpress-keeps-logging-out-problem", "", "77.75.77.101", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("659", "2023-04-06 11:57:51", "/how-to-fix-wordpress-login-redirect-loop-issue/feed", "", "66.249.75.191", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("660", "2023-04-06 12:33:07", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "202.88.36.3", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("661", "2023-04-06 13:10:07", "/fix-sidebar-below-content-error-in-wordpress", "", "192.0.112.114", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) HeadlessChrome/112.0.5614.0 Safari/537.36 WordPress.com mShots", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("662", "2023-04-06 13:21:31", "/.well-known/apple-app-site-association", "", "66.249.87.203", "AdsBot-Google (+http://www.google.com/adsbot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("663", "2023-04-06 13:21:52", "/tag/error-establishing-database-connection", "", "77.75.79.109", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("664", "2023-04-06 13:47:54", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "52.17.1.235", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/83.0.4103.61 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("665", "2023-04-06 14:16:31", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "202.125.156.133", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("666", "2023-04-06 16:07:13", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "154.3.99.188", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("667", "2023-04-06 16:38:46", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "185.87.123.170", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("668", "2023-04-06 16:56:19", "/tag/500-internal-server-error", "", "77.75.79.54", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("669", "2023-04-06 17:25:35", "/assets/jquery_uploader/server/php/?file=tf2rghf.jpg", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("670", "2023-04-06 17:34:14", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "46.105.226.35", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("671", "2023-04-06 17:54:35", "/wp-admin/includes/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("672", "2023-04-06 17:54:43", "/wp-includes/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("673", "2023-04-06 17:54:54", "/.well-known/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("674", "2023-04-06 17:55:10", "/css/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("675", "2023-04-06 17:55:25", "/images/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("676", "2023-04-06 17:55:43", "/wp-content/languages/plugins/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("677", "2023-04-06 17:55:50", "/wp-includes/images/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("678", "2023-04-06 17:56:17", "/wp-content/languages/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("679", "2023-04-06 17:56:30", "/wp-content/upgrade/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("680", "2023-04-06 17:56:43", "/wp-content/uploads/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("681", "2023-04-06 17:57:12", "/wp-admin/js/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("682", "2023-04-06 17:57:23", "/wp-admin/css/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("683", "2023-04-06 17:57:37", "/wp-admin/css/colors/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("684", "2023-04-06 17:57:47", "/wp-admin/maint/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("685", "2023-04-06 17:57:58", "/wp-content/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("686", "2023-04-06 17:58:16", "/wp-admin/css/colors/blue/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("687", "2023-04-06 17:58:23", "/wp-admin/css/colors/coffee/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("688", "2023-04-06 17:58:42", "/wp-admin/css/colors/ectoplasm/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("689", "2023-04-06 17:58:53", "/wp-admin/css/colors/midnight/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("690", "2023-04-06 17:59:03", "/wp-admin/css/colors/modern/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("691", "2023-04-06 17:59:31", "/.well-known/pki-validation/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("692", "2023-04-06 17:59:49", "/wp-admin/images/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("693", "2023-04-06 17:59:58", "/wp-admin/css/colors/ocean/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("694", "2023-04-06 18:00:11", "/wp-admin/js/widgets/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("695", "2023-04-06 18:00:23", "/wp-includes/customize/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("696", "2023-04-06 18:00:35", "/wp-includes/pomo/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("697", "2023-04-06 18:01:13", "/wp-includes/ID3/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("698", "2023-04-06 18:01:30", "/wp-includes/IXR/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("699", "2023-04-06 18:01:58", "/wp-includes/PHPMailer/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("700", "2023-04-06 18:02:16", "/wp-includes/Requests/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("701", "2023-04-06 18:02:36", "/wp-includes/SimplePie/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("702", "2023-04-06 18:02:49", "/wp-includes/Text/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("703", "2023-04-06 18:02:59", "/wp-includes/assets/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("704", "2023-04-06 18:03:40", "/wp-includes/block-patterns/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("705", "2023-04-06 18:03:57", "/wp-includes/block-supports/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("706", "2023-04-06 18:04:26", "/wp-includes/blocks/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("707", "2023-04-06 18:04:43", "/wp-includes/certificates/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("708", "2023-04-06 18:04:51", "/wp-includes/css/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("709", "2023-04-06 18:15:14", "/portfolios_category-sitemap.xml", "", "66.249.75.173", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("710", "2023-04-06 18:46:43", "/wp-content/plugins/wc-multivendor-membership/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("711", "2023-04-06 18:56:20", "/apple-app-site-association", "", "66.249.87.222", "AdsBot-Google (+http://www.google.com/adsbot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("712", "2023-04-06 19:41:19", "/2022/05", "", "77.75.77.72", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("713", "2023-04-06 19:54:50", "/how-to-block-failed-login-attempts-on-wordpress", "", "66.249.75.191", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("714", "2023-04-06 21:04:02", "/wp-content/uploads/2021/03/fix-thumbnail-1024x537.jpg", "", "107.20.125.66", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("715", "2023-04-06 22:04:46", "/tag/failed-login-attempts-wordpress", "", "77.75.79.72", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("716", "2023-04-06 22:24:04", "/2021/03", "", "5.255.231.66", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("717", "2023-04-06 23:46:28", "/2020", "", "213.180.203.111", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("718", "2023-04-06 23:54:48", "/all-topics", "", "213.180.203.21", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("719", "2023-04-07 00:23:30", "/wp-content/uploads/kaswara/fonts_icon/a57bze8931/.__a57bze8931.php", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("720", "2023-04-07 00:23:32", "/wp-content/plugins/apikey/apikey.php", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("721", "2023-04-07 00:23:34", "/wp-content/plugins/apikey/a57bze8931.php", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("722", "2023-04-07 00:23:37", "/abruzi.php4", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("723", "2023-04-07 00:23:38", "/wp-content/x.php?1=system", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("724", "2023-04-07 00:23:39", "/wp-content/king.php", "http://www.google.com", "139.59.227.231", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("725", "2023-04-07 00:33:22", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://www.wpquickassist.com/", "131.108.16.120", "Mozilla/5.0 (X11; Linux i686) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("726", "2023-04-07 00:57:30", "/portfolios/sb-collagen", "", "85.208.98.20", "Mozilla/5.0 (compatible; SemrushBot-BA; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("727", "2023-04-07 03:10:56", "/tag/login-page-refreshing-and-redirecting-issue", "", "77.75.78.172", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("728", "2023-04-07 03:21:53", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "197.149.235.178", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("729", "2023-04-07 03:28:39", "/tag/wordpress-login-redirect-loop-issue", "", "77.75.79.72", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("730", "2023-04-07 03:59:27", "/public/assets/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("731", "2023-04-07 04:46:14", "/fix-wordpress-login-page-refreshing-redirecting-issue", "", "66.249.75.169", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("732", "2023-04-07 04:50:26", "/wp-content/uploads/2021/07/How-to-Fix-Add-Media-Button-Not-Working-in-WordPress.jpg", "", "157.55.39.227", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("733", "2023-04-07 05:55:35", "/post_tag-sitemap.xml", "", "66.249.75.161", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("734", "2023-04-07 06:03:17", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "20.124.222.49", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("735", "2023-04-07 06:18:25", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "103.211.15.164", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/63.0.3239.132 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("736", "2023-04-07 06:20:53", "/cgi-sys/suspendedpage.cgi", "", "77.75.79.95", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("737", "2023-04-07 07:06:27", "/2021/07", "", "17.241.75.151", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("738", "2023-04-07 07:07:40", "/wp-content/uploads/2020/10/wordPress-not-uploading-images.jpg", "", "128.30.195.65", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("739", "2023-04-07 07:15:07", "/portfolios/ipc", "", "77.75.79.54", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("740", "2023-04-07 08:37:23", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("741", "2023-04-07 08:37:25", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("742", "2023-04-07 09:37:51", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("743", "2023-04-07 09:37:53", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("744", "2023-04-07 09:37:54", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("745", "2023-04-07 09:37:56", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("746", "2023-04-07 09:39:40", "/how-to-fix-error-establishing-a-database-connection-in-wordpress", "", "54.236.1.13", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("747", "2023-04-07 09:41:55", "/fix-image-upload-issue-in-wordpress", "", "77.75.79.101", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("748", "2023-04-07 10:10:12", "/tag/syntax-error-in-wordpress", "", "77.75.79.54", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("749", "2023-04-07 10:26:16", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "104.168.82.34", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; Xbox; Xbox One) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edge/44.18363.8131", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("750", "2023-04-07 11:07:28", "/fix-wordpress-not-sending-email-issue", "", "54.236.1.13", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("751", "2023-04-07 11:29:51", "/wp/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("752", "2023-04-07 11:29:53", "/new/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("753", "2023-04-07 11:29:54", "/old/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("754", "2023-04-07 11:29:55", "/wordpress/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("755", "2023-04-07 11:29:57", "/test/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("756", "2023-04-07 11:29:58", "/blog/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("757", "2023-04-07 11:30:00", "/cms/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("758", "2023-04-07 11:30:01", "/web/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("759", "2023-04-07 11:30:03", "/backup/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("760", "2023-04-07 11:30:04", "/site/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("761", "2023-04-07 11:30:06", "/oldsite/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("762", "2023-04-07 11:51:10", "/tag/sidebar-below-content-error", "", "5.45.207.158", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("763", "2023-04-07 12:13:11", "/wp-content/uploads/2019/11/fix-responsiveness1-1.jpg", "", "128.30.195.59", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("764", "2023-04-07 12:20:11", "/tag/change-blog-name-on-wordpress", "", "77.75.79.54", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("765", "2023-04-07 12:39:10", "/how-to-fix-add-media-button-not-working-in-wordpress/feed", "", "77.75.79.109", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("766", "2023-04-07 13:16:15", "/how-to-change-wordpress-theme-without-losing-content", "", "66.249.70.105", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("767", "2023-04-07 13:46:39", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "103.155.217.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("768", "2023-04-07 13:54:51", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "54.147.0.110", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("769", "2023-04-07 14:12:23", "/2022/06", "", "77.75.79.72", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("770", "2023-04-07 14:59:58", "/wp-content/uploads/2021/06/How-to-Fix-the-Error-Establishing-Database-Connection-in-WordPress.jpg", "", "216.244.66.234", "Mozilla/5.0 (compatible; DotBot/1.2; +https://opensiteexplorer.org/dotbot; help@moz.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("771", "2023-04-07 15:50:40", "/wp-content/uploads/2020/10/wp-maintenance-mode.jpg", "", "104.238.222.54", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("772", "2023-04-07 16:11:31", "/tag/failed-login-attempts-on-wordpress", "", "77.75.78.172", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("773", "2023-04-07 16:14:37", "/wp-content/uploads/2021/04/wp-sidebar-error.jpg", "", "69.63.184.118", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("774", "2023-04-07 16:14:38", "/wp-content/uploads/2021/04/500error1.jpg", "", "69.63.184.118", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("775", "2023-04-07 16:14:39", "/wp-content/uploads/2021/04/wp-syntax-error.jpg", "", "69.63.184.120", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("776", "2023-04-07 16:50:21", "/portfolios/panoroof", "", "77.75.76.172", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("777", "2023-04-07 16:52:40", "/portfolios/anthrop", "", "213.180.203.87", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("778", "2023-04-07 17:27:34", "/author/fixwp", "", "77.75.79.54", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("779", "2023-04-07 17:47:19", "/portfolios/furniture-shop", "", "77.75.79.72", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("780", "2023-04-07 18:31:39", "/tag/fix-wordpress-rss-feed-errors", "", "213.180.203.97", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("781", "2023-04-07 18:47:23", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "192.111.139.162", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("782", "2023-04-07 20:22:57", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("783", "2023-04-07 20:23:14", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("784", "2023-04-07 20:23:43", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("785", "2023-04-07 20:23:58", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("786", "2023-04-07 20:46:34", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "181.177.111.213", "Mozilla/5.0 (X11; Ubuntu; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("787", "2023-04-07 21:03:30", "/wp-content/uploads/2021/03/avatar.png", "", "104.238.222.54", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("788", "2023-04-07 21:04:41", "/2022", "", "77.75.76.172", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("789", "2023-04-08 00:43:18", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("790", "2023-04-08 00:43:18", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("791", "2023-04-08 01:03:46", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "62.210.127.188", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("792", "2023-04-08 01:04:36", "/how-to-fix-wordpress-rss-feed-errors/feed", "", "77.75.76.172", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("793", "2023-04-08 02:02:55", "/author-sitemap.xml", "", "66.249.70.107", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("794", "2023-04-08 02:39:08", "/how-to-fix-your-website-stuck-in-wordpress-maintenance-mode", "", "17.241.227.168", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("795", "2023-04-08 03:29:36", "/fix-sidebar-below-content-error-in-wordpress", "", "66.249.70.109", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.5615.49 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("796", "2023-04-08 04:25:16", "/how-to-fix-add-media-button-not-working-in-wordpress", "", "66.249.70.125", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.5615.49 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("797", "2023-04-08 05:26:00", "/2020/10", "", "77.75.79.62", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("798", "2023-04-08 05:40:55", "/wp-content/uploads/2020/10/wordPress-not-uploading-images.jpg", "", "128.30.195.66", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("799", "2023-04-08 05:48:46", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "220.245.73.112", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("800", "2023-04-08 06:50:54", "/portfolios/cryomed", "", "77.75.79.95", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("801", "2023-04-08 06:54:52", "/wp-admin/css/colors/blue/uploader.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("802", "2023-04-08 06:55:12", "/wp-admin/shell20211028.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("803", "2023-04-08 06:55:24", "/wp-admin/css/colors/blue/nin.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("804", "2023-04-08 07:01:12", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "204.10.194.8", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("805", "2023-04-08 07:01:12", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "204.10.194.8", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("806", "2023-04-08 07:01:13", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "174.138.167.178", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("807", "2023-04-08 07:05:51", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "128.30.195.65", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("808", "2023-04-08 07:20:30", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://www.wpquickassist.com/", "5.78.71.201", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("809", "2023-04-08 07:45:40", "/portfolio", "", "17.241.75.10", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("810", "2023-04-08 08:40:07", "/tag/add-media-button-not-working", "", "77.75.79.72", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("811", "2023-04-08 09:50:51", "/portfolios/sun-fixtures", "", "213.180.203.60", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("812", "2023-04-08 10:56:40", "/fix-500-internal-server-error-on-wordpress", "https://www.wpquickassist.com/", "46.35.247.89", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("813", "2023-04-08 11:42:23", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "139.99.68.200", "Mozilla/5.0 (X11; Fedora; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("814", "2023-04-08 11:57:41", "/2021/03", "", "77.75.77.62", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("815", "2023-04-08 13:20:54", "/fix-sidebar-below-content-error-in-wordpress", "", "17.241.219.140", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("816", "2023-04-08 13:29:20", "/public/assets/plugins/jquery_uploader/server/php/?file=tf2rghf.jpg", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("817", "2023-04-08 14:20:56", "/wp-admin/includes/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("818", "2023-04-08 14:21:27", "/wp-includes/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("819", "2023-04-08 14:21:46", "/.well-known/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("820", "2023-04-08 14:21:59", "/css/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("821", "2023-04-08 14:22:18", "/home/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("822", "2023-04-08 14:22:38", "/images/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("823", "2023-04-08 14:22:55", "/wp-includes/images/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("824", "2023-04-08 14:23:06", "/wp-admin/user/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("825", "2023-04-08 14:23:15", "/wp-content/languages/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("826", "2023-04-08 14:23:28", "/wp-content/upgrade/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("827", "2023-04-08 14:23:41", "/wp-content/uploads/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("828", "2023-04-08 14:24:07", "/wp-admin/network/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("829", "2023-04-08 14:24:24", "/wp-admin/js/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("830", "2023-04-08 14:24:45", "/wp-admin/css/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("831", "2023-04-08 14:25:06", "/wp-admin/css/colors/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("832", "2023-04-08 14:25:33", "/wp-admin/maint/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("833", "2023-04-08 14:25:51", "/wp-content/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("834", "2023-04-08 14:26:04", "/wp-admin/css/colors/blue/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("835", "2023-04-08 14:26:26", "/wp-admin/css/colors/coffee/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("836", "2023-04-08 14:26:41", "/wp-admin/css/colors/ectoplasm/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("837", "2023-04-08 14:27:02", "/wp-admin/css/colors/midnight/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("838", "2023-04-08 14:27:28", "/wp-admin/css/colors/modern/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("839", "2023-04-08 14:27:45", "/.well-known/pki-validation/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("840", "2023-04-08 14:28:03", "/wp-admin/images/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("841", "2023-04-08 14:28:09", "/wp-admin/css/colors/ocean/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("842", "2023-04-08 14:28:34", "/wp-admin/js/widgets/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("843", "2023-04-08 14:28:48", "/wp-includes/customize/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("844", "2023-04-08 14:29:02", "/wp-includes/pomo/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("845", "2023-04-08 14:29:14", "/wp-includes/ID3/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("846", "2023-04-08 14:29:24", "/wp-includes/IXR/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("847", "2023-04-08 14:29:47", "/wp-includes/PHPMailer/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("848", "2023-04-08 14:29:47", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "166.1.10.126", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("849", "2023-04-08 14:30:01", "/wp-includes/Requests/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("850", "2023-04-08 14:30:26", "/wp-includes/SimplePie/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("851", "2023-04-08 14:31:15", "/wp-includes/Text/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("852", "2023-04-08 14:31:38", "/wp-includes/assets/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("853", "2023-04-08 14:31:49", "/wp-includes/block-patterns/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("854", "2023-04-08 14:32:02", "/wp-includes/block-supports/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("855", "2023-04-08 14:32:17", "/wp-includes/blocks/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("856", "2023-04-08 14:32:24", "/wp-includes/certificates/xmrlpc.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("857", "2023-04-08 15:45:13", "/wp-content/uploads/2019/11/fix-responsiveness1-1.jpg", "", "119.96.11.234", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("858", "2023-04-08 16:58:04", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "128.30.195.65", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("859", "2023-04-08 18:09:03", "/casestudies-sitemap.xml", "", "66.249.79.205", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("860", "2023-04-08 18:51:13", "/2021/07", "", "95.108.213.247", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("861", "2023-04-08 19:01:29", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "54.82.172.113", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("862", "2023-04-08 19:58:34", "/fix-image-upload-issue-in-wordpress", "", "17.241.75.38", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("863", "2023-04-08 20:02:25", "/wp-content/plugins/zendrop-dropshipping-and-fulfillment/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("864", "2023-04-08 20:05:24", "/bc", "https://wpquickassist.com/bc", "128.90.141.11", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("865", "2023-04-08 20:05:25", "/bk", "https://wpquickassist.com/bk", "128.90.141.11", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("866", "2023-04-08 20:05:28", "/old", "https://wpquickassist.com/old", "128.90.141.11", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("867", "2023-04-08 20:05:31", "/home", "https://wpquickassist.com/home", "128.90.141.11", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("868", "2023-04-08 20:21:59", "/complete-order/?selected_package=1", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("869", "2023-04-08 20:32:16", "/wp-content/uploads/2021/03/fix-thumbnail-1024x537.jpg", "", "140.205.11.12", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("870", "2023-04-08 21:00:08", "/wp-content/plugins/n-media-woocommerce-checkout-fields/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("871", "2023-04-08 21:19:12", "/wp-content/plugins/videowhisper-live-streaming-integration/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("872", "2023-04-08 21:37:33", "/wp-content/plugins/js-support-ticket/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("873", "2023-04-08 21:56:01", "/wp-content/themes/statfort-new/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("874", "2023-04-08 22:14:48", "/wp-content/themes/faith-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("875", "2023-04-08 22:31:05", "/wp/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("876", "2023-04-08 22:31:07", "/new/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("877", "2023-04-08 22:31:09", "/old/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("878", "2023-04-08 22:31:10", "/wordpress/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("879", "2023-04-08 22:31:12", "/test/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("880", "2023-04-08 22:31:14", "/blog/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("881", "2023-04-08 22:31:15", "/cms/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("882", "2023-04-08 22:31:16", "/web/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("883", "2023-04-08 22:31:17", "/backup/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("884", "2023-04-08 22:31:19", "/site/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("885", "2023-04-08 22:31:21", "/oldsite/wp-admin/install.php", "", "159.65.133.201", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("886", "2023-04-08 22:33:03", "/wp-content/uploads/2022/05/qa-1170x630.jpg", "", "40.77.167.107", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("887", "2023-04-08 22:33:41", "/wp-content/themes/soccer-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("888", "2023-04-08 22:52:30", "/wp-content/themes/churchlife/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("889", "2023-04-08 23:02:32", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "38.170.26.36", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("890", "2023-04-08 23:11:18", "/wp-content/themes/onelife/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("891", "2023-04-08 23:30:11", "/wp-content/themes/snapture/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("892", "2023-04-08 23:49:09", "/wp-content/themes/theme-deejay/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("893", "2023-04-08 23:59:43", "/wp-content/plugins/instabuilder2/cache/add.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("894", "2023-04-09 00:08:13", "/wp-content/themes/bolster-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("895", "2023-04-09 00:27:23", "/wp-content/themes/rocky-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("896", "2023-04-09 01:10:24", "/fix-sidebar-below-content-error-in-wordpress", "", "93.158.91.39", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/94.0.4606.81 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("897", "2023-04-09 01:29:16", "/wp-content/plugins/elementor-pro/modules/woocommerce/module.php", "http://www.google.com", "178.159.37.41", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("898", "2023-04-09 01:29:20", "/wp-content/plugins/woocommerce/woocommerce.php", "http://www.google.com", "178.159.37.41", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("899", "2023-04-09 01:30:36", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "38.15.140.78", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("900", "2023-04-09 02:18:45", "/wp-content/uploads/2019/11/favicon-64x50.png", "", "66.249.79.221", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("901", "2023-04-09 03:13:52", "/wp-content/plugins/woocommerce-payments/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("902", "2023-04-09 03:13:55", "/wp-content/plugins/wp-email-capture/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("903", "2023-04-09 03:13:59", "/wp-content/plugins/zendrop-dropshipping-and-fulfillment/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("904", "2023-04-09 03:14:05", "/complete-order/?selected_package=1", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("905", "2023-04-09 03:14:14", "/wp-content/plugins/wp-sms/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("906", "2023-04-09 03:14:20", "/wp-content/plugins/n-media-woocommerce-checkout-fields/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("907", "2023-04-09 03:14:24", "/wp-content/plugins/videowhisper-live-streaming-integration/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("908", "2023-04-09 03:14:25", "/wp-content/plugins/learnpress/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("909", "2023-04-09 03:14:29", "/wp-content/plugins/extensive-vc-addon/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("910", "2023-04-09 03:14:34", "/wp-content/plugins/js-support-ticket/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("911", "2023-04-09 03:14:38", "/wp-content/themes/statfort-new/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("912", "2023-04-09 03:14:45", "/wp-content/themes/faith-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("913", "2023-04-09 03:14:49", "/wp-content/themes/soccer-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("914", "2023-04-09 03:14:54", "/wp-content/themes/churchlife/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("915", "2023-04-09 03:14:59", "/wp-content/themes/onelife/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("916", "2023-04-09 03:15:05", "/wp-content/themes/snapture/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("917", "2023-04-09 03:15:09", "/wp-content/themes/theme-deejay/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("918", "2023-04-09 03:15:12", "/wp-content/themes/bolster-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("919", "2023-04-09 03:15:13", "/wp-content/themes/rocky-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("920", "2023-04-09 03:15:15", "/wp-content/themes/bolster/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("921", "2023-04-09 03:15:17", "/wp-content/themes/soundblast/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("922", "2023-04-09 03:15:21", "/wp-content/themes/spikes-black/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("923", "2023-04-09 03:15:22", "/wp-content/themes/spikes/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("924", "2023-04-09 03:15:24", "/wp-content/themes/kingclub-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("925", "2023-04-09 03:15:30", "/wp-content/themes/club-theme/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("926", "2023-04-09 03:15:33", "/wp-content/themes/statfort/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("927", "2023-04-09 03:15:38", "/wp-content/themes/aidreform/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("928", "2023-04-09 03:15:40", "/wp-content/themes/footysquare/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("929", "2023-04-09 03:15:42", "/wp-content/themes/westand/include/lang_upload.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("930", "2023-04-09 03:15:47", "/wp-content/plugins/dsp_dating/wpdating-gallery/lib/server/php", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("931", "2023-04-09 03:15:52", "/wp-content/plugins/yith-woocommerce-gift-cards-premium/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("932", "2023-04-09 03:15:55", "/wp-content/plugins/wholesale-market-for-woocommerce/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("933", "2023-04-09 03:15:58", "/wp-content/plugins/membership-for-woocommerce/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("934", "2023-04-09 03:15:59", "/wp-content/plugins/wp-upg/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("935", "2023-04-09 03:16:07", "/wp-content/plugins/user-verification/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("936", "2023-04-09 03:16:11", "/wp-content/plugins/booking-calendar/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("937", "2023-04-09 03:16:19", "/wp-content/plugins/usc-e-shop/functions/content-log.php?logfile=./../../../../wp-config.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("938", "2023-04-09 03:16:24", "/wp-content/plugins/woo-refund-and-exchange-lite/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("939", "2023-04-09 03:16:29", "/wp-content/plugins/armember/js/arm_widgets_js.js", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("940", "2023-04-09 03:16:33", "/wp-content/plugins/armember/documentation/index.html", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("941", "2023-04-09 03:16:38", "/wp-content/plugins/jobboardwp/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("942", "2023-04-09 03:16:40", "/wp-content/themes/listingo/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("943", "2023-04-09 03:16:47", "/wp-content/themes/listingo/js/listingo_callbacks.js", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("944", "2023-04-09 03:16:51", "/wp-content/themes/greyd_suite/style.css", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("945", "2023-04-09 03:16:56", "/wp-content/plugins/simply-schedule-appointments/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("946", "2023-04-09 03:17:01", "/wp-content/plugins/directorist/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("947", "2023-04-09 03:17:01", "/wp-content/plugins/all-in-one-video-gallery/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("948", "2023-04-09 03:17:04", "/wp-content/plugins/alphabetic-pagination/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("949", "2023-04-09 03:17:08", "/wp-content/plugins/scripts-organizer/plugins/meta-box/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("950", "2023-04-09 03:17:12", "/wp-content/themes/workreap/style.css", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("951", "2023-04-09 03:17:18", "/wp-content/plugins/wpgateway/css/style.css", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("952", "2023-04-09 03:17:23", "/wp-content/plugins/ultimate-member/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("953", "2023-04-09 03:17:26", "/wp-content/plugins/ninja-forms/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("954", "2023-04-09 03:17:29", "/wp-content/plugins/armember-membership/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("955", "2023-04-09 03:17:32", "/wp-content/plugins/wp-live-chat-support-pro/css/wplc_styles_pro.css", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("956", "2023-04-09 03:17:39", "/wp-content/plugins/quiz-master-next/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("957", "2023-04-09 03:17:45", "/wp-content/plugins/wp-user-avatar/changelog.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("958", "2023-04-09 03:17:48", "/wp-content/plugins/sitemap-by-click5/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("959", "2023-04-09 03:17:51", "/wp-content/plugins/nd-restaurant-reservations/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("960", "2023-04-09 03:17:55", "/wp-content/plugins/nd-donations/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("961", "2023-04-09 03:17:58", "/wp-content/plugins/nd-booking/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("962", "2023-04-09 03:18:01", "/wp-content/plugins/nd-shortcodes/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("963", "2023-04-09 03:18:06", "/wp-content/plugins/nd-learning/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("964", "2023-04-09 03:18:08", "/wp-content/plugins/wpcargo/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("965", "2023-04-09 03:18:09", "/wp-content/plugins/woo-product-table/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("966", "2023-04-09 03:18:09", "/wp-content/plugins/udraw/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("967", "2023-04-09 03:18:10", "/wp-content/plugins/tatsu/changelog.md", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("968", "2023-04-09 03:18:14", "/wp-content/plugins/post-pdf-export/dompdf/dompdf.php?input_file=../../../../wp-config.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("969", "2023-04-09 03:18:18", "/wp-content/plugins/web-portal-lite-client-portal-secure-file-sharing-private-messaging/includes/libs/pdf/dompdf.php?input_file=../../../../../../wp-config.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("970", "2023-04-09 03:18:25", "/wp-content/plugins/cherry-plugin/admin/import-export/download-content.php?file=../../../../../wp-config.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("971", "2023-04-09 03:18:35", "/wp-content/plugins/mapsvg/gm_download.php?file=/wp-config.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("972", "2023-04-09 03:18:42", "/wp-content/plugins/mapsvg-lite-interactive-vector-maps/gm_download.php?file=/wp-config.php", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("973", "2023-04-09 03:18:47", "/wp-content/plugins/masterstudy-lms-learning-management-system/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("974", "2023-04-09 03:18:54", "/wp-content/plugins/vc-tabs/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("975", "2023-04-09 03:18:57", "/wp-content/plugins/shortcode-addons/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("976", "2023-04-09 03:18:59", "/wp-content/plugins/dzs-zoomsounds/admin/admin.css", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("977", "2023-04-09 03:19:05", "/wp-content/plugins/mstore-api/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("978", "2023-04-09 03:19:08", "/wp-content/plugins/superlogoshowcase-wp/css/sls-wp-admin.css", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("979", "2023-04-09 03:19:12", "/wp-content/plugins/super-interactive-maps/css/sim-wp-admin.css", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("980", "2023-04-09 03:19:19", "/wp-content/plugins/superstorefinder-wp/css/ssf-wp-admin.css", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("981", "2023-04-09 03:19:24", "/wp-content/plugins/e-signature/page-template/default/style.css", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("982", "2023-04-09 03:19:29", "/wp-content/plugins/angwp/__UPDATES.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("983", "2023-04-09 03:19:32", "/wp-content/plugins/ait-csv-import-export/changelog.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("984", "2023-04-09 03:19:38", "/wp-content/plugins/image-hover-effects-ultimate/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("985", "2023-04-09 03:19:41", "/wp-content/plugins/ulisting/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("986", "2023-04-09 03:19:43", "/wp-content/plugins/wp-pinterest-automatic/changelog", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("987", "2023-04-09 03:19:45", "/wp-content/plugins/capabilities-pro/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("988", "2023-04-09 03:19:50", "/wp-content/plugins/capability-manager-enhanced/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("989", "2023-04-09 03:19:53", "/wp-content/plugins/wp-automatic/css/wp-automatic.css", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("990", "2023-04-09 03:19:58", "/wp-content/plugins/wp-automatic/changelog", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; ONEPLUS A6013) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("991", "2023-04-09 03:20:00", "/wp-content/plugins/wp-user-extra-fields/js/wpuef-configurator.js", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("992", "2023-04-09 03:20:05", "/wp-content/plugins/woocommerce-upload-files/js/wcuf-admin-menu.js", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 12; SM-A205U) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.57 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("993", "2023-04-09 03:20:09", "/wp-content/plugins/emails-verification-for-woocommerce/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("994", "2023-04-09 03:20:14", "/wp-content/plugins/woocommerce-jetpack/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("995", "2023-04-09 03:20:20", "/wp-content/plugins/advanced-import/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (iPhone; CPU iPhone OS 16_3 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) CriOS/111.0.5563.72 Mobile/15E148 Safari/604.1", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("996", "2023-04-09 03:20:23", "/wp-content/plugins/themegrill-demo-importer/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_2_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("997", "2023-04-09 03:20:28", "/wp-content/plugins/wp-time-capsule/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("998", "2023-04-09 03:20:32", "/wp-content/plugins/iwp-client/readme.txt", "", "172.245.254.204", "Mozilla/5.0 (Linux; Android 11; Lenovo YT-J706X) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("999", "2023-04-09 03:23:30", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "5.157.61.146", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1000", "2023-04-09 03:26:36", "/how-to-fix-wordpress-rss-feed-errors", "", "17.241.219.121", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1001", "2023-04-09 03:47:56", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://www.wpquickassist.com/", "27.130.68.200", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1002", "2023-04-09 04:05:46", "/2018", "", "95.108.213.164", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1003", "2023-04-09 07:05:22", "/fix-password-reset-key-error-in-wordpress", "", "213.180.203.232", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1004", "2023-04-09 07:15:45", "/portfolios/zagas-design", "", "213.180.203.3", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1005", "2023-04-09 07:16:34", "/bc", "http://www.wpquickassist.com/bc", "69.167.12.25", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1006", "2023-04-09 07:16:35", "/bk", "http://www.wpquickassist.com/bk", "69.167.12.25", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1007", "2023-04-09 07:16:36", "/old", "http://www.wpquickassist.com/old", "69.167.12.25", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1008", "2023-04-09 07:16:39", "/home", "http://www.wpquickassist.com/home", "69.167.12.25", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/74.0.3729.169 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1009", "2023-04-09 08:21:48", "/500-internal-server-error", "", "17.241.75.97", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1010", "2023-04-09 08:24:38", "/market-research", "", "5.255.231.26", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1011", "2023-04-09 08:26:21", "/market-research", "", "213.180.203.202", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1012", "2023-04-09 08:34:06", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "104.227.168.37", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1013", "2023-04-09 08:50:53", "/wp-content/themes/pridmag/db.php?u", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1014", "2023-04-09 08:51:05", "/wp-content/themes/seotheme/db.php?u", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1015", "2023-04-09 08:51:16", "/wp-content/plugins/seoplugins/db.php", "", "193.47.61.30", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1016", "2023-04-09 09:31:24", "/assets/global/plugins/jquery_uploader/server/php/?file=tf2rghf.jpg", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1017", "2023-04-09 10:00:59", "/wp-content/plugins/formidable/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1018", "2023-04-09 11:06:42", "/how-to-fix-wordpress-404-error", "", "17.241.75.42", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1019", "2023-04-09 11:44:00", "/how-to-fix-wordpress-memory-exhausted-error", "", "54.236.1.11", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1020", "2023-04-09 14:52:07", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "20.232.104.46", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1021", "2023-04-09 15:06:14", "/tag/reputation", "", "95.108.213.152", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1022", "2023-04-09 15:58:50", "/tag/wordpress-not-sending-emails", "", "213.180.203.48", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1023", "2023-04-09 15:59:45", "/tag/change-header-color-in-wordpress", "", "17.241.227.19", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1024", "2023-04-09 16:16:43", "/how-to-change-wordpress-theme-without-losing-content", "", "66.249.75.189", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1025", "2023-04-09 16:48:36", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "173.213.84.25", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1026", "2023-04-09 16:51:54", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://www.wpquickassist.com/", "73.190.101.172", "Mozilla/5.0 (Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1027", "2023-04-09 16:56:02", "/how-to-change-wordpress-theme-without-losing-content", "", "66.249.79.201", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1028", "2023-04-09 17:12:59", "/guide-how-to-create-a-wordpress-account", "", "192.95.30.12", "Mozilla/5.0 (compatible; MJ12bot/v1.4.8; http://mj12bot.com/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1029", "2023-04-09 17:27:30", "/wp-content/uploads/2020/10/wordPress-not-uploading-images.jpg", "", "173.252.83.18", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1030", "2023-04-09 18:11:56", "/testimonial-sitemap.xml", "", "66.249.79.203", "Mozilla/5.0 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1031", "2023-04-09 18:47:20", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "154.16.206.62", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1032", "2023-04-09 20:27:37", "/2021/03", "", "77.75.79.109", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1033", "2023-04-09 21:39:33", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "196.242.20.72", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1034", "2023-04-09 22:44:35", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "173.234.225.124", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1035", "2023-04-09 22:51:41", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue", "154.13.105.124", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1036", "2023-04-09 23:10:10", "/wp-content/themes/finley/min.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1037", "2023-04-10 01:16:02", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "202.186.222.240", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1038", "2023-04-10 01:36:03", "/.well-known/apple-app-site-association", "", "72.14.199.221", "AdsBot-Google (+http://www.google.com/adsbot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1039", "2023-04-10 01:43:51", "/apple-app-site-association", "", "72.14.199.223", "AdsBot-Google (+http://www.google.com/adsbot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1040", "2023-04-10 03:16:22", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "120.92.12.179", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1041", "2023-04-10 04:06:07", "/wp-content/uploads/2019/11/website-theme-277x221.jpg", "", "66.249.79.203", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1042", "2023-04-10 05:04:12", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1043", "2023-04-10 05:04:14", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1044", "2023-04-10 05:04:15", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1045", "2023-04-10 05:04:16", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1046", "2023-04-10 06:05:12", "/wp-content/plugins/w0rdpr3ssnew/about.phpp", "http://www.google.com", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1047", "2023-04-10 08:07:37", "/wp-includes/class-index-wordpress.php", "", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1048", "2023-04-10 08:07:40", "/wp-includes/wp-system-cloud.php", "", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1049", "2023-04-10 08:07:41", "/wp-includes/class-wp-page-icon.php", "", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1050", "2023-04-10 08:07:42", "/wp-includes/class-wordpress-license.php", "", "146.190.102.198", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1051", "2023-04-10 08:17:13", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "154.3.99.125", "Mozilla/5.0 (Windows NT 10.0) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1052", "2023-04-10 08:17:52", "/wp-content/plugins/wp-shoutbox-live-chat/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1053", "2023-04-10 08:36:50", "/turn-off-php-errors-in-wordpress", "", "17.241.75.221", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1054", "2023-04-10 10:24:52", "/how-to-fix-wordpress-keeps-logging-out-problem", "https://www.wpquickassist.com/", "154.205.185.24", "Mozilla/5.0 (Windows NT 10.0; WOW64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1055", "2023-04-10 10:30:44", "/wp/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1056", "2023-04-10 10:30:47", "/new/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1057", "2023-04-10 10:30:48", "/old/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1058", "2023-04-10 10:30:50", "/wordpress/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1059", "2023-04-10 10:30:51", "/test/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1060", "2023-04-10 10:30:52", "/blog/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1061", "2023-04-10 10:30:53", "/cms/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1062", "2023-04-10 10:30:54", "/web/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1063", "2023-04-10 10:30:55", "/backup/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1064", "2023-04-10 10:30:56", "/site/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1065", "2023-04-10 10:30:57", "/oldsite/wp-admin/install.php", "", "146.190.102.198", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1066", "2023-04-10 10:37:18", "/guide-how-to-create-a-wordpress-account", "", "176.9.117.99", "Mozilla/5.0 (compatible; MegaIndex.ru/2.0; +http://megaindex.com/crawler)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1067", "2023-04-10 10:40:55", "/fix-wordpress-login-page-refreshing-redirecting-issue", "https://yandex.ru/", "178.140.63.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:109.0) Gecko/20100101 Firefox/111.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1068", "2023-04-10 10:50:49", "/tag/change-author-in-wordpress", "", "77.75.77.109", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1069", "2023-04-10 11:25:34", "/wp-admin/includes/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1070", "2023-04-10 11:25:43", "/wp-includes/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1071", "2023-04-10 11:25:51", "/.well-known/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1072", "2023-04-10 11:26:07", "/css/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1073", "2023-04-10 11:26:29", "/images/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1074", "2023-04-10 11:26:55", "/wp-content/languages/plugins/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1075", "2023-04-10 11:27:00", "/wp-includes/images/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1076", "2023-04-10 11:27:10", "/wp-admin/user/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1077", "2023-04-10 11:27:34", "/wp-content/languages/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1078", "2023-04-10 11:27:46", "/wp-content/upgrade/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1079", "2023-04-10 11:27:53", "/wp-content/uploads/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1080", "2023-04-10 11:28:33", "/how-to-fix-wordpress-keeps-logging-out-problem", "", "95.108.213.172", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1081", "2023-04-10 11:28:49", "/wp-admin/network/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1082", "2023-04-10 11:29:01", "/wp-admin/js/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1083", "2023-04-10 11:29:16", "/wp-admin/css/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1084", "2023-04-10 11:29:38", "/wp-admin/css/colors/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1085", "2023-04-10 11:29:51", "/wp-admin/maint/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1086", "2023-04-10 11:30:19", "/wp-content/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1087", "2023-04-10 11:30:41", "/wp-admin/css/colors/blue/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1088", "2023-04-10 11:30:50", "/wp-admin/css/colors/coffee/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1089", "2023-04-10 11:31:07", "/wp-admin/css/colors/ectoplasm/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1090", "2023-04-10 11:31:25", "/how-to-back-up-wordpress-and-switch-hosting/tips-and-tricks.html", "", "176.9.117.99", "Mozilla/5.0 (compatible; MegaIndex.ru/2.0; +http://megaindex.com/crawler)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1091", "2023-04-10 11:31:29", "/wp-admin/css/colors/midnight/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1092", "2023-04-10 11:31:45", "/wp-admin/css/colors/modern/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1093", "2023-04-10 11:32:10", "/.well-known/pki-validation/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1094", "2023-04-10 11:32:41", "/wp-admin/images/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1095", "2023-04-10 11:32:56", "/wp-admin/css/colors/ocean/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1096", "2023-04-10 11:33:25", "/wp-admin/js/widgets/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1097", "2023-04-10 11:33:36", "/wp-includes/customize/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1098", "2023-04-10 11:33:55", "/wp-includes/pomo/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1099", "2023-04-10 11:34:06", "/wp-includes/ID3/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1100", "2023-04-10 11:34:24", "/wp-includes/IXR/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1101", "2023-04-10 11:34:57", "/wp-includes/PHPMailer/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1102", "2023-04-10 11:35:12", "/wp-includes/Requests/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1103", "2023-04-10 11:35:37", "/wp-includes/SimplePie/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1104", "2023-04-10 11:36:03", "/wp-includes/Text/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1105", "2023-04-10 11:36:22", "/wp-includes/assets/moon.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1106", "2023-04-10 11:48:58", "/admin/assets/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1107", "2023-04-10 12:18:34", "/upl.php", "http://www.google.com.hk", "33.59.184.100", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.90 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1108", "2023-04-10 12:19:24", "/wp_wol.php", "http://www.google.com.hk", "33.59.184.100", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/42.0.2311.90 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1109", "2023-04-10 13:43:57", "/how-to-fix-wordpress-login-redirect-loop-issue", "", "77.75.78.171", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1110", "2023-04-10 15:23:14", "/wp-content/uploads/2020/11/wp-logout1.jpg", "", "69.171.249.20", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1111", "2023-04-10 15:40:41", "/wp-content/uploads/2021/03/avatar.png", "", "47.246.164.146", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1112", "2023-04-10 16:24:57", "/wp-content/uploads/2021/04/wp-syntax-error-1024x537.jpg", "", "47.246.164.139", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1113", "2023-04-10 16:46:33", "/wp-content/uploads/2021/04/wp-syntax-error-1024x537.jpg", "", "104.238.222.54", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1114", "2023-04-10 17:02:46", "/fix-error-establishing-a-database-connection-in-wordpress/feed", "", "77.75.78.172", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1115", "2023-04-10 18:06:25", "/wp-content/uploads/2021/07/How-to-Fix-Add-Media-Button-Not-Working-in-WordPress-1022x537.jpg", "", "77.75.79.72", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1116", "2023-04-10 18:34:25", "/wp-content/uploads/2020/10/wp-maintenance-mode.jpg", "", "47.246.164.152", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1117", "2023-04-10 19:45:35", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "77.220.50.125", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1118", "2023-04-10 20:05:18", "/wp-content/plugins/lead-generated/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1119", "2023-04-10 20:13:21", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "103.240.99.245", "Mozilla/5.0 (X11; Linux i686; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1120", "2023-04-10 20:55:01", "/how-to-fix-add-media-button-not-working-in-wordpress", "", "66.249.79.203", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.5615.49 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1121", "2023-04-11 01:20:59", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1122", "2023-04-11 01:21:00", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1123", "2023-04-11 01:58:14", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "182.253.182.177", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1124", "2023-04-11 03:19:20", "/tag/change-header-color-in-wordpress", "", "77.75.79.95", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1125", "2023-04-11 03:25:39", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1126", "2023-04-11 03:25:40", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1127", "2023-04-11 03:41:46", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1128", "2023-04-11 03:41:48", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1129", "2023-04-11 03:41:49", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1130", "2023-04-11 03:41:50", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1131", "2023-04-11 04:40:14", "/wp-includes/class-index-wordpress.php", "", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1132", "2023-04-11 04:40:15", "/wp-includes/wp-system-cloud.php", "", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1133", "2023-04-11 04:40:17", "/wp-includes/class-wp-page-icon.php", "", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1134", "2023-04-11 04:40:18", "/wp-includes/class-wordpress-license.php", "", "143.198.82.44", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1135", "2023-04-11 04:46:38", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "104.144.83.134", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1136", "2023-04-11 06:09:41", "/effective-solutions", "", "40.77.167.242", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1137", "2023-04-11 07:14:00", "/library.php?check=t", "http://wpquickassist.com", "119.252.174.184", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1138", "2023-04-11 07:14:12", "/wp-content/plugins/Cache/alfa-rex.php?1958", "http://wpquickassist.com", "142.93.48.245", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1139", "2023-04-11 07:14:21", "/alfa-rex.php?1958", "http://wpquickassist.com", "119.252.174.184", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1140", "2023-04-11 07:14:21", "/wp-content/uploads/radio.php?1958", "http://wpquickassist.com", "5.135.152.155", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1141", "2023-04-11 07:14:23", "/admin.php?u=t", "http://wpquickassist.com", "119.252.174.184", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1142", "2023-04-11 07:14:34", "/wp-content/plugins/Cache/dropdown.php?1958", "http://wpquickassist.com", "142.93.48.245", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1143", "2023-04-11 07:15:32", "/wp-content/plugins/seooo/alfa-rex.php?1958", "http://wpquickassist.com", "142.93.48.245", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1144", "2023-04-11 07:15:32", "/wp-content/plugins/Cache/alfanew.php?1958", "http://wpquickassist.com", "142.93.48.245", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1145", "2023-04-11 07:15:32", "/wp-content/plugins/seooo/alfanew.php?1958", "http://wpquickassist.com", "5.135.152.155", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1146", "2023-04-11 07:15:33", "/alfanew.php?1958", "http://wpquickassist.com", "119.252.174.184", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1147", "2023-04-11 07:17:00", "/wp-content/themes/finley/alfanew.php?1958", "http://wpquickassist.com", "5.135.152.155", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1148", "2023-04-11 07:17:43", "/style.php?sig=rename&#038;rename=123&#038;source_name=qw123", "http://wpquickassist.com", "119.252.174.184", "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/50.0.2661.75 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1149", "2023-04-11 07:28:13", "/fix-sidebar-below-content-erro", "", "77.75.79.101", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1150", "2023-04-11 08:08:30", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/fix-sidebar-below-content-error-in-wordpress/", "80.70.109.127", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1151", "2023-04-11 08:48:28", "/how-to-fix-wordpress-login-redirect-loop-issue", "", "5.255.231.36", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1152", "2023-04-11 08:49:00", "/how-to-fix-wordpress-login-redirect-loop-issue", "", "213.180.203.47", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/108.0.0.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1153", "2023-04-11 08:56:29", "/wp/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1154", "2023-04-11 08:56:30", "/new/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1155", "2023-04-11 08:56:31", "/old/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1156", "2023-04-11 08:56:32", "/wordpress/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1157", "2023-04-11 08:56:33", "/test/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1158", "2023-04-11 08:56:34", "/blog/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1159", "2023-04-11 08:56:36", "/cms/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1160", "2023-04-11 08:56:37", "/web/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1161", "2023-04-11 08:56:39", "/backup/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1162", "2023-04-11 08:56:40", "/site/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1163", "2023-04-11 08:56:41", "/oldsite/wp-admin/install.php", "", "143.198.82.44", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1164", "2023-04-11 09:08:15", "/wordpress-not-sending-emails", "", "5.102.173.71", "Mozilla/5.0 (compatible; MojeekBot/0.11; +https://www.mojeek.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1165", "2023-04-11 09:24:28", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "200.105.215.22", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1166", "2023-04-11 10:34:00", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "120.92.12.179", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1167", "2023-04-11 11:11:20", "/wp-content/uploads/2020/10/wordPress-not-uploading-images.jpg", "", "173.252.83.16", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1168", "2023-04-11 11:35:18", "/how-to-fix-wordpress-not-uploading-images-issue", "", "54.236.1.11", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1169", "2023-04-11 13:49:47", "/services", "", "54.236.1.13", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1170", "2023-04-11 14:05:32", "/how-to-fix-your-website-stuck-in-wordpress-maintenance-mode", "", "54.236.1.11", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1171", "2023-04-11 14:16:33", "/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1172", "2023-04-11 14:16:33", "/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1173", "2023-04-11 14:16:37", "/.aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1174", "2023-04-11 14:16:37", "/.aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1175", "2023-04-11 14:16:38", "/.aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1176", "2023-04-11 14:16:41", "/.aws/config", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1177", "2023-04-11 14:16:42", "/.aws/config", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1178", "2023-04-11 14:16:44", "/aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1179", "2023-04-11 14:16:45", "/aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1180", "2023-04-11 14:16:49", "/aws/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1181", "2023-04-11 14:16:49", "/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1182", "2023-04-11 14:16:53", "/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1183", "2023-04-11 14:16:54", "/credentials", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1184", "2023-04-11 14:16:57", "/test.php", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1185", "2023-04-11 14:16:58", "/test.php", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1186", "2023-04-11 14:17:00", "/test.php", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1187", "2023-04-11 14:17:05", "/laravel/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1188", "2023-04-11 14:17:07", "/laravel/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1189", "2023-04-11 14:17:12", "/demo/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1190", "2023-04-11 14:17:12", "/demo/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1191", "2023-04-11 14:17:17", "/web/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1192", "2023-04-11 14:17:19", "/web/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1193", "2023-04-11 14:17:21", "/phpinfo", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1194", "2023-04-11 14:17:28", "/phpinfo", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1195", "2023-04-11 14:17:28", "/phpinfo", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1196", "2023-04-11 14:17:32", "/admin/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1197", "2023-04-11 14:17:33", "/admin/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1198", "2023-04-11 14:17:36", "/backend/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1199", "2023-04-11 14:17:40", "/backend/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1200", "2023-04-11 14:17:40", "/app/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1201", "2023-04-11 14:17:48", "/app/.env", "", "109.237.98.53", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/81.0.4044.129 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1202", "2023-04-11 15:49:52", "/public/assets/jquery_uploader/server/php/?file=tf2rghf.jpg", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1203", "2023-04-11 16:30:50", "/fix-sidebar-below-content-error-in-wordpress", "", "17.241.75.225", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1204", "2023-04-11 16:41:20", "/_ignition/health-check", "https://wpquickassist.com/_ignition/health-check/", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1205", "2023-04-11 16:41:24", "/public/_ignition/health-check", "https://wpquickassist.com/public/_ignition/health-check/", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1206", "2023-04-11 16:41:32", "/wp-content/plugins/elementor-pro/assets/css/editor.css", "https://wpquickassist.com/wp-content/plugins/elementor-pro/assets/css/editor.css", "147.78.47.249", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1207", "2023-04-11 18:32:06", "/1.php", "https://www.wpquickassist.com/1.php", "194.113.235.169", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1; SV1)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1208", "2023-04-11 19:02:03", "/fix-sidebar-below-content", "", "66.249.79.201", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1209", "2023-04-11 19:07:52", "/fix-syntax-error-in-wordpress", "", "54.236.1.13", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1210", "2023-04-11 19:34:57", "/fix-wordpress-login-page-refreshing-redirecting-issue", "", "66.249.79.193", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1211", "2023-04-11 19:51:45", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "20.39.50.240", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1212", "2023-04-11 20:15:10", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "195.246.120.36", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1213", "2023-04-11 21:44:09", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "107.20.1.87", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1214", "2023-04-11 22:36:30", "/how-to-fix-add-media-button-not-working-in-wordpress", "", "17.241.75.127", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1215", "2023-04-11 23:07:09", "/portfolios/panoroof", "", "77.75.79.109", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1216", "2023-04-12 01:21:37", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "54.163.56.117", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1217", "2023-04-12 01:57:13", "/wp-content/uploads/2021/04/How-To-Fix-Wordpress-Not-Sending-Email-Issue.jpg", "", "95.108.213.239", "Mozilla/5.0 (compatible; YandexImages/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1218", "2023-04-12 02:51:14", "/how-to-change-wordpress-theme-without-losing-content", "", "66.249.79.203", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.5563.146 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1219", "2023-04-12 03:19:21", "/how-to-fix-wordpress-rss-feed-errors/feed", "", "77.75.79.101", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1220", "2023-04-12 03:29:00", "/wp/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1221", "2023-04-12 03:29:02", "/new/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1222", "2023-04-12 03:29:03", "/old/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1223", "2023-04-12 03:29:04", "/wordpress/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1224", "2023-04-12 03:29:05", "/test/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1225", "2023-04-12 03:29:06", "/blog/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1226", "2023-04-12 03:29:07", "/cms/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1227", "2023-04-12 03:29:08", "/web/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1228", "2023-04-12 03:29:09", "/backup/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1229", "2023-04-12 03:29:10", "/site/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1230", "2023-04-12 03:29:12", "/oldsite/wp-admin/install.php", "", "146.190.96.206", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1231", "2023-04-12 03:29:41", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "104.168.82.34", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1232", "2023-04-12 03:41:10", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "147.160.184.121", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1233", "2023-04-12 03:44:06", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1234", "2023-04-12 03:44:07", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1235", "2023-04-12 03:53:24", "/public/plugins/jquery_uploader/server/php/?file=tf2rghf.jpg", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1236", "2023-04-12 03:57:51", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1237", "2023-04-12 03:57:52", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1238", "2023-04-12 03:57:53", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1239", "2023-04-12 03:57:54", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1240", "2023-04-12 04:30:01", "/wp-content/uploads/2021/03/fix-thumbnail-1024x537.jpg", "", "147.160.184.91", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1241", "2023-04-12 04:46:50", "/wp-includes/class-index-wordpress.php", "", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1242", "2023-04-12 04:46:53", "/wp-includes/wp-system-cloud.php", "", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1243", "2023-04-12 04:46:54", "/wp-includes/class-wp-page-icon.php", "", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1244", "2023-04-12 04:46:56", "/wp-includes/class-wordpress-license.php", "", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1245", "2023-04-12 05:05:20", "/humans.txt", "https://wpquickassist.com/humans.txt", "185.27.99.121", "Mozilla/5.0 (Linux; Android 12; SM-G781W Build/SP1A.210812.016; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/103.0.5060.71 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1246", "2023-04-12 05:05:21", "/ads.txt", "https://wpquickassist.com/ads.txt", "185.27.99.113", "Mozilla/5.0 (Linux; Android 12; SM-G781W Build/SP1A.210812.016; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/103.0.5060.71 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1247", "2023-04-12 05:19:52", "/fix-wordpress-login-page-refreshing-redirecting-issue", "https://yandex.ru/", "37.204.10.25", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36 OPR/97.0.0.0 (Edition Yx GX)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1248", "2023-04-12 07:21:07", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "38.32.70.140", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1249", "2023-04-12 08:35:24", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "45.138.16.150", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1250", "2023-04-12 08:35:25", "/wp-content/plugins/apikey/apikey.php?test=hello", "", "45.138.16.150", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1251", "2023-04-12 08:35:25", "/plugins/content/apismtp/apismtp.php?test=hello", "", "45.138.16.150", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1252", "2023-04-12 08:35:26", "/wp-content/plugins/apikey/apikey.php.suspected?test=hello", "", "45.138.16.150", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1253", "2023-04-12 08:35:26", "/plugins/content/apismtp/apismtp.php.suspected?test=hello", "", "45.138.16.150", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1254", "2023-04-12 08:35:27", "/wp-plain.php", "http://www.google.com", "45.138.16.150", "Mozilla/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1255", "2023-04-12 08:35:28", "/ALFA_DATA/alfacgiapi/perl.alfa", "http://www.google.com", "45.138.16.150", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1256", "2023-04-12 08:35:29", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "45.138.16.150", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1257", "2023-04-12 08:35:30", "/alfacgiapi/perl.alfa", "http://www.google.com", "45.138.16.150", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1258", "2023-04-12 10:01:35", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "130.44.212.114", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1259", "2023-04-12 11:51:05", "/fix-image-upload-issue-in-wordpress", "https://www.wpquickassist.com/", "154.3.99.146", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1260", "2023-04-12 12:35:59", "/wp-content/uploads/kaswara/fonts_icon/a57bze8931/.__a57bze8931.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1261", "2023-04-12 12:36:01", "/wp-content/plugins/apikey/apikey.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1262", "2023-04-12 12:36:02", "/wp-content/plugins/apikey/a57bze8931.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1263", "2023-04-12 12:36:05", "/abruzi.php4", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1264", "2023-04-12 12:36:07", "/wp-content/x.php?1=system", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1265", "2023-04-12 12:36:07", "/wp-content/king.php", "http://www.google.com", "146.190.96.206", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1266", "2023-04-12 13:49:19", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "103.87.142.172", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1267", "2023-04-12 15:34:59", "/stylec.php", "http://www.google.com", "82.165.244.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1268", "2023-04-12 15:35:05", "/stylec.php", "http://www.google.com", "82.165.244.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1269", "2023-04-12 15:43:00", "/portfolios/furniture-shop", "", "77.75.79.54", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1270", "2023-04-12 15:49:25", "/assets/admin/global/plugins/jquery_uploader/server/php/?file=tf2rghf.jpg", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1271", "2023-04-12 16:21:45", "/how-to-fix-add-media-button-not-working-in-wordpress", "", "54.236.1.13", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1272", "2023-04-12 16:24:24", "/fix-sidebar-below-content-error-in-wordpress", "", "54.236.1.13", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1273", "2023-04-12 17:28:19", "/wp-content/uploads/2020/10/wordPress-not-uploading-images.jpg", "", "18.237.66.59", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1274", "2023-04-12 18:36:06", "/wp-admin/includes/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1275", "2023-04-12 18:36:10", "/wp-includes/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1276", "2023-04-12 18:36:15", "/.well-known/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1277", "2023-04-12 18:36:23", "/css/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1278", "2023-04-12 18:36:35", "/images/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1279", "2023-04-12 18:36:40", "/wp-content/languages/plugins/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1280", "2023-04-12 18:36:57", "/wp-includes/images/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1281", "2023-04-12 18:37:23", "/wp-content/languages/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1282", "2023-04-12 18:37:30", "/wp-content/upgrade/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1283", "2023-04-12 18:37:35", "/wp-content/uploads/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1284", "2023-04-12 18:37:54", "/wp-admin/js/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1285", "2023-04-12 18:38:28", "/wp-admin/css/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1286", "2023-04-12 18:38:46", "/wp-admin/css/colors/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1287", "2023-04-12 18:38:50", "/wp-admin/maint/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1288", "2023-04-12 18:38:57", "/wp-content/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1289", "2023-04-12 18:39:10", "/wp-admin/css/colors/blue/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1290", "2023-04-12 18:39:26", "/wp-admin/css/colors/coffee/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1291", "2023-04-12 18:39:33", "/wp-admin/css/colors/ectoplasm/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1292", "2023-04-12 18:39:53", "/wp-admin/css/colors/midnight/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1293", "2023-04-12 18:40:06", "/wp-admin/css/colors/modern/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1294", "2023-04-12 18:40:13", "/.well-known/pki-validation/about.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1295", "2023-04-12 18:57:29", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "107.20.1.87", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1296", "2023-04-12 18:59:16", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "23.231.36.53", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1297", "2023-04-12 21:45:49", "/style.php?sig=rename", "", "43.128.96.34", "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.5) Gecko/20091102 Firefox/3.5.5 (.NET CLR 3.5.30729)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1298", "2023-04-13 00:27:57", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "173.213.84.25", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1299", "2023-04-13 01:17:49", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "141.193.68.10", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1300", "2023-04-13 01:58:50", "/fix-wordpress-login-page-refreshing-redirecting-issue", "https://yandex.ru/", "95.161.239.250", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 OPR/96.0.0.0 (Edition Yx GX)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1301", "2023-04-13 01:59:18", "/fix-wordpress-login-page-refreshing-redirecting-issue", "https://yandex.ru/", "95.161.221.114", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/111.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1302", "2023-04-13 02:01:00", "/fix-sidebar-below-content-error-in-wordpress", "http://www.wpquickassist.com/fix-sidebar-below-content-error-in-wordpress/", "75.97.206.53", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1303", "2023-04-13 02:59:49", "/howto", "", "17.241.219.240", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1304", "2023-04-13 03:48:43", "/assets/admin/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1305", "2023-04-13 05:10:01", "/wp-content/uploads/2019/11/fix-responsiveness1-1.jpg", "", "8.218.179.231", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1306", "2023-04-13 05:50:33", "/_files/blog-post-image-12.png", "", "66.249.79.201", "Googlebot-Image/1.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1307", "2023-04-13 09:03:55", "/style.php?sig=rename", "", "92.223.86.27", "Mozilla/5.0 (Windows; U; Windows NT 6.1; en-US; rv:1.9.1.5) Gecko/20091102 Firefox/3.5.5 (.NET CLR 3.5.30729)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1308", "2023-04-13 09:36:23", "/cgi-sys/suspendedpage.cgi", "", "17.241.75.224", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1309", "2023-04-13 09:56:48", "/wp-content/plugins/supportcandy/readme.txt", "", "185.196.220.26", "Mozilla/5.0 (Macintosh; Intel Mac OS X 13_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1310", "2023-04-13 10:43:04", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "104.160.8.65", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Edg/103.0.1264.71", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1311", "2023-04-13 10:51:25", "/fix-error-too-many-redirects-in-wordpress", "", "54.236.1.11", "Mozilla/5.0 (compatible; Pinterestbot/1.0; +http://www.pinterest.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1312", "2023-04-13 14:09:42", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "141.193.68.10", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1313", "2023-04-13 14:36:12", "/wp-content/uploads/2022/05/qa-1170x630.jpg", "", "40.77.167.171", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1314", "2023-04-13 16:41:32", "/wp-content/uploads/2020/10/wordPress-not-uploading-images.jpg", "", "8.218.179.231", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1315", "2023-04-13 18:49:26", "/tag/wordpress-not-uploading-images-issue", "", "5.255.231.99", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1316", "2023-04-13 19:53:56", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "77.220.53.163", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1317", "2023-04-13 22:48:36", "/auto_seo.php", "http://wpquickassist.com", "187.103.250.210", "Mozilla/5.1 (Windows NT 6.0; WOW64) AppleWebKit/537.37 (KHTML, like Gecko) Chrome/58.0.1145.75 Safari/537.37", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1318", "2023-04-13 22:48:37", "/wp-content/themes/seotheme/auto_seo.php", "http://wpquickassist.com", "187.103.250.210", "Mozilla/5.1 (Windows NT 6.0; WOW64) AppleWebKit/537.37 (KHTML, like Gecko) Chrome/58.0.1145.75 Safari/537.37", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1319", "2023-04-13 22:50:34", "/wp-content/auto_seo.php", "http://wpquickassist.com", "187.103.250.210", "Mozilla/5.1 (Windows NT 6.0; WOW64) AppleWebKit/537.37 (KHTML, like Gecko) Chrome/58.0.1145.75 Safari/537.37", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1320", "2023-04-13 22:51:18", "/inputs.php", "http://wpquickassist.com", "187.103.250.210", "Mozilla/5.1 (Windows NT 6.0; WOW64) AppleWebKit/537.37 (KHTML, like Gecko) Chrome/58.0.1145.75 Safari/537.37", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1321", "2023-04-13 22:52:08", "/wp-admin/auto_seo.php", "http://wpquickassist.com", "187.103.250.210", "Mozilla/5.1 (Windows NT 6.0; WOW64) AppleWebKit/537.37 (KHTML, like Gecko) Chrome/58.0.1145.75 Safari/537.37", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1322", "2023-04-14 00:10:45", "/how-are-electric-vehicles", "", "87.250.224.209", "Mozilla/5.0 (compatible; YandexBot/3.0; +http://yandex.com/bots)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1323", "2023-04-14 00:47:53", "/turn-off-php-errors-in-wordpress", "", "173.252.107.18", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1324", "2023-04-14 00:47:53", "/fix-facebook-incorrect-thumbnail-issue-in-wordpress", "", "173.252.107.18", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1325", "2023-04-14 00:47:53", "/fix-error-too-many-redirects-in-wordpress", "", "173.252.107.21", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1326", "2023-04-14 00:47:53", "/fix-sidebar-below-content-error-in-wordpress", "", "173.252.107.15", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1327", "2023-04-14 00:47:53", "/how-to-fix-error-establishing-a-database-connection-in-wordpress", "", "173.252.107.13", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1328", "2023-04-14 00:47:53", "/fix-syntax-error-in-wordpress", "", "173.252.107.4", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1329", "2023-04-14 00:47:53", "/fix-wordpress-login-page-refreshing-redirecting-issue", "", "173.252.107.5", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1330", "2023-04-14 00:47:53", "/fix-image-upload-issue-in-wordpress", "", "173.252.107.6", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1331", "2023-04-14 00:47:53", "/how-to-fix-add-media-button-not-working-in-wordpress", "", "173.252.107.4", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1332", "2023-04-14 00:47:53", "/how-to-fix-wordpress-rss-feed-errors", "", "173.252.107.21", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1333", "2023-04-14 00:47:53", "/how-to-fix-wordpress-keeps-logging-out-problem", "", "173.252.107.1", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1334", "2023-04-14 00:47:53", "/fix-password-reset-key-error-in-wordpress", "", "173.252.107.15", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1335", "2023-04-14 00:47:53", "/fix-wordpress-not-sending-email-issue", "", "173.252.107.13", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1336", "2023-04-14 00:47:53", "/how-to-fix-your-website-stuck-in-wordpress-maintenance-mode", "", "173.252.107.17", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1337", "2023-04-14 00:47:53", "/fix-500-internal-server-error-on-wordpress", "", "173.252.107.15", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1338", "2023-04-14 00:47:54", "/wp-content/uploads/2021/04/How-to-Fix-Image-Upload-Issue-in-WordPress.jpg", "", "173.252.107.3", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1339", "2023-04-14 00:47:55", "/wp-content/uploads/2020/10/wp-maintenance-mode.jpg", "", "173.252.107.17", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1340", "2023-04-14 00:47:55", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "173.252.107.5", "facebookexternalhit/1.1 (+http://www.facebook.com/externalhit_uatext.php)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1341", "2023-04-14 01:32:42", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "103.240.99.245", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1342", "2023-04-14 02:04:31", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "104.160.8.65", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 Vivaldi/5.3.2679.68", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1343", "2023-04-14 03:14:29", "/wp-content/uploads/2021/03/fix-thumbnail-1024x537.jpg", "", "47.246.164.136", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1344", "2023-04-14 03:31:47", "/apple-app-site-association", "", "72.14.199.204", "AdsBot-Google (+http://www.google.com/adsbot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1345", "2023-04-14 03:36:05", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "223.29.253.134", "Mozilla/5.0 (Windows NT 6.3; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1346", "2023-04-14 04:03:45", "/how-to-fix-wordpress-login-redirect-loop-issue", "", "185.191.171.18", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1347", "2023-04-14 04:19:19", "/.well-known/apple-app-site-association", "", "72.14.199.223", "AdsBot-Google (+http://www.google.com/adsbot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1348", "2023-04-14 04:21:38", "/testimonial/mason-wright", "", "185.191.171.17", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1349", "2023-04-14 04:34:28", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "66.150.71.237", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1350", "2023-04-14 04:42:51", "/how-to-fix-wordpress-not-uploading-images-issue", "", "185.191.171.36", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1351", "2023-04-14 05:37:31", "/how-to-change-wordpress-theme-without-losing-content", "", "66.249.79.203", "Mozilla/5.0 (Linux; Android 6.0.1; Nexus 5X Build/MMB29P) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/112.0.5615.49 Mobile Safari/537.36 (compatible; Googlebot/2.1; +http://www.google.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1352", "2023-04-14 05:44:23", "/tag/change-header-color-in-wordpress", "", "185.191.171.17", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1353", "2023-04-14 06:08:10", "/sitemap.xml.gz", "", "52.167.144.32", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1354", "2023-04-14 06:35:52", "/sitemap.txt", "", "40.77.167.242", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1355", "2023-04-14 06:38:08", "/sitemaps.xml", "", "52.167.144.98", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1356", "2023-04-14 06:42:22", "/atom.xml", "", "40.77.167.242", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1357", "2023-04-14 07:21:28", "/wp-admin/includes/install.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1358", "2023-04-14 07:21:57", "/wp-includes/install.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1359", "2023-04-14 07:22:13", "/.well-known/install.php", "", "194.87.151.73", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1360", "2023-04-14 07:46:36", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "79.137.195.31", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 YaBrowser/22.7.0 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1361", "2023-04-14 08:08:49", "/wordpress-not-sending-emails", "", "17.241.75.224", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1362", "2023-04-14 08:13:41", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "51.255.3.118", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12.5; rv:102.0) Gecko/20100101 Firefox/102.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1363", "2023-04-14 08:26:54", "/terms-of-service", "", "185.191.171.10", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1364", "2023-04-14 08:31:52", "/author/john-smith/page/2", "", "185.191.171.41", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1365", "2023-04-14 08:35:50", "/fix-sidebar-below-content-error-in-wordpress/Sidebar", "", "185.191.171.33", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1366", "2023-04-14 09:09:47", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "87.133.114.154", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36 OPR/89.0.4447.51", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1367", "2023-04-14 09:29:11", "/portfolios/sologigabit-blog", "", "185.191.171.36", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1368", "2023-04-14 09:37:10", "/tag/turn-off-php-errors", "", "185.191.171.26", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1369", "2023-04-14 10:15:15", "/fix-syntax-error-in-wordpress", "", "17.241.75.80", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1370", "2023-04-14 11:12:28", "/assets/admin/global/plugins/plupload/examples/upload.php", "", "194.38.23.179", "ALittle Client", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1371", "2023-04-14 12:06:59", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "185.87.123.170", "Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1372", "2023-04-14 12:46:31", "/testimonial/quinton-w-united-kingdom", "", "185.191.171.26", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1373", "2023-04-14 12:52:57", "/Makhdamx.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1374", "2023-04-14 12:53:02", "/Makhdamx.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1375", "2023-04-14 12:53:07", "/database.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1376", "2023-04-14 12:53:12", "/wp-commentin.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1377", "2023-04-14 12:53:16", "/wp-content/themes/seotheme/db.php?u", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1378", "2023-04-14 12:53:20", "/xltavrat.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1379", "2023-04-14 12:53:25", "/wp-admin/includes/class-wp-media-list-data.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1380", "2023-04-14 12:53:29", "/wp-content/plugins/seoplugins", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1381", "2023-04-14 12:53:34", "/wso112233.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1382", "2023-04-14 12:53:38", "/xleet-shell.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1383", "2023-04-14 12:53:42", "/xleet.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1384", "2023-04-14 12:53:47", "/wp-content/plugins/seoplugins/mar.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1385", "2023-04-14 12:53:51", "/wp-content/themes/seotheme/mar.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1386", "2023-04-14 12:53:58", "/0z.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1387", "2023-04-14 12:54:03", "/fw.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1388", "2023-04-14 12:54:07", "/wp-includes/wp-class.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1389", "2023-04-14 12:54:12", "/radio.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1390", "2023-04-14 12:54:16", "/i.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1391", "2023-04-14 12:54:19", "/o.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1392", "2023-04-14 12:54:23", "/alwso.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1393", "2023-04-14 12:54:26", "/wp-blog.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1394", "2023-04-14 12:54:30", "/u.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1395", "2023-04-14 12:54:35", "/templates/beez5", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1396", "2023-04-14 12:54:38", "/mini.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1397", "2023-04-14 12:54:42", "/x.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1398", "2023-04-14 12:54:46", "/404.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1399", "2023-04-14 12:54:50", "/13.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1400", "2023-04-14 12:54:53", "/11index.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1401", "2023-04-14 12:54:57", "/wp-uploads.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1402", "2023-04-14 12:55:01", "/sh.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1403", "2023-04-14 12:55:06", "/k.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1404", "2023-04-14 12:55:10", "/wikindex.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1405", "2023-04-14 12:55:14", "/y.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1406", "2023-04-14 12:55:19", "/alf.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1407", "2023-04-14 12:55:23", "/WSO.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1408", "2023-04-14 12:55:28", "/10.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1409", "2023-04-14 12:55:32", "/2index.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1410", "2023-04-14 12:55:36", "/mari.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1411", "2023-04-14 12:55:41", "/1.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1412", "2023-04-14 12:55:45", "/100.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1413", "2023-04-14 12:55:49", "/wp-admin.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1414", "2023-04-14 12:55:54", "/shx.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1415", "2023-04-14 12:55:58", "/xx.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1416", "2023-04-14 12:56:02", "/shell.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1417", "2023-04-14 12:56:06", "/wso1.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1418", "2023-04-14 12:56:11", "/doc.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1419", "2023-04-14 12:56:16", "/wso2.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1420", "2023-04-14 12:56:20", "/wp-content/wp.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1421", "2023-04-14 12:56:24", "/uploads/up.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1422", "2023-04-14 12:56:28", "/old-index.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1423", "2023-04-14 12:56:33", "/9.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1424", "2023-04-14 12:56:37", "/date.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1425", "2023-04-14 12:56:40", "/n.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1426", "2023-04-14 12:56:45", "/p.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1427", "2023-04-14 12:56:49", "/mar.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1428", "2023-04-14 12:56:52", "/01.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1429", "2023-04-14 12:56:57", "/0.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1430", "2023-04-14 12:57:01", "/wp-admin/fw.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1431", "2023-04-14 12:57:05", "/about.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1432", "2023-04-14 12:57:11", "/ups.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1433", "2023-04-14 12:57:15", "/wp-content/x.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1434", "2023-04-14 12:57:18", "/root.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1435", "2023-04-14 12:57:22", "/wp-content/fw.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1436", "2023-04-14 12:57:26", "/wp-includes/about.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1437", "2023-04-14 12:57:30", "/q.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1438", "2023-04-14 12:57:34", "/xxx.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1439", "2023-04-14 12:57:38", "/h.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1440", "2023-04-14 12:57:43", "/a.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1441", "2023-04-14 12:57:47", "/fox.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1442", "2023-04-14 12:57:51", "/wp-includes/991176.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1443", "2023-04-14 12:57:56", "/wp-admin/radio.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1444", "2023-04-14 12:58:00", "/wp.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1445", "2023-04-14 12:58:05", "/wp-file.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1446", "2023-04-14 12:58:09", "/jindex.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1447", "2023-04-14 12:58:13", "/Alfa.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1448", "2023-04-14 12:58:17", "/403.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1449", "2023-04-14 12:58:21", "/0byte.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1450", "2023-04-14 12:58:26", "/s.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1451", "2023-04-14 12:58:31", "/haxor.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1452", "2023-04-14 12:58:35", "/xl.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1453", "2023-04-14 12:58:40", "/r.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1454", "2023-04-14 12:58:44", "/hello.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1455", "2023-04-14 12:58:47", "/4.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1456", "2023-04-14 12:58:52", "/g.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1457", "2023-04-14 12:58:55", "/priv8.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1458", "2023-04-14 12:59:00", "/wp-class.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1459", "2023-04-14 12:59:04", "/wp-admin/css/fw.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1460", "2023-04-14 12:59:08", "/uploader.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1461", "2023-04-14 12:59:12", "/e.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1462", "2023-04-14 12:59:15", "/2.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1463", "2023-04-14 12:59:19", "/wp_wrong_datlib.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1464", "2023-04-14 12:59:24", "/f.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1465", "2023-04-14 12:59:28", "/5.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1466", "2023-04-14 12:59:32", "/v.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1467", "2023-04-14 12:59:35", "/w3llstore.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1468", "2023-04-14 12:59:39", "/images/about.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1469", "2023-04-14 12:59:44", "/rss.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1470", "2023-04-14 12:59:48", "/wp-info.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1471", "2023-04-14 12:59:52", "/m.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1472", "2023-04-14 12:59:56", "/wso.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1473", "2023-04-14 13:00:00", "/1index.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1474", "2023-04-14 13:00:05", "/public/403.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1475", "2023-04-14 13:00:09", "/blog.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1476", "2023-04-14 13:00:13", "/c99.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1477", "2023-04-14 13:00:17", "/autoload_classmap.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1478", "2023-04-14 13:00:21", "/b.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1479", "2023-04-14 13:00:26", "/alfashell.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1480", "2023-04-14 13:00:30", "/bypass.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1481", "2023-04-14 13:00:34", "/content.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1482", "2023-04-14 13:00:38", "/wp-content/about.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1483", "2023-04-14 13:00:41", "/1337.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1484", "2023-04-14 13:00:46", "/3.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1485", "2023-04-14 13:00:50", "/up.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1486", "2023-04-14 13:00:54", "/FoxWSO.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1487", "2023-04-14 13:00:58", "/license.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1488", "2023-04-14 13:01:02", "/goods.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1489", "2023-04-14 13:01:06", "/ws.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1490", "2023-04-14 13:01:09", "/marijuana.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1491", "2023-04-14 13:01:13", "/small.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1492", "2023-04-14 13:01:17", "/fx.php", "", "138.128.244.180", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/91.0.4472.124 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1493", "2023-04-14 13:37:22", "/portfolios_category/portfolio/page/4", "", "185.191.171.16", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1494", "2023-04-14 13:58:05", "/portfolios/panoroof", "", "185.191.171.16", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1495", "2023-04-14 14:16:41", "/wp-content/uploads/2021/03/fix-thumbnail.jpg", "", "120.92.12.179", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1496", "2023-04-14 14:25:29", "/2022/06", "", "185.191.171.7", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1497", "2023-04-14 15:06:06", "/cgi-sys/suspendedpage.cgi", "", "185.191.171.39", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1498", "2023-04-14 15:22:12", "/casestudies/macoptimizer", "", "185.191.171.37", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1499", "2023-04-14 16:07:51", "/2020/11", "", "185.191.171.16", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1500", "2023-04-14 16:20:57", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1501", "2023-04-14 16:20:58", "/how-to-fix-wordpress-login-redirect-loop-issue", "https://wpquickassist.com/how-to-fix-wordpress-login-redirect-loop-issue/", "85.208.98.18", "Mozilla/5.0 (compatible; SemrushBot; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1502", "2023-04-14 16:25:25", "/how-to-fix-wordpress-memory-exhausted-error", "https://yandex.ru/", "95.161.221.42", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 YaBrowser/23.3.1.895 Yowser/2.5 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1503", "2023-04-14 16:32:00", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1504", "2023-04-14 16:32:01", "/wp-content/themes/seotheme/db.php?u", "http://www.google.com", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1505", "2023-04-14 16:44:01", "/wp-content/uploads/2021/03/avatar.png", "", "34.227.227.217", "Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:72.0) Gecko/20100101 Firefox/72.0", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1506", "2023-04-14 17:07:48", "/wp-content/plugins/anttt/simple.php", "http://www.google.com", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1507", "2023-04-14 17:07:49", "/wp-content/plugins/TOPXOH/wDR.php", "http://www.google.com", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1508", "2023-04-14 17:07:51", "/wp-content/plugins/wordpresss3cll/up.php", "http://www.google.com", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1509", "2023-04-14 17:07:51", "/wp-content/plugins/wp-file-upload/ROOBOTS.php", "http://www.google.com", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1510", "2023-04-14 17:10:31", "/2021/07", "", "17.241.227.237", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.1.1 Safari/605.1.15 (Applebot/0.1; +http://www.apple.com/go/applebot)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1511", "2023-04-14 17:10:54", "/tag/failed-login-attempts-wordpress", "", "40.77.167.242", "Mozilla/5.0 AppleWebKit/537.36 (KHTML, like Gecko; compatible; bingbot/2.0; +http://www.bing.com/bingbot.htm) Chrome/103.0.5060.134 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1512", "2023-04-14 17:43:39", "/how-to-fix-wordpress-404-error", "", "185.191.171.11", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1513", "2023-04-14 18:13:32", "/wp-includes/class-index-wordpress.php", "", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1514", "2023-04-14 18:13:34", "/wp-includes/wp-system-cloud.php", "", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1515", "2023-04-14 18:13:35", "/wp-includes/class-wp-page-icon.php", "", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1516", "2023-04-14 18:13:36", "/wp-includes/class-wordpress-license.php", "", "165.232.168.48", "Mozlila/5.0 (Linux; Android 7.0; SM-G892A Bulid/NRD90M; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/60.0.3112.107 Moblie Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1517", "2023-04-14 18:25:46", "/adminer", "", "51.89.213.54", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1518", "2023-04-14 18:25:51", "/_adminer.php", "", "51.89.213.54", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1519", "2023-04-14 18:25:58", "/adminer1.php", "", "51.89.213.54", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1520", "2023-04-14 18:26:01", "/adminer/adminer.php", "", "51.89.213.54", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.3987.163 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1521", "2023-04-14 18:55:04", "/how-to-fix-wordpress-login-redirect-loop-issue", "", "77.75.79.72", "Mozilla/5.0 (compatible; SeznamBot/4.0-RC1; +http://napoveda.seznam.cz/seznambot-intro/)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1522", "2023-04-14 19:09:10", "/wp-content/uploads/2021/06/How-To-Fix-Wordpress-Login-Page-Refreshing-Redirecting-Issue.jpg", "", "108.174.2.217", "LinkedInBot/1.0 (compatible; Mozilla/5.0; Apache-HttpClient +http://www.linkedin.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1523", "2023-04-14 19:09:10", "/wp-content/uploads/2021/06/How-to-Fix-the-Error-Establishing-Database-Connection-in-WordPress.jpg", "", "108.174.2.219", "LinkedInBot/1.0 (compatible; Mozilla/5.0; Apache-HttpClient +http://www.linkedin.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1524", "2023-04-14 19:09:11", "/wp-content/uploads/2021/07/How-to-Fix-Add-Media-Button-Not-Working-in-WordPress.jpg", "", "108.174.2.217", "LinkedInBot/1.0 (compatible; Mozilla/5.0; Apache-HttpClient +http://www.linkedin.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1525", "2023-04-14 19:09:12", "/wp-content/uploads/2021/07/How-to-Fix-Error-Too-Many-Redirects-Issue-in-WordPress.jpg", "", "108.174.2.217", "LinkedInBot/1.0 (compatible; Mozilla/5.0; Apache-HttpClient +http://www.linkedin.com)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1526", "2023-04-14 19:18:57", "/wp/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1527", "2023-04-14 19:18:58", "/new/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1528", "2023-04-14 19:19:00", "/old/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1529", "2023-04-14 19:19:00", "/wordpress/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1530", "2023-04-14 19:19:02", "/test/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1531", "2023-04-14 19:19:03", "/blog/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1532", "2023-04-14 19:19:04", "/cms/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1533", "2023-04-14 19:19:05", "/web/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1534", "2023-04-14 19:19:07", "/backup/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1535", "2023-04-14 19:19:08", "/site/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1536", "2023-04-14 19:19:09", "/oldsite/wp-admin/install.php", "", "165.232.168.48", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_10_1) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/39.0.2171.95 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1537", "2023-04-14 21:28:56", "/fix-wordpress-not-sending-email-issue", "", "185.191.171.20", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1538", "2023-04-14 21:55:11", "/fix-sidebar-below-content-error-in-wordpress", "https://www.wpquickassist.com/", "217.146.81.151", "Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1539", "2023-04-14 22:18:51", "/tag/wordpress-not-uploading-images-issue", "", "185.191.171.24", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1540", "2023-04-14 22:20:43", "/fix-facebook-incorrect-thumbnail-issue-in-wordpress", "", "185.191.171.21", "Mozilla/5.0 (compatible; SemrushBot/7~bl; +http://www.semrush.com/bot.html)", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1541", "2023-04-14 22:43:55", "/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1542", "2023-04-14 22:43:56", "/wp/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1543", "2023-04-14 22:43:57", "/wordpress/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1544", "2023-04-14 22:43:57", "/blog/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1545", "2023-04-14 22:43:58", "/new/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1546", "2023-04-14 22:43:59", "/test/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1547", "2023-04-14 22:43:59", "/old/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1548", "2023-04-14 22:44:00", "/backup/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1549", "2023-04-14 22:44:00", "/backup/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1550", "2023-04-14 22:44:01", "/backup/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1551", "2023-04-14 22:44:02", "/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1552", "2023-04-14 22:44:02", "/wp/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1553", "2023-04-14 22:44:03", "/wordpress/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1554", "2023-04-14 22:44:04", "/blog/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1555", "2023-04-14 22:44:04", "/new/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1556", "2023-04-14 22:44:05", "/test/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1557", "2023-04-14 22:44:05", "/old/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1558", "2023-04-14 22:44:06", "/backup/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1559", "2023-04-14 22:44:07", "/backup/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1560", "2023-04-14 22:44:07", "/backup/wp-content/themes/sketch/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1561", "2023-04-14 22:44:08", "/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1562", "2023-04-14 22:44:09", "/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1563", "2023-04-14 22:44:10", "/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1564", "2023-04-14 22:44:11", "/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1565", "2023-04-14 22:44:11", "/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1566", "2023-04-14 22:44:12", "/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1567", "2023-04-14 22:44:13", "/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1568", "2023-04-14 22:44:14", "/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1569", "2023-04-14 22:44:14", "/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1570", "2023-04-14 22:44:15", "/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1571", "2023-04-14 22:44:16", "/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1572", "2023-04-14 22:44:16", "/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1573", "2023-04-14 22:44:17", "/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1574", "2023-04-14 22:44:18", "/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1575", "2023-04-14 22:44:18", "/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1576", "2023-04-14 22:44:20", "/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1577", "2023-04-14 22:44:20", "/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1578", "2023-04-14 22:44:21", "/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1579", "2023-04-14 22:44:22", "/wp-content/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1580", "2023-04-14 22:44:22", "/wp-content/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1581", "2023-04-14 22:44:23", "/wp-content/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1582", "2023-04-14 22:44:24", "/wp-content/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1583", "2023-04-14 22:44:24", "/wp-content/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1584", "2023-04-14 22:44:25", "/wp-content/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1585", "2023-04-14 22:44:26", "/wp-content/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1586", "2023-04-14 22:44:27", "/wp-content/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1587", "2023-04-14 22:44:28", "/wp-content/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1588", "2023-04-14 22:44:29", "/wp-content/ALFA_DATA/alfacgiapi/wp-content/uploads/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1589", "2023-04-14 22:44:29", "/wp-content/ALFA_DATA/alfacgiapi/wp-content/uploads/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1590", "2023-04-14 22:44:30", "/wp-content/ALFA_DATA/alfacgiapi/wp-content/uploads/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1591", "2023-04-14 22:44:31", "/wp-content/ALFA_DATA/alfacgiapi/wp-content/uploads/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1592", "2023-04-14 22:44:31", "/wp-content/ALFA_DATA/alfacgiapi/wp-content/uploads/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1593", "2023-04-14 22:44:32", "/wp-content/ALFA_DATA/alfacgiapi/wp-content/uploads/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1594", "2023-04-14 22:44:33", "/wp-content/ALFA_DATA/alfacgiapi/wp-content/uploads/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1595", "2023-04-14 22:44:34", "/wp-content/ALFA_DATA/alfacgiapi/wp-content/uploads/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1596", "2023-04-14 22:44:34", "/wp-content/ALFA_DATA/alfacgiapi/wp-content/uploads/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1597", "2023-04-14 22:44:35", "/wp-content/uploads/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1598", "2023-04-14 22:44:36", "/wp-content/uploads/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1599", "2023-04-14 22:44:36", "/wp-content/uploads/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1600", "2023-04-14 22:44:37", "/wp-content/uploads/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1601", "2023-04-14 22:44:38", "/wp-content/uploads/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1602", "2023-04-14 22:44:39", "/wp-content/uploads/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1603", "2023-04-14 22:44:40", "/wp-content/uploads/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1604", "2023-04-14 22:44:41", "/wp-content/uploads/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1605", "2023-04-14 22:44:41", "/wp-content/uploads/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1606", "2023-04-14 22:44:42", "/wp-content/plugins/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1607", "2023-04-14 22:44:43", "/wp-content/plugins/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1608", "2023-04-14 22:44:43", "/wp-content/plugins/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1609", "2023-04-14 22:44:44", "/wp-content/plugins/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1610", "2023-04-14 22:44:45", "/wp-content/plugins/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1611", "2023-04-14 22:44:45", "/wp-content/plugins/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1612", "2023-04-14 22:44:46", "/wp-content/plugins/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1613", "2023-04-14 22:44:47", "/wp-content/plugins/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1614", "2023-04-14 22:44:48", "/wp-content/plugins/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1615", "2023-04-14 22:44:49", "/wp-content/plugins/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1616", "2023-04-14 22:44:49", "/wp-content/plugins/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1617", "2023-04-14 22:44:50", "/wp-content/plugins/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1618", "2023-04-14 22:44:51", "/wp-content/plugins/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1619", "2023-04-14 22:44:51", "/wp-content/plugins/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1620", "2023-04-14 22:44:52", "/wp-content/plugins/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1621", "2023-04-14 22:44:53", "/wp-content/plugins/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1622", "2023-04-14 22:44:54", "/wp-content/plugins/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1623", "2023-04-14 22:44:54", "/wp-content/plugins/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1624", "2023-04-14 22:44:55", "/wp-content/themes/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1625", "2023-04-14 22:44:56", "/wp-content/themes/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1626", "2023-04-14 22:44:57", "/wp-content/themes/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1627", "2023-04-14 22:44:57", "/wp-content/themes/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1628", "2023-04-14 22:44:58", "/wp-content/themes/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1629", "2023-04-14 22:44:59", "/wp-content/themes/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1630", "2023-04-14 22:45:00", "/wp-content/themes/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1631", "2023-04-14 22:45:00", "/wp-content/themes/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1632", "2023-04-14 22:45:01", "/wp-content/themes/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1633", "2023-04-14 22:45:02", "/wp-content/themes/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1634", "2023-04-14 22:45:02", "/wp-content/themes/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1635", "2023-04-14 22:45:03", "/wp-content/themes/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1636", "2023-04-14 22:45:04", "/wp-content/themes/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1637", "2023-04-14 22:45:04", "/wp-content/themes/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1638", "2023-04-14 22:45:05", "/wp-content/themes/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1639", "2023-04-14 22:45:07", "/wp-content/themes/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1640", "2023-04-14 22:45:08", "/wp-content/themes/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1641", "2023-04-14 22:45:09", "/wp-content/themes/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1642", "2023-04-14 22:45:10", "/wp-content/upgrade/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1643", "2023-04-14 22:45:10", "/wp-content/upgrade/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1644", "2023-04-14 22:45:11", "/wp-content/upgrade/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1645", "2023-04-14 22:45:12", "/wp-content/upgrade/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1646", "2023-04-14 22:45:12", "/wp-content/upgrade/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1647", "2023-04-14 22:45:13", "/wp-content/upgrade/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1648", "2023-04-14 22:45:14", "/wp-content/upgrade/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1649", "2023-04-14 22:45:15", "/wp-content/upgrade/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1650", "2023-04-14 22:45:15", "/wp-content/upgrade/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1651", "2023-04-14 22:45:16", "/wp-content/upgrade/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1652", "2023-04-14 22:45:17", "/wp-content/upgrade/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1653", "2023-04-14 22:45:18", "/wp-content/upgrade/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1654", "2023-04-14 22:45:18", "/wp-content/upgrade/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1655", "2023-04-14 22:45:19", "/wp-content/upgrade/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1656", "2023-04-14 22:45:20", "/wp-content/upgrade/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1657", "2023-04-14 22:45:21", "/wp-content/upgrade/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1658", "2023-04-14 22:45:22", "/wp-content/upgrade/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1659", "2023-04-14 22:45:23", "/wp-content/upgrade/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1660", "2023-04-14 22:45:23", "/wp-content/updraft/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1661", "2023-04-14 22:45:24", "/wp-content/updraft/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1662", "2023-04-14 22:45:25", "/wp-content/updraft/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1663", "2023-04-14 22:45:25", "/wp-content/updraft/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1664", "2023-04-14 22:45:26", "/wp-content/updraft/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1665", "2023-04-14 22:45:27", "/wp-content/updraft/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1666", "2023-04-14 22:45:28", "/wp-content/updraft/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1667", "2023-04-14 22:45:28", "/wp-content/updraft/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1668", "2023-04-14 22:45:29", "/wp-content/updraft/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1669", "2023-04-14 22:45:30", "/wp-content/updraft/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1670", "2023-04-14 22:45:31", "/wp-content/updraft/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1671", "2023-04-14 22:45:31", "/wp-content/updraft/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1672", "2023-04-14 22:45:32", "/wp-content/updraft/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1673", "2023-04-14 22:45:32", "/wp-content/updraft/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1674", "2023-04-14 22:45:33", "/wp-content/updraft/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1675", "2023-04-14 22:45:34", "/wp-content/updraft/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1676", "2023-04-14 22:45:35", "/wp-content/updraft/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1677", "2023-04-14 22:45:36", "/wp-content/updraft/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1678", "2023-04-14 22:45:37", "/wp-content/plugins/cekidot/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1679", "2023-04-14 22:45:38", "/wp-content/plugins/cekidot/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1680", "2023-04-14 22:45:38", "/wp-content/plugins/cekidot/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1681", "2023-04-14 22:45:39", "/wp-content/plugins/cekidot/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1682", "2023-04-14 22:45:40", "/wp-content/plugins/cekidot/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1683", "2023-04-14 22:45:40", "/wp-content/plugins/cekidot/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1684", "2023-04-14 22:45:41", "/wp-content/plugins/cekidot/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1685", "2023-04-14 22:45:42", "/wp-content/plugins/cekidot/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1686", "2023-04-14 22:45:43", "/wp-content/plugins/cekidot/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1687", "2023-04-14 22:45:44", "/wp-content/plugins/cekidot/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1688", "2023-04-14 22:45:45", "/wp-content/plugins/cekidot/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1689", "2023-04-14 22:45:45", "/wp-content/plugins/cekidot/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1690", "2023-04-14 22:45:46", "/wp-content/plugins/cekidot/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1691", "2023-04-14 22:45:47", "/wp-content/plugins/cekidot/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1692", "2023-04-14 22:45:47", "/wp-content/plugins/cekidot/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1693", "2023-04-14 22:45:48", "/wp-content/plugins/cekidot/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1694", "2023-04-14 22:45:49", "/wp-content/plugins/cekidot/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1695", "2023-04-14 22:45:50", "/wp-content/plugins/cekidot/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1696", "2023-04-14 22:45:51", "/wp-content/plugins/library/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1697", "2023-04-14 22:45:51", "/wp-content/plugins/library/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1698", "2023-04-14 22:45:52", "/wp-content/plugins/library/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1699", "2023-04-14 22:45:52", "/wp-content/plugins/library/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1700", "2023-04-14 22:45:53", "/wp-content/plugins/library/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1701", "2023-04-14 22:45:54", "/wp-content/plugins/library/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1702", "2023-04-14 22:45:55", "/wp-content/plugins/library/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1703", "2023-04-14 22:45:55", "/wp-content/plugins/library/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1704", "2023-04-14 22:45:56", "/wp-content/plugins/library/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1705", "2023-04-14 22:45:57", "/wp-content/plugins/library/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1706", "2023-04-14 22:45:57", "/wp-content/plugins/library/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1707", "2023-04-14 22:45:58", "/wp-content/plugins/library/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1708", "2023-04-14 22:46:00", "/wp-content/plugins/library/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1709", "2023-04-14 22:46:00", "/wp-content/plugins/library/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1710", "2023-04-14 22:46:01", "/wp-content/plugins/library/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1711", "2023-04-14 22:46:02", "/wp-content/plugins/library/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1712", "2023-04-14 22:46:03", "/wp-content/plugins/library/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1713", "2023-04-14 22:46:04", "/wp-content/plugins/library/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1714", "2023-04-14 22:46:04", "/wp-admin/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1715", "2023-04-14 22:46:05", "/wp-admin/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1716", "2023-04-14 22:46:06", "/wp-admin/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1717", "2023-04-14 22:46:06", "/wp-admin/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1718", "2023-04-14 22:46:07", "/wp-admin/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1719", "2023-04-14 22:46:08", "/wp-admin/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1720", "2023-04-14 22:46:09", "/wp-admin/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1721", "2023-04-14 22:46:10", "/wp-admin/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1722", "2023-04-14 22:46:11", "/wp-admin/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1723", "2023-04-14 22:46:12", "/wp-admin/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1724", "2023-04-14 22:46:12", "/wp-admin/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1725", "2023-04-14 22:46:13", "/wp-admin/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1726", "2023-04-14 22:46:14", "/wp-admin/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1727", "2023-04-14 22:46:14", "/wp-admin/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1728", "2023-04-14 22:46:15", "/wp-admin/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1729", "2023-04-14 22:46:16", "/wp-admin/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1730", "2023-04-14 22:46:16", "/wp-admin/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1731", "2023-04-14 22:46:17", "/wp-admin/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1732", "2023-04-14 22:46:18", "/wp-includes/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1733", "2023-04-14 22:46:18", "/wp-includes/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1734", "2023-04-14 22:46:19", "/wp-includes/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1735", "2023-04-14 22:46:20", "/wp-includes/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1736", "2023-04-14 22:46:20", "/wp-includes/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1737", "2023-04-14 22:46:21", "/wp-includes/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1738", "2023-04-14 22:46:22", "/wp-includes/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1739", "2023-04-14 22:46:23", "/wp-includes/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1740", "2023-04-14 22:46:24", "/wp-includes/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1741", "2023-04-14 22:46:24", "/wp-includes/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1742", "2023-04-14 22:46:25", "/wp-includes/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1743", "2023-04-14 22:46:26", "/wp-includes/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1744", "2023-04-14 22:46:26", "/wp-includes/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1745", "2023-04-14 22:46:27", "/wp-includes/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1746", "2023-04-14 22:46:27", "/wp-includes/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1747", "2023-04-14 22:46:28", "/wp-includes/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1748", "2023-04-14 22:46:29", "/wp-includes/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1749", "2023-04-14 22:46:30", "/wp-includes/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1750", "2023-04-14 22:46:30", "/.well-known/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1751", "2023-04-14 22:46:31", "/.well-known/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1752", "2023-04-14 22:46:32", "/.well-known/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1753", "2023-04-14 22:46:32", "/.well-known/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1754", "2023-04-14 22:46:33", "/.well-known/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1755", "2023-04-14 22:46:33", "/.well-known/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1756", "2023-04-14 22:46:34", "/.well-known/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1757", "2023-04-14 22:46:35", "/.well-known/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1758", "2023-04-14 22:46:36", "/.well-known/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1759", "2023-04-14 22:46:36", "/.well-known/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1760", "2023-04-14 22:46:37", "/.well-known/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1761", "2023-04-14 22:46:37", "/.well-known/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1762", "2023-04-14 22:46:38", "/.well-known/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1763", "2023-04-14 22:46:39", "/.well-known/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1764", "2023-04-14 22:46:39", "/.well-known/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1765", "2023-04-14 22:46:40", "/.well-known/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1766", "2023-04-14 22:46:41", "/.well-known/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1767", "2023-04-14 22:46:41", "/.well-known/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1768", "2023-04-14 22:46:42", "/.well-known/acme-challenge/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1769", "2023-04-14 22:46:42", "/.well-known/acme-challenge/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1770", "2023-04-14 22:46:43", "/.well-known/acme-challenge/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1771", "2023-04-14 22:46:44", "/.well-known/acme-challenge/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1772", "2023-04-14 22:46:44", "/.well-known/acme-challenge/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1773", "2023-04-14 22:46:45", "/.well-known/acme-challenge/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1774", "2023-04-14 22:46:46", "/.well-known/acme-challenge/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1775", "2023-04-14 22:46:47", "/.well-known/acme-challenge/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1776", "2023-04-14 22:46:47", "/.well-known/acme-challenge/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1777", "2023-04-14 22:46:48", "/.well-known/acme-challenge/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1778", "2023-04-14 22:46:48", "/.well-known/acme-challenge/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1779", "2023-04-14 22:46:49", "/.well-known/acme-challenge/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1780", "2023-04-14 22:46:50", "/.well-known/acme-challenge/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1781", "2023-04-14 22:46:50", "/.well-known/acme-challenge/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1782", "2023-04-14 22:46:51", "/.well-known/acme-challenge/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1783", "2023-04-14 22:46:52", "/.well-known/acme-challenge/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1784", "2023-04-14 22:46:53", "/.well-known/acme-challenge/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1785", "2023-04-14 22:46:53", "/.well-known/acme-challenge/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1786", "2023-04-14 22:46:54", "/.well-known/pki-validation/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1787", "2023-04-14 22:46:55", "/.well-known/pki-validation/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1788", "2023-04-14 22:46:55", "/.well-known/pki-validation/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1789", "2023-04-14 22:46:56", "/.well-known/pki-validation/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1790", "2023-04-14 22:46:57", "/.well-known/pki-validation/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1791", "2023-04-14 22:46:57", "/.well-known/pki-validation/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1792", "2023-04-14 22:46:58", "/.well-known/pki-validation/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1793", "2023-04-14 22:46:59", "/.well-known/pki-validation/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1794", "2023-04-14 22:46:59", "/.well-known/pki-validation/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1795", "2023-04-14 22:47:00", "/.well-known/pki-validation/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1796", "2023-04-14 22:47:01", "/.well-known/pki-validation/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1797", "2023-04-14 22:47:02", "/.well-known/pki-validation/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1798", "2023-04-14 22:47:03", "/.well-known/pki-validation/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1799", "2023-04-14 22:47:04", "/.well-known/pki-validation/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1800", "2023-04-14 22:47:04", "/.well-known/pki-validation/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1801", "2023-04-14 22:47:05", "/.well-known/pki-validation/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1802", "2023-04-14 22:47:06", "/.well-known/pki-validation/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1803", "2023-04-14 22:47:06", "/.well-known/pki-validation/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1804", "2023-04-14 22:47:07", "/.tmb/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1805", "2023-04-14 22:47:08", "/.tmb/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1806", "2023-04-14 22:47:08", "/.tmb/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1807", "2023-04-14 22:47:09", "/.tmb/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1808", "2023-04-14 22:47:09", "/.tmb/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1809", "2023-04-14 22:47:10", "/.tmb/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1810", "2023-04-14 22:47:11", "/.tmb/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1811", "2023-04-14 22:47:12", "/.tmb/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1812", "2023-04-14 22:47:12", "/.tmb/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1813", "2023-04-14 22:47:13", "/.tmb/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1814", "2023-04-14 22:47:14", "/.tmb/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1815", "2023-04-14 22:47:14", "/.tmb/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1816", "2023-04-14 22:47:16", "/.tmb/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1817", "2023-04-14 22:47:16", "/.tmb/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1818", "2023-04-14 22:47:17", "/.tmb/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1819", "2023-04-14 22:47:18", "/.tmb/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1820", "2023-04-14 22:47:18", "/.tmb/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1821", "2023-04-14 22:47:19", "/.tmb/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1822", "2023-04-14 22:47:19", "/.quarantine/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1823", "2023-04-14 22:47:20", "/.quarantine/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1824", "2023-04-14 22:47:21", "/.quarantine/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1825", "2023-04-14 22:47:21", "/.quarantine/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1826", "2023-04-14 22:47:22", "/.quarantine/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1827", "2023-04-14 22:47:23", "/.quarantine/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1828", "2023-04-14 22:47:24", "/.quarantine/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1829", "2023-04-14 22:47:24", "/.quarantine/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1830", "2023-04-14 22:47:25", "/.quarantine/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1831", "2023-04-14 22:47:25", "/.quarantine/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1832", "2023-04-14 22:47:26", "/.quarantine/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1833", "2023-04-14 22:47:26", "/.quarantine/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1834", "2023-04-14 22:47:27", "/.quarantine/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1835", "2023-04-14 22:47:28", "/.quarantine/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1836", "2023-04-14 22:47:28", "/.quarantine/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1837", "2023-04-14 22:47:29", "/.quarantine/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1838", "2023-04-14 22:47:30", "/.quarantine/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1839", "2023-04-14 22:47:30", "/.quarantine/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1840", "2023-04-14 22:47:35", "/images/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1841", "2023-04-14 22:47:36", "/images/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1842", "2023-04-14 22:47:37", "/images/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1843", "2023-04-14 22:47:37", "/images/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1844", "2023-04-14 22:47:38", "/images/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1845", "2023-04-14 22:47:38", "/images/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1846", "2023-04-14 22:47:40", "/images/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1847", "2023-04-14 22:47:41", "/images/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1848", "2023-04-14 22:47:42", "/images/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1849", "2023-04-14 22:47:42", "/images/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1850", "2023-04-14 22:47:43", "/images/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1851", "2023-04-14 22:47:44", "/images/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1852", "2023-04-14 22:47:44", "/images/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1853", "2023-04-14 22:47:45", "/images/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1854", "2023-04-14 22:47:45", "/images/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1855", "2023-04-14 22:47:46", "/images/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1856", "2023-04-14 22:47:47", "/images/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1857", "2023-04-14 22:47:48", "/images/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1858", "2023-04-14 22:47:48", "/components/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1859", "2023-04-14 22:47:49", "/components/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1860", "2023-04-14 22:47:50", "/components/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1861", "2023-04-14 22:47:50", "/components/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1862", "2023-04-14 22:47:51", "/components/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1863", "2023-04-14 22:47:51", "/components/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1864", "2023-04-14 22:47:52", "/components/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1865", "2023-04-14 22:47:53", "/components/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1866", "2023-04-14 22:47:54", "/components/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1867", "2023-04-14 22:47:54", "/components/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1868", "2023-04-14 22:47:55", "/components/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1869", "2023-04-14 22:47:55", "/components/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1870", "2023-04-14 22:47:56", "/components/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1871", "2023-04-14 22:47:57", "/components/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1872", "2023-04-14 22:47:58", "/components/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1873", "2023-04-14 22:47:59", "/components/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1874", "2023-04-14 22:47:59", "/components/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1875", "2023-04-14 22:48:00", "/components/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1876", "2023-04-14 22:48:00", "/wordpress/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1877", "2023-04-14 22:48:01", "/wordpress/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1878", "2023-04-14 22:48:01", "/wordpress/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1879", "2023-04-14 22:48:02", "/wordpress/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1880", "2023-04-14 22:48:03", "/wordpress/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1881", "2023-04-14 22:48:03", "/wordpress/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1882", "2023-04-14 22:48:04", "/wordpress/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1883", "2023-04-14 22:48:05", "/wordpress/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1884", "2023-04-14 22:48:06", "/wordpress/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1885", "2023-04-14 22:48:06", "/wordpress/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1886", "2023-04-14 22:48:07", "/wordpress/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1887", "2023-04-14 22:48:08", "/wordpress/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1888", "2023-04-14 22:48:08", "/wordpress/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1889", "2023-04-14 22:48:09", "/wordpress/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1890", "2023-04-14 22:48:09", "/wordpress/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1891", "2023-04-14 22:48:10", "/wordpress/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1892", "2023-04-14 22:48:11", "/wordpress/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1893", "2023-04-14 22:48:11", "/wordpress/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1894", "2023-04-14 22:48:12", "/wp/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1895", "2023-04-14 22:48:13", "/wp/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1896", "2023-04-14 22:48:13", "/wp/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1897", "2023-04-14 22:48:14", "/wp/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1898", "2023-04-14 22:48:15", "/wp/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1899", "2023-04-14 22:48:16", "/wp/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1900", "2023-04-14 22:48:17", "/wp/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1901", "2023-04-14 22:48:18", "/wp/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1902", "2023-04-14 22:48:18", "/wp/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1903", "2023-04-14 22:48:19", "/wp/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1904", "2023-04-14 22:48:20", "/wp/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1905", "2023-04-14 22:48:20", "/wp/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1906", "2023-04-14 22:48:21", "/wp/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1907", "2023-04-14 22:48:21", "/wp/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1908", "2023-04-14 22:48:22", "/wp/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1909", "2023-04-14 22:48:23", "/wp/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1910", "2023-04-14 22:48:24", "/wp/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1911", "2023-04-14 22:48:24", "/wp/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1912", "2023-04-14 22:48:25", "/blog/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1913", "2023-04-14 22:48:25", "/blog/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1914", "2023-04-14 22:48:26", "/blog/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1915", "2023-04-14 22:48:27", "/blog/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1916", "2023-04-14 22:48:27", "/blog/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1917", "2023-04-14 22:48:28", "/blog/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1918", "2023-04-14 22:48:29", "/blog/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1919", "2023-04-14 22:48:30", "/blog/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1920", "2023-04-14 22:48:30", "/blog/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1921", "2023-04-14 22:48:31", "/blog/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1922", "2023-04-14 22:48:32", "/blog/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1923", "2023-04-14 22:48:32", "/blog/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1924", "2023-04-14 22:48:33", "/blog/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1925", "2023-04-14 22:48:33", "/blog/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1926", "2023-04-14 22:48:34", "/blog/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1927", "2023-04-14 22:48:36", "/blog/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1928", "2023-04-14 22:48:36", "/blog/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1929", "2023-04-14 22:48:37", "/blog/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1930", "2023-04-14 22:48:37", "/new/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1931", "2023-04-14 22:48:39", "/new/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1932", "2023-04-14 22:48:39", "/new/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1933", "2023-04-14 22:48:40", "/new/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1934", "2023-04-14 22:48:40", "/new/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1935", "2023-04-14 22:48:41", "/new/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1936", "2023-04-14 22:48:42", "/new/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1937", "2023-04-14 22:48:42", "/new/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1938", "2023-04-14 22:48:43", "/new/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1939", "2023-04-14 22:48:43", "/new/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1940", "2023-04-14 22:48:44", "/new/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1941", "2023-04-14 22:48:44", "/new/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1942", "2023-04-14 22:48:45", "/new/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1943", "2023-04-14 22:48:46", "/new/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1944", "2023-04-14 22:48:47", "/new/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1945", "2023-04-14 22:48:48", "/new/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1946", "2023-04-14 22:48:49", "/new/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1947", "2023-04-14 22:48:49", "/old/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1948", "2023-04-14 22:48:50", "/old/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1949", "2023-04-14 22:48:50", "/old/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1950", "2023-04-14 22:48:51", "/old/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1951", "2023-04-14 22:48:52", "/old/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1952", "2023-04-14 22:48:52", "/old/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1953", "2023-04-14 22:48:53", "/old/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1954", "2023-04-14 22:48:54", "/old/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1955", "2023-04-14 22:48:54", "/old/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1956", "2023-04-14 22:48:55", "/old/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1957", "2023-04-14 22:48:55", "/old/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1958", "2023-04-14 22:48:56", "/old/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1959", "2023-04-14 22:48:56", "/old/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1960", "2023-04-14 22:48:57", "/old/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1961", "2023-04-14 22:48:58", "/old/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1962", "2023-04-14 22:48:58", "/old/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1963", "2023-04-14 22:48:59", "/old/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1964", "2023-04-14 22:49:00", "/old/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1965", "2023-04-14 22:49:00", "/backup/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1966", "2023-04-14 22:49:01", "/backup/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1967", "2023-04-14 22:49:01", "/backup/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1968", "2023-04-14 22:49:02", "/backup/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1969", "2023-04-14 22:49:02", "/backup/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1970", "2023-04-14 22:49:03", "/backup/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1971", "2023-04-14 22:49:04", "/backup/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1972", "2023-04-14 22:49:05", "/backup/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1973", "2023-04-14 22:49:06", "/backup/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1974", "2023-04-14 22:49:06", "/backup/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1975", "2023-04-14 22:49:07", "/backup/ALFA_DATA/alfacgiapi/perl.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1976", "2023-04-14 22:49:08", "/backup/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1977", "2023-04-14 22:49:08", "/backup/ALFA_DATA/alfacgiapi/bash.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1978", "2023-04-14 22:49:09", "/backup/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1979", "2023-04-14 22:49:09", "/backup/ALFA_DATA/alfacgiapi/py.alfa", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1980", "2023-04-14 22:49:10", "/backup/ALFA_DATA/alfacgiapi", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1981", "2023-04-14 22:49:11", "/backup/ALFA_DATA/alfacgiapi/radio.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1982", "2023-04-14 22:49:11", "/backup/ALFA_DATA/alfacgiapi/404.php", "", "20.197.16.71", "Mozilla/5.0 (Linux; Android 11; Redmi Note 9 Pro Build/RKQ1.200826.002; wv) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/90.0.4430.210 Mobile Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1983", "2023-04-14 22:49:12", "/wp-backup-sql-302.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1984", "2023-04-14 22:49:13", "/0.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1985", "2023-04-14 22:49:13", "/0byte.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1986", "2023-04-14 22:49:14", "/0x0.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1987", "2023-04-14 22:49:15", "/0z.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1988", "2023-04-14 22:49:15", "/1.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1989", "2023-04-14 22:49:16", "/13.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1990", "2023-04-14 22:49:17", "/1945.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1991", "2023-04-14 22:49:17", "/1index.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1992", "2023-04-14 22:49:18", "/1index.php?pass=shell", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1993", "2023-04-14 22:49:18", "/22xc.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1994", "2023-04-14 22:49:19", "/26.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1995", "2023-04-14 22:49:19", "/2index.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1996", "2023-04-14 22:49:20", "/2index.php?pass=shell", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1997", "2023-04-14 22:49:21", "/3.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1998", "2023-04-14 22:49:21", "/32.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("1999", "2023-04-14 22:49:22", "/3index.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2000", "2023-04-14 22:49:22", "/403.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2001", "2023-04-14 22:49:23", "/404.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2002", "2023-04-14 22:49:24", "/45.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2003", "2023-04-14 22:49:24", "/4x4.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2004", "2023-04-14 22:49:25", "/73.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2005", "2023-04-14 22:49:25", "/a.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2006", "2023-04-14 22:49:26", "/about.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2007", "2023-04-14 22:49:26", "/admin.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2008", "2023-04-14 22:49:27", "/al.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2009", "2023-04-14 22:49:27", "/alf.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2010", "2023-04-14 22:49:28", "/alf4.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2011", "2023-04-14 22:49:29", "/alfa-shell-v4.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2012", "2023-04-14 22:49:29", "/alfa.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2013", "2023-04-14 22:49:30", "/alfakun.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2014", "2023-04-14 22:49:30", "/alfatesla.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2015", "2023-04-14 22:49:31", "/alfateslav4.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2016", "2023-04-14 22:49:32", "/alwso.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2017", "2023-04-14 22:49:32", "/anjay.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2018", "2023-04-14 22:49:33", "/anon.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2019", "2023-04-14 22:49:33", "/anons79.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2020", "2023-04-14 22:49:34", "/autoload_classmap.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2021", "2023-04-14 22:49:34", "/base.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2022", "2023-04-14 22:49:35", "/batm.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2023", "2023-04-14 22:49:36", "/bj.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2024", "2023-04-14 22:49:36", "/black.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2025", "2023-04-14 22:49:37", "/by.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2026", "2023-04-14 22:49:38", "/bypass.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2027", "2023-04-14 22:49:39", "/byps.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2028", "2023-04-14 22:49:39", "/c.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2029", "2023-04-14 22:49:40", "/con.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2030", "2023-04-14 22:49:41", "/con7ext.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2031", "2023-04-14 22:49:41", "/dbx.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2032", "2023-04-14 22:49:42", "/degeselih.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2033", "2023-04-14 22:49:42", "/doc.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2034", "2023-04-14 22:49:43", "/docindex.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2035", "2023-04-14 22:49:43", "/dosya.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2036", "2023-04-14 22:49:44", "/e.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2037", "2023-04-14 22:49:45", "/error.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2038", "2023-04-14 22:49:46", "/error.php?phpshells", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2039", "2023-04-14 22:49:47", "/evil.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2040", "2023-04-14 22:49:47", "/file.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2041", "2023-04-14 22:49:48", "/fox.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2042", "2023-04-14 22:49:48", "/FoxWSO-full.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2043", "2023-04-14 22:49:49", "/FoxWSO.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2044", "2023-04-14 22:49:49", "/foxwso.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2045", "2023-04-14 22:49:50", "/fw.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2046", "2023-04-14 22:49:50", "/gank.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2047", "2023-04-14 22:49:51", "/gank.php.PhP", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2048", "2023-04-14 22:49:51", "/gel4y.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2049", "2023-04-14 22:49:52", "/gelay.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2050", "2023-04-14 22:49:53", "/gh.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2051", "2023-04-14 22:49:53", "/i.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2052", "2023-04-14 22:49:54", "/id.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2053", "2023-04-14 22:49:54", "/ids.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2054", "2023-04-14 22:49:55", "/idx.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2055", "2023-04-14 22:49:55", "/indoxploit.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2056", "2023-04-14 22:49:56", "/init.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2057", "2023-04-14 22:49:57", "/k.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2058", "2023-04-14 22:49:57", "/kepo.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2059", "2023-04-14 22:49:58", "/kk.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2060", "2023-04-14 22:49:58", "/kndw1.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2061", "2023-04-14 22:49:59", "/la.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2062", "2023-04-14 22:49:59", "/lnedx.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2063", "2023-04-14 22:50:00", "/loader/ff.php?pass=shell", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2064", "2023-04-14 22:50:01", "/local.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2065", "2023-04-14 22:50:01", "/lol.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2066", "2023-04-14 22:50:02", "/lolzk.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2067", "2023-04-14 22:50:02", "/m.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2068", "2023-04-14 22:50:03", "/mar.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2069", "2023-04-14 22:50:03", "/marijuana.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2070", "2023-04-14 22:50:05", "/mas.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2071", "2023-04-14 22:50:05", "/mass.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2072", "2023-04-14 22:50:06", "/mini.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2073", "2023-04-14 22:50:07", "/minik.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2074", "2023-04-14 22:50:07", "/minishell.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2075", "2023-04-14 22:50:08", "/mrjn.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2076", "2023-04-14 22:50:09", "/n.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2077", "2023-04-14 22:50:09", "/ninja.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2078", "2023-04-14 22:50:10", "/o.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2079", "2023-04-14 22:50:10", "/ohayo.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2080", "2023-04-14 22:50:11", "/old-index.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2081", "2023-04-14 22:50:12", "/olux.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2082", "2023-04-14 22:50:12", "/phpinfo.php?re@=vo@", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT INTO `wp_link_juice_keeper` VALUES("2083", "2023-04-14 22:50:13", "/postfs.php", "", "20.197.16.71", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/85.0.4183.102 Safari/537.36", "1");
INSERT 